/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.lang.reflect.Constructor;
import org.alfresco.traitextender.ExtensionFactory;
import org.alfresco.traitextender.ExtensionPoint;
import org.alfresco.traitextender.InstanceExtension;
import org.alfresco.traitextender.InvalidExtension;
import org.alfresco.traitextender.Trait;

public class InstanceExtensionFactory<I extends InstanceExtension<E, T>, T extends Trait, E>
implements ExtensionFactory<E> {
    private Class<? extends I> extensionClass;
    private Class<T> traitAPI;

    public <C extends I> InstanceExtensionFactory(Class<C> extensionClass, Class<T> traitAPI, Class<? extends E> extensionAPI) {
        this.extensionClass = extensionClass;
        this.traitAPI = traitAPI;
        if (!extensionAPI.isAssignableFrom(extensionClass)) {
            throw new InvalidExtension("Extension class " + extensionClass + " is incompatible with extensio API " + extensionAPI);
        }
    }

    @Override
    public <TO extends Trait> E createExtension(TO traitObject) {
        try {
            TO tTrait = traitObject;
            Constructor<I> c = this.extensionClass.getConstructor(this.traitAPI);
            return (E)c.newInstance(tTrait);
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    @Override
    public boolean canCreateExtensionFor(ExtensionPoint<?, ?> point) {
        return point.getExtensionAPI().isAssignableFrom(this.extensionClass) && this.traitAPI.isAssignableFrom(point.getTraitAPI());
    }
}

