/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.page;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.query.ListBackedPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.virtual.page.InvalidPageBounds;
import org.alfresco.repo.virtual.page.PageCollationException;
import org.alfresco.repo.virtual.page.PageCollator;
import org.alfresco.util.Pair;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.springframework.util.comparator.ComparableComparator;

public class PageCollatorTest
extends TestCase {
    private static Log logger = LogFactory.getLog(PageCollatorTest.class);

    protected void setUp() throws Exception {
        super.setUp();
    }

    private int[] createMergedPage(int skip, int count, List<Integer> s1, Integer[] s2) {
        return this.createMergedPage(skip, count, s1, ArrayUtils.toPrimitive((Integer[])s2));
    }

    private int[] createMergedPage(int skip, int count, List<Integer> s1, int[] s2) {
        int[] s1Primitive = s1 == null || s1.isEmpty() ? new int[]{} : ArrayUtils.toPrimitive((Integer[])s1.toArray(new Integer[s1.size()]));
        return this.createMergedPage(skip, count, s1Primitive, s2);
    }

    private int[] createMergedPage(int skip, int count, int[] s1, int[] s2) {
        int[] m = Arrays.copyOf(s1, s1.length + s2.length);
        System.arraycopy(s2, 0, m, s1.length, s2.length);
        Arrays.sort(m);
        int zeroCount = count == 0 ? m.length : count;
        int len = Math.min(m.length - skip, zeroCount);
        if (len > 0) {
            int[] p = new int[len];
            System.arraycopy(m, skip, p, 0, len);
            return p;
        }
        return new int[0];
    }

    private void assertEqualPages(int[] expected, int[] actual) {
        this.assertEqualPages(String.valueOf(Arrays.toString(expected)) + " vs " + Arrays.toString(actual), expected, actual);
    }

    private void assertEqualPages(String message, int[] expected, int[] actual) {
        PageCollatorTest.assertTrue((String)message, (boolean)Arrays.equals(expected, actual));
    }

    private void assertEqualPages(String message, int[] expected, List<Integer> page) {
        this.assertEqualPages(message, expected, ArrayUtils.toPrimitive((Integer[])page.toArray(new Integer[0])));
    }

    @Test
    public void testCreateMergedPage() throws Exception {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 8;
        int[] s1 = nArray;
        int[] s2 = new int[]{2, 4, 9, 10};
        this.assertEqualPages(new int[]{2, 3, 4}, this.createMergedPage(2, 3, s1, s2));
        this.assertEqualPages(new int[]{9, 10}, this.createMergedPage(7, 2, s1, s2));
        int[] nArray2 = new int[5];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        this.assertEqualPages(nArray2, this.createMergedPage(0, 5, s1, s2));
        int[] nArray3 = new int[5];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArray3[4] = 4;
        this.assertEqualPages(nArray3, this.createMergedPage(0, 5, s1, s2));
        this.assertEqualPages(new int[]{4, 7, 8, 9}, this.createMergedPage(4, 4, s1, s2));
        this.assertEqualPages(new int[0], this.createMergedPage(10, 4, s1, s2));
        this.assertEqualPages(new int[0], this.createMergedPage(9, 1, s1, s2));
        this.assertEqualPages(new int[0], this.createMergedPage(9, 1, s1, s2));
        this.assertEqualPages(new int[0], this.createMergedPage(11, 3, s1, s2));
        int[] s3 = new int[]{2, 3};
        int[] s4 = new int[]{7, 10, 13, 11};
        this.assertEqualPages(new int[]{13}, this.createMergedPage(5, 2, s3, s4));
        int[] s5 = new int[]{1, 2, 3};
        int[] s6 = new int[]{5};
        this.assertEqualPages(new int[]{5}, this.createMergedPage(3, 1, s5, s6));
        this.assertEqualPages(new int[]{1, 2, 3, 5}, this.createMergedPage(0, 0, s5, s6));
    }

    public void assertCollate(List<Integer> results, Integer[] source, int skip, int pageSize) throws Exception {
        this.assertCollate(results, source, skip, pageSize, false);
    }

    public void assertCollate(List<Integer> results, Integer[] source, int skip, int pageSize, boolean boundsError) throws Exception {
        Arrays.sort((Object[])source);
        Collections.sort(results);
        int[] expected = this.createMergedPage(skip, pageSize, results, source);
        PagingResults actualResults = new PageCollator().collate(results, new ArrayPageSource<Integer>(source), new PagingRequest(skip, pageSize), (Comparator)new ComparableComparator());
        List actualPage = actualResults.getPage();
        String message = "[" + results + " + " + Arrays.toString((Object[])source) + " ] -> " + Arrays.toString(expected) + " != " + actualPage;
        this.assertEqualPages(message, expected, actualPage);
        PageCollatorTest.assertEquals((String)"Invalid moreItems info!", (pageSize != 0 && skip + pageSize < results.size() + source.length ? 1 : 0) != 0, (boolean)actualResults.hasMoreItems());
        PageCollatorTest.assertTrue((String)message, (pageSize == 0 || actualPage.size() <= pageSize ? 1 : 0) != 0);
        int expectedTotal = source.length + results.size();
        if (boundsError && !new Pair(null, null).equals((Object)actualResults.getTotalResultCount())) {
            PageCollatorTest.assertEquals((String)"Invalid total info", (Object)new Pair((Object)expectedTotal, (Object)expectedTotal), (Object)actualResults.getTotalResultCount());
        }
        logger.info((Object)actualPage);
    }

    @Test
    public void testCollate() throws Exception {
        List<Integer> s1 = Arrays.asList(2, 4, 9, 10);
        Integer[] s2 = new Integer[]{0, 1, 3, 5, 7, 8};
        this.assertCollate(s1, s2, 0, 3);
        this.assertCollate(s1, s2, 2, 3);
        List<Integer> s3 = Arrays.asList(2, 4, 9, 10, 12, 15, 17, 18);
        Integer[] s4 = new Integer[]{0, 1, 3, 8, 16, 19};
        this.assertCollate(s3, s4, 0, 3);
        this.assertCollate(s3, s4, 2, 3);
        this.assertCollate(s3, s4, 6, 3);
        this.assertCollate(s3, s4, 7, 3);
        List<Integer> s5 = Arrays.asList(2, 3, 6, 8);
        Integer[] s6 = new Integer[]{7, 10, 13, 11, 17, 19};
        this.assertCollate(s5, s6, 0, 1);
        this.assertCollate(s5, s6, 1, 2);
    }

    public void testCollateBoundary1() throws Exception {
        List<Integer> s1 = Arrays.asList(2, 3);
        Integer[] s2 = new Integer[]{7, 10, 13, 11};
        this.assertCollate(s1, s2, 6, 1, true);
    }

    public void testCollateBoundary2() throws Exception {
        List<Integer> s1 = Arrays.asList(2, 3);
        Integer[] s2 = new Integer[]{7, 10, 13, 11};
        this.assertCollate(s1, s2, 5, 2, true);
    }

    public void testCollateBoundary3() throws Exception {
        List<Integer> s1 = Arrays.asList(1, 2, 3);
        Integer[] s2 = new Integer[]{5, 6, 7, 8};
        this.assertCollate(s1, s2, 6, 1, true);
    }

    public void testCollateBoundary4() throws Exception {
        List<Integer> s1 = Arrays.asList(1, 2, 3);
        Integer[] s2 = new Integer[]{5};
        this.assertCollate(s1, s2, 3, 1, false);
    }

    public void testCollateBoundary5() throws Exception {
        List<Integer> s1 = Arrays.asList(2, 3);
        Integer[] s2 = new Integer[]{7, 10, 13};
        this.assertCollate(s1, s2, 10, 2, true);
    }

    public void testCollateBoundary6() throws Exception {
        List<Integer> s1 = Arrays.asList(2, 3);
        Integer[] s2 = new Integer[]{7, 10, 13};
        this.assertCollate(s1, s2, 0, 0, true);
    }

    public void testCollateBoundary7() throws Exception {
        List<Integer> s1 = Arrays.asList(10);
        Integer[] s2 = new Integer[]{1, 2, 3};
        this.assertCollate(s1, s2, 6, 1, true);
    }

    public void testCollateBoundary8() throws Exception {
        List<Integer> s1 = Arrays.asList(1);
        Integer[] s2 = new Integer[]{5, 6, 7};
        this.assertCollate(s1, s2, 5, 1, true);
    }

    public void testCollateBoundary9() throws Exception {
        List<Integer> s1 = Arrays.asList(1);
        Integer[] s2 = new Integer[]{5};
        this.assertCollate(s1, s2, 0, 2, true);
    }

    public void testCollateBoundary10() throws Exception {
        List<Integer> s1 = Arrays.asList(new Integer[0]);
        Integer[] s2 = new Integer[]{5};
        this.assertCollate(s1, s2, 0, 2, true);
    }

    public void testCollateBoundary11() throws Exception {
        List<Integer> s1 = Arrays.asList(1);
        Integer[] s2 = new Integer[]{};
        this.assertCollate(s1, s2, 0, 1, false);
    }

    public void testCollateBoundary12() throws Exception {
        List<Integer> s1 = Arrays.asList(new Integer[0]);
        Integer[] s2 = new Integer[]{};
        this.assertCollate(s1, s2, 0, 1, false);
    }

    public void testCollateBoundary13() throws Exception {
        List<Integer> s1 = Arrays.asList(6, 7, 8, 9, 10, 11, 12, 13, 14);
        Integer[] s2 = new Integer[]{1};
        this.assertCollate(s1, s2, 3, 5, false);
    }

    public void testCollateFalsePositive1() throws Exception {
        List<Integer> s1 = Arrays.asList(2, 3);
        Integer[] s2 = new Integer[]{7, 10, 13};
        try {
            new PageCollator().collate(s1, new ArrayPageSource<Integer>(s2), new PagingRequest(-1, 1), (Comparator)new ComparableComparator());
            PageCollatorTest.fail((String)"Invalid page data.");
        }
        catch (PageCollationException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            new PageCollator().collate(s1, new ArrayPageSource<Integer>(s2), new PagingRequest(1, -1), (Comparator)new ComparableComparator());
            PageCollatorTest.fail((String)"Invalid page data.");
        }
        catch (PageCollationException e) {
            logger.info((Object)e.getMessage());
        }
    }

    class ArrayPageSource<R>
    implements PageCollator.PagingResultsSource<R> {
        private R[] array;
        private boolean boundsError;

        public ArrayPageSource(R[] array) {
            this(array, true);
        }

        public ArrayPageSource(R[] array, boolean boundsError) {
            this.array = array;
            this.boundsError = boundsError;
        }

        public PagingResults<R> retrieve(PagingRequest pr) throws PageCollationException {
            int skip = pr.getSkipCount();
            int pageSize = pr.getMaxItems();
            if (skip < 0 || pageSize < 0) {
                throw new PageCollationException("Invalid page!");
            }
            if (this.boundsError && skip >= this.array.length) {
                throw new InvalidPageBounds("Out of bounds " + skip + ">=" + this.array.length);
            }
            return new ListBackedPagingResults(Arrays.asList(this.array), pr);
        }
    }
}

