/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.repo.activities.ActivityPostServiceImpl;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public abstract class AbstractFeedGenerator
implements FeedGenerator {
    private static Log logger = LogFactory.getLog(AbstractFeedGenerator.class);
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"FeedGenerator");
    private static final long LOCK_TTL = 60000L;
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(AbstractFeedGenerator.class.getName());
    private int maxItemsPerCycle = 100;
    private ActivityPostDAO postDAO;
    private ActivityPostServiceImpl activityPostServiceImpl;
    private AuthenticationService authenticationService;
    private SysAdminParams sysAdminParams;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private String repoEndPoint;
    private boolean userNamesAreCaseSensitive = false;
    private RepoCtx ctx = null;

    public void setActivityPostServiceImpl(ActivityPostServiceImpl activityPostServiceImpl) {
        this.activityPostServiceImpl = activityPostServiceImpl;
    }

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setRepoEndPoint(String repoEndPoint) {
        this.repoEndPoint = repoEndPoint;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setMaxItemsPerCycle(int maxItemsPerCycle) {
        this.maxItemsPerCycle = maxItemsPerCycle;
    }

    public int getMaxItemsPerCycle() {
        return this.maxItemsPerCycle;
    }

    public ActivityPostDAO getPostDaoService() {
        return this.postDAO;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public RepoCtx getWebScriptsCtx() {
        return this.ctx;
    }

    public void init() throws Exception {
        this.ctx = new RepoCtx(this.sysAdminParams, this.repoEndPoint);
        this.ctx.setUserNamesAreCaseSensitive(this.userNamesAreCaseSensitive);
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        this.activityPostServiceImpl.setEstimatedGridSize(this.getEstimatedGridSize());
    }

    @Override
    public abstract int getEstimatedGridSize();

    @Override
    public void execute() throws JobExecutionException {
        this.checkProperties();
        if (!this.transactionService.getAllowWrite()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Activities feed generator not running due to read-only server");
            }
            return;
        }
        RetryingTransactionHelper helper = this.transactionService.getRetryingTransactionHelper();
        helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                LockCallback lockCallback = new LockCallback();
                String lockToken = null;
                try {
                    try {
                        lockToken = AbstractFeedGenerator.this.acquireLock(lockCallback);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Activities feed generator started");
                        }
                        AbstractFeedGenerator.this.generate();
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Activities feed generator completed");
                        }
                    }
                    catch (LockAcquisitionException lockAcquisitionException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Activities feed generator already underway: " + LOCK_QNAME));
                        }
                        AbstractFeedGenerator.this.releaseLock(lockCallback, lockToken);
                    }
                    catch (Throwable e) {
                        block11: {
                            if (vmShutdownListener.isVmShuttingDown()) break block11;
                            logger.error((Object)"Exception during generation of feeds", e);
                        }
                        AbstractFeedGenerator.this.releaseLock(lockCallback, lockToken);
                    }
                }
                finally {
                    AbstractFeedGenerator.this.releaseLock(lockCallback, lockToken);
                }
                return null;
            }
        }, false, false);
    }

    protected abstract boolean generate() throws Exception;

    private String acquireLock(JobLockService.JobLockRefreshCallback lockCallback) throws LockAcquisitionException {
        String lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
        this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, lockCallback);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("lock acquired: " + LOCK_QNAME + ": " + lockToken));
        }
        return lockToken;
    }

    private void releaseLock(LockCallback lockCallback, String lockToken) {
        block5: {
            try {
                if (lockCallback != null) {
                    lockCallback.running.set(false);
                }
                if (lockToken != null) {
                    this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Lock released: " + LOCK_QNAME + ": " + lockToken));
                    }
                }
            }
            catch (LockAcquisitionException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("Lock release failed: " + LOCK_QNAME + ": " + lockToken + "(" + e.getMessage() + ")"));
            }
        }
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback() {
        }

        @Override
        public boolean isActive() {
            return this.running.get();
        }

        @Override
        public void lockReleased() {
            this.running.set(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Lock release notification: " + LOCK_QNAME));
            }
        }
    }
}

