/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.rawevents.AbstractEventProducer;
import org.alfresco.util.PropertyCheck;
import org.apache.camel.ExchangePattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class Event2MessageProducer
extends AbstractEventProducer
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"producer", (Object)this.producer);
        PropertyCheck.mandatory((Object)this, (String)"endpoint", (Object)this.endpoint);
        PropertyCheck.mandatory((Object)this, (String)"objectMapper", (Object)this.objectMapper);
        if (StringUtils.isEmpty((CharSequence)this.endpoint)) {
            throw new IllegalArgumentException("Property 'endpoint' cannot be an empty string.");
        }
    }

    public void send(Object event) {
        this.send(this.endpoint, null, event, null);
    }

    @Override
    public void send(String endpointUri, ExchangePattern exchangePattern, Object event, Map<String, Object> headers) {
        try {
            if (!(event instanceof String)) {
                event = this.objectMapper.writeValueAsString(event);
            }
            if (exchangePattern == null) {
                exchangePattern = ExchangePattern.InOnly;
            }
            this.producer.sendBodyAndHeaders(endpointUri, exchangePattern, event, this.addHeaders(headers));
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Could not send event", (Throwable)e);
        }
    }
}

