/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import java.util.Set;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.util.EqualsHelper;
import org.springframework.beans.factory.InitializingBean;

public class OwnerDynamicAuthority
implements DynamicAuthority,
InitializingBean {
    private OwnableService ownableService;

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ownableService == null) {
            throw new IllegalArgumentException("There must be an ownable service");
        }
    }

    @Override
    public boolean hasAuthority(final NodeRef nodeRef, final String userName) {
        return (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return EqualsHelper.nullSafeEquals((Object)OwnerDynamicAuthority.this.ownableService.getOwner(nodeRef), (Object)userName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public String getAuthority() {
        return "ROLE_OWNER";
    }

    @Override
    public Set<PermissionReference> requiredFor() {
        return null;
    }
}

