/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.remote.server;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.alfresco.util.remote.server.socket.HostConfigurableSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class AlfrescoRmiRegistryFactoryBean
implements FactoryBean<Registry>,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(AlfrescoRmiRegistryFactoryBean.class);
    private boolean created = false;
    private final boolean enabled;
    private final int port;
    private final Registry registry;

    public AlfrescoRmiRegistryFactoryBean(boolean enabled, int port, HostConfigurableSocketFactory socketFactory) throws Exception {
        this.enabled = enabled;
        this.port = port;
        this.registry = this.enabled ? this.initRegistry(socketFactory) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Registry initRegistry(HostConfigurableSocketFactory socketFactory) throws RemoteException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for RMI registry at port '" + this.port + "', using custom socket factory");
        }
        Class<LocateRegistry> clazz = LocateRegistry.class;
        synchronized (LocateRegistry.class) {
            try {
                Registry localRegistry = LocateRegistry.getRegistry(null, this.port, socketFactory);
                this.testRegistry(localRegistry);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return localRegistry;
            }
            catch (RemoteException ex) {
                LOG.trace("RMI registry access threw exception", (Throwable)ex);
                LOG.debug("Could not detect RMI registry - creating new one");
                this.created = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return LocateRegistry.createRegistry(this.port, socketFactory, socketFactory);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void destroy() throws Exception {
        if (this.created) {
            LOG.debug("Unexporting RMI registry");
            UnicastRemoteObject.unexportObject(this.registry, true);
        }
    }

    public Registry getObject() throws Exception {
        return this.registry;
    }

    public Class<?> getObjectType() {
        return this.registry != null ? this.registry.getClass() : Registry.class;
    }

    public boolean isCreated() {
        return this.created;
    }

    public int getPort() {
        return this.port;
    }

    private void testRegistry(Registry registry) throws RemoteException {
        registry.list();
    }
}

