/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.store;

import java.util.Arrays;
import org.alfresco.repo.virtual.store.TypeVirtualizationMethod;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;

public class TypeVirtualizationMethodUnitTest {
    private static Log logger = LogFactory.getLog(TypeVirtualizationMethodUnitTest.class);

    @Test
    public void testQNameFiltersSetter_invalidFilters() throws Exception {
        TypeVirtualizationMethodUnitTest.assertIllegalQNameFilters(null);
        TypeVirtualizationMethodUnitTest.assertIllegalQNameFilters("");
    }

    @Test
    public void testQNameFiltersSetter_validFilters() throws Exception {
        TypeVirtualizationMethodUnitTest.assertQNameFilters("st:site");
        TypeVirtualizationMethodUnitTest.assertQNameFilters("st:site,cm:folder");
        TypeVirtualizationMethodUnitTest.assertQNameFilters("st:site,cm:test-folder");
        TypeVirtualizationMethodUnitTest.assertQNameFilters("st:*");
        TypeVirtualizationMethodUnitTest.assertQNameFilters("st:*,cm:*");
        TypeVirtualizationMethodUnitTest.assertQNameFilters("*");
        TypeVirtualizationMethodUnitTest.assertQNameFilters("none");
    }

    static NamespacePrefixResolver mockNamespacePrefixResolver() {
        NamespacePrefixResolver mockNamespacePrefixResolver = (NamespacePrefixResolver)Mockito.mock(NamespacePrefixResolver.class, (Answer)new ThrowsException((Throwable)new NamespaceException("Mock exception ")));
        ((NamespacePrefixResolver)Mockito.doReturn(Arrays.asList("st")).when((Object)mockNamespacePrefixResolver)).getPrefixes("http://www.alfresco.org/model/site/1.0");
        ((NamespacePrefixResolver)Mockito.doReturn((Object)"http://www.alfresco.org/model/site/1.0").when((Object)mockNamespacePrefixResolver)).getNamespaceURI("st");
        ((NamespacePrefixResolver)Mockito.doReturn(Arrays.asList("cm")).when((Object)mockNamespacePrefixResolver)).getPrefixes("http://www.alfresco.org/model/content/1.0");
        ((NamespacePrefixResolver)Mockito.doReturn((Object)"http://www.alfresco.org/model/content/1.0").when((Object)mockNamespacePrefixResolver)).getNamespaceURI("cm");
        ((NamespacePrefixResolver)Mockito.doReturn((Object)("mock(NamespacePrefixResolver)@" + TypeVirtualizationMethod.class.toString())).when((Object)mockNamespacePrefixResolver)).toString();
        return mockNamespacePrefixResolver;
    }

    static void assertIllegalQNameFilters(String filters) {
        TypeVirtualizationMethod tvm = new TypeVirtualizationMethod();
        try {
            tvm.setNamespacePrefixResolver(TypeVirtualizationMethodUnitTest.mockNamespacePrefixResolver());
            tvm.setQnameFilters(filters);
            Assert.fail((String)("Should not be able to set filters string " + filters));
        }
        catch (IllegalArgumentException e) {
            logger.info((Object)e.getMessage());
        }
    }

    static void assertQNameFilters(String filters) {
        TypeVirtualizationMethod tvm = new TypeVirtualizationMethod();
        tvm.setNamespacePrefixResolver(TypeVirtualizationMethodUnitTest.mockNamespacePrefixResolver());
        tvm.setQnameFilters(filters);
    }
}

