/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.Item;

public class Form {
    protected Item item;
    protected String submissionUrl;
    protected List<FieldDefinition> fieldDefinitions;
    protected Collection<FieldGroup> fieldGroups;
    protected FormData data;

    public Form(Item item) {
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    public String getSubmissionUrl() {
        return this.submissionUrl;
    }

    public void setSubmissionUrl(String url) {
        this.submissionUrl = url;
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public List<String> getFieldDefinitionNames() {
        ArrayList<String> result = new ArrayList<String>(this.fieldDefinitions.size());
        for (FieldDefinition fieldDefn : this.fieldDefinitions) {
            result.add(fieldDefn.getName());
        }
        return result;
    }

    public void setFieldDefinitions(List<FieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public void addFieldDefinition(FieldDefinition definition) {
        if (this.fieldDefinitions == null) {
            this.fieldDefinitions = new ArrayList<FieldDefinition>(8);
        }
        this.fieldDefinitions.add(definition);
    }

    public Collection<FieldGroup> getFieldGroups() {
        return this.fieldGroups;
    }

    public void setFieldGroups(Collection<FieldGroup> fieldGroups) {
        this.fieldGroups = fieldGroups;
    }

    public FormData getFormData() {
        return this.data;
    }

    public void setFormData(FormData data) {
        this.data = data;
    }

    public boolean dataExists(String dataKey) {
        if (this.data == null) {
            return false;
        }
        return this.data.getFieldNames().contains(dataKey);
    }

    public void addData(String fieldName, Object fieldData) {
        if (this.data == null) {
            this.data = new FormData();
        }
        this.data.addFieldData(fieldName, fieldData);
    }

    public void addField(Field field) {
        if (field == null) {
            return;
        }
        FieldDefinition fieldDefinition = field.getFieldDefinition();
        this.addFieldDefinition(fieldDefinition);
        Object value = field.getValue();
        if (value != null) {
            this.addData(fieldDefinition.getDataKeyName(), value);
        }
    }

    public void addFields(Collection<Field> fields) {
        for (Field field : fields) {
            this.addField(field);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" (");
        buffer.append("item=").append(this.item);
        buffer.append(", submissionUrl=").append(this.submissionUrl);
        buffer.append(", fieldGroups=").append(this.fieldGroups);
        buffer.append("\nfieldDefinitions=").append(this.fieldDefinitions);
        buffer.append("\nformData=").append(this.data);
        buffer.append(")");
        return buffer.toString();
    }
}

