/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.DefaultContentHandler;
import org.alfresco.repo.importer.ImportContentHandler;
import org.alfresco.repo.importer.ImportNode;
import org.alfresco.repo.importer.ImportParent;
import org.alfresco.repo.importer.Importer;
import org.alfresco.repo.importer.Parser;
import org.alfresco.repo.importer.view.NodeContext;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.usage.ContentUsageImpl;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidClassException;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterContentCache;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.util.StringUtils;
import org.xml.sax.ContentHandler;

public class ImporterComponent
implements ImporterService {
    private static final Log logger = LogFactory.getLog(ImporterComponent.class);
    private Parser viewParser;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private BehaviourFilter behaviourFilter;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;
    private RuleService ruleService;
    private PermissionService permissionService;
    private AuthorityService authorityService;
    private OwnableService ownableService;
    private VersionService versionService;
    private HiddenAspect hiddenAspect;
    private ContentUsageImpl contentUsageImpl;
    protected NodeService dbNodeService;
    private static final String START_BINDING_MARKER = "${";
    private static final String END_BINDING_MARKER = "}";

    public void setViewParser(Parser viewParser) {
        this.viewParser = viewParser;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setDbNodeService(NodeService nodeService) {
        this.dbNodeService = nodeService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setContentUsageImpl(ContentUsageImpl contentUsageImpl) {
        this.contentUsageImpl = contentUsageImpl;
    }

    @Override
    public void importView(Reader viewReader, Location location, ImporterBinding binding, ImporterProgress progress) {
        NodeRef nodeRef = this.getNodeRef(location, binding);
        this.parserImport(nodeRef, location, viewReader, new DefaultStreamHandler(), binding, progress);
    }

    @Override
    public void importView(ImportPackageHandler importHandler, Location location, ImporterBinding binding, ImporterProgress progress) throws ImporterException {
        importHandler.startImport();
        Reader dataFileReader = importHandler.getDataStream();
        NodeRef nodeRef = this.getNodeRef(location, binding);
        this.parserImport(nodeRef, location, dataFileReader, importHandler, binding, progress);
        importHandler.endImport();
    }

    private NodeRef getNodeRef(Location location, ImporterBinding binding) {
        String path;
        ParameterCheck.mandatory((String)"Location", (Object)location);
        NodeRef nodeRef = location.getNodeRef();
        if (nodeRef == null) {
            nodeRef = this.nodeService.getRootNode(location.getStoreRef());
        }
        if ((path = location.getPath()) != null && path.length() > 0) {
            path = this.bindPlaceHolder(path, binding);
            List nodeRefs = this.searchService.selectNodes(nodeRef, path = this.createValidPath(path), null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() == 0) {
                throw new ImporterException("Path " + path + " within node " + nodeRef + " does not exist - the path must resolve to a valid location");
            }
            if (nodeRefs.size() > 1) {
                throw new ImporterException("Path " + path + " within node " + nodeRef + " found too many locations - the path must resolve to one location");
            }
            nodeRef = (NodeRef)nodeRefs.get(0);
        }
        return nodeRef;
    }

    private String bindPlaceHolder(String value, ImporterBinding binding) {
        if (binding != null) {
            int iStartBinding = value.indexOf(START_BINDING_MARKER);
            while (iStartBinding != -1) {
                int iEndBinding = value.indexOf(END_BINDING_MARKER, iStartBinding + START_BINDING_MARKER.length());
                if (iEndBinding == -1) {
                    throw new ImporterException("Cannot find end marker } within value " + value);
                }
                String key = value.substring(iStartBinding + START_BINDING_MARKER.length(), iEndBinding);
                String keyValue = binding.getValue(key);
                if (keyValue == null) {
                    logger.warn((Object)("No binding value for placeholder (will default to empty string): " + value));
                }
                value = StringUtils.replace((String)value, (String)(START_BINDING_MARKER + key + END_BINDING_MARKER), (String)(keyValue == null ? "" : keyValue));
                iStartBinding = value.indexOf(START_BINDING_MARKER);
            }
        }
        return value;
    }

    private String createValidPath(String path) {
        StringBuffer validPath = new StringBuffer(path.length());
        String[] segments = StringUtils.delimitedListToStringArray((String)path, (String)"/");
        int i = 0;
        while (i < segments.length) {
            if (segments[i] != null && segments[i].length() > 0) {
                int colonIndex = segments[i].indexOf(58);
                if (colonIndex == -1) {
                    validPath.append(segments[i]);
                } else {
                    String[] qnameComponents = QName.splitPrefixedQName((String)segments[i]);
                    String localName = qnameComponents[1];
                    if (localName == null || localName.length() == 0) {
                        throw new IllegalArgumentException("Local name cannot be null or empty.");
                    }
                    localName = localName.replace("@", "_x0040_");
                    QName segmentQName = QName.createQName((String)qnameComponents[0], (String)localName, (NamespacePrefixResolver)this.namespaceService);
                    validPath.append(segmentQName.toPrefixString());
                }
            }
            if (i < segments.length - 1) {
                validPath.append("/");
            }
            ++i;
        }
        return validPath.toString();
    }

    public void parserImport(NodeRef nodeRef, Location location, Reader viewReader, ImportPackageHandler streamHandler, ImporterBinding binding, ImporterProgress progress) {
        ParameterCheck.mandatory((String)"Node Reference", (Object)nodeRef);
        ParameterCheck.mandatory((String)"View Reader", (Object)viewReader);
        ParameterCheck.mandatory((String)"Stream Handler", (Object)streamHandler);
        NodeImporter nodeImporter = new NodeImporter(nodeRef, location, binding, streamHandler, progress);
        try {
            nodeImporter.start();
            this.viewParser.parse(viewReader, nodeImporter);
            nodeImporter.end();
        }
        catch (RuntimeException e) {
            nodeImporter.error(e);
            throw e;
        }
    }

    public ContentHandler handlerImport(NodeRef nodeRef, Location location, ImportContentHandler handler, ImporterBinding binding, ImporterProgress progress) {
        ParameterCheck.mandatory((String)"Node Reference", (Object)nodeRef);
        DefaultContentHandler defaultHandler = new DefaultContentHandler(handler);
        ContentHandlerStreamHandler streamHandler = new ContentHandlerStreamHandler(defaultHandler);
        NodeImporter nodeImporter = new NodeImporter(nodeRef, location, binding, streamHandler, progress);
        defaultHandler.setImporter(nodeImporter);
        return defaultHandler;
    }

    private static class ContentHandlerStreamHandler
    implements ImportPackageHandler {
        private ImportContentHandler handler;

        private ContentHandlerStreamHandler(ImportContentHandler handler) {
            this.handler = handler;
        }

        @Override
        public void startImport() {
        }

        @Override
        public InputStream importStream(String content) {
            return this.handler.importStream(content);
        }

        @Override
        public Reader getDataStream() {
            return null;
        }

        @Override
        public void endImport() {
        }
    }

    private static class DefaultStreamHandler
    implements ImportPackageHandler {
        private DefaultStreamHandler() {
        }

        @Override
        public void startImport() {
        }

        @Override
        public InputStream importStream(String content) {
            DefaultResourceLoader loader = new DefaultResourceLoader();
            Resource resource = loader.getResource(content);
            if (!resource.exists()) {
                throw new ImporterException("Content URL " + content + " does not exist.");
            }
            try {
                return resource.getInputStream();
            }
            catch (IOException iOException) {
                throw new ImporterException("Failed to retrieve input stream for content URL " + content);
            }
        }

        @Override
        public Reader getDataStream() {
            return null;
        }

        @Override
        public void endImport() {
        }
    }

    private static class ImportedNodeRef {
        private ImportNode context;
        private QName property;
        private Serializable value;

        private ImportedNodeRef(ImportNode context, QName property, Serializable value) {
            this.context = context;
            this.property = property;
            this.value = value;
        }

        static /* synthetic */ Serializable access$0(ImportedNodeRef importedNodeRef) {
            return importedNodeRef.value;
        }

        static /* synthetic */ ImportNode access$1(ImportedNodeRef importedNodeRef) {
            return importedNodeRef.context;
        }

        static /* synthetic */ QName access$2(ImportedNodeRef importedNodeRef) {
            return importedNodeRef.property;
        }
    }

    private class NodeImporter
    implements Importer {
        private NodeRef rootRef;
        private QName rootAssocType;
        private Location location;
        private ImporterBinding binding;
        private ImporterProgress progress;
        private ImportPackageHandler streamHandler;
        private NodeImporterStrategy importStrategy;
        private UpdateExistingNodeImporterStrategy updateStrategy;
        private QName[] excludedClasses;
        private List<ImportedNodeRef> nodeRefs = new ArrayList<ImportedNodeRef>();

        private NodeImporter(NodeRef rootRef, Location location, ImporterBinding binding, ImportPackageHandler streamHandler, ImporterProgress progress) {
            this.rootRef = rootRef;
            this.rootAssocType = location.getChildAssocType();
            this.location = location;
            this.binding = binding;
            this.progress = progress;
            this.streamHandler = streamHandler;
            this.importStrategy = this.createNodeImporterStrategy(binding == null ? null : binding.getUUIDBinding());
            this.updateStrategy = new UpdateExistingNodeImporterStrategy();
            this.excludedClasses = binding == null || binding.getExcludedClasses() == null ? new QName[]{ContentModel.ASPECT_REFERENCEABLE} : binding.getExcludedClasses();
        }

        private NodeImporterStrategy createNodeImporterStrategy(ImporterBinding.UUID_BINDING uuidBinding) {
            if (uuidBinding == null) {
                return new CreateNewNodeImporterStrategy(true);
            }
            if (uuidBinding.equals((Object)ImporterBinding.UUID_BINDING.CREATE_NEW)) {
                return new CreateNewNodeImporterStrategy(true);
            }
            if (uuidBinding.equals((Object)ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID)) {
                return new CreateNewNodeImporterStrategy(false);
            }
            if (uuidBinding.equals((Object)ImporterBinding.UUID_BINDING.REMOVE_EXISTING)) {
                return new RemoveExistingNodeImporterStrategy();
            }
            if (uuidBinding.equals((Object)ImporterBinding.UUID_BINDING.REPLACE_EXISTING)) {
                return new ReplaceExistingNodeImporterStrategy();
            }
            if (uuidBinding.equals((Object)ImporterBinding.UUID_BINDING.UPDATE_EXISTING)) {
                return new UpdateExistingNodeImporterStrategy();
            }
            if (uuidBinding.equals((Object)ImporterBinding.UUID_BINDING.THROW_ON_COLLISION)) {
                return new ThrowOnCollisionNodeImporterStrategy();
            }
            return new CreateNewNodeImporterStrategy(true);
        }

        @Override
        public NodeRef getRootRef() {
            return this.rootRef;
        }

        @Override
        public QName getRootAssocType() {
            return this.rootAssocType;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public void start() {
            this.reportStarted();
        }

        @Override
        public void importMetaData(Map<QName, String> properties) {
            String complexPath = properties.get(QName.createQName((String)"http://www.alfresco.org/view/repository/1.0", (String)"exportOf"));
            String[] stringArray = complexPath.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeRef storeRootRef;
                String path = stringArray[n2];
                if (path != null && path.equals("/") && !(storeRootRef = ImporterComponent.this.nodeService.getRootNode(this.rootRef.getStoreRef())).equals((Object)this.rootRef)) {
                    throw new ImporterException("A complete repository package cannot be imported here");
                }
                ++n2;
            }
        }

        @Override
        public NodeRef importNode(ImportNode context) {
            NodeRef nodeRef = context.isReference() ? this.linkNode(context) : this.importStrategy.importNode(context);
            for (QName qName : context.getNodeAspects()) {
                if (ImporterComponent.this.nodeService.hasAspect(nodeRef, qName)) continue;
                ImporterComponent.this.nodeService.addAspect(nodeRef, qName, null);
                this.reportAspectAdded(nodeRef, qName);
            }
            ImporterComponent.this.hiddenAspect.checkHidden(nodeRef, false, false);
            for (Map.Entry entry : context.getProperties().entrySet()) {
                DataTypeDefinition valueDataType = context.getPropertyDataType((QName)entry.getKey());
                if (valueDataType == null || !valueDataType.getName().equals((Object)DataTypeDefinition.CONTENT)) continue;
                Object objVal = entry.getValue();
                if (objVal instanceof String) {
                    this.importContent(nodeRef, (QName)entry.getKey(), (String)objVal);
                    continue;
                }
                if (!(objVal instanceof Collection)) continue;
                for (String value : (Collection)objVal) {
                    this.importContent(nodeRef, (QName)entry.getKey(), value);
                }
            }
            if (context.getNodeAspects().contains(ContentModel.ASPECT_VERSIONABLE)) {
                this.generateVersioningForVersionableNode(nodeRef);
            }
            return nodeRef;
        }

        private void generateVersioningForVersionableNode(NodeRef nodeRef) {
            if (ImporterComponent.this.versionService.getVersionHistory(nodeRef) != null) {
                return;
            }
            String label = (String)((Object)ImporterComponent.this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
            Version version = ImporterComponent.this.versionService.createVersion(nodeRef, null);
            NodeRef versionNodeRef = VersionUtil.convertNodeRef(version.getFrozenStateNodeRef());
            ImporterComponent.this.dbNodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)label));
            ImporterComponent.this.dbNodeService.setProperty(versionNodeRef, ContentModel.PROP_VERSION_LABEL, null);
            ImporterComponent.this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)label));
        }

        private NodeRef linkNode(ImportNode context) {
            ImportParent parentContext = context.getParentContext();
            NodeRef parentRef = parentContext.getParentRef();
            String uuid = context.getUUID();
            if (uuid == null || uuid.length() == 0) {
                throw new ImporterException("Node reference does not specify a reference to follow.");
            }
            NodeRef referencedRef = new NodeRef(this.rootRef.getStoreRef(), uuid);
            if (!parentRef.equals((Object)this.getRootRef())) {
                QName assocType = this.getAssocType(context);
                AssociationDefinition assocDef = ImporterComponent.this.dictionaryService.getAssociation(assocType);
                if (assocDef.isChild()) {
                    QName childQName = this.getChildName(context);
                    if (childQName == null) {
                        String name = (String)((Object)ImporterComponent.this.nodeService.getProperty(referencedRef, ContentModel.PROP_NAME));
                        if (name == null || name.length() == 0) {
                            throw new ImporterException("Cannot determine node reference child name");
                        }
                        String localName = QName.createValidLocalName((String)name);
                        childQName = QName.createQName((String)assocType.getNamespaceURI(), (String)localName);
                    }
                    ImporterComponent.this.nodeService.addChild(parentRef, referencedRef, assocType, childQName);
                    this.reportNodeLinked(referencedRef, parentRef, assocType, childQName);
                } else {
                    ImporterComponent.this.nodeService.createAssociation(parentRef, referencedRef, assocType);
                    this.reportNodeLinked(parentRef, referencedRef, assocType, null);
                }
            }
            this.updateStrategy.importNode(context);
            return referencedRef;
        }

        private void importContent(NodeRef nodeRef, QName propertyName, String importContentData) {
            DataTypeDefinition dataTypeDef;
            ContentData contentData;
            String contentUrl;
            ImporterContentCache contentCache = this.binding == null ? null : this.binding.getImportConentCache();
            if ((importContentData = ImporterComponent.this.bindPlaceHolder(importContentData, this.binding)) != null && importContentData.length() > 0 && (contentUrl = (contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(dataTypeDef = ImporterComponent.this.dictionaryService.getDataType(DataTypeDefinition.CONTENT), (Object)importContentData)).getContentUrl()) != null && contentUrl.length() > 0) {
                Map propsBefore = null;
                if (ImporterComponent.this.contentUsageImpl != null && ImporterComponent.this.contentUsageImpl.getEnabled()) {
                    propsBefore = ImporterComponent.this.nodeService.getProperties(nodeRef);
                }
                if (contentCache != null) {
                    ContentData cachedContentData = contentCache.getContent(this.streamHandler, contentData);
                    ImporterComponent.this.nodeService.setProperty(nodeRef, propertyName, (Serializable)cachedContentData);
                } else {
                    InputStream contentStream = this.streamHandler.importStream(contentUrl);
                    ContentWriter writer = ImporterComponent.this.contentService.getWriter(nodeRef, propertyName, true);
                    writer.setEncoding(contentData.getEncoding());
                    writer.setMimetype(contentData.getMimetype());
                    writer.putContent(contentStream);
                }
                if (ImporterComponent.this.contentUsageImpl != null && ImporterComponent.this.contentUsageImpl.getEnabled()) {
                    Map propsAfter = ImporterComponent.this.nodeService.getProperties(nodeRef);
                    ImporterComponent.this.contentUsageImpl.onUpdateProperties(nodeRef, propsBefore, propsAfter);
                }
                this.reportContentCreated(nodeRef, contentUrl);
            }
        }

        @Override
        public void childrenImported(NodeRef nodeRef) {
            ImporterComponent.this.behaviourFilter.enableBehaviour(nodeRef);
            ImporterComponent.this.ruleService.enableRules(nodeRef);
        }

        @Override
        public NodeRef resolvePath(String path) {
            NodeRef referencedRef = null;
            if (path != null && path.length() > 0) {
                referencedRef = this.resolveImportedNodeRef(this.rootRef, path);
            }
            return referencedRef;
        }

        @Override
        public boolean isExcludedClass(QName className) {
            QName[] qNameArray = this.excludedClasses;
            int n = this.excludedClasses.length;
            int n2 = 0;
            while (n2 < n) {
                QName excludedClass = qNameArray[n2];
                if (excludedClass.equals((Object)className)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void end() {
            for (ImportedNodeRef importedRef : this.nodeRefs) {
                refProperty /* !! */  = null;
                if (ImportedNodeRef.access$0(importedRef) != null) {
                    if (ImportedNodeRef.access$0(importedRef) instanceof Collection) {
                        unresolvedRefs = (Collection)ImportedNodeRef.access$0(importedRef);
                        resolvedRefs = new ArrayList<NodeRef>(unresolvedRefs.size());
                        for (String unresolvedRef : unresolvedRefs) {
                            if (unresolvedRef == null || (nodeRef = this.resolveImportedNodeRef(ImportedNodeRef.access$1(importedRef).getNodeRef(), unresolvedRef)) == null) continue;
                            resolvedRefs.add(nodeRef);
                        }
                        refProperty /* !! */  = resolvedRefs;
                    } else {
                        refProperty /* !! */  = this.resolveImportedNodeRef(ImportedNodeRef.access$1(importedRef).getNodeRef(), (String)ImportedNodeRef.access$0(importedRef));
                    }
                }
                nodeTypeAndAspects = this.getNodeTypeAndAspects(ImportedNodeRef.access$1(importedRef));
                try {
                    for (QName typeOrAspect : nodeTypeAndAspects) {
                        ImporterComponent.access$0(ImporterComponent.this).disableBehaviour(ImportedNodeRef.access$1(importedRef).getNodeRef(), typeOrAspect);
                    }
                    ImporterComponent.access$1(ImporterComponent.this).setProperty(ImportedNodeRef.access$1(importedRef).getNodeRef(), ImportedNodeRef.access$2(importedRef), (Serializable)refProperty /* !! */ );
                    if (this.progress != null) {
                        this.progress.propertySet(ImportedNodeRef.access$1(importedRef).getNodeRef(), ImportedNodeRef.access$2(importedRef), (Serializable)refProperty /* !! */ );
                    }
                }
                finally {
                    var9_10 = nodeTypeAndAspects.iterator();
                    if (true) ** GOTO lbl33
                }
                {
                }
                do {
                    typeOrAspect = var9_10.next();
                    ImporterComponent.access$0(ImporterComponent.this).enableBehaviour(ImportedNodeRef.access$1(importedRef).getNodeRef(), typeOrAspect);
lbl33:
                    // 2 sources

                } while (var9_10.hasNext());
            }
            this.reportCompleted();
        }

        @Override
        public void error(Throwable e) {
            ImporterComponent.this.behaviourFilter.enableBehaviour();
            this.reportError(e);
        }

        private QName getChildName(ImportNode context) {
            QName assocType = this.getAssocType(context);
            QName childQName = null;
            String childName = context.getChildName();
            if (childName != null) {
                childName = ImporterComponent.this.bindPlaceHolder(childName, this.binding);
                if (ContentModel.TYPE_PERSON.equals((Object)context.getTypeDefinition().getName()) && assocType.equals((Object)ContentModel.ASSOC_CHILDREN)) {
                    childName = childName.toLowerCase();
                }
                String[] qnameComponents = QName.splitPrefixedQName((String)childName);
                childQName = QName.createQName((String)qnameComponents[0], (String)QName.createValidLocalName((String)qnameComponents[1]), (NamespacePrefixResolver)ImporterComponent.this.namespaceService);
            } else {
                Map<QName, Serializable> typeProperties = context.getProperties();
                Serializable nameValue = typeProperties.get(ContentModel.PROP_NAME);
                if (nameValue != null && !String.class.isAssignableFrom(nameValue.getClass())) {
                    throw new ImporterException("Unable to use childName property: " + ContentModel.PROP_NAME + " is not a string");
                }
                String name = (String)((Object)nameValue);
                if (name != null && name.length() > 0) {
                    name = ImporterComponent.this.bindPlaceHolder(name, this.binding);
                    String localName = QName.createValidLocalName((String)name);
                    childQName = QName.createQName((String)assocType.getNamespaceURI(), (String)localName);
                }
            }
            return childQName;
        }

        private QName getAssocType(ImportNode context) {
            QName assocType = context.getParentContext().getAssocType();
            if (assocType != null) {
                return assocType;
            }
            ArrayList<QName> nodeTypes = new ArrayList<QName>();
            nodeTypes.add(context.getTypeDefinition().getName());
            for (QName aspect : context.getNodeAspects()) {
                nodeTypes.add(aspect);
            }
            HashMap<QName, QName> targetTypes = new HashMap<QName, QName>();
            QName parentType = ImporterComponent.this.nodeService.getType(context.getParentContext().getParentRef());
            ClassDefinition classDef = ImporterComponent.this.dictionaryService.getClass(parentType);
            Map childAssocDefs = classDef.getChildAssociations();
            for (ChildAssociationDefinition childAssocDef : childAssocDefs.values()) {
                targetTypes.put(childAssocDef.getTargetClass().getName(), childAssocDef.getName());
            }
            Set parentAspects = ImporterComponent.this.nodeService.getAspects(context.getParentContext().getParentRef());
            for (QName parentAspect : parentAspects) {
                classDef = ImporterComponent.this.dictionaryService.getClass(parentAspect);
                if (classDef == null) {
                    throw new InvalidClassException("Failed import for context '" + context.getParentContext() + "'.  Unknown aspect: " + parentAspect, parentAspect);
                }
                childAssocDefs = classDef.getChildAssociations();
                for (ChildAssociationDefinition childAssocDef : childAssocDefs.values()) {
                    targetTypes.put(childAssocDef.getTargetClass().getName(), childAssocDef.getName());
                }
            }
            QName closestAssocType = null;
            int closestHit = 1;
            for (QName nodeType : nodeTypes) {
                block5: for (QName targetType : targetTypes.keySet()) {
                    QName testType = nodeType;
                    int howClose = 1;
                    while (testType != null) {
                        if (targetType.equals((Object)testType) && --howClose < closestHit) {
                            closestAssocType = (QName)targetTypes.get(targetType);
                            closestHit = howClose;
                            continue block5;
                        }
                        ClassDefinition testTypeDef = ImporterComponent.this.dictionaryService.getClass(testType);
                        QName qName = testType = testTypeDef == null ? null : testTypeDef.getParentName();
                    }
                }
            }
            return closestAssocType;
        }

        private Set<QName> getNodeTypeAndAspects(ImportNode context) {
            HashSet<QName> classNames = new HashSet<QName>();
            TypeDefinition typeDef = context.getTypeDefinition();
            classNames.add(typeDef.getName());
            classNames.addAll(context.getNodeAspects());
            return classNames;
        }

        private Map<QName, Serializable> bindProperties(ImportNode context) {
            Map<QName, Serializable> properties = context.getProperties();
            HashMap<QName, Serializable> boundProperties = new HashMap<QName, Serializable>(properties.size());
            for (QName property : properties.keySet()) {
                DataTypeDefinition valueDataType = context.getPropertyDataType(property);
                if (valueDataType != null && valueDataType.getName().equals((Object)DataTypeDefinition.CONTENT)) continue;
                Serializable value = properties.get(property);
                if (value instanceof Collection) {
                    ArrayList<Serializable> boundCollection = new ArrayList<Serializable>();
                    for (Serializable collectionValue : (Collection)((Object)value)) {
                        Serializable objValue = this.bindValue(context, property, valueDataType, collectionValue);
                        boundCollection.add(objValue);
                    }
                    value = boundCollection;
                } else {
                    value = this.bindValue(context, property, valueDataType, value);
                }
                if (valueDataType != null && (valueDataType.getName().equals((Object)DataTypeDefinition.NODE_REF) || valueDataType.getName().equals((Object)DataTypeDefinition.CATEGORY))) {
                    ImportedNodeRef importedRef = new ImportedNodeRef(context, property, value);
                    this.nodeRefs.add(importedRef);
                    continue;
                }
                boundProperties.put(property, value);
            }
            return boundProperties;
        }

        private List<AccessPermission> bindPermissions(List<AccessPermission> permissions) {
            ArrayList<AccessPermission> boundPermissions = new ArrayList<AccessPermission>(permissions.size());
            for (AccessPermission permission : permissions) {
                NodeContext.ACE ace = new NodeContext.ACE(permission.getAccessStatus(), ImporterComponent.this.bindPlaceHolder(permission.getAuthority(), this.binding), permission.getPermission());
                boundPermissions.add(ace);
            }
            return boundPermissions;
        }

        private Serializable bindValue(ImportNode context, QName property, DataTypeDefinition valueType, Serializable value) {
            Object objValue = null;
            if (value != null && valueType != null) {
                if (value instanceof String) {
                    value = ImporterComponent.this.bindPlaceHolder(value.toString(), this.binding);
                }
                objValue = valueType.getName().equals((Object)DataTypeDefinition.NODE_REF) || valueType.getName().equals((Object)DataTypeDefinition.CATEGORY) ? value : (Serializable)DefaultTypeConverter.INSTANCE.convert(valueType, value);
            }
            return objValue;
        }

        private NodeRef resolveImportedNodeRef(NodeRef sourceNodeRef, String importedRef) {
            NodeRef nodeRef = null;
            if ((importedRef = ImporterComponent.this.bindPlaceHolder(importedRef, this.binding)).equals("/")) {
                nodeRef = sourceNodeRef;
            } else if (importedRef.startsWith("/")) {
                String path = ImporterComponent.this.createValidPath(importedRef);
                List nodeRefs = ImporterComponent.this.searchService.selectNodes(sourceNodeRef, path, null, (NamespacePrefixResolver)ImporterComponent.this.namespaceService, false);
                if (nodeRefs.size() > 0) {
                    nodeRef = (NodeRef)nodeRefs.get(0);
                }
            } else if (NodeRef.isNodeRef((String)importedRef)) {
                nodeRef = new NodeRef(importedRef);
            } else {
                try {
                    String path = ImporterComponent.this.createValidPath(importedRef);
                    List nodeRefs = ImporterComponent.this.searchService.selectNodes(sourceNodeRef, path, null, (NamespacePrefixResolver)ImporterComponent.this.namespaceService, false);
                    if (nodeRefs.size() > 0) {
                        nodeRef = (NodeRef)nodeRefs.get(0);
                    }
                }
                catch (XPathException xPathException) {
                    nodeRef = new NodeRef(importedRef);
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
            }
            return nodeRef;
        }

        private void reportStarted() {
            if (this.progress != null) {
                this.progress.started();
            }
        }

        private void reportCompleted() {
            if (this.progress != null) {
                this.progress.completed();
            }
        }

        private void reportError(Throwable e) {
            if (this.progress != null) {
                this.progress.error(e);
            }
        }

        private void reportNodeCreated(ChildAssociationRef childAssocRef) {
            if (this.progress != null) {
                this.progress.nodeCreated(childAssocRef.getChildRef(), childAssocRef.getParentRef(), childAssocRef.getTypeQName(), childAssocRef.getQName());
            }
        }

        private void reportNodeLinked(NodeRef childRef, NodeRef parentRef, QName assocType, QName childName) {
            if (this.progress != null) {
                this.progress.nodeLinked(childRef, parentRef, assocType, childName);
            }
        }

        private void reportContentCreated(NodeRef nodeRef, String sourceUrl) {
            if (this.progress != null) {
                this.progress.contentCreated(nodeRef, sourceUrl);
            }
        }

        private void reportAspectAdded(NodeRef nodeRef, QName aspect) {
            if (this.progress != null) {
                this.progress.aspectAdded(nodeRef, aspect);
            }
        }

        private void reportPropertySet(NodeRef nodeRef, Map<QName, Serializable> properties) {
            if (this.progress != null && properties != null) {
                for (QName property : properties.keySet()) {
                    this.progress.propertySet(nodeRef, property, properties.get(property));
                }
            }
        }

        private void reportPermissionSet(NodeRef nodeRef, List<AccessPermission> permissions) {
            if (this.progress != null && permissions != null) {
                for (AccessPermission permission : permissions) {
                    this.progress.permissionSet(nodeRef, permission);
                }
            }
        }

        private class CreateNewNodeImporterStrategy
        implements NodeImporterStrategy {
            private boolean assignNewUUID;

            public CreateNewNodeImporterStrategy(boolean assignNewUUID) {
                this.assignNewUUID = assignNewUUID;
            }

            @Override
            public NodeRef importNode(ImportNode node) {
                TypeDefinition nodeType = node.getTypeDefinition();
                NodeRef parentRef = node.getParentContext().getParentRef();
                QName assocType = NodeImporter.this.getAssocType(node);
                QName childQName = NodeImporter.this.getChildName(node);
                if (childQName == null) {
                    throw new ImporterException("Cannot determine child name of node (type: " + nodeType.getName() + ")");
                }
                Set nodeTypeAndAspects = NodeImporter.this.getNodeTypeAndAspects(node);
                for (QName typeOrAspect : nodeTypeAndAspects) {
                    ImporterComponent.this.behaviourFilter.disableBehaviour(typeOrAspect);
                }
                Map initialProperties = NodeImporter.this.bindProperties(node);
                if (!this.assignNewUUID && node.getUUID() != null) {
                    initialProperties.put(ContentModel.PROP_NODE_UUID, node.getUUID());
                }
                ChildAssociationRef assocRef = ImporterComponent.this.nodeService.createNode(parentRef, assocType, childQName, nodeType.getName(), initialProperties);
                NodeRef nodeRef = assocRef.getChildRef();
                if (!AuthenticationUtil.isRunAsUserTheSystemUser() && !ImporterComponent.this.authorityService.hasAdminAuthority()) {
                    ImporterComponent.this.ownableService.takeOwnership(nodeRef);
                }
                List permissions = null;
                AccessStatus writePermission = ImporterComponent.this.permissionService.hasPermission(nodeRef, "ChangePermissions");
                if (AuthenticationUtil.isRunAsUserTheSystemUser() || writePermission.equals((Object)AccessStatus.ALLOWED)) {
                    permissions = NodeImporter.this.bindPermissions(node.getAccessControlEntries());
                    for (AccessPermission permission : permissions) {
                        ImporterComponent.this.permissionService.setPermission(nodeRef, permission.getAuthority(), permission.getPermission(), permission.getAccessStatus().equals((Object)AccessStatus.ALLOWED));
                    }
                    boolean inheritPermissions = node.getInheritPermissions();
                    if (!inheritPermissions) {
                        ImporterComponent.this.permissionService.setInheritParentPermissions(nodeRef, false);
                    }
                }
                for (QName typeOrAspect : nodeTypeAndAspects) {
                    ImporterComponent.this.behaviourFilter.enableBehaviour(typeOrAspect);
                }
                ImporterComponent.this.behaviourFilter.disableBehaviour(nodeRef);
                ImporterComponent.this.ruleService.disableRules(nodeRef);
                NodeImporter.this.reportNodeCreated(assocRef);
                NodeImporter.this.reportPropertySet(nodeRef, initialProperties);
                NodeImporter.this.reportPermissionSet(nodeRef, permissions);
                return nodeRef;
            }
        }

        private class RemoveExistingNodeImporterStrategy
        implements NodeImporterStrategy {
            private NodeImporterStrategy createNewStrategy;

            private RemoveExistingNodeImporterStrategy() {
                this.createNewStrategy = new CreateNewNodeImporterStrategy(false);
            }

            @Override
            public NodeRef importNode(ImportNode node) {
                String uuid = node.getUUID();
                if (uuid != null && uuid.length() > 0) {
                    NodeRef existingNodeRef = new NodeRef(NodeImporter.this.rootRef.getStoreRef(), uuid);
                    if (ImporterComponent.this.nodeService.exists(existingNodeRef)) {
                        ChildAssociationRef childAssocRef = ImporterComponent.this.nodeService.getPrimaryParent(existingNodeRef);
                        ImporterComponent.this.nodeService.removeChild(childAssocRef.getParentRef(), childAssocRef.getChildRef());
                    }
                }
                return this.createNewStrategy.importNode(node);
            }
        }

        private class ReplaceExistingNodeImporterStrategy
        implements NodeImporterStrategy {
            private NodeImporterStrategy createNewStrategy;

            private ReplaceExistingNodeImporterStrategy() {
                this.createNewStrategy = new CreateNewNodeImporterStrategy(false);
            }

            @Override
            public NodeRef importNode(ImportNode node) {
                String uuid = node.getUUID();
                if (uuid != null && uuid.length() > 0) {
                    NodeRef existingNodeRef = new NodeRef(NodeImporter.this.rootRef.getStoreRef(), uuid);
                    if (ImporterComponent.this.nodeService.exists(existingNodeRef)) {
                        ChildAssociationRef childAssocRef = ImporterComponent.this.nodeService.getPrimaryParent(existingNodeRef);
                        ImporterComponent.this.nodeService.removeChild(childAssocRef.getParentRef(), childAssocRef.getChildRef());
                        node.getParentContext().setParentRef(childAssocRef.getParentRef());
                        node.getParentContext().setAssocType(childAssocRef.getTypeQName());
                    }
                }
                return this.createNewStrategy.importNode(node);
            }
        }

        private class ThrowOnCollisionNodeImporterStrategy
        implements NodeImporterStrategy {
            private NodeImporterStrategy createNewStrategy;

            private ThrowOnCollisionNodeImporterStrategy() {
                this.createNewStrategy = new CreateNewNodeImporterStrategy(false);
            }

            @Override
            public NodeRef importNode(ImportNode node) {
                String uuid = node.getUUID();
                if (uuid != null && uuid.length() > 0) {
                    NodeRef existingNodeRef = new NodeRef(NodeImporter.this.rootRef.getStoreRef(), uuid);
                    if (ImporterComponent.this.nodeService.exists(existingNodeRef)) {
                        throw new InvalidNodeRefException("Node " + existingNodeRef + " already exists", existingNodeRef);
                    }
                }
                return this.createNewStrategy.importNode(node);
            }
        }

        private class UpdateExistingNodeImporterStrategy
        implements NodeImporterStrategy {
            private NodeImporterStrategy createNewStrategy;

            private UpdateExistingNodeImporterStrategy() {
                this.createNewStrategy = new CreateNewNodeImporterStrategy(false);
            }

            @Override
            public NodeRef importNode(ImportNode node) {
                String uuid = node.getUUID();
                NodeRef existingNodeRef = null;
                if (uuid == null && NodeImporter.this.location.getPath() != null) {
                    NodeRef parentNodeRef = node.getParentContext().getParentRef();
                    String path = String.valueOf(NodeImporter.this.location.getPath()) + "/" + QName.createQName((String)node.getTypeDefinition().getName().getNamespaceURI(), (String)node.getChildName()).toPrefixString();
                    List nodeRefs = ImporterComponent.this.searchService.selectNodes(parentNodeRef, path, null, (NamespacePrefixResolver)ImporterComponent.this.namespaceService, false);
                    if (!nodeRefs.isEmpty()) {
                        existingNodeRef = (NodeRef)nodeRefs.get(0);
                    }
                }
                if (uuid != null && uuid.length() > 0 || existingNodeRef != null) {
                    if (existingNodeRef == null) {
                        existingNodeRef = new NodeRef(NodeImporter.this.rootRef.getStoreRef(), uuid);
                    }
                    if (ImporterComponent.this.nodeService.exists(existingNodeRef)) {
                        Map existingProperties = ImporterComponent.this.nodeService.getProperties(existingNodeRef);
                        Map updateProperties = NodeImporter.this.bindProperties(node);
                        if (updateProperties != null && updateProperties.size() > 0) {
                            existingProperties.putAll(updateProperties);
                            ImporterComponent.this.nodeService.setProperties(existingNodeRef, existingProperties);
                        }
                        List permissions = null;
                        AccessStatus writePermission = ImporterComponent.this.permissionService.hasPermission(existingNodeRef, "ChangePermissions");
                        if (AuthenticationUtil.isRunAsUserTheSystemUser() || writePermission.equals((Object)AccessStatus.ALLOWED)) {
                            boolean inheritPermissions = node.getInheritPermissions();
                            if (!inheritPermissions) {
                                ImporterComponent.this.permissionService.setInheritParentPermissions(existingNodeRef, false);
                            }
                            permissions = NodeImporter.this.bindPermissions(node.getAccessControlEntries());
                            for (AccessPermission permission : permissions) {
                                ImporterComponent.this.permissionService.setPermission(existingNodeRef, permission.getAuthority(), permission.getPermission(), permission.getAccessStatus().equals((Object)AccessStatus.ALLOWED));
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Updating existing node " + existingNodeRef + " at " + ImporterComponent.this.nodeService.getPath(existingNodeRef) + " for " + node.toString()));
                        }
                        NodeImporter.this.reportPropertySet(existingNodeRef, updateProperties);
                        NodeImporter.this.reportPermissionSet(existingNodeRef, permissions);
                        return existingNodeRef;
                    }
                }
                return this.createNewStrategy.importNode(node);
            }
        }
    }

    public static interface NodeImporterStrategy {
        public NodeRef importNode(ImportNode var1);
    }
}

