/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.AddFeaturesActionExecuter;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AddFeaturesActionExecuterTest
extends BaseSpringTest {
    private static final String ID = GUID.generate();
    private NodeService nodeService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private AddFeaturesActionExecuter executer;

    @Before
    public void before() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.executer = (AddFeaturesActionExecuter)this.applicationContext.getBean("add-features");
    }

    @Test
    public void testExecution() {
        AddFeaturesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_CLASSIFIABLE));
        ActionImpl action = new ActionImpl(null, ID, "add-features", null);
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        this.executer.execute((Action)action, this.nodeRef);
        AddFeaturesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_CLASSIFIABLE));
    }

    @Test
    public void testCheckLocalizedParamDefintionWithConstraint() {
        I18NUtil.setLocale((Locale)Locale.GERMAN);
        ActionDefinition actionDef = this.executer.getActionDefinition();
        List paramDef = actionDef.getParameterDefinitions();
        AddFeaturesActionExecuterTest.assertNotNull((Object)paramDef);
        String constraintName = ((ParameterDefinition)paramDef.get(0)).getParameterConstraintName();
        AddFeaturesActionExecuterTest.assertNotNull((Object)constraintName);
        AddFeaturesActionExecuterTest.assertEquals((String)"ac-aspects", (String)constraintName);
        I18NUtil.setLocale((Locale)Locale.ITALY);
        actionDef = this.executer.getActionDefinition();
        paramDef = actionDef.getParameterDefinitions();
        AddFeaturesActionExecuterTest.assertNotNull((Object)paramDef);
        constraintName = ((ParameterDefinition)paramDef.get(0)).getParameterConstraintName();
        AddFeaturesActionExecuterTest.assertNotNull((Object)constraintName);
        AddFeaturesActionExecuterTest.assertEquals((String)"ac-aspects", (String)constraintName);
        I18NUtil.setLocale((Locale)Locale.getDefault());
    }

    @Test
    public void testCheckActionContext() {
        ActionImpl action = new ActionImpl(null, ID, "add-features", null);
        action.setParameterValue("actionContext", (Serializable)((Object)"v1"));
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        this.executer.execute((Action)action, this.nodeRef);
        AddFeaturesActionExecuterTest.assertFalse((boolean)this.nodeService.getProperties(this.nodeRef).containsKey(QName.createQName((String)"actionContext")));
    }
}

