/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.descriptor.DescriptorServiceAvailableEvent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.alfresco.service.license.LicenseException;
import org.alfresco.service.license.LicenseService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.VersionNumber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class DescriptorServiceImpl
extends AbstractLifecycleBean
implements DescriptorService,
InitializingBean,
LicenseService.LicenseChangeHandler {
    private DescriptorDAO serverDescriptorDAO;
    private DescriptorDAO currentRepoDescriptorDAO;
    private DescriptorDAO installedRepoDescriptorDAO;
    private TransactionService transactionService;
    private LicenseService licenseService;
    private RepoUsageComponent repoUsageComponent;
    private HBDataCollectorService hbDataCollectorService;
    private boolean isBootstrapped;
    private Descriptor serverDescriptor;
    private Descriptor currentRepoDescriptor;
    private Descriptor installedRepoDescriptor;
    private ReentrantReadWriteLock currentRepoDescriptorLock = new ReentrantReadWriteLock();
    private Object licenseLock = new Object();
    private static final Log logger = LogFactory.getLog(DescriptorServiceImpl.class);

    public void setServerDescriptorDAO(DescriptorDAO serverDescriptorDAO) {
        this.serverDescriptorDAO = serverDescriptorDAO;
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setInstalledRepoDescriptorDAO(DescriptorDAO installedRepoDescriptorDAO) {
        this.installedRepoDescriptorDAO = installedRepoDescriptorDAO;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setHbDataCollectorService(HBDataCollectorService hbDataCollectorService) {
        this.hbDataCollectorService = hbDataCollectorService;
    }

    public void setRepoUsageComponent(RepoUsageComponent repoUsageComponent) {
        this.repoUsageComponent = repoUsageComponent;
    }

    @Override
    public Descriptor getServerDescriptor() {
        return this.serverDescriptor;
    }

    @Override
    public Descriptor getCurrentRepositoryDescriptor() {
        this.currentRepoDescriptorLock.readLock().lock();
        try {
            Descriptor descriptor = this.currentRepoDescriptor != null ? this.currentRepoDescriptor : new UnknownDescriptor();
            return descriptor;
        }
        finally {
            this.currentRepoDescriptorLock.readLock().unlock();
        }
    }

    private void setCurrentRepoDescriptor(Descriptor newRepoDescriptor) {
        this.currentRepoDescriptorLock.writeLock().lock();
        try {
            this.currentRepoDescriptor = newRepoDescriptor;
        }
        finally {
            this.currentRepoDescriptorLock.writeLock().unlock();
        }
    }

    private boolean isCurrentRepoDescriptorIsNull() {
        this.currentRepoDescriptorLock.readLock().lock();
        try {
            boolean bl = this.currentRepoDescriptor == null;
            return bl;
        }
        finally {
            this.currentRepoDescriptorLock.readLock().unlock();
        }
    }

    private boolean currentRepoDescriptorNullOrModeHasChanged(RepoUsage.LicenseMode newMode) {
        this.currentRepoDescriptorLock.readLock().lock();
        try {
            boolean bl = this.currentRepoDescriptor == null || newMode != this.currentRepoDescriptor.getLicenseMode();
            return bl;
        }
        finally {
            this.currentRepoDescriptorLock.readLock().unlock();
        }
    }

    @Override
    public Descriptor getInstalledRepositoryDescriptor() {
        if (this.installedRepoDescriptor == null) {
            throw new IllegalStateException("Not bootstrapped");
        }
        return this.installedRepoDescriptor;
    }

    @Override
    public LicenseDescriptor getLicenseDescriptor() {
        if (this.licenseService == null) {
            throw new IllegalStateException("Not bootstrapped");
        }
        return this.licenseService.getLicense();
    }

    @Override
    public String loadLicense() {
        final RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setForceWritable(true);
        final RetryingTransactionHelper.RetryingTransactionCallback<String> loadCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                return DescriptorServiceImpl.this.licenseService.loadLicense();
            }
        };
        String result = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)txnHelper.doInTransaction(loadCallback, false, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Load license call returning: " + result));
        }
        return result;
    }

    @Override
    public String loadLicense(final InputStream licenseStream) {
        final RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setForceWritable(true);
        final RetryingTransactionHelper.RetryingTransactionCallback<String> loadCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                return DescriptorServiceImpl.this.licenseService.loadLicense(licenseStream);
            }
        };
        String result = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)txnHelper.doInTransaction(loadCallback, false, true);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Load license call returning: " + result));
        }
        return result;
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.RunAsWork<Void> bootstrapWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                DescriptorServiceImpl.this.bootstrap();
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)bootstrapWork, (String)AuthenticationUtil.getSystemUserName());
        this.isBootstrapped = true;
        ((ApplicationContext)event.getSource()).publishEvent((ApplicationEvent)new DescriptorServiceAvailableEvent(this));
    }

    private void bootstrap() {
        ApplicationContext applicationContext;
        logger.debug((Object)"onBootstrap");
        RetryingTransactionHelper helper = this.transactionService.getRetryingTransactionHelper();
        helper.setForceWritable(true);
        RetryingTransactionHelper.RetryingTransactionCallback<Descriptor> getDescriptorCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Descriptor>(){

            @Override
            public Descriptor execute() {
                return DescriptorServiceImpl.this.installedRepoDescriptorDAO.getDescriptor();
            }
        };
        Descriptor installed = helper.doInTransaction(getDescriptorCallback, false, false);
        this.installedRepoDescriptor = installed != null ? installed : new UnknownDescriptor();
        this.licenseService = (LicenseService)this.constructSpecialService("org.alfresco.enterprise.license.LicenseComponent");
        if (this.licenseService == null) {
            this.licenseService = new NOOPLicenseService();
        }
        if ((applicationContext = this.getApplicationContext()) instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)applicationContext).getBeanFactory().registerSingleton("licenseService", (Object)this.licenseService);
        }
        this.licenseService.registerOnLicenseChange((LicenseService.LicenseChangeHandler)((Object)this.hbDataCollectorService));
        this.licenseService.registerOnLicenseChange(this);
        try {
            this.licenseService.verifyLicense();
        }
        catch (LicenseException licenseException) {}
    }

    protected void onShutdown(ApplicationEvent event) {
        if (this.licenseService != null) {
            this.licenseService.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.serverDescriptor = this.serverDescriptorDAO.getDescriptor();
    }

    private Object constructSpecialService(String className) {
        try {
            Class<?> componentClass = Class.forName(className);
            Constructor<?> constructor = componentClass.getConstructor(ApplicationContext.class);
            return constructor.newInstance(this.getApplicationContext());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to initialise " + className, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLicenseChange(final LicenseDescriptor licenseDescriptor) {
        Object object = this.licenseLock;
        synchronized (object) {
            logger.debug((Object)("Received changed license descriptor: " + licenseDescriptor));
            RetryingTransactionHelper.RetryingTransactionCallback<RepoUsage> updateLicenseCallback = new RetryingTransactionHelper.RetryingTransactionCallback<RepoUsage>(){

                @Override
                public RepoUsage execute() {
                    RepoUsage.LicenseMode newMode = licenseDescriptor.getLicenseMode();
                    Long expiryTime = licenseDescriptor.getValidUntil() == null ? null : Long.valueOf(licenseDescriptor.getValidUntil().getTime());
                    RepoUsage restrictions = new RepoUsage(System.currentTimeMillis(), licenseDescriptor.getMaxUsers(), licenseDescriptor.getMaxDocs(), newMode, expiryTime, false);
                    DescriptorServiceImpl.this.repoUsageComponent.setRestrictions(restrictions);
                    if (restrictions.getUsers() == null) {
                        DescriptorServiceImpl.this.repoUsageComponent.resetUsage(RepoUsage.UsageType.USAGE_USERS);
                    }
                    if (restrictions.getDocuments() == null) {
                        DescriptorServiceImpl.this.repoUsageComponent.resetUsage(RepoUsage.UsageType.USAGE_DOCUMENTS);
                    }
                    if (DescriptorServiceImpl.this.currentRepoDescriptorNullOrModeHasChanged(newMode)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Changing license mode in current repo descriptor to: " + (Object)((Object)newMode)));
                        }
                        Descriptor newRepoDescriptor = DescriptorServiceImpl.this.currentRepoDescriptorDAO.updateDescriptor(DescriptorServiceImpl.this.serverDescriptor, newMode);
                        DescriptorServiceImpl.this.setCurrentRepoDescriptor(newRepoDescriptor);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("License restrictions updated: " + restrictions));
                    }
                    return null;
                }
            };
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            txnHelper.setForceWritable(true);
            txnHelper.doInTransaction(updateLicenseCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLicenseFail() {
        Object object = this.licenseLock;
        synchronized (object) {
            if (this.isCurrentRepoDescriptorIsNull()) {
                RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
                RetryingTransactionHelper.RetryingTransactionCallback<Void> nopLoadLicense = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() {
                        Descriptor newRepoDescriptor = DescriptorServiceImpl.this.currentRepoDescriptorDAO.updateDescriptor(DescriptorServiceImpl.this.serverDescriptor, RepoUsage.LicenseMode.UNKNOWN);
                        DescriptorServiceImpl.this.setCurrentRepoDescriptor(newRepoDescriptor);
                        return null;
                    }
                };
                txnHelper.setForceWritable(true);
                txnHelper.doInTransaction(nopLoadLicense, false, false);
            }
        }
    }

    @Override
    public boolean isBootstrapped() {
        return this.isBootstrapped;
    }

    public static abstract class BaseDescriptor
    implements Descriptor {
        private VersionNumber versionNumber = null;
        private String strVersion = null;

        @Override
        public VersionNumber getVersionNumber() {
            if (this.versionNumber == null) {
                StringBuilder version = new StringBuilder();
                version.append(this.getVersionMajor());
                version.append(".");
                version.append(this.getVersionMinor());
                version.append(".");
                version.append(this.getVersionRevision());
                this.versionNumber = new VersionNumber(version.toString());
            }
            return this.versionNumber;
        }

        @Override
        public String getVersion() {
            if (this.strVersion == null) {
                boolean hasBuild;
                StringBuilder version = new StringBuilder(this.getVersionMajor());
                version.append(".");
                version.append(this.getVersionMinor());
                version.append(".");
                version.append(this.getVersionRevision());
                String label = this.getVersionLabel();
                String build = this.getVersionBuild();
                boolean hasLabel = label != null && label.length() > 0;
                boolean bl = hasBuild = build != null && build.length() > 0;
                if (hasLabel || hasBuild) {
                    version.append(" (");
                }
                if (hasLabel) {
                    version.append(label);
                }
                if (hasBuild) {
                    if (hasLabel) {
                        version.append(" ");
                    }
                    version.append(build);
                }
                if (hasLabel || hasBuild) {
                    version.append(")");
                }
                this.strVersion = version.toString();
            }
            return this.strVersion;
        }

        protected int getSchema(String schemaStr) {
            if (schemaStr == null) {
                return 0;
            }
            try {
                int schema = Integer.parseInt(schemaStr);
                if (schema < 0) {
                    throw new NumberFormatException();
                }
                return schema;
            }
            catch (NumberFormatException numberFormatException) {
                throw new AlfrescoRuntimeException("Schema must be a positive integer '" + schemaStr + "' is not!");
            }
        }
    }

    private class NOOPLicenseService
    implements LicenseService {
        private NOOPLicenseService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void verifyLicense() throws LicenseException {
            Object object = DescriptorServiceImpl.this.licenseLock;
            synchronized (object) {
                if (DescriptorServiceImpl.this.isCurrentRepoDescriptorIsNull()) {
                    RetryingTransactionHelper txnHelper = DescriptorServiceImpl.this.transactionService.getRetryingTransactionHelper();
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> nopLoadLicense = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() {
                            Descriptor newRepoDescriptor = DescriptorServiceImpl.this.currentRepoDescriptorDAO.updateDescriptor(DescriptorServiceImpl.this.serverDescriptor, RepoUsage.LicenseMode.UNKNOWN);
                            DescriptorServiceImpl.this.setCurrentRepoDescriptor(newRepoDescriptor);
                            return null;
                        }
                    };
                    txnHelper.doInTransaction(nopLoadLicense, false, false);
                }
            }
        }

        @Override
        public boolean isLicenseValid() {
            return true;
        }

        @Override
        public LicenseDescriptor getLicense() throws LicenseException {
            return null;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void registerOnLicenseChange(LicenseService.LicenseChangeHandler callback) {
        }

        @Override
        public String loadLicense() {
            return "Done";
        }

        @Override
        public String loadLicense(InputStream licenseStream) {
            return this.loadLicense();
        }
    }

    private class UnknownDescriptor
    implements Descriptor {
        private UnknownDescriptor() {
        }

        @Override
        public String getId() {
            return "Unknown";
        }

        @Override
        public String getName() {
            return "Unknown";
        }

        @Override
        public String getVersionMajor() {
            return "Unknown";
        }

        @Override
        public String getVersionMinor() {
            return "Unknown";
        }

        @Override
        public String getVersionRevision() {
            return "Unknown";
        }

        @Override
        public String getVersionLabel() {
            return "Unknown";
        }

        @Override
        public String getVersionBuild() {
            return "Unknown";
        }

        @Override
        public VersionNumber getVersionNumber() {
            return new VersionNumber("0.0.0");
        }

        @Override
        public String getVersion() {
            return "Unknown";
        }

        @Override
        public String getEdition() {
            return "Unknown";
        }

        @Override
        public int getSchema() {
            return 0;
        }

        @Override
        public String[] getDescriptorKeys() {
            return new String[0];
        }

        @Override
        public String getDescriptor(String key) {
            return null;
        }

        @Override
        public RepoUsage.LicenseMode getLicenseMode() {
            return RepoUsage.LicenseMode.UNKNOWN;
        }
    }
}

