/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.List;
import org.alfresco.repo.forms.processor.node.AbstractAssocCommand;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AddAssocCommand
extends AbstractAssocCommand {
    private static final Log logger = LogFactory.getLog(AddAssocCommand.class);

    public AddAssocCommand(NodeRef sourceNodeRef, NodeRef targetNodeRef, QName assocQName) {
        super(sourceNodeRef, targetNodeRef, assocQName);
    }

    @Override
    protected void updateAssociations(NodeService nodeService) {
        List existingAssocs = nodeService.getTargetAssocs(this.sourceNodeRef, (QNamePattern)this.assocQName);
        for (AssociationRef assoc : existingAssocs) {
            if (!assoc.getTargetRef().equals((Object)this.targetNodeRef)) continue;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Attempt to add existing association prevented. " + assoc));
            }
            return;
        }
        nodeService.createAssociation(this.sourceNodeRef, this.targetNodeRef, this.assocQName);
    }
}

