/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.DummySSLServerSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.alfresco.repo.imap.AlfrescoImapHostManager;
import org.alfresco.repo.imap.ImapService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class AlfrescoImapServer
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(AlfrescoImapServer.class);
    private ImapServer serverImpl;
    private ImapServer secureServerImpl;
    private int port = 143;
    private int securePort = 993;
    private boolean imapsEnabled = false;
    private boolean imapEnabled = true;
    private String host = "0.0.0.0";
    private UserManager imapUserManager;
    private ImapService imapService;
    private boolean imapServerEnabled;

    public void setImapServerEnabled(boolean imapServerEnabled) {
        this.imapServerEnabled = imapServerEnabled;
    }

    public boolean isImapServerEnabled() {
        return this.imapServerEnabled;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setSecurePort(int securePort) {
        this.securePort = securePort;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public String getHost() {
        return this.host;
    }

    public void setImapService(ImapService imapService) {
        this.imapService = imapService;
    }

    public void setImapUserManager(UserManager imapUserManager) {
        this.imapUserManager = imapUserManager;
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (this.imapServerEnabled) {
            this.startup();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"IMAP service is disabled.");
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        this.shutdown();
    }

    public void startup() {
        if (this.serverImpl == null) {
            AtomicReference<Exception> serverOpeningExceptionRef;
            Managers imapManagers = new Managers(){

                public ImapHostManager getImapHostManager() {
                    return new AlfrescoImapHostManager(AlfrescoImapServer.this.imapService);
                }

                public UserManager getUserManager() {
                    return AlfrescoImapServer.this.imapUserManager;
                }
            };
            if (this.isImapEnabled()) {
                serverOpeningExceptionRef = new AtomicReference<Exception>();
                this.serverImpl = new DefaultImapServer(new ServerSetup(this.port, this.host, "imap"), imapManagers, serverOpeningExceptionRef);
                this.serverImpl.startService(null);
                this.checkForOpeningExceptions(serverOpeningExceptionRef);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("IMAP service started on host:port " + this.host + ":" + this.port));
                }
            }
            if (this.isImapsEnabled()) {
                serverOpeningExceptionRef = new AtomicReference();
                this.secureServerImpl = new SecureImapServer(new ServerSetup(this.securePort, this.host, "imaps"), imapManagers, serverOpeningExceptionRef);
                this.secureServerImpl.startService(null);
                this.checkForOpeningExceptions(serverOpeningExceptionRef);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("IMAPS service started on host:port " + this.host + ":" + this.securePort));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"IMAP server already running.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForOpeningExceptions(AtomicReference<Exception> serverOpeningExceptionRef) {
        AtomicReference<Exception> atomicReference = serverOpeningExceptionRef;
        synchronized (atomicReference) {
            block6: {
                try {
                    serverOpeningExceptionRef.wait();
                    if (serverOpeningExceptionRef.get() != null) {
                        throw new RuntimeException(serverOpeningExceptionRef.get());
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void shutdown() {
        if (this.serverImpl != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"IMAP service stopping.");
            }
            this.serverImpl.stopService(null);
        }
        if (this.secureServerImpl != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"IMAPS service stopping.");
            }
            this.secureServerImpl.stopService(null);
        }
    }

    public void setImapsEnabled(boolean imapsEnabled) {
        this.imapsEnabled = imapsEnabled;
    }

    public boolean isImapsEnabled() {
        return this.imapsEnabled;
    }

    public void setImapEnabled(boolean imapEnabled) {
        this.imapEnabled = imapEnabled;
    }

    public boolean isImapEnabled() {
        return this.imapEnabled;
    }

    private class DefaultImapServer
    extends ImapServer {
        public DefaultImapServer(ServerSetup setup, Managers managers, AtomicReference<Exception> serverOpeningExceptionRef) {
            super(setup, managers, serverOpeningExceptionRef);
        }

        protected synchronized ServerSocket openServerSocket() throws IOException {
            ServerSocket ret;
            if (this.setup.isSecure()) {
                try {
                    ret = (SSLServerSocket)DummySSLServerSocketFactory.getDefault().createServerSocket(this.setup.getPort(), 0, this.bindTo);
                }
                catch (IOException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)("Unable to open socket bindTo:" + this.bindTo + " port " + this.setup.getPort()), (Throwable)e);
                    }
                    throw e;
                }
            }
            try {
                ret = new ServerSocket(this.setup.getPort(), 0, this.bindTo);
            }
            catch (IOException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Unable to open socket bindTo:" + this.bindTo + " port " + this.setup.getPort()), (Throwable)e);
                }
                throw e;
            }
            return ret;
        }
    }

    private class SecureImapServer
    extends ImapServer {
        public SecureImapServer(ServerSetup setup, Managers managers, AtomicReference<Exception> serverOpeningExceptionRef) {
            super(setup, managers, serverOpeningExceptionRef);
        }

        protected synchronized ServerSocket openServerSocket() throws IOException {
            ServerSocket ret;
            if (this.setup.isSecure()) {
                try {
                    ret = (SSLServerSocket)SSLServerSocketFactory.getDefault().createServerSocket(this.setup.getPort(), 0, this.bindTo);
                }
                catch (IOException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)("Unable to open socket bindTo:" + this.bindTo + "port " + this.setup.getPort()), (Throwable)e);
                    }
                    throw e;
                }
            }
            try {
                ret = new ServerSocket(this.setup.getPort(), 0, this.bindTo);
            }
            catch (IOException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Unable to open socket bindTo:" + this.bindTo + "port " + this.setup.getPort()), (Throwable)e);
                }
                throw e;
            }
            return ret;
        }
    }
}

