/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.app.BasePropertyDecorator;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class UsernamePropertyDecorator
extends BasePropertyDecorator {
    private PersonService personService = null;

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public JSONAware decorate(QName propertyName, NodeRef nodeRef, Serializable value) {
        String username = value.toString();
        String firstName = null;
        String lastName = null;
        JSONObject map = new JSONObject();
        map.put((Object)"userName", (Object)username);
        if (username.isEmpty()) {
            firstName = "";
            lastName = "";
        } else if (username.equals("System") || username.startsWith("System@")) {
            firstName = "System";
            lastName = "User";
        } else if (this.personService.personExists(username)) {
            NodeRef personRef = this.personService.getPerson(username, false);
            firstName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_FIRSTNAME));
            lastName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_LASTNAME));
        } else {
            map.put((Object)"isDeleted", (Object)true);
            return map;
        }
        map.put((Object)"firstName", (Object)firstName);
        map.put((Object)"lastName", (Object)lastName);
        map.put((Object)"displayName", (Object)(String.valueOf(firstName != null ? String.valueOf(firstName) + " " : "") + (lastName != null ? lastName : "")).replaceAll("^\\s+|\\s+$", ""));
        return map;
    }
}

