/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.io.Serializable;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authority.script.Authority;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.mozilla.javascript.Scriptable;

public class ScriptUser
implements Authority,
Serializable {
    private static final long serialVersionUID = 7865300693011208293L;
    private transient ServiceRegistry serviceRegistry;
    private transient AuthorityService authorityService;
    private transient PersonService personService;
    private Authority.ScriptAuthorityType authorityType = Authority.ScriptAuthorityType.USER;
    private String userName;
    private String shortName;
    private String displayName;
    private String fullName;
    private NodeRef personNodeRef;
    private Scriptable scope;

    public ScriptUser(String userName, NodeRef personNodeRef, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.serviceRegistry = serviceRegistry;
        this.authorityService = serviceRegistry.getAuthorityService();
        this.personService = serviceRegistry.getPersonService();
        this.scope = scope;
        this.personNodeRef = personNodeRef == null ? this.personService.getPerson(userName) : personNodeRef;
        this.userName = userName;
        this.shortName = this.authorityService.getShortName(userName);
        NodeService nodeService = serviceRegistry.getNodeService();
        String firstName = (String)((Object)nodeService.getProperty(this.personNodeRef, ContentModel.PROP_FIRSTNAME));
        String lastName = (String)((Object)nodeService.getProperty(this.personNodeRef, ContentModel.PROP_LASTNAME));
        this.displayName = this.fullName = String.valueOf(firstName != null ? firstName : "") + (lastName != null ? String.valueOf(' ') + lastName : "");
    }

    @Override
    public Authority.ScriptAuthorityType getAuthorityType() {
        return this.authorityType;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public NodeRef getPersonNodeRef() {
        if (this.personNodeRef == null) {
            this.personNodeRef = this.authorityService.getAuthorityNodeRef(this.userName);
        }
        return this.personNodeRef;
    }

    public ScriptNode getPerson() {
        return new ScriptNode(this.getPersonNodeRef(), this.serviceRegistry, this.scope);
    }

    @Override
    public Set<String> getZones() {
        return this.authorityService.getAuthorityZones(this.fullName);
    }
}

