/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.alfresco.opencmis.AlfrescoCmisServiceFactory;
import org.alfresco.opencmis.AlfrescoCmisStreamInterceptor;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.events.EventPublisherForTestingOnly;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.events.types.ContentEventImpl;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.TestHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.TempStoreOutputStream;
import org.apache.chemistry.opencmis.server.shared.TempStoreOutputStreamFactory;
import org.junit.experimental.categories.Category;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.ConcurrencyFailureException;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class OpenCmisLocalTest
extends TestCase {
    public static final String[] CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml", "classpath:opencmis/opencmistest-context.xml"};
    private static ApplicationContext ctx;
    private static final String BEAN_NAME_AUTHENTICATION_COMPONENT = "authenticationComponent";
    private static final String MIME_PLAIN_TEXT = "text/plain";
    private TempStoreOutputStreamFactory streamFactory;
    private EventPublisherForTestingOnly eventPublisher;

    private Repository getRepository(String user, String password) {
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", "admin");
        parameters.put("org.apache.chemistry.opencmis.password", "admin");
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.LOCAL.value());
        parameters.put("org.apache.chemistry.opencmis.binding.local.classname", "org.alfresco.opencmis.OpenCmisLocalTest$TestCmisServiceFactory");
        List repositories = sessionFactory.getRepositories(parameters);
        return repositories.size() > 0 ? (Repository)repositories.get(0) : null;
    }

    public void setUp() throws Exception {
        ctx = ApplicationContextHelper.getApplicationContext((String[])CONFIG_LOCATIONS);
        File tempDir = new File(TempFileProvider.getTempDir(), GUID.generate());
        this.streamFactory = TempStoreOutputStreamFactory.newInstance((File)tempDir, (int)1024, (long)1024L, (boolean)false);
        this.eventPublisher = (EventPublisherForTestingOnly)ctx.getBean("eventPublisher");
    }

    public void testVoid() {
    }

    public void DISABLED_testSetUp() throws Exception {
        Repository repository = this.getRepository("admin", "admin");
        OpenCmisLocalTest.assertNotNull((String)"No repository available for testing", (Object)repository);
    }

    public void DISABLED_testBasicFileOps() {
        Repository repository = this.getRepository("admin", "admin");
        Session session = repository.createSession();
        Folder rootFolder = session.getRootFolder();
        HashMap<String, String> folderProps = new HashMap<String, String>();
        folderProps.put("cmis:objectTypeId", "cmis:folder");
        folderProps.put("cmis:name", String.valueOf(this.getName()) + "-" + GUID.generate());
        Folder folder = rootFolder.createFolder(folderProps, null, null, null, session.getDefaultContext());
        HashMap<String, String> fileProps = new HashMap<String, String>();
        fileProps.put("cmis:objectTypeId", "cmis:document");
        fileProps.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType(MIME_PLAIN_TEXT);
        fileContent.setStream(reader.getContentInputStream());
        folder.createDocument(fileProps, (ContentStream)fileContent, VersioningState.MAJOR);
    }

    public void testDownloadEvent() throws InterruptedException {
        Repository repository = this.getRepository("admin", "admin");
        Session session = repository.createSession();
        Folder rootFolder = session.getRootFolder();
        String docname = "mydoc-" + GUID.generate() + ".txt";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cmis:objectTypeId", "D:cmiscustom:document");
        props.put("cmis:name", docname);
        byte[] byteContent = "Hello from Download testing class".getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(byteContent);
        ContentStreamImpl contentStream = new ContentStreamImpl(docname, BigInteger.valueOf(byteContent.length), MIME_PLAIN_TEXT, (InputStream)stream);
        Document doc1 = rootFolder.createDocument(props, (ContentStream)contentStream, VersioningState.MAJOR);
        this.cmisIdToNodeRef(doc1.getId());
        ContentStream content = doc1.getContentStream();
        OpenCmisLocalTest.assertNotNull((Object)content);
        content = doc1.getContentStream(BigInteger.valueOf(2L), BigInteger.valueOf(4L));
        OpenCmisLocalTest.assertNotNull((Object)content);
    }

    private void commonAsserts(byte[] byteContent, ContentEventImpl cre) {
        OpenCmisLocalTest.assertEquals((Object)FileFilterMode.Client.cmis, (Object)cre.getClient());
        OpenCmisLocalTest.assertEquals((long)byteContent.length, (long)cre.getSize());
        OpenCmisLocalTest.assertEquals((String)MIME_PLAIN_TEXT, (String)cre.getMimeType());
    }

    private NodeRef cmisIdToNodeRef(String nodeId) {
        int idx = nodeId.indexOf(";");
        if (idx != -1) {
            nodeId = nodeId.substring(0, idx);
        }
        NodeRef nodeRef = new NodeRef(nodeId);
        return nodeRef;
    }

    public void testALF10085() throws InterruptedException {
        Repository repository = this.getRepository("admin", "admin");
        Session session = repository.createSession();
        Folder rootFolder = session.getRootFolder();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cmis:objectTypeId", "D:cmiscustom:document");
        props.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        Document doc1 = rootFolder.createDocument(props, null, null);
        props = new HashMap();
        props.put("cmis:objectTypeId", "D:cmiscustom:document");
        props.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        Document doc2 = rootFolder.createDocument(props, null, null);
        Thread.sleep(6000L);
        session.getObject((ObjectId)doc1);
        doc1.refresh();
        Calendar doc1LastModifiedBefore = (Calendar)doc1.getProperty("cmis:lastModificationDate").getFirstValue();
        OpenCmisLocalTest.assertNotNull((Object)doc1LastModifiedBefore);
        doc2.refresh();
        Calendar doc2LastModifiedBefore = (Calendar)doc2.getProperty("cmis:lastModificationDate").getFirstValue();
        OpenCmisLocalTest.assertNotNull((Object)doc2LastModifiedBefore);
        props = new HashMap();
        props.put("cmis:objectTypeId", "R:cmiscustom:assoc");
        props.put("cmis:name", "A Relationship");
        props.put("cmis:sourceId", doc1.getId());
        props.put("cmis:targetId", doc2.getId());
        session.createRelationship(props);
        doc1.refresh();
        Calendar doc1LastModifiedAfter = (Calendar)doc1.getProperty("cmis:lastModificationDate").getFirstValue();
        OpenCmisLocalTest.assertNotNull((Object)doc1LastModifiedAfter);
        doc2.refresh();
        Calendar doc2LastModifiedAfter = (Calendar)doc2.getProperty("cmis:lastModificationDate").getFirstValue();
        OpenCmisLocalTest.assertNotNull((Object)doc2LastModifiedAfter);
        OpenCmisLocalTest.assertEquals((Object)doc1LastModifiedBefore, (Object)doc1LastModifiedAfter);
        OpenCmisLocalTest.assertEquals((Object)doc2LastModifiedBefore, (Object)doc2LastModifiedAfter);
    }

    public void testAlfrescoCmisStreamInterceptor() throws Exception {
        this.simulateCallWithAdvice(true);
    }

    private ContentStreamImpl makeContentStream(String filename, String mimetype, String content) throws IOException {
        TempStoreOutputStream tos = this.streamFactory.newOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)tos);
        writer.write(content);
        ContentStreamImpl contentStream = new ContentStreamImpl(filename, BigInteger.valueOf(tos.getLength()), MIME_PLAIN_TEXT, tos.getInputStream());
        return contentStream;
    }

    private void simulateCallWithAdvice(boolean includeStreamInterceptor) throws Exception {
        final AtomicInteger beforeAdviceCount = new AtomicInteger(0);
        final AtomicInteger afterAdviceCount = new AtomicInteger(0);
        final AtomicInteger targetCount = new AtomicInteger(0);
        MethodInterceptor beforeAdvice = new MethodInterceptor(){

            public Object invoke(MethodInvocation mi) throws Throwable {
                beforeAdviceCount.incrementAndGet();
                return mi.proceed();
            }
        };
        AlfrescoCmisStreamInterceptor interceptor = new AlfrescoCmisStreamInterceptor();
        MethodInterceptor afterAdvice = new MethodInterceptor(){

            public Object invoke(MethodInvocation mi) throws Throwable {
                boolean exit = true;
                while (true) {
                    try {
                        afterAdviceCount.incrementAndGet();
                        return mi.proceed();
                    }
                    catch (RuntimeException e) {
                        if (!"Test".equals(e.getMessage())) {
                            throw e;
                        }
                        exit = false;
                        if (!exit) continue;
                        return null;
                    }
                    break;
                }
            }
        };
        TestStreamTarget target = new TestStreamTarget(){

            @Override
            public void methodA(ContentStream csa, String str, ContentStream csb, ContentStream csc, int i) throws Exception {
                int count = targetCount.incrementAndGet();
                File a = null;
                File b = null;
                File c = null;
                try {
                    a = TempFileProvider.createTempFile((InputStream)csa.getStream(), (String)"csA", (String)".txt");
                    b = TempFileProvider.createTempFile((InputStream)csb.getStream(), (String)"csB", (String)".txt");
                    c = TempFileProvider.createTempFile(null, (String)"csC", (String)".txt");
                    if (csa.getLength() > -1L && (a == null || csa.getLength() != a.length())) {
                        throw new CmisStorageException("Expected " + csa.getLength() + " bytes but retrieved " + (a == null ? -1L : a.length()) + " bytes!");
                    }
                }
                finally {
                    if (a != null) {
                        a.delete();
                    }
                    if (b != null) {
                        b.delete();
                    }
                    if (c != null) {
                        c.delete();
                    }
                }
                if (count < 3) {
                    throw new RuntimeException("Test");
                }
            }
        };
        ProxyFactory proxyFactory = new ProxyFactory((Object)target);
        proxyFactory.addInterface(TestStreamTarget.class);
        proxyFactory.addAdvice((Advice)beforeAdvice);
        if (includeStreamInterceptor) {
            proxyFactory.addAdvice((Advice)interceptor);
        }
        proxyFactory.addAdvice((Advice)afterAdvice);
        TestStreamTarget proxy = (TestStreamTarget)proxyFactory.getProxy();
        File tempDir = new File(TempFileProvider.getTempDir(), GUID.generate());
        TempStoreOutputStreamFactory streamFactory = TempStoreOutputStreamFactory.newInstance((File)tempDir, (int)1024, (long)1024L, (boolean)false);
        TempStoreOutputStream tos = streamFactory.newOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)tos);
        writer.write("The cat sat on the mat");
        ContentStreamImpl csa = this.makeContentStream("file1", MIME_PLAIN_TEXT, "The cat sat on the mat");
        ContentStreamImpl csb = this.makeContentStream("file2", MIME_PLAIN_TEXT, "and the cow jumped over the moon.");
        proxy.methodA((ContentStream)csa, "ignored", (ContentStream)csb, null, 10);
        OpenCmisLocalTest.assertEquals((String)"beforeAdvice count", (int)1, (int)beforeAdviceCount.intValue());
        OpenCmisLocalTest.assertEquals((String)"afterAdvice count", (int)1, (int)beforeAdviceCount.intValue());
        OpenCmisLocalTest.assertEquals((String)"target count", (int)3, (int)targetCount.intValue());
    }

    public void testCancelCheckoutWhileInCheckedOutState() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        CheckOutCheckInService cociService = serviceRegistry.getCheckOutCheckInService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean(BEAN_NAME_AUTHENTICATION_COMPONENT);
        authenticationComponent.setSystemUserAsCurrentUser();
        Repository repository = this.getRepository("admin", "admin");
        Session session = repository.createSession();
        Folder rootFolder = session.getRootFolder();
        String docname = "myDoc-" + GUID.generate() + ".txt";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
        props.put("cmis:name", docname);
        byte[] byteContent = "Some content".getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(byteContent);
        ContentStreamImpl contentStream = new ContentStreamImpl(docname, BigInteger.valueOf(byteContent.length), MIME_PLAIN_TEXT, (InputStream)stream);
        Document doc1 = rootFolder.createDocument(props, (ContentStream)contentStream, VersioningState.CHECKEDOUT);
        NodeRef doc1NodeRef = this.cmisIdToNodeRef(doc1.getId());
        NodeRef doc1WorkingCopy = cociService.getWorkingCopy(doc1NodeRef);
        TestHelper.waitForMethodToFinish(Duration.of(100L, ChronoUnit.MILLIS), () -> {
            NodeRef nodeRef2 = cociService.cancelCheckout(doc1WorkingCopy);
        }, CmisRuntimeException.class, ConcurrencyFailureException.class);
        NodeService nodeService = serviceRegistry.getNodeService();
        OpenCmisLocalTest.assertFalse((boolean)nodeService.exists(doc1NodeRef));
        OpenCmisLocalTest.assertFalse((boolean)nodeService.exists(doc1WorkingCopy));
    }

    public void testEncodingForCreateContentStream() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        FileFolderService ffs = serviceRegistry.getFileFolderService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean(BEAN_NAME_AUTHENTICATION_COMPONENT);
        authenticationComponent.setSystemUserAsCurrentUser();
        try {
            Repository repository = this.getRepository("admin", "admin");
            Session session = repository.createSession();
            Folder rootFolder = session.getRootFolder();
            Document document = OpenCmisLocalTest.createDocument(rootFolder, "test_file_" + GUID.generate() + ".txt", session);
            ContentStream content = document.getContentStream();
            OpenCmisLocalTest.assertNotNull((Object)content);
            content = document.getContentStream(BigInteger.valueOf(2L), BigInteger.valueOf(4L));
            OpenCmisLocalTest.assertNotNull((Object)content);
            NodeRef doc1NodeRef = this.cmisIdToNodeRef(document.getId());
            FileInfo fileInfo = ffs.getFileInfo(doc1NodeRef);
            Map properties = fileInfo.getProperties();
            ContentDataWithId contentData = (ContentDataWithId)properties.get(QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}content"));
            String encoding = contentData.getEncoding();
            OpenCmisLocalTest.assertEquals((String)"ISO-8859-1", (String)encoding);
        }
        finally {
            authenticationComponent.clearCurrentSecurityContext();
        }
    }

    private static Document createDocument(Folder target, String newDocName, Session session) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cmis:objectTypeId", "cmis:document");
        props.put("cmis:name", newDocName);
        String content = "aegif Mind Share Leader Generating New Paradigms by aegif corporation.";
        byte[] buf = null;
        try {
            buf = content.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        ContentStream contentStream = session.getObjectFactory().createContentStream(newDocName, (long)buf.length, "text/plain; charset=UTF-8", (InputStream)input);
        return target.createDocument(props, contentStream, VersioningState.MAJOR);
    }

    public static class TestCmisServiceFactory
    extends AbstractServiceFactory {
        private static AlfrescoCmisServiceFactory serviceFactory;

        public void init(Map<String, String> parameters) {
            serviceFactory = (AlfrescoCmisServiceFactory)ctx.getBean("CMISServiceFactory");
            serviceFactory.init(parameters);
        }

        public void destroy() {
        }

        public CmisService getService(CallContext context) {
            return serviceFactory.getService(context);
        }
    }

    private static interface TestStreamTarget {
        public void methodA(ContentStream var1, String var2, ContentStream var3, ContentStream var4, int var5) throws Exception;
    }
}

