/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.ContentRestoreParams;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.replication.AggregatingContentStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AggregatingContentStoreUnitTest {
    private static final String X_AMZ_HEADER_1 = "x-amz-header1";
    private static final String VALUE_1 = "value1";
    private static final String X_AMZ_HEADER_2 = "x-amz-header2";
    private static final String VALUE_2 = "value2";
    private List<ContentStore> secondaryStores;
    @Mock
    ContentStore primaryStore;
    @Mock
    ContentStore secondaryStore;
    @InjectMocks
    private AggregatingContentStore objectUnderTest;

    @Before
    public void setUp() {
        this.secondaryStores = List.of(this.secondaryStore);
        this.objectUnderTest.setSecondaryStores(this.secondaryStores);
    }

    @Test
    public void shouldReturnStoragePropertiesFromPrimaryStore() {
        Map<String, String> primaryStorePropertiesMap = Map.of(X_AMZ_HEADER_1, VALUE_1, X_AMZ_HEADER_2, VALUE_2);
        Mockito.when((Object)this.primaryStore.getStorageProperties("url")).thenReturn(primaryStorePropertiesMap);
        Map storageProperties = this.objectUnderTest.getStorageProperties("url");
        Assert.assertFalse((boolean)storageProperties.isEmpty());
        Assert.assertEquals(primaryStorePropertiesMap, (Object)storageProperties);
        ((ContentStore)Mockito.verify((Object)this.secondaryStore, (VerificationMode)Mockito.times((int)0))).getStorageProperties("url");
    }

    @Test
    public void shouldReturnStoragePropertiesFromSecondaryStore() {
        Map<String, String> secondaryStorePropertiesMap = Map.of(X_AMZ_HEADER_1, VALUE_1, X_AMZ_HEADER_2, VALUE_2);
        Mockito.when((Object)this.primaryStore.getStorageProperties("url")).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.secondaryStore.getStorageProperties("url")).thenReturn(secondaryStorePropertiesMap);
        Map storageProperties = this.objectUnderTest.getStorageProperties("url");
        Assert.assertFalse((boolean)storageProperties.isEmpty());
        Assert.assertEquals(secondaryStorePropertiesMap, (Object)storageProperties);
        ((ContentStore)Mockito.verify((Object)this.secondaryStore, (VerificationMode)Mockito.times((int)1))).getStorageProperties("url");
        ((ContentStore)Mockito.verify((Object)this.primaryStore, (VerificationMode)Mockito.times((int)1))).getStorageProperties("url");
    }

    @Test
    public void shouldReturnEmptyStorageProperties() {
        Mockito.when((Object)this.primaryStore.getStorageProperties("url")).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.secondaryStore.getStorageProperties("url")).thenReturn(Collections.emptyMap());
        Map storageProperties = this.objectUnderTest.getStorageProperties("url");
        Assert.assertTrue((boolean)storageProperties.isEmpty());
        ((ContentStore)Mockito.verify((Object)this.primaryStore, (VerificationMode)Mockito.times((int)1))).getStorageProperties("url");
    }

    @Test
    public void shouldRequestContentArchiveThroughPrimaryStore() {
        Map archiveParams = Collections.emptyMap();
        Mockito.when((Object)this.primaryStore.requestSendContentToArchive("url", archiveParams)).thenReturn((Object)true);
        boolean sendContentToArchive = this.objectUnderTest.requestSendContentToArchive("url", archiveParams);
        Assert.assertEquals((Object)true, (Object)sendContentToArchive);
        ((ContentStore)Mockito.verify((Object)this.secondaryStore, (VerificationMode)Mockito.never())).requestSendContentToArchive("url", archiveParams);
    }

    @Test
    public void shouldRequestContentArchiveThroughSecondaryStore() {
        Map archiveParams = Collections.emptyMap();
        Mockito.when((Object)this.primaryStore.requestSendContentToArchive("url", archiveParams)).thenThrow(UnsupportedOperationException.class);
        Mockito.when((Object)this.secondaryStore.requestSendContentToArchive("url", archiveParams)).thenReturn((Object)true);
        boolean sendContentToArchive = this.objectUnderTest.requestSendContentToArchive("url", archiveParams);
        Assert.assertEquals((Object)true, (Object)sendContentToArchive);
        ((ContentStore)Mockito.verify((Object)this.primaryStore, (VerificationMode)Mockito.times((int)1))).requestSendContentToArchive("url", archiveParams);
        ((ContentStore)Mockito.verify((Object)this.secondaryStore, (VerificationMode)Mockito.times((int)1))).requestSendContentToArchive("url", archiveParams);
    }

    @Test
    public void shouldThrowExceptionWhenRequestContentArchiveNotImplemented() {
        Mockito.when((Object)this.primaryStore.getStorageProperties("url")).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.secondaryStore.getStorageProperties("url")).thenReturn(Collections.emptyMap());
        Map storageProperties = this.objectUnderTest.getStorageProperties("url");
        Assert.assertTrue((boolean)storageProperties.isEmpty());
        ((ContentStore)Mockito.verify((Object)this.primaryStore, (VerificationMode)Mockito.times((int)1))).getStorageProperties("url");
    }

    @Test
    public void shouldRequestRestoreContentFromArchiveThroughPrimaryStore() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), "High");
        Mockito.when((Object)this.primaryStore.requestRestoreContentFromArchive("url", restoreParams)).thenReturn((Object)true);
        boolean sendContentToArchive = this.objectUnderTest.requestRestoreContentFromArchive("url", restoreParams);
        Assert.assertEquals((Object)true, (Object)sendContentToArchive);
        ((ContentStore)Mockito.verify((Object)this.secondaryStore, (VerificationMode)Mockito.never())).requestRestoreContentFromArchive("url", restoreParams);
    }

    @Test
    public void shouldRequestRestoreContentFromArchiveThroughSecondaryStore() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), "High");
        Mockito.when((Object)this.primaryStore.requestRestoreContentFromArchive("url", restoreParams)).thenThrow(UnsupportedOperationException.class);
        Mockito.when((Object)this.secondaryStore.requestRestoreContentFromArchive("url", restoreParams)).thenReturn((Object)true);
        boolean sendContentToArchive = this.objectUnderTest.requestRestoreContentFromArchive("url", restoreParams);
        Assert.assertEquals((Object)true, (Object)sendContentToArchive);
        ((ContentStore)Mockito.verify((Object)this.primaryStore, (VerificationMode)Mockito.times((int)1))).requestRestoreContentFromArchive("url", restoreParams);
        ((ContentStore)Mockito.verify((Object)this.secondaryStore, (VerificationMode)Mockito.times((int)1))).requestRestoreContentFromArchive("url", restoreParams);
    }

    @Test
    public void shouldThrowExceptionWhenRequestRestoreContentFromArchiveNotImplemented() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), "High");
        Mockito.when((Object)this.primaryStore.requestRestoreContentFromArchive("url", restoreParams)).thenCallRealMethod();
        Mockito.when((Object)this.secondaryStore.requestRestoreContentFromArchive("url", restoreParams)).thenCallRealMethod();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.objectUnderTest.requestRestoreContentFromArchive("url", restoreParams));
        ((ContentStore)Mockito.verify((Object)this.primaryStore, (VerificationMode)Mockito.times((int)1))).requestRestoreContentFromArchive("url", restoreParams);
        ((ContentStore)Mockito.verify((Object)this.secondaryStore, (VerificationMode)Mockito.times((int)1))).requestRestoreContentFromArchive("url", restoreParams);
    }
}

