/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition.executer.ImageRenderingEngine;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailHelper;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.thumbnail.ThumbnailServiceImplTest;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.test.context.ContextConfiguration;

@Deprecated
@Category(value={OwnJVMTestsCategory.class})
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:org/alfresco/repo/rendition2/test-transform-context.xml"})
public class RenditionServicePermissionsTest {
    private static Log logger = LogFactory.getLog(RenditionServicePermissionsTest.class);
    public static ApplicationContextInit APP_CONTEXT_INIT = ApplicationContextInit.createStandardContextWithOverrides("classpath:/test/alfresco/test-renditions-context.xml", "classpath:org/alfresco/repo/rendition2/test-transform-context.xml");
    public static AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserOne");
    @ClassRule
    public static RuleChain staticRuleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1);
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    public TemporarySites testSites = new TemporarySites(APP_CONTEXT_INIT);
    public RunAsFullyAuthenticatedRule runTestsAsUser = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    @Rule
    public RuleChain nonStaticRuleChain = RuleChain.outerRule((TestRule)this.runTestsAsUser).around((TestRule)this.testNodes).around((TestRule)this.testSites);
    private static final QName RESCALE_RENDER_DEFN_NAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("imageRenderingEngine" + System.currentTimeMillis()));
    private static ContentService contentService;
    private static NodeService nodeService;
    private static PermissionService permissionService;
    private static RenditionService renditionService;
    private static Repository repositoryHelper;
    private static RetryingTransactionHelper transactionHelper;
    private static ServiceRegistry services;
    private static ThumbnailRegistry thumbnailRegistry;
    private NodeRef companyHome;
    private String testFolderName;
    private NodeRef testFolder;
    private NodeRef nodeWithImageContent;
    private TemporarySites.TestSiteAndMemberInfo testSiteInfo;
    private NodeRef brokenJpg;

    @BeforeClass
    public static void initStaticData() throws Exception {
        contentService = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("ContentService");
        nodeService = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("NodeService");
        permissionService = (PermissionService)APP_CONTEXT_INIT.getApplicationContext().getBean("PermissionService");
        renditionService = (RenditionService)APP_CONTEXT_INIT.getApplicationContext().getBean("renditionService");
        repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        transactionHelper = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper");
        services = (ServiceRegistry)APP_CONTEXT_INIT.getApplicationContext().getBean("ServiceRegistry");
        thumbnailRegistry = (ThumbnailRegistry)APP_CONTEXT_INIT.getApplicationContext().getBean("thumbnailRegistry");
        ThumbnailServiceImplTest.createTestThumbnail(thumbnailRegistry);
    }

    @Before
    public void initNonStaticData() throws Exception {
        this.companyHome = repositoryHelper.getCompanyHome();
        this.testFolderName = "Test-folder-" + System.currentTimeMillis();
        this.testFolder = this.testNodes.createFolder(this.companyHome, this.testFolderName, AuthenticationUtil.getAdminUserName());
        String testImageNodeName = "testImageNode" + System.currentTimeMillis();
        this.nodeWithImageContent = this.testNodes.createQuickFile("image/png", this.companyHome, testImageNodeName, AuthenticationUtil.getAdminUserName());
        this.testSiteInfo = this.testSites.createTestSiteWithUserPerRole(this.getClass().getSimpleName(), "sitePreset", SiteVisibility.PRIVATE, AuthenticationUtil.getAdminUserName());
        NodeRef siteDocLib = this.testSiteInfo.doclib;
        this.brokenJpg = this.testNodes.createQuickFileByName("quickCorrupt.jpg", siteDocLib, AuthenticationUtil.getAdminUserName());
    }

    @Test
    public void testRenditionAccessPermissions() throws Exception {
        final String normalUser = TEST_USER1.getUsername();
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                permissionService.setPermission(RenditionServicePermissionsTest.this.testFolder, normalUser, "Consumer", true);
                return null;
            }
        });
        final NodeRef rendition = (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)normalUser);
                Assert.assertFalse((String)"Source node has unexpected renditioned aspect.", (boolean)nodeService.hasAspect(RenditionServicePermissionsTest.this.nodeWithImageContent, RenditionModel.ASPECT_RENDITIONED));
                String path = String.valueOf(RenditionServicePermissionsTest.this.testFolderName) + "/testRendition.png";
                RenditionDefinition action = RenditionServicePermissionsTest.this.makeRescaleImageAction();
                action.setParameterValue("destination-path-template", (Serializable)((Object)path));
                logger.debug((Object)("Creating rendition of: " + RenditionServicePermissionsTest.this.nodeWithImageContent));
                ChildAssociationRef renditionAssoc = renditionService.render(RenditionServicePermissionsTest.this.nodeWithImageContent, action);
                logger.debug((Object)("Created rendition: " + renditionAssoc.getChildRef()));
                NodeRef renditionNode = renditionAssoc.getChildRef();
                RenditionServicePermissionsTest.this.testNodes.addNodeRef(renditionNode);
                Assert.assertEquals((String)"The parent node was not correct", (Object)RenditionServicePermissionsTest.this.nodeWithImageContent, (Object)renditionAssoc.getParentRef());
                logger.debug((Object)("rendition's primary parent: " + nodeService.getPrimaryParent(renditionNode)));
                Assert.assertEquals((String)"The parent node was not correct", (Object)RenditionServicePermissionsTest.this.testFolder, (Object)nodeService.getPrimaryParent(renditionNode).getParentRef());
                Assert.assertTrue((String)"Source node is missing renditioned aspect.", (boolean)nodeService.hasAspect(RenditionServicePermissionsTest.this.nodeWithImageContent, RenditionModel.ASPECT_RENDITIONED));
                return renditionNode;
            }
        });
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                Serializable renditionCreator = nodeService.getProperty(rendition, ContentModel.PROP_CREATOR);
                Assert.assertEquals((String)"Incorrect creator", (Object)normalUser, (Object)renditionCreator);
                return null;
            }
        });
    }

    @Test
    public void testRenditionUserPreserved() throws Exception {
        final String normalUser = TEST_USER1.getUsername();
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                permissionService.setPermission(RenditionServicePermissionsTest.this.testFolder, normalUser, "Coordinator", true);
                return null;
            }
        });
        final NodeRef rendition = (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)normalUser);
                Assert.assertFalse((String)"Source node has unexpected renditioned aspect.", (boolean)nodeService.hasAspect(RenditionServicePermissionsTest.this.nodeWithImageContent, RenditionModel.ASPECT_RENDITIONED));
                String path = String.valueOf(RenditionServicePermissionsTest.this.testFolderName) + "/testRendition.png";
                QName renditionName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("PreserveUser" + System.currentTimeMillis()));
                RenditionDefinition action = renditionService.createRenditionDefinition(renditionName, "mockRenderingEngine");
                action.setParameterValue("destination-path-template", (Serializable)((Object)path));
                action.setParameterValue("mime-type", (Serializable)((Object)"image/alfresco.test.user"));
                logger.debug((Object)("Creating rendition of: " + RenditionServicePermissionsTest.this.nodeWithImageContent));
                ChildAssociationRef renditionAssoc = renditionService.render(RenditionServicePermissionsTest.this.nodeWithImageContent, action);
                logger.debug((Object)("Created rendition: " + renditionAssoc.getChildRef()));
                NodeRef renditionNode = renditionAssoc.getChildRef();
                return renditionNode;
            }
        });
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                Serializable renditionCreator = nodeService.getProperty(rendition, ContentModel.PROP_CREATOR);
                Assert.assertEquals((String)"Incorrect creator", (Object)normalUser, (Object)renditionCreator);
                return null;
            }
        });
    }

    @Test
    public void userWithReadOnlyAccessToNodeShouldNotCauseFailedThumbnailProblems() throws Exception {
        String siteConsumer = this.testSiteInfo.siteConsumer;
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteConsumer);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ThumbnailDefinition details = thumbnailRegistry.getThumbnailDefinition("testThumbnail");
                Action action = ThumbnailHelper.createCreateThumbnailAction((ThumbnailDefinition)details, (ServiceRegistry)services);
                services.getActionService().executeAction(action, RenditionServicePermissionsTest.this.brokenJpg, true, true);
                return null;
            }
        });
        Thread.sleep(2000L);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertTrue((String)"Expected an empty list of renditions for brokenJpg.", (boolean)renditionService.getRenditions(RenditionServicePermissionsTest.this.brokenJpg).isEmpty());
                Assert.assertTrue((String)"Expected brokenJpg to have FailedThumbnailSource aspect.", (boolean)nodeService.hasAspect(RenditionServicePermissionsTest.this.brokenJpg, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE));
                List failedThumbnailChildren = nodeService.getChildAssocs(RenditionServicePermissionsTest.this.brokenJpg, (QNamePattern)ContentModel.ASSOC_FAILED_THUMBNAIL, RegexQNamePattern.MATCH_ALL);
                Assert.assertEquals((String)"Wrong number of failed thumbnail child nodes.", (long)1L, (long)failedThumbnailChildren.size());
                NodeRef failedThumbnailChildNode = ((ChildAssociationRef)failedThumbnailChildren.get(0)).getChildRef();
                Assert.assertEquals((Object)1, (Object)nodeService.getProperty(failedThumbnailChildNode, ContentModel.PROP_FAILURE_COUNT));
                return null;
            }
        });
    }

    @Test
    public void userWithoutDeleteAccessToNodeShouldNotCauseFailedThumbnailProblemsOnUpdate() throws Exception {
        String siteManager = this.testSiteInfo.siteManager;
        String siteCollaborator = this.testSiteInfo.siteCollaborator;
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteManager);
        final NodeRef imgNode = (NodeRef)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef imgNode = RenditionServicePermissionsTest.this.testNodes.createQuickFile("image/jpeg", ((RenditionServicePermissionsTest)RenditionServicePermissionsTest.this).testSiteInfo.doclib, "quick.jpg", AuthenticationUtil.getFullyAuthenticatedUser());
                ThumbnailDefinition details = thumbnailRegistry.getThumbnailDefinition("doclib");
                Action action = ThumbnailHelper.createCreateThumbnailAction((ThumbnailDefinition)details, (ServiceRegistry)services);
                services.getActionService().executeAction(action, imgNode, true, false);
                Assert.assertEquals((long)1L, (long)renditionService.getRenditions(imgNode).size());
                return imgNode;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)siteCollaborator);
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentWriter writer = contentService.getWriter(imgNode, ContentModel.PROP_CONTENT, true);
                ContentReader reader = contentService.getReader(RenditionServicePermissionsTest.this.brokenJpg, ContentModel.PROP_CONTENT);
                writer.putContent(reader.getContentInputStream());
                return null;
            }
        });
        int waitTime = 200;
        int numRetries = 20;
        int i = 1;
        while (i <= numRetries) {
            Thread.sleep(waitTime * i);
            Boolean hasNoRenditions = (Boolean)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                public Boolean execute() throws Throwable {
                    return renditionService.getRenditions(imgNode).isEmpty();
                }
            });
            if (hasNoRenditions.booleanValue()) break;
            if (i == numRetries) {
                Assert.fail((String)"The node should have no renditions.");
            }
            ++i;
        }
    }

    private RenditionDefinition makeRescaleImageAction() {
        RenditionDefinition result = renditionService.createRenditionDefinition(RESCALE_RENDER_DEFN_NAME, "imageRenderingEngine");
        result.setParameterValue("xsize", (Serializable)Integer.valueOf(42));
        return result;
    }

    private static class MockRenderingEngine
    extends ImageRenderingEngine {
        public static final String NAME = "mockRenderingEngine";

        private MockRenderingEngine() {
        }

        protected void checkParameterValues(Action action) {
        }
    }
}

