/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import jakarta.transaction.UserTransaction;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={LuceneTests.class, NeverRunsTests.class})
public class DBQueryTest
implements DictionaryListener {
    protected static ApplicationContext ctx = null;
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/lucenetest";
    private static final QName ASSOC_TYPE_QNAME = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"assoc");
    private static QName CREATED_DATE = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"createdDate");
    private static QName ORDER_DOUBLE = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderDouble");
    private static QName ORDER_FLOAT = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderFloat");
    private static QName ORDER_LONG = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderLong");
    private static QName ORDER_INT = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderInt");
    private static QName ORDER_TEXT = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderText");
    private static QName ORDER_ML_TEXT = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderMLText");
    private static QName ASPECT_WITH_CHILDREN = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"aspectWithChildren");
    private static QName TEST_CONTENT_TYPE = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testContentType");
    private static QName TEST_SUPER_CONTENT_TYPE = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testSuperContentType");
    private static QName TEST_FOLDER_TYPE = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testFolderType");
    private static QName TEST_SUPER_FOLDER_TYPE = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testSuperFolderType");
    private static QName TEST_ASPECT = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testAspect");
    private static QName TEST_SUPER_ASPECT = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testSuperAspect");
    TransactionService transactionService;
    RetryingTransactionHelper retryingTransactionHelper;
    NodeService nodeService;
    DictionaryService dictionaryService;
    TenantService tenantService;
    private DictionaryDAO dictionaryDAO;
    private NamespaceDAO namespaceDao;
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private DictionaryNamespaceComponent namespacePrefixResolver;
    private UserTransaction txn;
    private M2Model model;
    private NodeRef rootNodeRef;
    private NodeRef n1;
    private NodeRef n2;
    private NodeRef n3;
    private NodeRef n4;
    private NodeRef n5;
    private NodeRef n6;
    private NodeRef n7;
    private NodeRef n8;
    private NodeRef n9;
    private NodeRef n10;
    private NodeRef n11;
    private NodeRef n12;
    private NodeRef n13;
    private NodeRef n14;
    private NodeRef n15;
    private Date testDate;
    private String formattedTestDate;
    private String midCreationDate;
    private String midModificationDate;
    private String midOrderDate;
    private ContentService contentService;
    private double orderDoubleCount = -0.11;
    private Date orderDate = new Date();
    private float orderFloatCount = -3.5556f;
    private long orderLongCount = -1999999999999999L;
    private int orderIntCount = -45764576;
    private int orderTextCount = 0;

    protected static void startContext() {
        ctx = ApplicationContextHelper.getApplicationContext();
    }

    protected static void stopContext() {
        ApplicationContextHelper.closeApplicationContext();
    }

    @BeforeClass
    public static void beforeTests() {
        DBQueryTest.startContext();
    }

    @AfterClass
    public static void afterTests() {
        DBQueryTest.stopContext();
    }

    public void afterDictionaryDestroy() {
    }

    public void afterDictionaryInit() {
    }

    public void onDictionaryInit() {
        this.dictionaryDAO.putModel(this.model);
    }

    @Before
    public void setup() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.namespacePrefixResolver = (DictionaryNamespaceComponent)ctx.getBean("namespaceService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.namespaceDao = (NamespaceDAO)ctx.getBean("namespaceDAO");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.loadTestModel();
        this.createTestData();
    }

    protected void loadTestModel() {
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/search/impl/MetadataQueryTest_model.xml");
        Assert.assertNotNull((Object)modelStream);
        this.model = M2Model.createModel((InputStream)modelStream);
        this.dictionaryDAO.registerListener((DictionaryListener)this);
        this.dictionaryDAO.reset();
        Assert.assertNotNull((Object)this.dictionaryDAO.getClass(TEST_SUPER_CONTENT_TYPE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTestData() throws Exception {
        I18NUtil.setLocale((Locale)Locale.UK);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}top"), TEST_SUPER_FOLDER_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n1, ContentModel.PROP_NAME, (Serializable)((Object)"Folder_1"));
        this.n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), TEST_FOLDER_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n2, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 2"));
        this.n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), TEST_SUPER_CONTENT_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n3, ContentModel.PROP_NAME, (Serializable)((Object)"Content 3"));
        HashMap<QName, Object> testProperties = new HashMap<QName, Object>();
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic"), "TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYONE");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-unstored-tokenised-atomic"), "TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYUNSTORED");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-nonatomic"), "TEXT THAT IS INDEXED STORED AND TOKENISED BUT NOT ATOMICALLY KEYTWO");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"int-ista"), 1);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"long-ista"), 2L);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"float-ista"), Float.valueOf(3.4f));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"double-ista"), 5.6);
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(new Date(new Date().getTime() - 10000L));
        this.testDate = c.getTime();
        this.formattedTestDate = CachingDateFormat.getDateFormat().format(this.testDate);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"date-ista"), this.testDate);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista"), this.testDate);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"boolean-ista"), Boolean.TRUE);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"qname-ista"), QName.createQName((String)"{wibble}wobble"));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"category-ista"), new NodeRef(storeRef, "CategoryId"));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"noderef-ista"), this.n1);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista"), this.nodeService.getPath(this.n3));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista"), Locale.UK);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"period-ista"), new Period("period|12"));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"null"), null);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"list"), new ArrayList());
        MLText mlText = new MLText();
        mlText.addValue(Locale.ENGLISH, "banana");
        mlText.addValue(Locale.FRENCH, "banane");
        mlText.addValue(Locale.CHINESE, "\u9999\u8549");
        mlText.addValue(new Locale("nl"), "banaan");
        mlText.addValue(Locale.GERMAN, "banane");
        mlText.addValue(new Locale("el"), "\u03bc\u03c0\u03b1\u03bd\u03ac\u03bd\u03b1");
        mlText.addValue(Locale.ITALIAN, "banana");
        mlText.addValue(new Locale("ja"), "\u30d0\u30ca\u30ca");
        mlText.addValue(new Locale("ko"), "\ubc14\ub098\ub098");
        mlText.addValue(new Locale("pt"), "banana");
        mlText.addValue(new Locale("ru"), "\u0431\u0430\u043d\u0430\u043d");
        mlText.addValue(new Locale("es"), "pl\u00e1tano");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"ml"), mlText);
        ArrayList<Object> anyValues = new ArrayList<Object>();
        anyValues.add(100);
        anyValues.add("anyValueAsString");
        anyValues.add(new UnknownDataType());
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista"), anyValues);
        ArrayList<ContentData> contentValues = new ArrayList<ContentData>();
        contentValues.add(new ContentData(null, "text/plain", 0L, "UTF-16", Locale.UK));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"content-many-ista"), contentValues);
        MLText mlText1 = new MLText();
        mlText1.addValue(Locale.ENGLISH, "cabbage");
        mlText1.addValue(Locale.FRENCH, "chou");
        MLText mlText2 = new MLText();
        mlText2.addValue(Locale.ENGLISH, "lemur");
        mlText2.addValue(new Locale("ru"), "\u043b\u0435\u043c\u0443\u0440");
        ArrayList<MLText> mlValues = new ArrayList<MLText>();
        mlValues.add(mlText1);
        mlValues.add(mlText2);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"mltext-many-ista"), mlValues);
        ArrayList<Object> testList = new ArrayList<Object>();
        testList.add(null);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"nullist"), testList);
        ArrayList<String> testList2 = new ArrayList<String>();
        testList2.add("woof");
        testList2.add(null);
        testProperties.put(ContentModel.PROP_NAME, "Node 4");
        this.n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}four"), TEST_CONTENT_TYPE, testProperties).getChildRef();
        this.nodeService.setProperty(this.n4, ContentModel.PROP_NAME, (Serializable)((Object)"Content 4"));
        this.n5 = this.nodeService.createNode(this.n1, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}five"), TEST_SUPER_FOLDER_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n5, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 5"));
        this.n6 = this.nodeService.createNode(this.n1, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}six"), TEST_SUPER_FOLDER_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n6, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 6"));
        DBQueryTest dBQueryTest = this;
        synchronized (dBQueryTest) {
            this.wait(1000L);
        }
        this.midOrderDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.orderDate);
        this.n7 = this.nodeService.createNode(this.n2, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}seven"), TEST_SUPER_CONTENT_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n7, ContentModel.PROP_NAME, (Serializable)((Object)"Content 7"));
        this.midCreationDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(this.n7, ContentModel.PROP_CREATED));
        this.midModificationDate = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(this.n7, ContentModel.PROP_MODIFIED));
        dBQueryTest = this;
        synchronized (dBQueryTest) {
            this.wait(1000L);
        }
        this.n8 = this.nodeService.createNode(this.n2, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}eight-2"), TEST_SUPER_CONTENT_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n8, ContentModel.PROP_NAME, (Serializable)((Object)"Content 8"));
        this.n9 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}nine"), TEST_SUPER_CONTENT_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n9, ContentModel.PROP_NAME, (Serializable)((Object)"Content 9"));
        this.n10 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}ten"), TEST_SUPER_CONTENT_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n10, ContentModel.PROP_NAME, (Serializable)((Object)"Content 10"));
        this.n11 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}eleven"), TEST_SUPER_CONTENT_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n11, ContentModel.PROP_NAME, (Serializable)((Object)"Content 11"));
        this.n12 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}twelve"), TEST_SUPER_FOLDER_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n12, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 12"));
        this.n13 = this.nodeService.createNode(this.n12, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}thirteen"), TEST_SUPER_FOLDER_TYPE, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n13, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 13"));
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        MLText desc1 = new MLText();
        desc1.addValue(Locale.ENGLISH, "Alfresco tutorial");
        desc1.addValue(Locale.US, "Alfresco tutorial");
        Date explicitCreatedDate = new Date();
        Thread.sleep(2000L);
        properties.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties.put(ContentModel.PROP_DESCRIPTION, desc1);
        properties.put(ContentModel.PROP_CREATED, explicitCreatedDate);
        this.n14 = this.nodeService.createNode(this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}fourteen"), ContentModel.TYPE_CONTENT, properties).getChildRef();
        this.nodeService.setProperty(this.n14, ContentModel.PROP_NAME, (Serializable)((Object)"Content 14"));
        ContentWriter writer = this.contentService.getWriter(this.n14, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.putContent("12345678");
        this.n15 = this.nodeService.createNode(this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}fifteen"), ContentModel.TYPE_THUMBNAIL, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n15, ContentModel.PROP_NAME, (Serializable)((Object)"Content 15"));
        this.nodeService.addChild(this.rootNodeRef, this.n8, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eight-0"));
        this.nodeService.addChild(this.n1, this.n8, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}eight-1"));
        this.nodeService.addChild(this.n2, this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}link"));
        this.nodeService.addChild(this.n1, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n2, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n5, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n6, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n12, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n13, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
    }

    public Map<QName, Serializable> getOrderProperties() {
        HashMap<QName, Serializable> testProperties = new HashMap<QName, Serializable>();
        testProperties.put(CREATED_DATE, this.orderDate);
        testProperties.put(ORDER_DOUBLE, Double.valueOf(this.orderDoubleCount));
        testProperties.put(ORDER_FLOAT, Float.valueOf(this.orderFloatCount));
        testProperties.put(ORDER_LONG, Long.valueOf(this.orderLongCount));
        testProperties.put(ORDER_INT, Integer.valueOf(this.orderIntCount));
        testProperties.put(ORDER_TEXT, (Serializable)((Object)(String.valueOf(new String(new char[]{(char)(97 + this.orderTextCount)})) + " cabbage")));
        MLText mlText = new MLText();
        mlText.addValue(Locale.ENGLISH, String.valueOf(new String(new char[]{(char)(97 + this.orderTextCount)})) + " banana");
        mlText.addValue(Locale.FRENCH, String.valueOf(new String(new char[]{(char)(90 - this.orderTextCount)})) + " banane");
        mlText.addValue(Locale.CHINESE, String.valueOf(new String(new char[]{(char)(39321 + this.orderTextCount)})) + " \u9999\u8549");
        testProperties.put(ORDER_ML_TEXT, (Serializable)mlText);
        this.orderDate = Duration.subtract((Date)this.orderDate, (Duration)new Duration("P1D"));
        this.orderDoubleCount += 0.1;
        this.orderFloatCount += 0.82f;
        this.orderLongCount += 299999999999999L;
        this.orderIntCount += 8576457;
        ++this.orderTextCount;
        return testProperties;
    }

    @After
    public void teardown() throws Exception {
        if (this.txn.getStatus() == 0) {
            this.txn.rollback();
        }
    }

    @Test
    public void testCmisSql() throws InterruptedException {
        this.sqlQueryWithCount("SELECT * FROM cmis:document", 8);
        this.sqlQueryWithCount("SELECT * FROM cm:thumbnail", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder", 6);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperContentType", 7);
        this.sqlQueryWithCount("SELECT * FROM test:testContentType", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperFolderType", 6);
        this.sqlQueryWithCount("SELECT * FROM test:testFolderType", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect", 14);
        this.sqlQueryWithCount("SELECT * FROM test:testAspect", 2);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name = 'Folder_1'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name = 'Folder 2'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 3'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 4'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name = 'Folder 5'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name = 'Folder 6'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 7'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 8'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 9'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 10'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 11'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name = 'Folder 12'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name = 'Folder 13'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 14'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name = 'Content 15'", 0);
        this.sqlQueryWithCount("SELECT * FROM cm:thumbnail where cmis:name = 'Content 15'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name <> 'Content 7'", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name < 'Content 7'", 5);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name <= 'Content 7'", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name > 'Content 7'", 2);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name >= 'Content 7'", 3);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name IN ('Content 3', 'Content 4')", 2);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name NOT IN ('Content 3', 'Content 4')", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name like 'Content _'", 5);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name like 'Content __'", 3);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name not like 'Content __'", 5);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name like 'Content%'", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name like 'Content%4'", 2);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name is not null", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:name is null", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where IN_FOLDER('" + this.n2 + "')", 3);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where IN_FOLDER('" + this.n2 + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where LOWER(cmis:name) = 'folder_1'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where UPPER(cmis:name) = 'FOLDER_1'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name like 'Folder 1'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name like 'Folder 2'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name like 'Folder_1'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name like 'Folder_2'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name like 'Folder\\_1'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:name like 'Folder\\_2'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where IN_FOLDER('" + this.n2 + "') and cmis:name = 'Content 7'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where IN_FOLDER('" + this.n2 + "') and cmis:name = 'Content 8'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where IN_FOLDER('" + this.n2 + "') and cmis:name = 'Content 14'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where IN_FOLDER('" + this.n2 + "') and  not cmis:name = 'Content 8'", 2);
        this.sqlQueryWithCount("SELECT * FROM cmis:document d join test:testContentType a on d.cmis:objectId = a.cmis:objectId", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document d join test:testSuperContentType a on d.cmis:objectId = a.cmis:objectId", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:creationDate = '" + this.midCreationDate + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:lastModificationDate = '" + this.midModificationDate + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:createdBy = 'System'", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:lastModifiedBy = 'System'", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:createdDate = '" + this.midOrderDate + "'", 1);
        try {
            this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderDouble = -0.11", 1);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderFloat = -3.5556", 1);
            Assert.fail();
        }
        catch (Exception exception) {}
        long longValue = -200000000000005L;
        this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderLong = -1999999999999999", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong = " + longValue, 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong <>  " + longValue, 12);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong <  " + longValue, 6);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong <=  " + longValue, 7);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong >  " + longValue, 6);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong >=  " + longValue, 7);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong IN ( " + longValue + ")", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong NOT IN  (" + longValue + ")", 12);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong is null", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderLong is not null", 13);
        long intValue = 5694166L;
        this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderInt = -45764576", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt = " + intValue, 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt <>  " + intValue, 12);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt <  " + intValue, 6);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt <=  " + intValue, 7);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt >  " + intValue, 6);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt >=  " + intValue, 7);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt IN ( " + intValue + ")", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt NOT IN  (" + intValue + ")", 12);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt is null", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderInt is not null", 13);
        String stringValue = String.valueOf(new String(new char[]{'g'})) + " cabbage";
        this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderText = 'a cabbage'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText = '" + stringValue + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText <>  '" + stringValue + "'", 12);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText <  '" + stringValue + "'", 6);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText <=  '" + stringValue + "'", 7);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText >  '" + stringValue + "'", 6);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText >=  '" + stringValue + "'", 7);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText IN ( '" + stringValue + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText NOT IN  ('" + stringValue + "')", 12);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText is null", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderText is not null", 13);
        stringValue = String.valueOf(new String(new char[]{'g'})) + " banana";
        this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderMLText = 'a banana'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText = '" + stringValue + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText IN ( '" + stringValue + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText is null", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText is not null", 13);
        stringValue = String.valueOf(new String(new char[]{'T'})) + " banane";
        this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderMLText = 'Z banane'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText = '" + stringValue + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText IN ( '" + stringValue + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText is null", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText is not null", 13);
        stringValue = String.valueOf(new String(new char[]{'\u999f'})) + " \u9999\u8549";
        this.sqlQueryWithCount("SELECT * FROM cmis:folder d join test:testSuperAspect a on d.cmis:objectId = a.cmis:objectId where a.test:orderMLText = '\u9999 \u9999\u8549'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText = '" + stringValue + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText IN ( '" + stringValue + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText is null", 1);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a where a.test:orderMLText is not null", 13);
    }

    @Test
    public void testOrdering() {
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:name asc", 8, ContentModel.PROP_NAME, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:name asc", 6, ContentModel.PROP_NAME, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:name desc", 8, ContentModel.PROP_NAME, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:name desc", 6, ContentModel.PROP_NAME, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:creationDate asc", 8, ContentModel.PROP_CREATED, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:creationDate asc", 6, ContentModel.PROP_CREATED, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:creationDate desc", 8, ContentModel.PROP_CREATED, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:creationDate desc", 6, ContentModel.PROP_CREATED, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:lastModificationDate asc", 8, ContentModel.PROP_MODIFIED, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:lastModificationDate asc", 6, ContentModel.PROP_MODIFIED, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:lastModificationDate desc", 8, ContentModel.PROP_MODIFIED, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:lastModificationDate desc", 6, ContentModel.PROP_MODIFIED, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:createdBy asc", 8, ContentModel.PROP_CREATOR, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:createdBy asc", 6, ContentModel.PROP_CREATOR, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:createdBy desc", 8, ContentModel.PROP_CREATOR, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:createdBy desc", 6, ContentModel.PROP_CREATOR, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:lastModifiedBy asc", 8, ContentModel.PROP_MODIFIER, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:lastModifiedBy asc", 6, ContentModel.PROP_MODIFIER, true);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:lastModifiedBy desc", 8, ContentModel.PROP_MODIFIER, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder order by cmis:lastModifiedBy desc", 6, ContentModel.PROP_MODIFIER, false);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:createdDate asc", 14, CREATED_DATE, true);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:createdDate desc", 14, CREATED_DATE, false);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:orderLong asc", 14, ORDER_LONG, true);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:orderLong desc", 14, ORDER_LONG, false);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:orderInt asc", 14, ORDER_INT, true);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:orderInt desc", 14, ORDER_INT, false);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:orderText asc", 14, ORDER_TEXT, true);
        this.sqlQueryWithCount("SELECT * FROM test:testSuperAspect a order by a.test:orderText desc", 14, ORDER_TEXT, false);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:contentStreamMimeType asc", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:contentStreamMimeType desc", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:contentStreamLength asc", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document order by cmis:contentStreamLength desc", 8);
    }

    @Test
    public void testOtherCMIS() {
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:parentId = '" + this.n2 + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:parentId IN ('" + this.n2 + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:parentId <> '" + this.n2 + "'", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:parentId NOT IN ('" + this.n2 + "')", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:parentId IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:parentId IS NOT NULL", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamLength = 8", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName = 'Content 3'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName < 'Content 3'", 3);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName <= 'Content 3'", 4);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName > 'Content 3'", 4);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName >= 'Content 3'", 5);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName <> 'Content 3'", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName IN ('Content 3', 'Content 4')", 2);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName NOT IN ('Content 3', 'Content 4')", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamFileName IS NOT NULL", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType = 'text/plain'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType < 'text/plain'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType <= 'text/plain'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType > 'text/plain'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType >= 'text/plain'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType <> 'text/plain'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType IN ('text/plain')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType NOT IN ('text/plain')", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType IS NULL", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType IS NOT NULL", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:contentStreamMimeType like 'text%'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectId = '" + this.n2 + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectId IN ('" + this.n2 + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectId <> '" + this.n2 + "'", 5);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectId NOT IN ('" + this.n2 + "')", 5);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectId IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectId IS NOT NULL", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectTypeId = 'cmis:folder'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectTypeId IN ('cmis:folder')", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectTypeId <> 'cmis:folder'", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectTypeId NOT IN ('cmis:folder')", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectTypeId IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:objectTypeId IS NOT NULL", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:baseTypeId = 'cmis:folder'", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:baseTypeId IN ('cmis:folder')", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:baseTypeId <> 'cmis:folder'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:baseTypeId NOT IN ('cmis:folder')", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:baseTypeId IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:folder where cmis:baseTypeId IS NOT NULL", 6);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId = '" + this.n3 + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId IN ('" + this.n3 + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId <> '" + this.n3 + "'", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId NOT IN ('" + this.n3 + "')", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId = '" + this.n3.getId() + "'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId IN ('" + this.n3.getId() + "')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId <> '" + this.n3.getId() + "'", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId NOT IN ('" + this.n3.getId() + "')", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId = '" + this.n3 + ";1.0'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId IN ('" + this.n3 + ";1.0')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId <> '" + this.n3 + ";1.0'", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId NOT IN ('" + this.n3 + ";1.0')", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId = '" + this.n3.getId() + ";1.0'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId IN ('" + this.n3.getId() + ";1.0')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId <> '" + this.n3.getId() + ";1.0'", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId NOT IN ('" + this.n3.getId() + ";1.0')", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectId IS NOT NULL", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectTypeId = 'cmis:document'", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectTypeId IN ('cmis:document')", 1);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectTypeId <> 'cmis:document'", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectTypeId NOT IN ('cmis:document')", 7);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectTypeId IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:objectTypeId IS NOT NULL", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:baseTypeId = 'cmis:document'", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:baseTypeId IN ('cmis:document')", 8);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:baseTypeId <> 'cmis:document'", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:baseTypeId NOT IN ('cmis:document')", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:baseTypeId IS NULL", 0);
        this.sqlQueryWithCount("SELECT * FROM cmis:document where cmis:baseTypeId IS NOT NULL", 8);
    }

    public void sqlQueryWithCount(String query, int count) {
        this.sqlQueryWithCount(query, count, null, null);
    }

    public void sqlQueryWithCount(String query, int count, QName property, Boolean ascending) {
        this.queryWithCount("cmis-alfresco", query, count, property, ascending);
    }

    @Test
    public void testAFTS() {
        this.aftsQueryWithCount("=TYPE:\"content\"", 8);
        this.aftsQueryWithCount("=TYPE:\"cm:content\"", 8);
        this.aftsQueryWithCount("=TYPE:\"cm:thumbnail\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:folder\"", 6);
        this.aftsQueryWithCount("=TYPE:\"test:testSuperContentType\"", 7);
        this.aftsQueryWithCount("=TYPE:\"test:testContentType\"", 1);
        this.aftsQueryWithCount("=TYPE:\"test:testSuperFolderType\"", 6);
        this.aftsQueryWithCount("=TYPE:\"test:testFolderType\"", 1);
        this.aftsQueryWithCount("=ASPECT:\"test:testSuperAspect\"", 14);
        this.aftsQueryWithCount("=ASPECT:\"test:testAspect\"", 2);
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =name:\"Folder_1\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =name:\"Folder 2\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 3\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 4\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =name:\"Folder 5\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =name:\"Folder 6\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 7\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 8\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 9\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 10\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 11\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =name:\"Folder 12\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =name:\"Folder 13\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 14\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:\"Content 15\"", 0);
        this.aftsQueryWithCount("=TYPE:\"cm:thumbnail\" AND =name:\"Content 15\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND NOT =name:\"Content 7\"", 7);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND -=name:\"Content 7\"", 7);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =name:Content*", 8);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =PARENT:\"" + this.n2 + "\" AND =name:\"Content 7\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =PARENT:\"" + this.n2 + "\" AND =name:\"Content 8\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =PARENT:\"" + this.n2 + "\" AND =name:\"Content 14\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =PARENT:\"" + this.n2 + "\" AND -=name:\"Content 8\"", 2);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =created:\"" + this.midCreationDate + "\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =modified:\"" + this.midModificationDate + "\"", 1);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =creator:System", 8);
        this.aftsQueryWithCount("=TYPE:\"cm:content\" AND =modifier:System", 8);
        long longValue = -200000000000005L;
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =ASPECT:\"test:testSuperAspect\" AND =test:orderLong:\"-1999999999999999\"", 1);
        this.aftsQueryWithCount("=ASPECT:\"test:testSuperAspect\" AND =test:orderLong:\"" + longValue + "\"", 1);
        long intValue = 5694166L;
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =ASPECT:\"test:testSuperAspect\" AND =test:orderInt:\"-45764576\"", 1);
        this.aftsQueryWithCount("=ASPECT:\"test:testSuperAspect\" AND =test:orderInt:\"" + intValue + "\"", 1);
        String stringValue = String.valueOf(new String(new char[]{'g'})) + " cabbage";
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =ASPECT:\"test:testSuperAspect\" AND =test:orderText:\"a cabbage\"", 1);
        this.aftsQueryWithCount("=ASPECT:\"test:testSuperAspect\" AND =test:orderText:\"" + stringValue + "\"", 1);
        stringValue = String.valueOf(new String(new char[]{'g'})) + " banana";
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =ASPECT:\"test:testSuperAspect\" AND =test:orderMLText:\"a banana\"", 1);
        this.aftsQueryWithCount("=ASPECT:\"test:testSuperAspect\" AND =test:orderMLText:\"" + stringValue + "\"", 1);
        stringValue = String.valueOf(new String(new char[]{'T'})) + " banane";
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =ASPECT:\"test:testSuperAspect\" AND =test:orderMLText:\"Z banane\"", 1);
        this.aftsQueryWithCount("=ASPECT:\"test:testSuperAspect\" AND =test:orderMLText:\"" + stringValue + "\"", 1);
        stringValue = String.valueOf(new String(new char[]{'\u999f'})) + " \u9999\u8549";
        this.aftsQueryWithCount("=TYPE:\"cm:folder\" AND =ASPECT:\"test:testSuperAspect\" AND =test:orderMLText:\"\u9999 \u9999\u8549\"", 1);
        this.aftsQueryWithCount("=ASPECT:\"test:testSuperAspect\" AND =test:orderMLText:\"" + stringValue + "\"", 1);
    }

    @Test
    public void testAftsPagination() {
        String query = "=TYPE:\"cm:folder\" ";
        int numFolders = 6;
        int count = 4;
        ResultSet results = this.query("fts-alfresco", query, count);
        Assert.assertEquals((String)"The number of results should be equal to count", (long)results.length(), (long)count);
        Assert.assertEquals((String)"The number of founds should be equal to the number of folders, and not influencedby the limit set to the query.", (long)results.getNumberFound(), (long)numFolders);
    }

    public ResultSet query(String ql, String query, Integer limit) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage(ql);
        sp.setQueryConsistency(QueryConsistency.TRANSACTIONAL);
        sp.setQuery(query);
        sp.addStore(this.rootNodeRef.getStoreRef());
        if (limit != null) {
            sp.setLimit(limit.intValue());
            sp.setLimitBy(LimitBy.FINAL_SIZE);
        }
        return this.serviceRegistry.getSearchService().query(sp);
    }

    public void aftsQueryWithCount(String query, int count) {
        this.queryWithCount("fts-alfresco", query, count, null, null);
    }

    public void aftsQueryWithCount(String query, int count, QName property, Boolean ascending) {
        this.queryWithCount("fts-alfresco", query, count, property, ascending);
    }

    public void queryWithCount(String ql, String query, int count, QName property, Boolean ascending) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage(ql);
        sp.setQueryConsistency(QueryConsistency.TRANSACTIONAL);
        sp.setQuery(query);
        sp.addStore(this.rootNodeRef.getStoreRef());
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        HashSet<NodeRef> found = new HashSet<NodeRef>();
        Comparable last = null;
        for (ResultSetRow row : results) {
            Assert.assertFalse((boolean)found.contains(row.getNodeRef()));
            found.add(row.getNodeRef());
            if (property == null) continue;
            Comparable current = (Comparable)((Object)this.nodeService.getProperty(row.getNodeRef(), property));
            if (last != null && (ascending == null || ascending != false ? !$assertionsDisabled && last.compareTo(current) < 0 : !$assertionsDisabled && last.compareTo(current) > 0)) {
                throw new AssertionError();
            }
            last = current;
        }
        Assert.assertEquals((long)count, (long)results.length());
        results.getResultSetMetaData();
        results.close();
    }

    @Test
    public void testGetValueForTransactionalQuery() {
        String query = "=TYPE:\"cm:folder\" ";
        this.queryUsingGetValue("fts-alfresco", query);
    }

    public void queryUsingGetValue(String ql, String query) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage(ql);
        sp.setQueryConsistency(QueryConsistency.TRANSACTIONAL);
        sp.setQuery(query);
        sp.addStore(this.rootNodeRef.getStoreRef());
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        int i = 0;
        while (i < results.length()) {
            ResultSetRow row = results.getRow(i);
            Assert.assertNotNull((Object)row.getValue(ContentModel.PROP_NODE_UUID));
            ++i;
        }
        results.getResultSetMetaData();
        results.close();
    }

    private static class UnknownDataType
    implements Serializable {
        private static final long serialVersionUID = -6729690518573349055L;

        private UnknownDataType() {
        }
    }
}

