/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.schedule;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.schedule.Cleaner;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.Before;
import org.junit.Test;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerAccessorBean;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:alfresco/schedule/test-schedule-context.xml"})
public class AbstractScheduledLockedJobTest
extends BaseSpringTest {
    private static final int TOTAL_NODES = 9;
    private static final int NUM_THREADS = 2;
    private static final long JOB_EXECUTER_LOCK_TTL = 30000L;
    private static final String ARCHIVE_STORE_URL = "archive://SpacesStore";
    private NodeService nodeService;
    private TransactionService transactionService;
    private Repository repository;
    private SchedulerAccessorBean testCleanerAccessor;
    private JobDetail testCleanerJobDetail;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractScheduledLockedJobTest.class);

    @Before
    public void setUp() {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.repository = (Repository)this.applicationContext.getBean("repositoryHelper");
    }

    @Test
    public void test() throws SchedulerException, InterruptedException {
        this.createAndDeleteNodes(9);
        AbstractScheduledLockedJobTest.assertTrue((String)"Expected nodes haven't been created", (this.getNumberOfNodesInTrashcan() >= 9L ? 1 : 0) != 0);
        CleanerThread[] threads = new CleanerThread[2];
        int i = 0;
        while (i < 2) {
            CleanerThread t;
            threads[i] = t = new CleanerThread(i);
            t.start();
            Thread.sleep(30000L);
            ++i;
        }
        CleanerThread[] cleanerThreadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            CleanerThread t = cleanerThreadArray[n2];
            t.join();
            ++n2;
        }
        while (this.getNumberOfNodesInTrashcan() > 0L) {
            Thread.sleep(2000L);
        }
        cleanerThreadArray = threads;
        n = threads.length;
        n2 = 0;
        while (n2 < n) {
            CleanerThread t = cleanerThreadArray[n2];
            if (t.hasErrors()) {
                AbstractScheduledLockedJobTest.fail((String)"An error has occurred when executing multiple cleaner jobs at the same time");
            }
            ++n2;
        }
    }

    private void createAndDeleteNodes(int archivedNodes) {
        AuthenticationUtil.runAsSystem(() -> {
            RetryingTransactionHelper.RetryingTransactionCallback txnWork = () -> {
                int i = 0;
                while (i < archivedNodes) {
                    this.addNodeToTrashcan();
                    ++i;
                }
                return null;
            };
            return (Void)this.transactionService.getRetryingTransactionHelper().doInTransaction(txnWork);
        });
    }

    private void addNodeToTrashcan() {
        NodeRef companyHome = this.repository.getCompanyHome();
        String name = "Sample (" + UUID.randomUUID().toString() + ")";
        ChildAssociationRef association = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)name), ContentModel.TYPE_CONTENT, (Map)ImmutableMap.of((Object)ContentModel.PROP_NAME, (Object)name));
        NodeRef parent = association.getChildRef();
        this.nodeService.deleteNode(parent);
    }

    private long getNumberOfNodesInTrashcan() {
        StoreRef storeRef = new StoreRef(ARCHIVE_STORE_URL);
        NodeRef archiveRoot = this.nodeService.getRootNode(storeRef);
        return this.nodeService.getChildAssocs(archiveRoot, (QNamePattern)ContentModel.ASSOC_CHILDREN, RegexQNamePattern.MATCH_ALL).size();
    }

    private class CleanerThread
    extends Thread {
        private int threadNum;
        private boolean started;
        private Cleaner testCleaner;

        CleanerThread(int threadNum) {
            super(String.valueOf(CleanerThread.class.getSimpleName()) + "-" + threadNum);
            this.threadNum = threadNum;
        }

        @Override
        public void run() {
            try {
                AbstractScheduledLockedJobTest.this.testCleanerAccessor = (SchedulerAccessorBean)AbstractScheduledLockedJobTest.this.applicationContext.getBean("testSchedulerAccessor");
                AbstractScheduledLockedJobTest.this.testCleanerJobDetail = (JobDetail)AbstractScheduledLockedJobTest.this.applicationContext.getBean("testCleanerJobDetail");
                this.testCleaner = (Cleaner)AbstractScheduledLockedJobTest.this.testCleanerJobDetail.getJobDataMap().get((Object)"testCleaner");
                AbstractScheduledLockedJobTest.this.testCleanerAccessor.getScheduler().triggerJob(AbstractScheduledLockedJobTest.this.testCleanerJobDetail.getKey());
                LOGGER.info("Thread {} has started", (Object)this.threadNum);
                this.started = true;
            }
            catch (SchedulerException schedulerException) {
                this.started = false;
            }
        }

        public boolean hasErrors() {
            return !this.started || this.testCleaner != null && this.testCleaner.hasErrors();
        }
    }
}

