/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.Reader;
import java.io.StringReader;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.template.BaseSearchResultsMap;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SavedSearchResultsMap
extends BaseSearchResultsMap {
    private static final String ELEMENT_QUERY = "query";

    public SavedSearchResultsMap(TemplateNode parent, ServiceRegistry services) {
        super(parent, services);
    }

    @Override
    public Object get(Object key) {
        String search = null;
        if (key != null && key.toString().length() != 0) {
            try {
                SAXReader reader;
                Document document;
                Element rootElement;
                Element queryElement;
                NodeRef ref = new NodeRef(key.toString());
                ContentReader content = this.services.getContentService().getReader(ref, ContentModel.PROP_CONTENT);
                if (content != null && content.exists() && (queryElement = (rootElement = (document = (reader = new SAXReader()).read((Reader)new StringReader(content.getContentString()))).getRootElement()).element(ELEMENT_QUERY)) != null) {
                    search = queryElement.getText();
                }
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Failed to find or load saved Search: " + key, err);
            }
        }
        return this.query(search);
    }
}

