/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.config.NodeRefPathExpression;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.template.FilingData;
import org.alfresco.repo.virtual.template.FilingParameters;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateFilingRule
implements FilingRule {
    private static Log logger = LogFactory.getLog(TemplateFilingRule.class);
    private ActualEnvironment env;
    private String path;
    private String type;
    private Set<String> aspects;
    private Map<String, String> stringProperties;

    public TemplateFilingRule(ActualEnvironment environment, String path, String type, Set<String> aspects, Map<String, String> properties) {
        this.env = environment;
        this.path = path;
        this.type = type;
        this.aspects = aspects;
        this.stringProperties = properties;
    }

    @Override
    public FilingData createFilingData(FilingParameters parameters) throws VirtualizationException {
        return this.createFilingData(parameters.getParentRef(), parameters.getAssocTypeQName(), parameters.getAssocQName(), parameters.getNodeTypeQName(), parameters.getProperties());
    }

    private FilingData createFilingData(Reference parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) throws VirtualizationException {
        NodeRef fParentRef = null;
        QName fType = null;
        HashSet<QName> fAspects = null;
        HashMap<QName, Serializable> fProperties = null;
        NamespacePrefixResolver nsPrefixResolver = this.env.getNamespacePrefixResolver();
        if (this.type == null || this.type.length() == 0) {
            fType = nodeTypeQName;
        } else {
            fType = QName.createQName((String)this.type, (NamespacePrefixResolver)nsPrefixResolver);
            if (this.env.isSubClass(fType, ContentModel.TYPE_FOLDER)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CM-528 acceptance criteria 3 : we deny the creation of folders subtype " + fType + " and force cm:content instead."));
                }
                fType = ContentModel.TYPE_CONTENT;
            }
            if (this.env.isSubClass(nodeTypeQName, fType)) {
                fType = nodeTypeQName;
            }
        }
        fParentRef = this.parentNodeRefFor(parentRef, true);
        fProperties = new HashMap<QName, Serializable>(properties);
        Set<Map.Entry<String, String>> propertyEntries = this.stringProperties.entrySet();
        for (Map.Entry<String, String> propertyEntry : propertyEntries) {
            String name = propertyEntry.getKey();
            QName qName = QName.createQName((String)name, (NamespacePrefixResolver)nsPrefixResolver);
            if (fProperties.containsKey(qName)) continue;
            fProperties.put(qName, (Serializable)((Object)this.stringProperties.get(name)));
        }
        fAspects = new HashSet<QName>();
        for (String aspect : this.aspects) {
            fAspects.add(QName.createQName((String)aspect, (NamespacePrefixResolver)this.env.getNamespacePrefixResolver()));
        }
        return new FilingData(fParentRef, assocTypeQName, assocQName, fType, fAspects, fProperties);
    }

    private NodeRef parentNodeRefFor(Reference parentReference, boolean failIfNotFound) {
        NodeRef fParentRef;
        if (this.path == null || this.path.length() == 0) {
            fParentRef = parentReference.execute(new GetActualNodeRefMethod(this.env));
        } else {
            String[] pathElements = NodeRefPathExpression.splitAndNormalizePath(this.path);
            int i = 0;
            while (i < pathElements.length) {
                pathElements[i] = ISO9075.decode((String)pathElements[i]);
                ++i;
            }
            fParentRef = this.env.findQNamePath(pathElements);
        }
        boolean noReadPermissions = false;
        if (fParentRef != null && !this.env.hasPermission(fParentRef, "ReadPermissions")) {
            fParentRef = null;
            noReadPermissions = true;
        }
        if (logger.isDebugEnabled() && fParentRef == null) {
            if (noReadPermissions) {
                logger.debug((Object)("Current user does not have READ_PERMISSIONS for filing path" + this.path + "."));
            } else {
                logger.debug((Object)("The filing path " + this.path + " doesn't exist."));
            }
        }
        if (failIfNotFound && fParentRef == null) {
            throw new VirtualizationException("The filing path " + this.path + " could not be resolved.");
        }
        return fParentRef;
    }

    @Override
    public boolean isNullFilingRule() {
        return false;
    }

    @Override
    public NodeRef filingNodeRefFor(FilingParameters parameters) throws VirtualizationException {
        return this.parentNodeRefFor(parameters.getParentRef(), false);
    }
}

