/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ActualEnvironmentException;
import org.alfresco.repo.virtual.VirtualizationException;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.template.BasicConstraint;
import org.alfresco.repo.virtual.template.FilesFoldersConstraint;
import org.alfresco.repo.virtual.template.IgnoreConstraint;
import org.alfresco.repo.virtual.template.NamePatternPropertyValueConstraint;
import org.alfresco.repo.virtual.template.PagingRequestConstraint;
import org.alfresco.repo.virtual.template.SortConstraint;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualQueryImpl
implements VirtualQuery {
    private static Log logger = LogFactory.getLog(VirtualQueryImpl.class);
    private String language;
    private String store;
    private String query;

    public VirtualQueryImpl(String store, String language, String query) {
        this.language = language;
        this.store = store;
        this.query = query;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getStoreRef() {
        return this.store;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public PagingResults<Reference> perform(ActualEnvironment environment, boolean files, boolean folders, String pattern, Set<QName> searchTypeQNames, Set<QName> ignoreTypeQNames, Set<QName> ignoreAspectQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest, Reference parentReference) throws VirtualizationException {
        if (!files && !folders) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Deprecated query  will be skipped due do incompatible types request.");
            }
            return this.asPagingResults(environment, pagingRequest, new EmptyResultSet(), parentReference);
        }
        VirtualQueryConstraint constraint = BasicConstraint.INSTANCE;
        constraint = new FilesFoldersConstraint(constraint, files, folders);
        if (pattern != null) {
            constraint = new NamePatternPropertyValueConstraint(constraint, ContentModel.PROP_NAME, (Serializable)((Object)pattern), environment.getNamespacePrefixResolver());
        }
        constraint = new IgnoreConstraint(constraint, ignoreTypeQNames, ignoreAspectQNames);
        constraint = new PagingRequestConstraint(constraint, pagingRequest);
        constraint = new SortConstraint(constraint, sortProps);
        return this.perform(environment, constraint, null, parentReference);
    }

    private String filter(String language, String query, boolean files, boolean folders) throws VirtualizationException {
        String filteredQuery = query;
        if (files ^ folders) {
            if ("fts-alfresco".equals(language)) {
                filteredQuery = !files ? "(" + filteredQuery + ") and TYPE:\"cm:folder\"" : "(" + filteredQuery + ") and TYPE:\"cm:content\"";
            } else {
                throw new VirtualizationException("Disjunctive file-folder filters are only supported on fts-alfresco virtual query language.");
            }
        }
        return filteredQuery;
    }

    private PagingResults<Reference> asPagingResults(ActualEnvironment environment, PagingRequest pagingRequest, ResultSet result, Reference parentReference) throws ActualEnvironmentException {
        int start;
        final LinkedList<Reference> page = new LinkedList<Reference>();
        for (ResultSetRow row : result) {
            page.add(NodeProtocol.newReference(row.getNodeRef(), parentReference));
        }
        final boolean hasMore = result.hasMore();
        int totalFirst = (int)result.getNumberFound();
        try {
            start = result.getStart();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unsupported ResultSet.getStart() when trying to create query paging result");
            }
            start = pagingRequest != null ? pagingRequest.getSkipCount() : 0;
        }
        int totlaSecond = !hasMore ? (int)result.getNumberFound() : (int)((long)start + result.getNumberFound() + 1L);
        final Pair total = new Pair((Object)totalFirst, (Object)totlaSecond);
        return new PagingResults<Reference>(){

            public List<Reference> getPage() {
                return page;
            }

            public boolean hasMoreItems() {
                return hasMore;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return total;
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    private SearchParameters createSearchParameters(boolean files, boolean folders, PagingRequest pagingRequest) throws VirtualizationException {
        SearchParameters searchParameters = new SearchParameters();
        if (this.store != null) {
            searchParameters.addStore(new StoreRef(this.store));
        } else {
            searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        }
        searchParameters.setLanguage(this.language);
        searchParameters.setQuery(this.filter(this.language, this.query, files, folders));
        searchParameters.setQueryConsistency(QueryConsistency.TRANSACTIONAL_IF_POSSIBLE);
        if (pagingRequest != null) {
            searchParameters.setSkipCount(pagingRequest.getSkipCount());
            searchParameters.setMaxItems(pagingRequest.getMaxItems());
        }
        return searchParameters;
    }

    @Override
    public PagingResults<Reference> perform(ActualEnvironment environment, VirtualQueryConstraint constraint, PagingRequest pagingRequest, Reference parentReference) throws VirtualizationException {
        VirtualQueryConstraint theConstraint = constraint;
        if (pagingRequest != null) {
            theConstraint = new PagingRequestConstraint(theConstraint, pagingRequest);
        }
        SearchParameters searchParameters = theConstraint.apply(environment, this);
        ResultSet result = environment.query(searchParameters);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Constrained query " + searchParameters + " resulted in " + result.length() + " rows."));
        }
        return this.asPagingResults(environment, pagingRequest, result, parentReference);
    }
}

