/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.ValueParameter;
import org.alfresco.repo.virtual.ref.VanillaProtocol;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.junit.Test;

public class ProtocolTest
extends TestCase {
    private StringParameter p1;
    private ResourceParameter p2;
    private List<ValueParameter<? extends Object>> parameters;
    private Reference r;
    private Protocol protocol = new Protocol("unitTest");

    protected void setUp() throws Exception {
        this.p1 = new StringParameter("sp1");
        this.p2 = new ResourceParameter((Resource)new ClasspathResource("/r/p.js"));
        this.parameters = Arrays.asList(this.p1, this.p2);
        this.r = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/a/b/c.class"), this.parameters);
    }

    @Test
    public void testGetParameter() throws Exception {
        Parameter tp1 = this.protocol.getParameter(this.r, 0);
        ProtocolTest.assertEquals((Object)this.p1, (Object)tp1);
        Parameter tp2 = this.protocol.getParameter(this.r, 1);
        ProtocolTest.assertEquals((Object)this.p2, (Object)tp2);
        try {
            this.protocol.getParameter(this.r, -1);
            ProtocolTest.fail((String)"Out of bounds!");
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        try {
            this.protocol.getParameter(this.r, 2);
            ProtocolTest.fail((String)"Out of bounds!");
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testReplaceParameter() throws Exception {
        StringParameter newParameter = new StringParameter("rep1");
        Reference rr1 = this.protocol.replaceParameter(this.r, 0, (Parameter)newParameter);
        ProtocolTest.assertEquals((Object)newParameter, (Object)this.protocol.getParameter(rr1, 0));
        try {
            this.protocol.replaceParameter(this.r, 2, (Parameter)newParameter);
            ProtocolTest.fail((String)"Out of bounds!");
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testAddParameter() throws Exception {
        StringParameter newParameter = new StringParameter("rep1");
        Reference rr1 = this.protocol.addParameter(this.r, (Parameter)newParameter);
        ProtocolTest.assertEquals((Object)newParameter, (Object)this.protocol.getParameter(rr1, 2));
    }

    @Test
    public void testDispatch() throws Exception {
        boolean sccess = (Boolean)this.protocol.dispatch((ProtocolMethod)new ProtocolMethod<Boolean>(){

            public Boolean execute(VanillaProtocol vanillaProtocol, Reference reference) throws ProtocolMethodException {
                ProtocolTest.fail((String)"Invalid dispatch");
                return false;
            }

            public Boolean execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
                ProtocolTest.fail((String)"Invalid dispatch");
                return false;
            }

            public Boolean execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
                ProtocolTest.fail((String)"Invalid dispatch");
                return false;
            }

            public Boolean execute(Protocol protocol, Reference reference) throws ProtocolMethodException {
                return true;
            }
        }, this.r);
        ProtocolTest.assertTrue((boolean)sccess);
    }
}

