/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.filesys.repo.MSOfficeContentNetworkFile;
import org.alfresco.filesys.repo.NodeRefNetworkFile;
import org.alfresco.filesys.repo.OpenOfficeContentNetworkFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ContentNetworkFile
extends NodeRefNetworkFile {
    private static final Log logger = LogFactory.getLog(ContentNetworkFile.class);
    private NodeService nodeService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private FileChannel channel;
    private ContentAccessor content;
    private boolean modified;
    private boolean writableChannel;

    public static ContentNetworkFile createFile(NodeService nodeService, ContentService contentService, MimetypeService mimetypeService, CifsHelper cifsHelper, NodeRef nodeRef, String path, boolean readOnly, boolean attributesOnly, SrvSession sess) {
        ContentFileInfo fileInfo;
        ContentNetworkFile netFile = null;
        netFile = ContentNetworkFile.isMSOfficeSpecialFile(path, sess, nodeService, nodeRef) ? new MSOfficeContentNetworkFile(nodeService, contentService, mimetypeService, nodeRef, path) : (ContentNetworkFile.isOpenOfficeSpecialFile(path, sess, nodeService, nodeRef) ? new OpenOfficeContentNetworkFile(nodeService, contentService, mimetypeService, nodeRef, path) : new ContentNetworkFile(nodeService, contentService, mimetypeService, nodeRef, path));
        if (attributesOnly) {
            netFile.setGrantedAccess(0);
        } else if (readOnly) {
            netFile.setGrantedAccess(1);
        } else {
            netFile.setGrantedAccess(3);
        }
        try {
            fileInfo = cifsHelper.getFileInformation(nodeRef, "", false, false);
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("File not found when creating network file: " + nodeRef, (Throwable)e);
        }
        if (fileInfo.isDirectory()) {
            netFile.setAttributes(16);
        } else {
            netFile.setFileSize(fileInfo.getSize());
        }
        if (fileInfo.hasCreationDateTime()) {
            netFile.setCreationDate(fileInfo.getCreationDateTime());
        }
        if (fileInfo.hasModifyDateTime() && fileInfo.getModifyDateTime() > 0L) {
            netFile.setModifyDate(fileInfo.getModifyDateTime());
        } else {
            netFile.setModifyDate(fileInfo.getCreationDateTime());
        }
        if (fileInfo.hasAccessDateTime() && fileInfo.getAccessDateTime() > 0L) {
            netFile.setAccessDate(fileInfo.getAccessDateTime());
        } else {
            netFile.setAccessDate(fileInfo.getCreationDateTime());
        }
        netFile.setAttributes(fileInfo.getFileAttributes());
        if (netFile.isReadOnly() && netFile.getGrantedAccess() == 3) {
            netFile.setGrantedAccess(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Create file node=" + nodeRef + ", path=" + path + ", netfile=" + netFile));
        }
        return netFile;
    }

    protected ContentNetworkFile(NodeService nodeService, ContentService contentService, MimetypeService mimetypeService, NodeRef nodeRef, String name) {
        super(name, nodeRef);
        this.setFullName(name);
        this.nodeService = nodeService;
        this.contentService = contentService;
        this.mimetypeService = mimetypeService;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getFullName());
        str.append(",");
        str.append(this.getNodeRef().getId());
        str.append(",channel=");
        str.append(this.channel);
        if (this.channel != null) {
            str.append(this.writableChannel ? "(Write)" : "(Read)");
        }
        str.append(",");
        str.append(this.getGrantedAccessAsString());
        if (this.hasLocks()) {
            str.append(",locks=");
            str.append(this.numberOfLocks());
        }
        if (this.hasOpLock()) {
            str.append(",oplock=");
            str.append(this.getOpLock());
        }
        if (this.modified) {
            str.append(",Modified");
        }
        if (this.isClosed()) {
            str.append(",Closed");
        }
        str.append(",open=");
        str.append(this.getOpenCount());
        str.append("]");
        return str.toString();
    }

    private boolean isWritable() {
        int access = this.getGrantedAccess();
        return access == 3 || access == 2;
    }

    public final boolean hasContent() {
        return this.content != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openContent(boolean write, boolean trunc) throws AccessDeniedException, AlfrescoRuntimeException {
        if (this.isDirectory()) {
            throw new AlfrescoRuntimeException("Unable to open content for a directory network file: " + this);
        }
        if (this.channel != null && !write) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"channel is already open for read-only");
            }
            return;
        }
        ContentNetworkFile contentNetworkFile = this;
        synchronized (contentNetworkFile) {
            if (write && !this.writableChannel && this.channel != null) {
                try {
                    this.channel.close();
                    this.channel = null;
                    this.content = null;
                }
                catch (IOException ex) {
                    logger.error((Object)"Error closing read-only channel", (Throwable)ex);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Switching to writable channel for " + this.getName()));
                }
            } else if (this.channel != null) {
                return;
            }
            if (write && !this.isWritable()) {
                throw new AccessDeniedException("The network file was created for read-only: " + this);
            }
            if (write) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"open writer for content property");
                }
                this.content = this.contentService.getWriter(this.getNodeRef(), ContentModel.PROP_CONTENT, false);
                this.writableChannel = true;
                this.channel = ((ContentWriter)this.content).getFileChannel(trunc);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"open reader for content property");
                }
                this.content = this.contentService.getReader(this.getNodeRef(), ContentModel.PROP_CONTENT);
                this.content = FileContentReader.getSafeContentReader((ContentReader)this.content, I18NUtil.getMessage((String)"content.content_missing"), this.getNodeRef(), this.content);
                this.writableChannel = false;
                this.channel = ((ContentReader)this.content).getFileChannel();
            }
            if (this.channel != null) {
                try {
                    this.setFileSize(this.channel.size());
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                }
                this.setClosed(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"closeFile");
        }
        if (this.isDirectory()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"file is a directory - nothing to do");
            }
            this.setClosed(true);
            return;
        }
        if (!this.hasContent()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no content to write - nothing to do");
            }
            this.setClosed(true);
            return;
        }
        ContentNetworkFile contentNetworkFile = this;
        synchronized (contentNetworkFile) {
            if (this.modified) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"content has been modified");
                }
                NodeRef contentNodeRef = this.getNodeRef();
                ContentWriter writer = (ContentWriter)this.content;
                if (this.channel != null) {
                    this.channel.close();
                    this.channel = null;
                }
                if (this.content.getMimetype() == null || this.content.getMimetype().equals("application/octet-stream")) {
                    String filename = (String)((Object)this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_NAME));
                    writer.guessMimetype(filename);
                }
                writer.guessEncoding();
                ContentData contentData = this.content.getContentData();
                this.nodeService.removeAspect(contentNodeRef, ContentModel.ASPECT_NO_CONTENT);
                try {
                    this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                }
                catch (ContentQuotaException qe) {
                    this.content = null;
                    this.setClosed(true);
                    throw new DiskFullException(qe.getMessage());
                }
                AlfrescoTransactionSupport.bindListener(new TransactionListenerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void afterCommit() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (ContentNetworkFile.this.channel == null) {
                                ContentNetworkFile.this.content = null;
                                ContentNetworkFile.this.setClosed(true);
                            }
                        }
                    }
                });
            } else if (this.channel != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"content not modified - simply close the channel");
                }
                this.channel.close();
                this.channel = null;
                this.content = null;
                this.setClosed(true);
            }
        }
    }

    public void truncateFile(long size) throws IOException {
        logger.debug((Object)"truncate file");
        try {
            if (!this.hasContent() && size == 0L) {
                this.openContent(true, true);
            } else {
                this.openContent(true, false);
                this.channel.truncate(size);
            }
        }
        catch (ContentIOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error opening file " + this.getFullName() + " for write"), (Throwable)ex);
            }
            throw new DiskFullException("Failed to open " + this.getFullName() + " for write");
        }
        this.modified = true;
        this.incrementWriteCount();
        this.setFileSize(size);
        if (this.getFileState() != null) {
            this.getFileState().updateModifyDateTime();
            this.getFileState().setFileSize(size);
            this.getFileState().setAllocationSize(size);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Truncate file=" + this + ", size=" + size));
        }
    }

    public void writeFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        try {
            this.openContent(true, false);
        }
        catch (ContentIOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error opening file " + this.getFullName() + " for write"), (Throwable)ex);
            }
            throw new DiskFullException("Failed to open " + this.getFullName() + " for write");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, position, length);
        int count = this.channel.write(byteBuffer, fileOffset);
        this.modified = true;
        this.incrementWriteCount();
        this.setFileSize(this.channel.size());
        if (this.getFileState() != null) {
            this.getFileState().updateModifyDateTime();
            this.getFileState().setFileSize(this.getFileSize());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Write file=" + this + ", size=" + count));
        }
    }

    public int readFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        this.openContent(false, false);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, position, length);
        int count = this.channel.read(byteBuffer, fileOffset);
        if (count < 0) {
            count = 0;
        }
        if (this.getFileState() != null) {
            this.getFileState().updateAccessDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read file=" + this + " read=" + count));
        }
        return count;
    }

    public void openFile(boolean createFlag) throws IOException {
        this.setClosed(false);
    }

    public long seekFile(long pos, int typ) throws IOException {
        this.openContent(false, false);
        long curPos = this.channel.position();
        switch (typ) {
            case 0: {
                if (curPos == pos) break;
                this.channel.position(pos);
                break;
            }
            case 1: {
                this.channel.position(curPos + pos);
                break;
            }
            case 2: {
                long newPos = this.channel.size() + pos;
                this.channel.position(newPos);
            }
        }
        if (this.getFileState() != null) {
            this.getFileState().updateAccessDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Seek file=" + this + ", pos=" + pos + ", type=" + typ));
        }
        return this.channel.position();
    }

    public void flushFile() throws IOException {
        this.openContent(true, false);
        this.channel.force(false);
        if (this.getFileState() != null) {
            this.getFileState().updateAccessDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Flush file=" + this));
        }
    }

    public final boolean isModified() {
        return this.modified;
    }

    private static final boolean isMSOfficeSpecialFile(String path, SrvSession sess, NodeService nodeService, NodeRef nodeRef) {
        return (path = path.toLowerCase()).endsWith(".xls") && sess instanceof SMBSrvSession && nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
    }

    private static final boolean isOpenOfficeSpecialFile(String path, SrvSession sess, NodeService nodeService, NodeRef nodeRef) {
        return (path = path.toLowerCase()).endsWith(".odt") && sess instanceof SMBSrvSession && nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
    }
}

