/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.lock.mem.Lifetime;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;

public class WorkingCopyAspect
implements CopyServicePolicies.OnCopyNodePolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.BeforeArchiveNodePolicy,
NodeServicePolicies.OnRestoreNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private NodeDAO nodeDAO;
    private LockService lockService;
    private CheckOutCheckInService checkOutCheckInService;
    private BehaviourFilter policyBehaviourFilter;
    private WorkingCopyAspectCopyBehaviourCallback workingCopyAspectCopyBehaviourCallback = new WorkingCopyAspectCopyBehaviourCallback();

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.TYPE_CMOBJECT, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, ContentModel.ASPECT_CHECKED_OUT, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeArchiveNodePolicy.QNAME, ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "beforeArchiveNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "beforeDeleteWorkingCopy"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRestoreNodePolicy.QNAME, ContentModel.ASPECT_ARCHIVE_LOCKABLE, (Behaviour)new JavaBehaviour(this, "onRestoreNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteAssociationPolicy.QNAME, ContentModel.ASPECT_CMIS_CREATED_CHECKEDOUT, ContentModel.ASSOC_WORKING_COPY_LINK, new JavaBehaviour(this, "onDeleteCmisCreatedCheckoutWorkingCopyAssociation"));
    }

    public void beforeDeleteWorkingCopy(NodeRef nodeRef) {
        NodeRef checkedOutNodeRef = this.checkOutCheckInService.getCheckedOut(nodeRef);
        if (checkedOutNodeRef != null) {
            this.policyBehaviourFilter.disableBehaviour(checkedOutNodeRef, ContentModel.ASPECT_AUDITABLE);
            try {
                this.lockService.unlock(checkedOutNodeRef, false, true);
                this.nodeService.removeAspect(checkedOutNodeRef, ContentModel.ASPECT_CHECKED_OUT);
            }
            finally {
                this.policyBehaviourFilter.enableBehaviour(checkedOutNodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    public void onDeleteCmisCreatedCheckoutWorkingCopyAssociation(AssociationRef nodeAssocRef) {
        NodeRef checkedOutNodeRef = nodeAssocRef.getSourceRef();
        this.policyBehaviourFilter.disableBehaviour(checkedOutNodeRef, ContentModel.ASPECT_AUDITABLE);
        try {
            this.nodeService.deleteNode(checkedOutNodeRef);
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(checkedOutNodeRef, ContentModel.ASPECT_AUDITABLE);
        }
    }

    @Override
    public void beforeArchiveNode(NodeRef workingCopyNodeRef) {
        NodeRef checkedOutNodeRef = this.checkOutCheckInService.getCheckedOut(workingCopyNodeRef);
        if (checkedOutNodeRef != null) {
            try {
                this.policyBehaviourFilter.disableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_AUDITABLE);
                if (this.nodeService.hasAspect(checkedOutNodeRef, ContentModel.ASPECT_LOCKABLE)) {
                    Map checkedOutNodeProperties = this.nodeService.getProperties(checkedOutNodeRef);
                    Map workingCopyProperties = this.nodeService.getProperties(workingCopyNodeRef);
                    Long nodeId = (Long)this.nodeDAO.getNodePair(workingCopyNodeRef).getFirst();
                    String lockOwner = (String)checkedOutNodeProperties.get(ContentModel.PROP_LOCK_OWNER);
                    Date expiryDate = (Date)checkedOutNodeProperties.get(ContentModel.PROP_EXPIRY_DATE);
                    String lockTypeStr = (String)checkedOutNodeProperties.get(ContentModel.PROP_LOCK_TYPE);
                    LockType lockType = lockTypeStr != null ? LockType.valueOf(lockTypeStr) : null;
                    String lifetimeStr = (String)checkedOutNodeProperties.get(ContentModel.PROP_LOCK_LIFETIME);
                    Lifetime lifetime = lifetimeStr != null ? Lifetime.valueOf(lifetimeStr) : null;
                    String additionalInfo = (String)checkedOutNodeProperties.get(ContentModel.PROP_LOCK_ADDITIONAL_INFO);
                    this.nodeService.addAspect(workingCopyNodeRef, ContentModel.ASPECT_ARCHIVE_LOCKABLE, null);
                    workingCopyProperties.put(ContentModel.PROP_ARCHIVED_LOCK_OWNER, lockOwner);
                    workingCopyProperties.put(ContentModel.PROP_ARCHIVED_LOCK_TYPE, lockType);
                    workingCopyProperties.put(ContentModel.PROP_ARCHIVED_LOCK_LIFETIME, lifetime);
                    workingCopyProperties.put(ContentModel.PROP_ARCHIVED_EXPIRY_DATE, expiryDate);
                    workingCopyProperties.put(ContentModel.PROP_ARCHIVED_LOCK_ADDITIONAL_INFO, additionalInfo);
                    Collection<Pair<Long, AssociationRef>> targetAssocs = this.nodeDAO.getTargetNodeAssocs(nodeId, null);
                    for (Pair<Long, AssociationRef> targetAssocPair : targetAssocs) {
                        if (!ContentModel.ASSOC_ORIGINAL.equals((Object)((AssociationRef)targetAssocPair.getSecond()).getTypeQName())) continue;
                        workingCopyProperties.put(ContentModel.PROP_ARCHIVED_TARGET_ASSOCS, (Serializable)targetAssocPair.getSecond());
                    }
                    Collection<Pair<Long, AssociationRef>> sourceAssocs = this.nodeDAO.getSourceNodeAssocs(nodeId, null);
                    for (Pair<Long, AssociationRef> sourceAssocPair : sourceAssocs) {
                        if (!ContentModel.ASSOC_WORKING_COPY_LINK.equals((Object)((AssociationRef)sourceAssocPair.getSecond()).getTypeQName())) continue;
                        workingCopyProperties.put(ContentModel.PROP_ARCHIVED_SOURCE_ASSOCS, (Serializable)sourceAssocPair.getSecond());
                    }
                    this.nodeService.setProperties(workingCopyNodeRef, workingCopyProperties);
                }
            }
            finally {
                this.policyBehaviourFilter.enableBehaviour(checkedOutNodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    @Override
    public void onRestoreNode(ChildAssociationRef childAssocRef) {
        NodeRef workingCopyNodeRef = childAssocRef.getChildRef();
        if (this.nodeService.hasAspect(workingCopyNodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            try {
                NodeRef checkedOutNodeRef = null;
                this.policyBehaviourFilter.disableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_AUDITABLE);
                Map workingCopyProperties = this.nodeService.getProperties(workingCopyNodeRef);
                String lockOwner = (String)workingCopyProperties.get(ContentModel.PROP_ARCHIVED_LOCK_OWNER);
                workingCopyProperties.remove(ContentModel.PROP_ARCHIVED_LOCK_OWNER);
                Date expiryDate = (Date)workingCopyProperties.get(ContentModel.PROP_ARCHIVED_EXPIRY_DATE);
                workingCopyProperties.remove(ContentModel.PROP_ARCHIVED_EXPIRY_DATE);
                String lockTypeStr = (String)workingCopyProperties.get(ContentModel.PROP_ARCHIVED_LOCK_TYPE);
                workingCopyProperties.remove(ContentModel.PROP_ARCHIVED_LOCK_TYPE);
                LockType lockType = lockTypeStr != null ? LockType.valueOf(lockTypeStr) : null;
                String lifetimeStr = (String)workingCopyProperties.get(ContentModel.PROP_ARCHIVED_LOCK_LIFETIME);
                workingCopyProperties.remove(ContentModel.PROP_ARCHIVED_LOCK_LIFETIME);
                Lifetime lifetime = lifetimeStr != null ? Lifetime.valueOf(lifetimeStr) : null;
                String additionalInfo = (String)workingCopyProperties.get(ContentModel.PROP_ARCHIVED_LOCK_ADDITIONAL_INFO);
                workingCopyProperties.remove(ContentModel.PROP_ARCHIVED_LOCK_ADDITIONAL_INFO);
                ArrayList targetAssocList = (ArrayList)workingCopyProperties.get(ContentModel.PROP_ARCHIVED_TARGET_ASSOCS);
                if (targetAssocList != null && targetAssocList.get(0) != null) {
                    AssociationRef targetAssoc = (AssociationRef)targetAssocList.get(0);
                    checkedOutNodeRef = targetAssoc.getSourceRef();
                    this.nodeService.createAssociation(targetAssoc.getSourceRef(), targetAssoc.getTargetRef(), ContentModel.ASSOC_ORIGINAL);
                }
                workingCopyProperties.remove(ContentModel.PROP_ARCHIVED_TARGET_ASSOCS);
                ArrayList sourceAssocList = (ArrayList)workingCopyProperties.get(ContentModel.PROP_ARCHIVED_SOURCE_ASSOCS);
                if (sourceAssocList != null && sourceAssocList.get(0) != null) {
                    AssociationRef sourceAssoc = (AssociationRef)sourceAssocList.get(0);
                    checkedOutNodeRef = sourceAssoc.getSourceRef();
                    this.nodeService.createAssociation(sourceAssoc.getSourceRef(), sourceAssoc.getTargetRef(), ContentModel.ASSOC_WORKING_COPY_LINK);
                }
                workingCopyProperties.remove(ContentModel.PROP_ARCHIVED_SOURCE_ASSOCS);
                this.nodeService.removeAspect(workingCopyNodeRef, ContentModel.ASPECT_ARCHIVE_LOCKABLE);
                this.nodeService.setProperties(workingCopyNodeRef, workingCopyProperties);
                this.nodeService.addAspect(checkedOutNodeRef, ContentModel.ASPECT_LOCKABLE, null);
                Map checkedOutNodeProperties = this.nodeService.getProperties(checkedOutNodeRef);
                checkedOutNodeProperties.put(ContentModel.PROP_LOCK_OWNER, lockOwner);
                checkedOutNodeProperties.put(ContentModel.PROP_LOCK_TYPE, lockType);
                checkedOutNodeProperties.put(ContentModel.PROP_LOCK_LIFETIME, lifetime);
                checkedOutNodeProperties.put(ContentModel.PROP_EXPIRY_DATE, expiryDate);
                checkedOutNodeProperties.put(ContentModel.PROP_LOCK_ADDITIONAL_INFO, additionalInfo);
                this.nodeService.setProperties(checkedOutNodeRef, checkedOutNodeProperties);
            }
            finally {
                this.policyBehaviourFilter.enableBehaviour(workingCopyNodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        throw new UnsupportedOperationException("Use CheckOutCheckInservice to manipulate working copies.");
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return this.workingCopyAspectCopyBehaviourCallback;
    }

    private class WorkingCopyAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private WorkingCopyAspectCopyBehaviourCallback() {
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return !classQName.equals((Object)ContentModel.ASPECT_WORKING_COPY);
        }

        @Override
        public boolean isTopLevelCanBeRenamed(QName classQName, CopyDetails copyDetails) {
            return true;
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            if (classQName.equals((Object)ContentModel.ASPECT_WORKING_COPY)) {
                return Collections.emptyMap();
            }
            if (copyDetails.getSourceNodeAspectQNames().contains(ContentModel.ASPECT_WORKING_COPY)) {
                NodeRef checkedOutFrom;
                String newName = null;
                if (copyDetails.isTargetNodeIsNew() && (checkedOutFrom = WorkingCopyAspect.this.checkOutCheckInService.getCheckedOut(copyDetails.getSourceNodeRef())) != null) {
                    String oldName = (String)((Object)WorkingCopyAspect.this.nodeService.getProperty(checkedOutFrom, ContentModel.PROP_NAME));
                    int extIndex = oldName.lastIndexOf(46);
                    String string = newName = extIndex == -1 ? String.valueOf(oldName) + "_" + GUID.generate() : String.valueOf(oldName.substring(0, extIndex)) + "_" + GUID.generate() + oldName.substring(extIndex);
                }
                if (newName == null) {
                    properties.remove(ContentModel.PROP_NAME);
                } else {
                    properties.put(ContentModel.PROP_NAME, (Serializable)((Object)newName));
                }
                return properties;
            }
            return properties;
        }
    }
}

