/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.util.Date;
import java.util.Properties;
import org.alfresco.repo.mode.ServerModeProvider;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class DescriptorStartupLog
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog(DescriptorService.class);
    private DescriptorService descriptorService;
    private TransactionService transactionService;
    private ServerModeProvider serverModeProvider;
    private final String SYSTEM_INFO_STARTUP = "system.info.startup";
    private final String SYSTEM_WARN_READONLY = "system.warn.readonly";
    private final String SYSTEM_INFO_NOTRAILID = "system.info.limited_trial";

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setServerModeProvider(ServerModeProvider serverModeProvider) {
        this.serverModeProvider = serverModeProvider;
    }

    protected void onBootstrap(ApplicationEvent event) {
        LicenseDescriptor license;
        Properties properties = System.getProperties();
        String version = properties.get("java.runtime.version") == null ? "unknown" : (String)properties.get("java.runtime.version");
        long maxHeap = Runtime.getRuntime().maxMemory();
        float maxHeapMB = maxHeap / 1024L;
        maxHeapMB /= 1024.0f;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Alfresco JVM - v%s; maximum heap size %.3fMB", version, Float.valueOf(maxHeapMB)));
        }
        if (logger.isWarnEnabled()) {
            if (version.startsWith("1.2") || version.startsWith("1.3") || version.startsWith("1.4")) {
                logger.warn((Object)String.format("Alfresco JVM - WARNING - v1.5 is required; currently using v%s", version));
            }
            if (maxHeapMB < 500.0f) {
                logger.warn((Object)String.format("Alfresco JVM - WARNING - maximum heap size %.3fMB is less than recommended 512MB", Float.valueOf(maxHeapMB)));
            }
        }
        if ((license = this.descriptorService.getLicenseDescriptor()) != null && logger.isInfoEnabled()) {
            Long maxDocs;
            RepoUsage.LicenseMode licenseMode = license.getLicenseMode();
            String msg = "Alfresco license: Mode " + (Object)((Object)licenseMode);
            msg = license.isClusterEnabled() ? String.valueOf(msg) + ", cluster:enabled" : String.valueOf(msg) + ", NO CLUSTER";
            msg = license.isCustomEmbeddedWorkflowEnabled() ? String.valueOf(msg) + ", customEmbeddedWorkflow:enabled" : String.valueOf(msg) + ", NO CUSTOM EMBEDDED WORKFLOW";
            String holder = license.getHolderOrganisation();
            if (holder != null) {
                msg = String.valueOf(msg) + " granted to " + holder;
            }
            Date validUntil = license.getValidUntil();
            Integer days = null;
            if (validUntil != null) {
                days = license.getDays();
                Integer remainingDays = license.getRemainingDays();
                msg = String.valueOf(msg) + " limited to " + days + " days expiring " + validUntil + " (" + remainingDays + " days remaining).";
            } else {
                msg = String.valueOf(msg) + " (does not expire).";
            }
            Long maxUsers = license.getMaxUsers();
            if (maxUsers != null) {
                msg = String.valueOf(msg) + "  User limit is " + maxUsers + ".";
            }
            if ((maxDocs = license.getMaxDocs()) != null) {
                msg = String.valueOf(msg) + "  Content Object limit is " + maxDocs + ".";
            }
            if ("Trial User".equals(holder) && days != null && days == 2) {
                String line = "================================================================";
                logger.info((Object)line);
                logger.info((Object)msg);
                logger.info((Object)I18NUtil.getMessage((String)"system.info.limited_trial"));
                logger.info((Object)line);
            } else {
                logger.info((Object)msg);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Server Mode :" + (Object)((Object)this.serverModeProvider.getServerMode())));
            Descriptor serverDescriptor = this.descriptorService.getServerDescriptor();
            Descriptor currentDescriptor = this.descriptorService.getCurrentRepositoryDescriptor();
            Descriptor installedRepoDescriptor = this.descriptorService.getInstalledRepositoryDescriptor();
            String serverEdition = serverDescriptor.getEdition();
            String currentVersion = currentDescriptor.getVersion();
            int currentSchemaVersion = currentDescriptor.getSchema();
            RepoUsage.LicenseMode currentMode = currentDescriptor.getLicenseMode();
            String installedRepoVersion = installedRepoDescriptor.getVersion();
            int installedSchemaVersion = installedRepoDescriptor.getSchema();
            Object[] params = new Object[]{serverEdition, currentMode != RepoUsage.LicenseMode.TEAM ? "" : " " + (Object)((Object)currentMode), !AuthenticationUtil.isMtEnabled() ? "" : " Multi-Tenant", currentVersion, currentSchemaVersion, installedRepoVersion, installedSchemaVersion};
            logger.info((Object)I18NUtil.getMessage((String)"system.info.startup", (Object[])params));
        }
        if (logger.isWarnEnabled() && !this.transactionService.getAllowWrite()) {
            logger.warn((Object)I18NUtil.getMessage((String)"system.warn.readonly"));
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

