/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.cleanup;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.cleanup.FeedCleaner;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationContext;

public abstract class AbstractFeedCleanerTest {
    private ApplicationContext ctx;
    private ActivityFeedDAO feedDAO;
    protected FeedCleaner cleaner;
    private SiteService siteService;
    private PersonService personService;
    protected RetryingTransactionHelper transactionHelper;
    private NodeArchiveService nodeArchiveService;
    private static final String TEST_SITE = "testSite";
    private static final String TEST_SITE_1 = "testSite1";
    private static final String TEST_SITE_2 = "testSite2";
    private static final String TEST_SITE_3 = "testSite3";
    private static final String TEST_SITE_4 = "testSite4";
    private static final String TEST_SITE_5 = "testSite5";
    private static final String TEST_SITE_6 = "testSite6";
    private static final String TEST_SITE_7 = "testSite7";
    private static final String TEST_USER_A = "testUserA";
    private static final String TEST_USER_B = "testUserB";
    private static final String TEST_USER_C = "testUserC";
    private static final String TEST_USER_D = "testUserD";
    protected static final String TEST_USER_E = "testUserE";
    private static final String TEST_USER_F = "testUserF";

    @Before
    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        JobLockService jobLockService = (JobLockService)this.ctx.getBean("JobLockService");
        PolicyComponent policyComponent = (PolicyComponent)this.ctx.getBean("policyComponent");
        NodeService nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.siteService = (SiteService)this.ctx.getBean("SiteService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.feedDAO = (ActivityFeedDAO)this.ctx.getBean("feedDAO");
        this.transactionHelper = (RetryingTransactionHelper)this.ctx.getBean("retryingTransactionHelper");
        this.nodeArchiveService = (NodeArchiveService)this.ctx.getBean("nodeArchiveService");
        Scheduler scheduler = (Scheduler)this.ctx.getBean("schedulerFactory");
        scheduler.shutdown();
        this.tearDown();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        int i = 1;
        while (i <= 7) {
            this.siteService.createSite("myPreset", TEST_SITE + i, null, null, SiteVisibility.PUBLIC);
            ++i;
        }
        AuthenticationUtil.setRunAsUserSystem();
        this.cleaner = new FeedCleaner();
        this.cleaner.setFeedDAO(this.feedDAO);
        this.cleaner.setPolicyComponent(policyComponent);
        this.cleaner.setJobLockService(jobLockService);
        this.cleaner.setNodeService(nodeService);
    }

    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.feedDAO.deleteFeedEntries(new Date(System.currentTimeMillis() + 120000L));
        int i = 1;
        while (i <= 7) {
            SiteInfo site = this.siteService.getSite(TEST_SITE + i);
            if (site != null) {
                this.siteService.deleteSite(TEST_SITE + i);
                this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(site.getNodeRef()));
            }
            ++i;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testSetup() throws Exception {
    }

    @Test
    public void testMaxIdRange() throws Exception {
        int i = 0;
        while (i < 10) {
            ActivityFeedEntity feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setSiteNetwork(TEST_SITE_4);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_C);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            ++i;
        }
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, -1).size());
        this.cleaner.setMaxIdRange(5);
        this.cleaner.execute();
        Assert.assertEquals((long)5L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, -1).size());
    }

    @Test
    public void testMaxAge() throws Exception {
        this.cleaner.setMaxFeedSize(0);
        ActivityFeedEntity feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date(System.currentTimeMillis() - 1200000L));
        feedEntry.setSiteNetwork(TEST_SITE_1);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId("");
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date());
        feedEntry.setSiteNetwork(TEST_SITE_1);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId("");
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date(System.currentTimeMillis() - 1200000L));
        feedEntry.setSiteNetwork(TEST_SITE_2);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId(TEST_USER_B);
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date());
        feedEntry.setSiteNetwork(TEST_SITE_3);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId(TEST_USER_B);
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        Assert.assertEquals((long)2L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_1, -1).size());
        Assert.assertEquals((long)2L, (long)this.feedDAO.selectUserFeedEntries(TEST_USER_B, null, false, false, -1L, -1).size());
        this.cleaner.setMaxAgeMins(10);
        this.cleaner.execute();
        Assert.assertEquals((long)1L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_1, -1).size());
        Assert.assertEquals((long)1L, (long)this.feedDAO.selectUserFeedEntries(TEST_USER_B, null, false, false, -1L, -1).size());
    }

    @Test
    public void testMaxSize() throws Exception {
        ActivityFeedEntity feedEntry;
        ActivityFeedEntity feedEntry2;
        this.cleaner.setMaxAgeMins(0);
        int i = 0;
        while (i < 10) {
            feedEntry2 = new ActivityFeedEntity();
            feedEntry2.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry2.setSiteNetwork(TEST_SITE_4);
            feedEntry2.setActivityType("testActivityType");
            feedEntry2.setPostUserId(TEST_USER_C);
            feedEntry2.setFeedUserId("");
            feedEntry2.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry2);
            ++i;
        }
        i = 0;
        while (i < 10) {
            feedEntry2 = new ActivityFeedEntity();
            feedEntry2.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry2.setSiteNetwork(TEST_SITE_5);
            feedEntry2.setActivityType("testActivityType");
            feedEntry2.setPostUserId(TEST_USER_A);
            feedEntry2.setFeedUserId(TEST_USER_D);
            feedEntry2.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry2);
            ++i;
        }
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, -1).size());
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectUserFeedEntries(TEST_USER_D, null, false, false, -1L, -1).size());
        this.cleaner.setMaxFeedSize(2);
        this.cleaner.execute();
        Assert.assertEquals((long)2L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, -1).size());
        Assert.assertEquals((long)2L, (long)this.feedDAO.selectUserFeedEntries(TEST_USER_D, null, false, false, -1L, -1).size());
        Date sameTime = new Date();
        int i2 = 0;
        while (i2 < 10) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(sameTime);
            feedEntry.setSiteNetwork(TEST_SITE_6);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_E);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(sameTime);
            feedEntry.setSiteNetwork(TEST_SITE_7);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_A);
            feedEntry.setFeedUserId(TEST_USER_F);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            ++i2;
        }
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, -1).size());
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectUserFeedEntries(TEST_USER_F, null, false, false, -1L, -1).size());
        this.cleaner.setMaxFeedSize(2);
        this.cleaner.execute();
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, -1).size());
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectUserFeedEntries(TEST_USER_F, null, false, false, -1L, -1).size());
    }

    @Test
    public void testSiteDelete() throws Exception {
        ActivityFeedEntity feedEntry;
        this.cleaner.setMaxAgeMins(100);
        Assert.assertEquals((long)0L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, -1).size());
        Assert.assertEquals((long)0L, (long)this.feedDAO.selectUserFeedEntries(TEST_USER_D, null, false, false, -1L, -1).size());
        int site4FeedCnt = 10;
        int i = 0;
        while (i < site4FeedCnt) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setSiteNetwork(TEST_SITE_4);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_C);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            feedEntry.setFeedUserId(TEST_USER_D);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            ++i;
        }
        i = 0;
        while (i < 5) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setSiteNetwork(TEST_SITE_5);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_C);
            feedEntry.setFeedUserId(TEST_USER_D);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            ++i;
        }
        Assert.assertEquals((long)site4FeedCnt, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, -1).size());
        Assert.assertEquals((long)(site4FeedCnt + 5), (long)this.feedDAO.selectUserFeedEntries(TEST_USER_D, null, false, false, -1L, -1).size());
        SiteInfo site = this.siteService.getSite(TEST_SITE_4);
        this.siteService.deleteSite(TEST_SITE_4);
        this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(site.getNodeRef()));
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((long)0L, (long)AbstractFeedCleanerTest.this.feedDAO.selectSiteFeedEntries(AbstractFeedCleanerTest.TEST_SITE_4, -1).size());
                Assert.assertEquals((long)5L, (long)AbstractFeedCleanerTest.this.feedDAO.selectUserFeedEntries(AbstractFeedCleanerTest.TEST_USER_D, null, false, false, -1L, -1).size());
                AbstractFeedCleanerTest.this.siteService.createSite("mypreset", AbstractFeedCleanerTest.TEST_SITE_4, AbstractFeedCleanerTest.TEST_SITE_4, AbstractFeedCleanerTest.TEST_SITE_4, SiteVisibility.PUBLIC);
                Assert.assertEquals((long)0L, (long)AbstractFeedCleanerTest.this.feedDAO.selectSiteFeedEntries(AbstractFeedCleanerTest.TEST_SITE_4, -1).size());
                return null;
            }
        }, false, true);
    }

    @Test
    public void testPersonDelete() throws Exception {
        boolean caseSensitive = Boolean.getBoolean(System.getProperty("user.name.caseSensitive"));
        if (caseSensitive) {
            this.testPersonDelete(TEST_USER_E);
        } else {
            this.testPersonDelete(TEST_USER_E.toLowerCase());
        }
    }

    protected void testPersonDelete(final String userId) throws Exception {
        ActivityFeedEntity feedEntry;
        this.cleaner.setMaxAgeMins(100);
        this.createPerson(userId);
        Assert.assertEquals((long)0L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, -1).size());
        Assert.assertEquals((long)0L, (long)this.feedDAO.selectUserFeedEntries(userId, null, false, false, -1L, -1).size());
        int i = 0;
        while (i < 10) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setSiteNetwork(TEST_SITE_6);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(userId);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            feedEntry.setFeedUserId(userId);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            ++i;
        }
        i = 0;
        while (i < 5) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setSiteNetwork(TEST_SITE_7);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(userId);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            feedEntry.setFeedUserId(userId);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            ++i;
        }
        Assert.assertEquals((long)10L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, -1).size());
        Assert.assertEquals((long)5L, (long)this.feedDAO.selectSiteFeedEntries(TEST_SITE_7, -1).size());
        Assert.assertEquals((long)15L, (long)this.feedDAO.selectUserFeedEntries(userId, null, false, false, -1L, -1).size());
        this.personService.deletePerson(userId);
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((long)10L, (long)AbstractFeedCleanerTest.this.feedDAO.selectSiteFeedEntries(AbstractFeedCleanerTest.TEST_SITE_6, -1).size());
                Assert.assertEquals((long)5L, (long)AbstractFeedCleanerTest.this.feedDAO.selectSiteFeedEntries(AbstractFeedCleanerTest.TEST_SITE_7, -1).size());
                Assert.assertEquals((long)0L, (long)AbstractFeedCleanerTest.this.feedDAO.selectUserFeedEntries(userId, null, false, false, -1L, -1).size());
                Assert.assertTrue((boolean)AbstractFeedCleanerTest.this.createPerson(userId));
                Assert.assertEquals((long)0L, (long)AbstractFeedCleanerTest.this.feedDAO.selectUserFeedEntries(userId, null, false, false, -1L, -1).size());
                return null;
            }
        }, false, true);
    }

    private boolean createPerson(String userName) {
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(userName) + "@email.com"));
            this.personService.createPerson((Map)personProps);
            return true;
        }
        return false;
    }

    @Test
    public void testConcurrentAccessAndRemoval() throws Exception {
        this.cleaner.setMaxAgeMins(1);
        this.cleaner.setMaxFeedSize(1);
        int typeCount = 3;
        int n = typeCount * 10;
        Thread[] threads = new Thread[n];
        Tester[] testers = new Tester[n];
        int i = 0;
        while (i < n) {
            Tester tester;
            testers[i] = tester = new Tester(i, typeCount);
            threads[i] = new Thread(tester);
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < n) {
            threads[i].join();
            if (testers[i].getErrorStackTrace() != null) {
                Assert.fail((String)testers[i].getErrorStackTrace());
            }
            ++i;
        }
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("user.name.caseSensitive");
    }

    private class Tester
    implements Runnable {
        private int i;
        private int typeCount;
        private String errorStackTrace = null;

        public Tester(int i, int typeCount) {
            this.i = i;
            this.typeCount = typeCount;
        }

        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        @Override
        public void run() {
            try {
                int type = this.i % this.typeCount;
                if (type == 0) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    int insertCount = 10;
                    int i = 0;
                    while (i < insertCount) {
                        final ActivityFeedEntity feedEntry = new ActivityFeedEntity();
                        feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
                        feedEntry.setSiteNetwork(AbstractFeedCleanerTest.TEST_SITE_4);
                        feedEntry.setActivityType("testActivityType");
                        feedEntry.setPostUserId(AbstractFeedCleanerTest.TEST_USER_C);
                        feedEntry.setFeedUserId("");
                        feedEntry.setFeedDate(new Date());
                        AbstractFeedCleanerTest.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            public Object execute() throws Throwable {
                                AbstractFeedCleanerTest.this.feedDAO.insertFeedEntry(feedEntry);
                                return null;
                            }
                        });
                        ++i;
                    }
                    System.out.println("[" + this.i + "] Inserted " + insertCount + " entries");
                }
                if (type == 1) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    int selectCount = (Integer)AbstractFeedCleanerTest.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                        public Integer execute() throws Throwable {
                            int selectCount = AbstractFeedCleanerTest.this.feedDAO.selectSiteFeedEntries(AbstractFeedCleanerTest.TEST_SITE_4, -1).size();
                            return selectCount;
                        }
                    });
                    System.out.println("[" + this.i + "] Selected " + selectCount + " entries");
                }
                if (type == 2) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                    int deleteCount = (Integer)AbstractFeedCleanerTest.this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                        public Integer execute() throws Throwable {
                            int deleteCount = ((Tester)Tester.this).AbstractFeedCleanerTest.this.cleaner.execute();
                            return deleteCount;
                        }
                    });
                    System.out.println("[" + this.i + "] Deleted " + deleteCount + " entries");
                }
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                this.errorStackTrace = sw.toString();
                Assert.fail((String)t.getMessage());
            }
        }
    }
}

