/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.content.MimetypeMap;
import org.alfresco.repo.content.transform.AbstractLocalTransform;
import org.alfresco.repo.content.transform.LocalPipelineTransform;
import org.alfresco.repo.content.transform.LocalTransformImpl;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.CombinedConfig;
import org.alfresco.transform.registry.SupportedTransform;
import org.alfresco.transform.registry.TransformRegistryModelTest;
import org.alfresco.transform.registry.TransformServiceRegistryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.quartz.CronExpression;

public class LocalTransformServiceRegistryConfigTest
extends TransformRegistryModelTest {
    public static final String HARD_CODED_VALUE = "hard coded value";
    private static Log log = LogFactory.getLog(LocalTransformServiceRegistry.class);
    public static final String PNG = "image/png";
    public static final String TIFF = "image/tiff";
    public static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private static final String LOCAL_TRANSFORM_SERVICE_CONFIG = "alfresco/local-transform-service-config-test.json";
    private static final String LOCAL_TRANSFORM_SERVICE_CONFIG_PIPELINE = "alfresco/local-transform-service-config-pipeline-test.json";
    private static final String LOCAL_TRANSFORM = "localTransform.";
    private static final String URL = ".url";
    private Map<String, Set<TransformOption>> mapOfTransformOptions;
    private List<Transformer> transformerList;
    protected TestLocalTransformServiceRegistry registry;
    private Properties properties = new Properties();
    @Mock
    private TransformerDebug transformerDebug;
    @Mock
    private MimetypeMap mimetypeMap;
    private Map<String, List<String>> imagemagickSupportedTransformation;
    private Map<String, List<String>> tikaSupportedTransformation;
    private Map<String, List<String>> pdfRendererSupportedTransformation;
    private Map<String, List<String>> libreofficeSupportedTransformation;
    private Map<String, List<String>> officeToImageViaPdfSupportedTransformation;
    private int readConfigCount;
    private long startMs = System.currentTimeMillis();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.initTestData();
        super.setUp();
        Configurator.setLevel(LocalTransformServiceRegistryConfigTest.class, (Level)Level.DEBUG);
    }

    protected LocalTransformServiceRegistry buildTransformServiceRegistryImpl() throws Exception {
        this.registry = new TestLocalTransformServiceRegistry();
        this.registry.setJsonObjectMapper(JSON_OBJECT_MAPPER);
        this.registry.setProperties(this.properties);
        this.registry.setTransformerDebug(this.transformerDebug);
        this.registry.setMimetypeService((MimetypeService)this.mimetypeMap);
        this.registry.setPipelineConfigDir("");
        this.registry.setCronExpression(null);
        this.registry.afterPropertiesSet();
        return this.registry;
    }

    private String getMs() {
        return String.valueOf(System.currentTimeMillis() - this.startMs) + "ms: ";
    }

    protected int getExpectedTransformsForTestJsonPipeline() {
        return 11;
    }

    private void retrieveLocalTransformList(String path) {
        CombinedConfig combinedConfig = new CombinedConfig(log, (AbstractTransformRegistry)this.registry, this.registry.getHttpClientConfig());
        combinedConfig.addLocalConfig(path);
        combinedConfig.register((TransformServiceRegistryImpl)this.registry);
        TransformConfig transformConfig = combinedConfig.buildTransformConfig();
        this.mapOfTransformOptions = transformConfig.getTransformOptions();
        this.transformerList = transformConfig.getTransformers();
    }

    private void initTestData() {
        System.setProperty("localTransform.pdfrenderer.url", "http://localhost:8090/");
        System.setProperty("localTransform.imagemagick.url", "http://localhost:8091/");
        System.setProperty("localTransform.libreoffice.url", "http://localhost:8092/");
        System.setProperty("localTransform.tika.url", "http://localhost:8093/");
        this.properties.setProperty("localTransform.pdfrenderer.url", "http://localhost:8090/");
        this.properties.setProperty("localTransform.imagemagick.url", "http://localhost:8091/");
        this.properties.setProperty("localTransform.libreoffice.url", "http://localhost:8092/");
        this.properties.setProperty("localTransform.tika.url", "http://localhost:8093/");
        this.imagemagickSupportedTransformation = new HashMap<String, List<String>>();
        ArrayList<String> targetMimetype = new ArrayList<String>();
        targetMimetype.add("image/gif");
        targetMimetype.add(TIFF);
        this.imagemagickSupportedTransformation.put(TIFF, targetMimetype);
        targetMimetype = new ArrayList(targetMimetype);
        targetMimetype.add(PNG);
        targetMimetype.add("image/jpeg");
        this.imagemagickSupportedTransformation.put("image/gif", targetMimetype);
        this.imagemagickSupportedTransformation.put("image/jpeg", targetMimetype);
        targetMimetype = new ArrayList(targetMimetype);
        targetMimetype.add("alfresco-metadata-extract");
        this.imagemagickSupportedTransformation.put(PNG, targetMimetype);
        targetMimetype = new ArrayList();
        targetMimetype.add("target1");
        targetMimetype.add("target2");
        targetMimetype.add("target3");
        this.imagemagickSupportedTransformation.put("source", targetMimetype);
        targetMimetype = new ArrayList();
        this.tikaSupportedTransformation = new HashMap<String, List<String>>();
        targetMimetype.add("text/plain");
        this.tikaSupportedTransformation.put("application/pdf", targetMimetype);
        this.tikaSupportedTransformation.put("application/msword", targetMimetype);
        this.tikaSupportedTransformation.put("application/vnd.ms-excel", targetMimetype);
        this.tikaSupportedTransformation.put("application/vnd.ms-powerpoint", targetMimetype);
        this.tikaSupportedTransformation.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", targetMimetype);
        this.tikaSupportedTransformation.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", targetMimetype);
        this.tikaSupportedTransformation.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", targetMimetype);
        this.tikaSupportedTransformation.put("application/vnd.ms-outlook", targetMimetype);
        targetMimetype = new ArrayList();
        targetMimetype.add("target1");
        targetMimetype.add("target2");
        targetMimetype.add("target3");
        this.tikaSupportedTransformation.put("source", targetMimetype);
        targetMimetype = new ArrayList();
        this.libreofficeSupportedTransformation = new HashMap<String, List<String>>();
        targetMimetype.add("application/pdf");
        this.libreofficeSupportedTransformation.put("application/vnd.ms-excel", targetMimetype);
        this.libreofficeSupportedTransformation.put("application/vnd.ms-powerpoint", targetMimetype);
        this.libreofficeSupportedTransformation.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", targetMimetype);
        this.libreofficeSupportedTransformation.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", targetMimetype);
        this.libreofficeSupportedTransformation.put("application/vnd.ms-outlook", targetMimetype);
        targetMimetype.add("application/msword");
        this.libreofficeSupportedTransformation.put("application/msword", targetMimetype);
        this.libreofficeSupportedTransformation.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", targetMimetype);
        targetMimetype = new ArrayList();
        this.pdfRendererSupportedTransformation = new HashMap<String, List<String>>();
        targetMimetype.add(PNG);
        this.pdfRendererSupportedTransformation.put("application/pdf", targetMimetype);
        targetMimetype = new ArrayList();
        targetMimetype.add("target1");
        targetMimetype.add("target2");
        targetMimetype.add("target3");
        this.pdfRendererSupportedTransformation.put("source", targetMimetype);
        targetMimetype = new ArrayList();
        this.officeToImageViaPdfSupportedTransformation = new HashMap<String, List<String>>();
        targetMimetype.add("image/gif");
        targetMimetype.add(TIFF);
        targetMimetype.add(PNG);
        targetMimetype.add("image/jpeg");
        this.officeToImageViaPdfSupportedTransformation.put("application/msword", targetMimetype);
        this.officeToImageViaPdfSupportedTransformation.put("application/vnd.ms-excel", targetMimetype);
        this.officeToImageViaPdfSupportedTransformation.put("application/vnd.ms-powerpoint", targetMimetype);
        this.officeToImageViaPdfSupportedTransformation.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", targetMimetype);
        this.officeToImageViaPdfSupportedTransformation.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", targetMimetype);
        this.officeToImageViaPdfSupportedTransformation.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", targetMimetype);
        this.officeToImageViaPdfSupportedTransformation.put("application/vnd.ms-outlook", targetMimetype);
    }

    protected String getBaseUrl(Transformer transformer) {
        return LOCAL_TRANSFORM + transformer.getTransformerName() + URL;
    }

    private int countTopLevelOptions(Set<String> transformOptionNames) {
        int i = 0;
        for (String name : transformOptionNames) {
            Set<TransformOption> transformOptions = this.mapOfTransformOptions.get(name);
            i += transformOptions.size();
        }
        return i;
    }

    private void register(String path) throws IOException {
        CombinedConfig combinedConfig = new CombinedConfig(log, (AbstractTransformRegistry)this.registry, this.registry.getHttpClientConfig());
        combinedConfig.addLocalConfig(path);
        combinedConfig.register((TransformServiceRegistryImpl)this.registry);
    }

    protected void assertSupported(String sourceMimetype, long sourceSizeInBytes, String targetMimetype, Map<String, String> actualOptions, String renditionName, String unsupportedMsg) {
        boolean supported = this.registry.isSupported(sourceMimetype, sourceSizeInBytes, targetMimetype, actualOptions, renditionName);
        if (unsupportedMsg != null && !unsupportedMsg.isEmpty()) {
            Assert.assertFalse((boolean)supported);
        } else {
            Assert.assertTrue((boolean)supported);
        }
    }

    @Test
    public void testJsonConfig() throws IOException {
        this.register(LOCAL_TRANSFORM_SERVICE_CONFIG);
        Assert.assertEquals((String)"The number of UNIQUE source to target mimetypes transforms has changed. Config change?", (long)64L, (long)this.countSupportedTransforms(true));
        Assert.assertEquals((String)"The number of source to target mimetypes transforms has changed. There may be multiple transformers for the same combination. Config change?", (long)70L, (long)this.countSupportedTransforms(false));
        this.assertSupported("application/msword", 1234L, "application/pdf", Collections.emptyMap(), null, "");
        this.assertSupported("application/msword", 1234L, "application/pdf", Collections.emptyMap(), null, "");
        this.assertSupported("application/pdf", 1234L, PNG, Collections.emptyMap(), null, "");
        this.assertSupported("image/jpeg", 1234L, "image/gif", Collections.emptyMap(), null, "");
        this.assertSupported("application/vnd.ms-outlook", 1234L, "text/plain", Collections.emptyMap(), null, "");
        this.assertSupported("application/vnd.ms-outlook", 1234L, "image/gif", Collections.emptyMap(), null, "");
        HashMap<String, String> invalidPdfOptions = new HashMap<String, String>();
        invalidPdfOptions.put("allowEnlargement", "false");
        this.assertSupported("application/msword", 1234L, "application/pdf", invalidPdfOptions, null, "Invalid as there is a extra option");
    }

    @Test
    public void testJsonPipeline() throws IOException {
        TransformOptionGroup pdf;
        TransformOptionGroup imagemagick;
        this.register(LOCAL_TRANSFORM_SERVICE_CONFIG_PIPELINE);
        int expectedTransforms = this.getExpectedTransformsForTestJsonPipeline();
        Assert.assertEquals((String)"The number of UNIQUE source to target mimetypes transforms has changed. Config change?", (long)expectedTransforms, (long)this.countSupportedTransforms(true));
        Assert.assertEquals((String)"The number of source to target mimetypes transforms has changed. There may be multiple transformers for the same combination. Config change?", (long)expectedTransforms, (long)this.countSupportedTransforms(false));
        Map transformsToWord = (Map)this.registry.getData().getTransforms().get("application/msword");
        List supportedTransforms = (List)transformsToWord.get("image/gif");
        SupportedTransform supportedTransform = (SupportedTransform)supportedTransforms.get(0);
        Set transformOptionsSet = supportedTransform.getTransformOptions().getTransformOptions();
        Iterator iterator = transformOptionsSet.iterator();
        Assert.assertTrue((String)"Expected transform values", (boolean)iterator.hasNext());
        TransformOptionGroup transformOptions1 = (TransformOptionGroup)iterator.next();
        Assert.assertTrue((String)"Expected transform values", (boolean)iterator.hasNext());
        TransformOptionGroup transformOptions2 = (TransformOptionGroup)iterator.next();
        if (this.containsTransformOptionValueName(transformOptions1, "alphaRemove")) {
            imagemagick = transformOptions1;
            pdf = transformOptions2;
        } else {
            imagemagick = transformOptions2;
            pdf = transformOptions1;
        }
        TransformOptionValue alphaRemove = (TransformOptionValue)this.retrieveTransformOptionByPropertyName(imagemagick, "alphaRemove", "TransformOptionValue");
        TransformOptionGroup crop = (TransformOptionGroup)this.retrieveTransformOptionByPropertyName(imagemagick, "crop", "TransformOptionGroup");
        TransformOptionValue cropGravity = (TransformOptionValue)this.retrieveTransformOptionByPropertyName(crop, "cropGravity", "TransformOptionValue");
        TransformOptionValue cropWidth = (TransformOptionValue)this.retrieveTransformOptionByPropertyName(crop, "cropWidth", "TransformOptionValue");
        Assert.assertTrue((String)"The holding group should be required", (boolean)supportedTransform.getTransformOptions().isRequired());
        Assert.assertFalse((String)"imagemagick should be optional as it is not set", (boolean)imagemagick.isRequired());
        Assert.assertFalse((String)"pdf should be optional as required is not set", (boolean)pdf.isRequired());
        Assert.assertEquals((Object)"alphaRemove", (Object)alphaRemove.getName());
        Assert.assertEquals((Object)"cropGravity", (Object)cropGravity.getName());
        Assert.assertEquals((Object)"cropWidth", (Object)cropWidth.getName());
        Assert.assertFalse((String)"alphaRemove should be optional as required is not set", (boolean)alphaRemove.isRequired());
        Assert.assertFalse((String)"crop should be optional as required is not set", (boolean)crop.isRequired());
        Assert.assertTrue((String)"cropGravity should be required as it is set", (boolean)cropGravity.isRequired());
        Assert.assertFalse((String)"cropWidth should be optional as required is not set", (boolean)cropWidth.isRequired());
        this.assertSupported("application/msword", 1234L, "image/gif", Collections.emptyMap(), null, "");
        this.assertSupported("application/msword", 1234L, PNG, Collections.emptyMap(), null, "");
        this.assertSupported("application/msword", 1234L, "image/jpeg", Collections.emptyMap(), null, "");
        this.assertSupported("application/msword", 1234L, TIFF, Collections.emptyMap(), null, "");
        HashMap<String, String> actualOptions = new HashMap<String, String>();
        actualOptions.put("thumbnail", "true");
        actualOptions.put("resizeWidth", "100");
        actualOptions.put("resizeHeight", "100");
        actualOptions.put("allowEnlargement", "false");
        actualOptions.put("maintainAspectRatio", "true");
        this.assertSupported("application/msword", 1234L, PNG, actualOptions, null, "");
    }

    private TransformOption retrieveTransformOptionByPropertyName(TransformOptionGroup transformOptionGroup, String propertyName, String propertyType) {
        Iterator iterator = transformOptionGroup.getTransformOptions().iterator();
        ArrayList<TransformOption> transformOptionsList = new ArrayList<TransformOption>();
        while (iterator.hasNext()) {
            transformOptionsList.add((TransformOption)iterator.next());
        }
        for (TransformOption t : transformOptionsList) {
            if (t instanceof TransformOptionValue) {
                TransformOptionValue value = (TransformOptionValue)t;
                if (propertyType.equalsIgnoreCase("TransformOptionValue")) {
                    if (!value.getName().equalsIgnoreCase(propertyName)) continue;
                    return value;
                }
                if (!value.getName().contains(propertyName)) continue;
                return transformOptionGroup;
            }
            TransformOption result = this.retrieveTransformOptionByPropertyName((TransformOptionGroup)t, propertyName, propertyType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean containsTransformOptionValueName(TransformOptionGroup transformOptionGroup, String propertyName) {
        return this.retrieveTransformOptionByPropertyName(transformOptionGroup, propertyName, "TransformOptionValue") != null;
    }

    private int countSupportedTransforms(boolean unique) {
        int count = 0;
        int uniqueCount = 0;
        for (Map targetMap : this.registry.getData().getTransforms().values()) {
            for (List supportedTransforms : targetMap.values()) {
                ++uniqueCount;
                count += supportedTransforms.size();
            }
        }
        return unique ? uniqueCount : count;
    }

    @Test
    public void testReadJsonConfig() {
        this.retrieveLocalTransformList(LOCAL_TRANSFORM_SERVICE_CONFIG);
        Assert.assertNotNull((String)"Transformer list is null.", this.transformerList);
        Assert.assertEquals((String)"Unexpected number of transformers retrieved", (long)5L, (long)this.transformerList.size());
        ArrayList<String> listOfExpectedTransformersName = new ArrayList<String>();
        listOfExpectedTransformersName.add("imagemagick");
        listOfExpectedTransformersName.add("tika");
        listOfExpectedTransformersName.add("pdfrenderer");
        listOfExpectedTransformersName.add("libreoffice");
        listOfExpectedTransformersName.add("officeToImageViaPdf");
        block14: for (Transformer transformer : this.transformerList) {
            Assert.assertTrue((String)(String.valueOf(transformer.getTransformerName()) + " should be an expected local transformer."), (boolean)listOfExpectedTransformersName.contains(transformer.getTransformerName()));
            listOfExpectedTransformersName.remove(transformer.getTransformerName());
            switch (transformer.getTransformerName()) {
                case "imagemagick": {
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " incorrect number of supported transform"), (long)18L, (long)transformer.getSupportedSourceAndTargetList().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform option names"), (long)1L, (long)transformer.getTransformOptions().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform options"), (long)6L, (long)this.countTopLevelOptions(transformer.getTransformOptions()));
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a transformer pipeline"), (long)transformer.getTransformerPipeline().size(), (long)0L);
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a failover pipeline"), (long)transformer.getTransformerFailover().size(), (long)0L);
                    for (SupportedSourceAndTarget ssat : transformer.getSupportedSourceAndTargetList()) {
                        Assert.assertTrue((String)(String.valueOf(ssat.getSourceMediaType()) + " not expected to be a supported transform source."), (boolean)this.imagemagickSupportedTransformation.containsKey(ssat.getSourceMediaType()));
                        Assert.assertTrue((String)(String.valueOf(ssat.getTargetMediaType()) + " not expected to be a supported transform target for " + ssat.getSourceMediaType()), (boolean)this.imagemagickSupportedTransformation.get(ssat.getSourceMediaType()).contains(ssat.getTargetMediaType()));
                    }
                    continue block14;
                }
                case "tika": {
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " incorrect number of supported transform"), (long)11L, (long)transformer.getSupportedSourceAndTargetList().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform option names"), (long)1L, (long)transformer.getTransformOptions().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform options"), (long)5L, (long)this.countTopLevelOptions(transformer.getTransformOptions()));
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a transformer pipeline"), (long)transformer.getTransformerPipeline().size(), (long)0L);
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a failover pipeline"), (long)transformer.getTransformerFailover().size(), (long)0L);
                    for (SupportedSourceAndTarget ssat : transformer.getSupportedSourceAndTargetList()) {
                        Assert.assertTrue((String)(String.valueOf(ssat.getSourceMediaType()) + " not expected to be a supported transform source."), (boolean)this.tikaSupportedTransformation.containsKey(ssat.getSourceMediaType()));
                        Assert.assertTrue((String)(String.valueOf(ssat.getTargetMediaType()) + " not expected to be a supported transform target for " + ssat.getSourceMediaType()), (boolean)this.tikaSupportedTransformation.get(ssat.getSourceMediaType()).contains(ssat.getTargetMediaType()));
                    }
                    continue block14;
                }
                case "pdfrenderer": {
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " incorrect number of supported transform"), (long)4L, (long)transformer.getSupportedSourceAndTargetList().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform option names"), (long)1L, (long)transformer.getTransformOptions().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform options"), (long)5L, (long)this.countTopLevelOptions(transformer.getTransformOptions()));
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a transformer pipeline"), (long)transformer.getTransformerPipeline().size(), (long)0L);
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a failover pipeline"), (long)transformer.getTransformerFailover().size(), (long)0L);
                    for (SupportedSourceAndTarget ssat : transformer.getSupportedSourceAndTargetList()) {
                        Assert.assertTrue((String)(String.valueOf(ssat.getSourceMediaType()) + " not expected to be a supported transform source."), (boolean)this.pdfRendererSupportedTransformation.containsKey(ssat.getSourceMediaType()));
                        Assert.assertTrue((String)(String.valueOf(ssat.getTargetMediaType()) + " not expected to be a supported transform target for " + ssat.getSourceMediaType()), (boolean)this.pdfRendererSupportedTransformation.get(ssat.getSourceMediaType()).contains(ssat.getTargetMediaType()));
                    }
                    continue block14;
                }
                case "libreoffice": {
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " incorrect number of supported transform"), (long)9L, (long)transformer.getSupportedSourceAndTargetList().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform option names"), (long)0L, (long)transformer.getTransformOptions().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform options"), (long)0L, (long)this.countTopLevelOptions(transformer.getTransformOptions()));
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a transformer pipeline"), (long)transformer.getTransformerPipeline().size(), (long)0L);
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to not be a failover pipeline"), (long)transformer.getTransformerFailover().size(), (long)0L);
                    for (SupportedSourceAndTarget ssat : transformer.getSupportedSourceAndTargetList()) {
                        Assert.assertTrue((String)(String.valueOf(ssat.getSourceMediaType()) + " not expected to be a supported transform source."), (boolean)this.libreofficeSupportedTransformation.containsKey(ssat.getSourceMediaType()));
                        Assert.assertTrue((String)(String.valueOf(ssat.getTargetMediaType()) + " not expected to be a supported transform target for " + ssat.getSourceMediaType()), (boolean)this.libreofficeSupportedTransformation.get(ssat.getSourceMediaType()).contains(ssat.getTargetMediaType()));
                    }
                    continue block14;
                }
                case "officeToImageViaPdf": {
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " incorrect number of supported transform"), (long)28L, (long)transformer.getSupportedSourceAndTargetList().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform option names"), (long)2L, (long)transformer.getTransformOptions().size());
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + "incorrect number of transform options"), (long)11L, (long)this.countTopLevelOptions(transformer.getTransformOptions()));
                    Assert.assertEquals((String)(String.valueOf(transformer.getTransformerName()) + " expected to be a transformer pipeline"), (long)transformer.getTransformerPipeline().size(), (long)3L);
                    for (SupportedSourceAndTarget ssat : transformer.getSupportedSourceAndTargetList()) {
                        Assert.assertTrue((String)(String.valueOf(ssat.getSourceMediaType()) + " not expected to be a supported transform source."), (boolean)this.officeToImageViaPdfSupportedTransformation.containsKey(ssat.getSourceMediaType()));
                        Assert.assertTrue((String)(String.valueOf(ssat.getTargetMediaType()) + " not expected to be a supported transform target for " + ssat.getSourceMediaType()), (boolean)this.officeToImageViaPdfSupportedTransformation.get(ssat.getSourceMediaType()).contains(ssat.getTargetMediaType()));
                    }
                    continue block14;
                }
            }
        }
        Assert.assertEquals((String)"Transformer expected but not found in config file", (long)0L, (long)listOfExpectedTransformersName.size());
    }

    @Test
    public void testReadTransformProperties() {
        this.retrieveLocalTransformList(LOCAL_TRANSFORM_SERVICE_CONFIG);
        Assert.assertNotNull((String)"Transformer list is null.", this.transformerList);
        for (Transformer transformer : this.transformerList) {
            if (transformer.getTransformerPipeline() != null) continue;
            Assert.assertNotNull((String)(String.valueOf(transformer.getTransformerName()) + " JVM property not set."), (Object)System.getProperty(LOCAL_TRANSFORM + transformer.getTransformerName() + URL));
        }
        Assert.assertEquals((String)"Unexpected pdfrenderer JVM property value", (Object)"http://localhost:8090/", (Object)System.getProperty("localTransform.pdfrenderer.url"));
        Assert.assertEquals((String)"Unexpected imagemagick JVM property value", (Object)"http://localhost:8091/", (Object)System.getProperty("localTransform.imagemagick.url"));
        Assert.assertEquals((String)"Unexpected libreoffice JVM property value", (Object)"http://localhost:8092/", (Object)System.getProperty("localTransform.libreoffice.url"));
        Assert.assertEquals((String)"Unexpected tika JVM property value", (Object)"http://localhost:8093/", (Object)System.getProperty("localTransform.tika.url"));
        for (Transformer transformer : this.transformerList) {
            if (transformer.getTransformerPipeline() != null) continue;
            Assert.assertNotNull((String)(String.valueOf(transformer.getTransformerName()) + " alfresco-global property not set."), (Object)this.properties.getProperty(LOCAL_TRANSFORM + transformer.getTransformerName() + URL));
        }
        Assert.assertEquals((String)"Unexpected pdfrenderer alfresco-global property value", (Object)"http://localhost:8090/", (Object)this.properties.getProperty("localTransform.pdfrenderer.url"));
        Assert.assertEquals((String)"Unexpected imagemagick alfresco-global property value", (Object)"http://localhost:8091/", (Object)this.properties.getProperty("localTransform.imagemagick.url"));
        Assert.assertEquals((String)"Unexpected libreoffice alfresco-global property value", (Object)"http://localhost:8092/", (Object)this.properties.getProperty("localTransform.libreoffice.url"));
        Assert.assertEquals((String)"Unexpected tika alfresco-global property value", (Object)"http://localhost:8093/", (Object)this.properties.getProperty("localTransform.tika.url"));
    }

    @Test
    public void testAdditionAndRemovalOfTEngines() throws Exception {
        CronExpression origCronExpression = this.registry.getCronExpression();
        CronExpression origInitialAndOnErrorCronExpression = this.registry.getInitialAndOnErrorCronExpression();
        String origPipelineConfigDir = this.registry.getPipelineConfigDir();
        try {
            this.readConfigCount = 0;
            this.registry.setInitialAndOnErrorCronExpression(new CronExpression("0/2 * * ? * * *"));
            this.registry.setCronExpression(new CronExpression("0/4 * * ? * * *"));
            Thread.sleep(4000L - System.currentTimeMillis() % 4000L);
            this.startMs = System.currentTimeMillis();
            this.registry.setMockSuccessReadingConfig(false);
            this.registry.afterPropertiesSet();
            LocalTransformServiceRegistry.LocalData data = this.registry.getData();
            Thread.sleep(1000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after a few milliseconds that fails");
            Thread.sleep(2000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after 2 seconds that fails");
            Thread.sleep(2000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after 4 seconds that fails");
            Thread.sleep(2000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after 6 seconds that fails");
            this.registry.setMockSuccessReadingConfig(true);
            Thread.sleep(2000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after 8 seconds that succeeds");
            Thread.sleep(2000L);
            data = this.registry.assertDataUnchanged((TransformServiceRegistryImpl.Data)data, "There really should not have been a read until 12 seconds");
            Thread.sleep(2000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after 12 seconds that succeeds");
            this.registry.setMockSuccessReadingConfig(false);
            Thread.sleep(4000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after 16 seconds that fails");
            Thread.sleep(2000L);
            data = this.registry.assertDataChanged((TransformServiceRegistryImpl.Data)data, "There should have been a read after 18 seconds");
        }
        finally {
            this.registry.setMockSuccessReadingConfig(true);
            this.registry.setCronExpression(origCronExpression);
            this.registry.setInitialAndOnErrorCronExpression(origInitialAndOnErrorCronExpression);
            this.registry.setPipelineConfigDir(origPipelineConfigDir);
        }
    }

    @Test
    public void testStripExtraOptions() {
        this.retrieveLocalTransformList(LOCAL_TRANSFORM_SERVICE_CONFIG);
        Map<String, String> actualOptions = Map.of("autoOrient", "true", "width", "100", "height", "50");
        LocalPipelineTransform officeToImageViaPdf = (LocalPipelineTransform)this.registry.getLocalTransform("application/msword", -1L, "image/gif", actualOptions, null);
        Assert.assertEquals((String)"Original number of options officeToImageViaPdf", (long)21L, (long)officeToImageViaPdf.getTransformsTransformOptionNames().size());
        AbstractLocalTransform libreoffice = (AbstractLocalTransform)officeToImageViaPdf.getIntermediateTransformer(0);
        Assert.assertEquals((String)"libreoffice options", (long)0L, (long)libreoffice.getTransformsTransformOptionNames().size());
        Assert.assertEquals((String)"libreoffice actual options", (long)0L, (long)libreoffice.getStrippedTransformOptions(actualOptions).size());
        AbstractLocalTransform pdfrenderer = (AbstractLocalTransform)officeToImageViaPdf.getIntermediateTransformer(1);
        Assert.assertEquals((String)"pdfrenderer options", (long)5L, (long)pdfrenderer.getTransformsTransformOptionNames().size());
        Assert.assertEquals((String)"pdfrenderer actual options", (long)2L, (long)pdfrenderer.getStrippedTransformOptions(actualOptions).size());
        AbstractLocalTransform imagemagick = (AbstractLocalTransform)officeToImageViaPdf.getIntermediateTransformer(2);
        Assert.assertEquals((String)"imagemagick options", (long)16L, (long)imagemagick.getTransformsTransformOptionNames().size());
        Assert.assertEquals((String)"imagemagick actual options", (long)1L, (long)imagemagick.getStrippedTransformOptions(actualOptions).size());
    }

    @Test
    public void testPriority() {
        this.retrieveLocalTransformList(LOCAL_TRANSFORM_SERVICE_CONFIG);
        Assert.assertEquals((Object)"pdfrenderer", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("source", -1L, "target1", Collections.emptyMap(), null)).getName());
        Assert.assertEquals((Object)"imagemagick", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("source", -1L, "target2", Collections.emptyMap(), null)).getName());
        Assert.assertEquals((Object)"tika", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("source", -1L, "target3", Collections.emptyMap(), null)).getName());
    }

    @Test
    public void testNoName() {
        this.retrieveLocalTransformList("alfresco/local-transform-service-config-no-name-test.json");
        this.registry.assertErrorLogged("Transformer names may not be null.*no-name-test.*");
    }

    @Test
    public void testPipelineAndFailover() {
        this.retrieveLocalTransformList("alfresco/local-transform-service-config-pipeline-and-failover-test.json");
        this.registry.assertErrorLogged("Transformer .* cannot have both pipeline and failover sections.*pipeline-and-failover.*");
    }

    @Test
    public void testTEngineDuplicateNames() {
        this.retrieveLocalTransformList("alfresco/local-transform-service-config-dup-name-test.json");
        this.registry.assertErrorLogged("Transformer \"pdfrenderer\" must be a unique name.*dup-name.*");
    }

    @Test
    public void testTEngineNoBaseUrls() {
        this.registry.setResetBaseUrl(false);
        this.retrieveLocalTransformList("alfresco/local-transform-service-config-no-base-url-test.json");
        this.registry.assertErrorLogged("Single step transformers \\(such as \"pdfrenderer\"\\) must be defined in a T-Engine rather than in a pipeline file, unless they are overriding an existing single step definition.*no-base-url.*");
    }

    @Test
    public void testPipelineMissingStepTransform() {
        this.retrieveLocalTransformList("alfresco/transform-service-config-pipeline-missing-step-test.json");
        this.registry.assertErrorLogged("Transformer \"missingPdfrenderer\" ignored as step transforms \\(\"pdfrenderer\"\\) do not exist.*pipeline-missing-step-test.*");
    }

    @Test
    public void testFailoverMissingStepTransform() {
        this.retrieveLocalTransformList("alfresco/transform-service-config-failover-missing-step-test.json");
        this.registry.assertErrorLogged("Transformer \"missingPdfrenderer\" ignored as step transforms \\(\"pdfrenderer\"\\) do not exist.*failover-missing-step-test.*");
    }

    @Test
    public void testOverrideTEngine() {
        this.retrieveLocalTransformList("alfresco/local-transform-service-config-override-test.json");
        Assert.assertNotNull((String)"Should still be supported", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("text/csv", 1000L, "text/html", Collections.emptyMap(), null)));
        Assert.assertNotNull((String)"Increased max size be supported", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("text/csv", 2000L, "text/html", Collections.emptyMap(), null)));
        Assert.assertNull((String)"Increased max size is now 2000", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("text/csv", 3000L, "text/html", Collections.emptyMap(), null)));
        Assert.assertNotNull((String)"Should have been added", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("text/csv", -1L, "application/pdf", Collections.emptyMap(), null)));
        Assert.assertNull((String)"Should have been removed", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("text/csv", -1L, "text/tab-separated-values", Collections.emptyMap(), null)));
        Assert.assertNotNull((String)"options1 should still exist, even if not used", this.mapOfTransformOptions.get("options1"));
        Assert.assertNotNull((String)"options2 should exist", this.mapOfTransformOptions.get("options2"));
        Map<String, String> actualOptions = Map.of("width", "100", "height", "50");
        Assert.assertNull((String)"width from options1 is no longer used, so should find no transformer", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("text/csv", -1L, "application/pdf", actualOptions, null)));
        actualOptions = Map.of("page", "100", "height", "50");
        Assert.assertNotNull((String)"Both options are in options2, so should we should find the transformer", (Object)((AbstractLocalTransform)this.registry.getLocalTransform("text/csv", -1L, "application/pdf", actualOptions, null)));
        LocalTransformImpl localTransform = (LocalTransformImpl)this.registry.getLocalTransform("text/csv", -1L, "application/pdf", Collections.emptyMap(), null);
        Assert.assertEquals((String)"Should only have 2 options", (long)2L, (long)localTransform.getTransformsTransformOptionNames().size());
        Assert.assertTrue((String)"The baseUrl should have been copied", (boolean)localTransform.remoteTransformerClientConfigured());
    }

    @Test
    public void testOverrideTEngineWithPipeline() {
        this.retrieveLocalTransformList("alfresco/local-transform-service-config-override-with-pipeline-test.json");
        LocalPipelineTransform pipelineTransform = (LocalPipelineTransform)this.registry.getLocalTransform("text/csv", -1L, PNG, Collections.emptyMap(), null);
        Assert.assertNotNull((String)"Should supported csv to png", (Object)pipelineTransform);
    }

    private class TestLocalTransformServiceRegistry
    extends LocalTransformServiceRegistry {
        private boolean mockSuccessReadingConfig = true;
        LocalTransformServiceRegistry.LocalData dummyData = new LocalTransformServiceRegistry.LocalData((LocalTransformServiceRegistry)this);
        private List<String> errorsLogged = new ArrayList<String>();
        private boolean resetBaseUrl = true;
        private int tEngineCount = 0;

        private TestLocalTransformServiceRegistry() {
        }

        public synchronized boolean getMockSuccessReadingConfig() {
            return this.mockSuccessReadingConfig;
        }

        public synchronized void setMockSuccessReadingConfig(boolean mockSuccessReadingConfig) {
            System.out.println("\n" + LocalTransformServiceRegistryConfigTest.this.getMs() + ": set next mock read to " + (mockSuccessReadingConfig ? "success" : "failure"));
            this.mockSuccessReadingConfig = mockSuccessReadingConfig;
        }

        public void setResetBaseUrl(boolean resetBaseUrl) {
            this.resetBaseUrl = resetBaseUrl;
        }

        public String getBaseUrlIfTesting(String name, String baseUrl) {
            boolean isTEngine = "t-engine".equals(name);
            this.tEngineCount += isTEngine ? 1 : 0;
            return baseUrl == null && this.resetBaseUrl && !isTEngine ? this.getProperty(LocalTransformServiceRegistryConfigTest.LOCAL_TRANSFORM + name + LocalTransformServiceRegistryConfigTest.URL, null) : (isTEngine && this.tEngineCount == 1 ? LocalTransformServiceRegistryConfigTest.HARD_CODED_VALUE : baseUrl);
        }

        public boolean readConfig() throws IOException {
            LocalTransformServiceRegistryConfigTest localTransformServiceRegistryConfigTest = LocalTransformServiceRegistryConfigTest.this;
            localTransformServiceRegistryConfigTest.readConfigCount = localTransformServiceRegistryConfigTest.readConfigCount + 1;
            this.dummyData = new LocalTransformServiceRegistry.LocalData((LocalTransformServiceRegistry)this);
            boolean mockSuccessReadingRemoteConfig = this.getMockSuccessReadingConfig();
            System.out.println(String.valueOf(LocalTransformServiceRegistryConfigTest.this.getMs()) + "readConfig() success=" + mockSuccessReadingRemoteConfig + " reads=" + LocalTransformServiceRegistryConfigTest.this.readConfigCount);
            return mockSuccessReadingRemoteConfig;
        }

        public LocalTransformServiceRegistry.LocalData getData() {
            return this.dummyData;
        }

        protected void logError(String msg) {
            this.errorsLogged.add(msg);
            super.logError(msg);
        }

        protected void logWarn(String msg) {
            this.logError(msg);
        }

        public TransformServiceRegistryImpl.Data assertDataChanged(TransformServiceRegistryImpl.Data prevData, String msg) {
            System.out.println(String.valueOf(LocalTransformServiceRegistryConfigTest.this.getMs()) + msg);
            LocalTransformServiceRegistry.LocalData data = this.getData();
            Assert.assertNotEquals((String)("The configuration data should have changed: " + msg), (Object)data, (Object)prevData);
            return data;
        }

        public TransformServiceRegistryImpl.Data assertDataUnchanged(TransformServiceRegistryImpl.Data data, String msg) {
            System.out.println(String.valueOf(LocalTransformServiceRegistryConfigTest.this.getMs()) + msg);
            Assert.assertEquals((String)("The configuration data should be the same: " + msg), (Object)this.getData(), (Object)data);
            return this.getData();
        }

        public void assertErrorLogged(String pattern) {
            Pattern p = Pattern.compile(pattern);
            for (String msg : this.errorsLogged) {
                Matcher matcher = p.matcher(msg);
                if (!matcher.matches()) continue;
                return;
            }
            Assert.fail((String)("Did not find error message that matches " + pattern));
        }
    }
}

