/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

public class GenericDeleteAspectForTypePatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.GenericDeleteAspectForTypePatch.result";
    private String qnameStringType;
    private String qnameStringAspect;
    private QNameDAO qnameDAO;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private RetryingTransactionHelper retryingTransactionHelper;
    private static long BATCH_SIZE = 100000L;

    public void setQnameStringType(String qnameStringType) {
        this.qnameStringType = qnameStringType;
    }

    public void setQnameStringAspect(String qnameStringAspect) {
        this.qnameStringAspect = qnameStringAspect;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.qnameDAO, "qnameDAO");
        this.checkPropertyNotNull(this.nodeDAO, "nodeDAO");
        this.checkPropertyNotNull(this.retryingTransactionHelper, "retryingTransactionHelper");
        this.checkPropertyNotNull(this.qnameStringType, "qnameStringType");
        this.checkPropertyNotNull(this.qnameStringAspect, "qnameStringAspect");
    }

    @Override
    protected String applyInternal() throws Exception {
        QName qnameType = QName.createQName((String)this.qnameStringType);
        QName qnameAspect = QName.createQName((String)this.qnameStringAspect);
        Long maxNodeId = this.patchDAO.getMaxAdmNodeID();
        Pair<Long, QName> type = this.qnameDAO.getQName(qnameType);
        Pair<Long, QName> aspect = this.qnameDAO.getQName(qnameAspect);
        if (type != null && aspect != null) {
            Long i = 0L;
            while (i < maxNodeId) {
                Work work = new Work(type, aspect, i);
                this.retryingTransactionHelper.doInTransaction(work, false, true);
                i = i + BATCH_SIZE;
            }
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{qnameAspect, qnameType});
    }

    private class Work
    implements RetryingTransactionHelper.RetryingTransactionCallback<Integer> {
        Pair<Long, QName> type;
        Pair<Long, QName> aspect;
        long lower;

        Work(Pair<Long, QName> type, Pair<Long, QName> aspect, long lower) {
            this.type = type;
            this.aspect = aspect;
            this.lower = lower;
        }

        @Override
        public Integer execute() throws Throwable {
            List<Long> nodeIds = GenericDeleteAspectForTypePatch.this.patchDAO.getNodesByTypeQNameAndAspectQNameId((Long)this.type.getFirst(), (Long)this.aspect.getFirst(), this.lower, this.lower + BATCH_SIZE);
            for (Long nodeId : nodeIds) {
                NodeRef nodeRef = GenericDeleteAspectForTypePatch.this.nodeService.getNodeRef(nodeId);
                GenericDeleteAspectForTypePatch.this.nodeService.removeAspect(nodeRef, (QName)this.aspect.getSecond());
            }
            return nodeIds.size();
        }
    }
}

