/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.repo.content.ContentLimitViolationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LimitedStreamCopier {
    private static final Log logger = LogFactory.getLog(LimitedStreamCopier.class);
    private static final int BYTE_BUFFER_SIZE = 4096;

    public final int copyStreams(InputStream in, OutputStream out, long sizeLimit) throws IOException {
        long bytes = this.copyStreamsLong(in, out, sizeLimit);
        if (bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.valueOf(bytes) + " cannot be cast to int.");
        }
        return (int)bytes;
    }

    public final long copyStreamsLong(InputStream in, OutputStream out, long sizeLimit) throws IOException {
        long byteCount = 0L;
        IOException error = null;
        long totalBytesRead = 0L;
        try {
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                if (sizeLimit > 0L && (totalBytesRead += (long)bytesRead) > sizeLimit) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Content size violation, limit = ").append(sizeLimit);
                    throw new ContentLimitViolationException(msg.toString());
                }
                out.write(buffer, 0, bytesRead);
                byteCount += (long)bytesRead;
            }
            out.flush();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                error = e;
                logger.error((Object)("Failed to close input stream: " + this), (Throwable)e);
            }
            try {
                out.close();
            }
            catch (IOException e) {
                error = e;
                logger.error((Object)("Failed to close output stream: " + this), (Throwable)e);
            }
        }
        if (error != null) {
            throw error;
        }
        return byteCount;
    }
}

