/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.blog.BlogService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LuceneTests.class})
public class BlogServiceImplTest
extends BaseSpringTest {
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static BehaviourFilter BEHAVIOUR_FILTER;
    private static BlogService BLOG_SERVICE;
    private static DictionaryService DICTIONARY_SERVICE;
    private static NodeService NODE_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static SiteService SITE_SERVICE;
    private static TaggingService TAGGING_SERVICE;
    private static final String TEST_USER;
    private static final String ADMIN_USER;
    private List<NodeRef> testNodesToTidy = new ArrayList<NodeRef>();
    private static List<NodeRef> CLASS_TEST_NODES_TO_TIDY;
    private static SiteInfo BLOG_SITE;
    private static NodeRef BLOG_CONTAINER_NODE;

    static {
        TEST_USER = String.valueOf(BlogServiceImplTest.class.getSimpleName()) + GUID.generate();
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
        CLASS_TEST_NODES_TO_TIDY = new ArrayList<NodeRef>();
    }

    @Before
    public void before() throws Exception {
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        BEHAVIOUR_FILTER = (BehaviourFilter)this.applicationContext.getBean("policyBehaviourFilter");
        BLOG_SERVICE = (BlogService)this.applicationContext.getBean("blogService");
        DICTIONARY_SERVICE = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        NODE_SERVICE = (NodeService)this.applicationContext.getBean("nodeService");
        PERSON_SERVICE = (PersonService)this.applicationContext.getBean("personService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        SITE_SERVICE = (SiteService)this.applicationContext.getBean("siteService");
        TAGGING_SERVICE = (TaggingService)this.applicationContext.getBean("TaggingService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        BlogServiceImplTest.createUser(TEST_USER);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        BlogServiceImplTest.createTestSiteWithBlogContainer();
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
    }

    private static void createTestSiteWithBlogContainer() throws Exception {
        BLOG_SITE = (SiteInfo)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite("BlogSitePreset", String.valueOf(BlogServiceImplTest.class.getSimpleName()) + "_testSite" + GUID.generate(), "test site title", "test site description", SiteVisibility.PUBLIC);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        BLOG_CONTAINER_NODE = (NodeRef)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                SiteInfo site = BLOG_SITE;
                NodeRef result = SITE_SERVICE.getContainer(site.getShortName(), "blog");
                if (result == null) {
                    result = SITE_SERVICE.createContainer(site.getShortName(), "blog", ContentModel.TYPE_FOLDER, null);
                    CLASS_TEST_NODES_TO_TIDY.add(result);
                }
                return result;
            }
        });
    }

    @Test
    public void createDraftBlogPostsAndGetPagedResults() throws Exception {
        final List submittedBlogPosts = (List)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> results = new ArrayList<NodeRef>();
                int i = 0;
                while (i < 42) {
                    BlogPostInfo newBlogPost = i % 2 == 0 ? BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "title_" + i, "Hello world", true) : BLOG_SERVICE.createBlogPost(BLOG_SITE.getShortName(), "title_" + i, "Hello world", true);
                    results.add(newBlogPost.getNodeRef());
                    BlogServiceImplTest.this.testNodesToTidy.add(newBlogPost.getNodeRef());
                    ++i;
                }
                return results;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ArrayList recoveredBlogPosts = new ArrayList(42);
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                pagingReq.setRequestTotalCountMax(42);
                PagingResults pagedResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong total result count.", (int)42, (int)((Integer)pagedResults.getTotalResultCount().getFirst()));
                while (pagedResults.hasMoreItems()) {
                    recoveredBlogPosts.addAll(pagedResults.getPage());
                    pagingReq = new PagingRequest(pagingReq.getSkipCount() + 10, 10, null);
                    pagedResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                }
                recoveredBlogPosts.addAll(pagedResults.getPage());
                BlogServiceImplTest.assertEquals((String)"Wrong number of blog posts.", (int)submittedBlogPosts.size(), (int)recoveredBlogPosts.size());
                BlogServiceImplTest.this.assertNodeRefsAreSortedBy(recoveredBlogPosts, ContentModel.PROP_CREATED, false);
                return null;
            }
        });
    }

    private void assertNodeRefsAreSortedBy(List<BlogPostInfo> blogPosts, QName property, boolean ascendingOrder) {
        PropertyDefinition propertyDef = DICTIONARY_SERVICE.getProperty(property);
        BlogServiceImplTest.assertNotNull((String)"Property not recognised.", (Object)propertyDef);
        BlogServiceImplTest.assertEquals((String)"Property was not a Date", (Object)DataTypeDefinition.DATETIME, (Object)propertyDef.getDataType().getName());
        if (blogPosts.size() > 1) {
            int i = 0;
            while (i < blogPosts.size() - 1) {
                Date date2;
                NodeRef nodeRef1 = blogPosts.get(i).getNodeRef();
                NodeRef nodeRef2 = blogPosts.get(i + 1).getNodeRef();
                Date date1 = (Date)NODE_SERVICE.getProperty(nodeRef1, property);
                if (!date1.equals(date2 = (Date)NODE_SERVICE.getProperty(nodeRef2, property))) {
                    if (ascendingOrder) {
                        BlogServiceImplTest.assertTrue((String)("BlogPosts not asc-sorted by " + property + ". Error at index " + i), (boolean)date1.before(date2));
                    } else {
                        BlogServiceImplTest.assertTrue((String)("BlogPosts not desc-sorted by " + property + ". Error at index " + i), (boolean)date1.after(date2));
                    }
                }
                ++i;
            }
        }
    }

    @Category(value={RedundantTests.class})
    @Test
    public void createTaggedDraftBlogPost() throws Exception {
        final List<String> tags = Arrays.asList("alpha", "beta", "gamma", "fran\u00e7ais", "chinese_\u535a\u5ba2");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> results = new ArrayList<NodeRef>();
                for (String tag : tags) {
                    String blogTitle = "draftWithTag" + tag;
                    BlogPostInfo newBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, blogTitle, "Hello world", true);
                    TAGGING_SERVICE.addTags(newBlogPost.getNodeRef(), Arrays.asList(tag));
                    BlogServiceImplTest.this.testNodesToTidy.add(newBlogPost.getNodeRef());
                    results.add(newBlogPost.getNodeRef());
                }
                return results;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashSet expectedTags = new HashSet();
                expectedTags.addAll(tags);
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                PagingResults pagedResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of blog posts", (int)tags.size(), (int)pagedResults.getPage().size());
                for (BlogPostInfo bpi : pagedResults.getPage()) {
                    NodeRef blogNode = bpi.getNodeRef();
                    List recoveredTags = TAGGING_SERVICE.getTags(blogNode);
                    BlogServiceImplTest.assertEquals((String)"Wrong number of tags", (int)1, (int)recoveredTags.size());
                    String tag = (String)recoveredTags.get(0);
                    BlogServiceImplTest.assertTrue((String)("Tag found on node but not expected: " + tag), (boolean)expectedTags.remove(tag));
                }
                BlogServiceImplTest.assertTrue((String)"Not all tags were recovered from a blogpost", (boolean)expectedTags.isEmpty());
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                BlogService.RangedDateProperty dates = new BlogService.RangedDateProperty(null, null, ContentModel.PROP_CREATED);
                for (String tag : tags) {
                    PagingResults pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, dates, tag, pagingReq);
                    BlogServiceImplTest.assertEquals((String)("Wrong number of blog posts for " + tag), (int)1, (int)pagedResults.getPage().size());
                }
                return null;
            }
        });
    }

    @Category(value={RedundantTests.class})
    @Test
    public void findBlogPostsByPublishedDate() throws Exception {
        final List<String> tags = Arrays.asList("hello", "goodbye");
        Calendar cal = Calendar.getInstance();
        cal.set(1971, 6, 15);
        final Date _1971 = cal.getTime();
        cal.set(1975, 0, 1);
        final Date _1975 = cal.getTime();
        cal.set(1980, 0, 1);
        final Date _1980 = cal.getTime();
        cal.set(1981, 0, 1);
        final Date _1981 = cal.getTime();
        cal.set(1985, 6, 15);
        final Date _1985 = cal.getTime();
        cal.set(1991, 6, 15);
        final Date _1991 = cal.getTime();
        final Map blogPosts = (Map)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<Integer, NodeRef>>(){

            public Map<Integer, NodeRef> execute() throws Throwable {
                HashMap<Integer, NodeRef> result = new HashMap<Integer, NodeRef>();
                BlogPostInfo blogPost1971 = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPostWithTags1971", "Hello world", true);
                BlogPostInfo blogPost1981 = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPostWithTags1981", "Hello world", true);
                BlogPostInfo blogPost1991 = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPostWithTags1991", "Hello world", true);
                TAGGING_SERVICE.addTags(blogPost1971.getNodeRef(), tags);
                TAGGING_SERVICE.addTags(blogPost1981.getNodeRef(), tags);
                TAGGING_SERVICE.addTags(blogPost1991.getNodeRef(), tags);
                BlogServiceImplTest.this.testNodesToTidy.add(blogPost1971.getNodeRef());
                BlogServiceImplTest.this.testNodesToTidy.add(blogPost1981.getNodeRef());
                BlogServiceImplTest.this.testNodesToTidy.add(blogPost1991.getNodeRef());
                NODE_SERVICE.setProperty(blogPost1971.getNodeRef(), ContentModel.PROP_PUBLISHED, (Serializable)_1971);
                NODE_SERVICE.setProperty(blogPost1981.getNodeRef(), ContentModel.PROP_PUBLISHED, (Serializable)_1981);
                NODE_SERVICE.setProperty(blogPost1991.getNodeRef(), ContentModel.PROP_PUBLISHED, (Serializable)_1991);
                result.put(1971, blogPost1971.getNodeRef());
                result.put(1981, blogPost1981.getNodeRef());
                result.put(1991, blogPost1991.getNodeRef());
                return result;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                BlogServiceImplTest.assertEquals((String)"Incorrect published date", (int)71, (int)((Date)NODE_SERVICE.getProperty((NodeRef)blogPosts.get(1971), ContentModel.PROP_PUBLISHED)).getYear());
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                BlogService.RangedDateProperty publishedBefore1980 = new BlogService.RangedDateProperty(null, _1980, ContentModel.PROP_PUBLISHED);
                BlogService.RangedDateProperty publishedAfter1980 = new BlogService.RangedDateProperty(_1980, null, ContentModel.PROP_PUBLISHED);
                BlogService.RangedDateProperty publishedBetween1975And1985 = new BlogService.RangedDateProperty(_1975, _1985, ContentModel.PROP_PUBLISHED);
                PagingResults pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, null, null, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of blog posts", (int)3, (int)pagedResults.getPage().size());
                HashSet<NodeRef> recoveredBlogNodes = new HashSet<NodeRef>();
                for (BlogPostInfo bpi : pagedResults.getPage()) {
                    recoveredBlogNodes.add(bpi.getNodeRef());
                }
                BlogServiceImplTest.assertTrue((String)"Missing expected BlogPost NodeRef 71", (boolean)recoveredBlogNodes.contains(blogPosts.get(1971)));
                BlogServiceImplTest.assertTrue((String)"Missing expected BlogPost NodeRef 81", (boolean)recoveredBlogNodes.contains(blogPosts.get(1981)));
                BlogServiceImplTest.assertTrue((String)"Missing expected BlogPost NodeRef 91", (boolean)recoveredBlogNodes.contains(blogPosts.get(1991)));
                pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, publishedBefore1980, null, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong blog post count", (int)1, (int)pagedResults.getPage().size());
                NodeRef blogNode = ((BlogPostInfo)pagedResults.getPage().get(0)).getNodeRef();
                BlogServiceImplTest.assertEquals((String)"Incorrect NodeRef.", (Object)blogNode, blogPosts.get(1971));
                List recoveredTags = TAGGING_SERVICE.getTags(blogNode);
                BlogServiceImplTest.assertEquals((String)"Incorrect tags.", (Object)tags, (Object)recoveredTags);
                pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, publishedAfter1980, "hello", pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong blog post count", (int)2, (int)pagedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedResults.getPage().get(0)).getNodeRef();
                BlogServiceImplTest.assertEquals((String)"Incorrect NodeRef.", (Object)blogNode, blogPosts.get(1981));
                pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, publishedBetween1975And1985, "hello", pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong blog post count", (int)1, (int)pagedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedResults.getPage().get(0)).getNodeRef();
                BlogServiceImplTest.assertEquals((String)"Incorrect NodeRef.", (Object)blogNode, blogPosts.get(1981));
                return null;
            }
        });
    }

    @Test
    public void ensureBlogPostsAreCorrectlySorted() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                int i = 0;
                while (i < 3) {
                    BlogPostInfo newDraft = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "draftPost_ensureBlogPostsAreCorrectlySorted" + i, "x", true);
                    Thread.sleep(50L);
                    BlogPostInfo newPublished = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "publishedPost_ensureBlogPostsAreCorrectlySorted" + i, "x", false);
                    Thread.sleep(50L);
                    BlogServiceImplTest.this.testNodesToTidy.add(newDraft.getNodeRef());
                    BlogServiceImplTest.this.testNodesToTidy.add(newPublished.getNodeRef());
                    ++i;
                }
                return null;
            }
        });
        final PagingRequest pagingReq = new PagingRequest(100);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                PagingResults resultsPage = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, currentUser, pagingReq);
                List blogPosts = resultsPage.getPage();
                BlogServiceImplTest.assertTrue((String)("Expected more draft blog posts than " + blogPosts.size()), (blogPosts.size() >= 3 ? 1 : 0) != 0);
                BlogServiceImplTest.this.assertSortingIsCorrect(blogPosts);
                resultsPage = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, null, null, currentUser, pagingReq);
                blogPosts = resultsPage.getPage();
                BlogServiceImplTest.assertTrue((String)("Expected more published blog posts than " + blogPosts.size()), (blogPosts.size() >= 3 ? 1 : 0) != 0);
                BlogServiceImplTest.this.assertSortingIsCorrect(blogPosts);
                System.out.println("  getMyDraftsAndAllPublished");
                resultsPage = BLOG_SERVICE.getMyDraftsAndAllPublished(BLOG_CONTAINER_NODE, null, null, pagingReq);
                blogPosts = resultsPage.getPage();
                BlogServiceImplTest.this.assertSortingIsCorrect(blogPosts);
                return null;
            }
        });
    }

    private void assertSortingIsCorrect(List<BlogPostInfo> blogPosts) {
        for (BlogPostInfo bpi : blogPosts) {
            System.out.println("  -----");
            Date published = (Date)NODE_SERVICE.getProperty(bpi.getNodeRef(), ContentModel.PROP_PUBLISHED);
            Date created = (Date)NODE_SERVICE.getProperty(bpi.getNodeRef(), ContentModel.PROP_CREATED);
            System.out.print("    published: " + (published == null ? "             " : Long.valueOf(published.getTime())));
            System.out.println("    created  : " + created.getTime());
        }
        int i = 0;
        while (i < blogPosts.size() - 1) {
            BlogPostInfo nextBPI = blogPosts.get(i);
            BlogPostInfo followingBPI = blogPosts.get(i + 1);
            Date nextPublishedDate = (Date)NODE_SERVICE.getProperty(nextBPI.getNodeRef(), ContentModel.PROP_PUBLISHED);
            Date followingPublishedDate = (Date)NODE_SERVICE.getProperty(followingBPI.getNodeRef(), ContentModel.PROP_PUBLISHED);
            Date nextCreatedDate = (Date)NODE_SERVICE.getProperty(nextBPI.getNodeRef(), ContentModel.PROP_CREATED);
            Date followingCreatedDate = (Date)NODE_SERVICE.getProperty(followingBPI.getNodeRef(), ContentModel.PROP_CREATED);
            if (nextPublishedDate == null && followingPublishedDate != null) {
                BlogServiceImplTest.fail((String)"Published posts must precede draft posts");
            } else if (nextPublishedDate != null && followingPublishedDate != null) {
                BlogServiceImplTest.assertTrue((String)"Error in BlogPostInfo sorting. Published dates in wrong order.", (!nextPublishedDate.before(followingPublishedDate) ? 1 : 0) != 0);
            } else if (nextPublishedDate == null && followingPublishedDate == null) {
                BlogServiceImplTest.assertTrue((String)"Error in BlogPostInfo sorting. Created dates in wrong order.", (!nextCreatedDate.before(followingCreatedDate) ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    @Test
    public void multipleUsersCreateDraftsAndPublishedPostsAndBrowse() throws Exception {
        final Pair adminPosts = (Pair)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

            public Pair<NodeRef, NodeRef> execute() throws Throwable {
                BlogPostInfo newDraftBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "adminDraft", "", true);
                BlogServiceImplTest.this.testNodesToTidy.add(newDraftBlogPost.getNodeRef());
                BlogPostInfo newPublishedBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "adminPublished", "", false);
                BlogServiceImplTest.this.testNodesToTidy.add(newPublishedBlogPost.getNodeRef());
                return new Pair((Object)newDraftBlogPost.getNodeRef(), (Object)newPublishedBlogPost.getNodeRef());
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        final Pair userPosts = (Pair)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

            public Pair<NodeRef, NodeRef> execute() throws Throwable {
                BlogPostInfo newDraftBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "userDraft", "", true);
                BlogServiceImplTest.this.testNodesToTidy.add(newDraftBlogPost.getNodeRef());
                BlogPostInfo newPublishedBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "userPublished", "", false);
                BlogServiceImplTest.this.testNodesToTidy.add(newPublishedBlogPost.getNodeRef());
                return new Pair((Object)newDraftBlogPost.getNodeRef(), (Object)newPublishedBlogPost.getNodeRef());
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                PagingResults pagedDraftResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, ADMIN_USER, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of admin draft blog posts", (int)1, (int)pagedDraftResults.getPage().size());
                NodeRef blogNode = ((BlogPostInfo)pagedDraftResults.getPage().get(0)).getNodeRef();
                BlogServiceImplTest.assertEquals((String)"Incorrect admin draft NodeRef.", (Object)blogNode, (Object)adminPosts.getFirst());
                PagingResults pagedPublishedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, null, null, ADMIN_USER, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of admin published blog posts", (int)1, (int)pagedPublishedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedPublishedResults.getPage().get(0)).getNodeRef();
                BlogServiceImplTest.assertEquals((String)"Incorrect admin published NodeRef.", (Object)blogNode, (Object)adminPosts.getSecond());
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 10, null);
                PagingResults pagedDraftResults = BLOG_SERVICE.getDrafts(BLOG_CONTAINER_NODE, TEST_USER, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of user draft blog posts", (int)1, (int)pagedDraftResults.getPage().size());
                NodeRef blogNode = ((BlogPostInfo)pagedDraftResults.getPage().get(0)).getNodeRef();
                BlogServiceImplTest.assertEquals((String)"Incorrect user draft NodeRef.", (Object)blogNode, (Object)userPosts.getFirst());
                PagingResults pagedPublishedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, null, null, TEST_USER, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of user published blog posts", (int)1, (int)pagedPublishedResults.getPage().size());
                blogNode = ((BlogPostInfo)pagedPublishedResults.getPage().get(0)).getNodeRef();
                BlogServiceImplTest.assertEquals((String)"Incorrect user published NodeRef.", (Object)blogNode, (Object)userPosts.getSecond());
                return null;
            }
        });
    }

    @Test
    public void getBlogPostsFilteredByDateRange() throws Exception {
        final List posts = (List)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> results = new ArrayList<NodeRef>();
                int i = 0;
                while (i < 91) {
                    BlogPostInfo newBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, "date-specific-post" + i, "", false);
                    BlogServiceImplTest.this.testNodesToTidy.add(newBlogPost.getNodeRef());
                    results.add(newBlogPost.getNodeRef());
                    ++i;
                }
                return results;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Calendar current = Calendar.getInstance();
                current.set(1999, 11, 1, 11, 0);
                Date currentDate = current.getTime();
                for (NodeRef nr : posts) {
                    BEHAVIOUR_FILTER.disableBehaviour(nr, ContentModel.ASPECT_AUDITABLE);
                    NODE_SERVICE.setProperty(nr, ContentModel.PROP_PUBLISHED, (Serializable)currentDate);
                    current.add(5, 1);
                    currentDate = current.getTime();
                }
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 100, null);
                Calendar cal = Calendar.getInstance();
                cal.set(1999, 11, 1, 0, 0, 0);
                Date firstDec99 = cal.getTime();
                cal.set(2000, 0, 1, 0, 0, 0);
                Date firstJan00 = cal.getTime();
                cal.set(2000, 1, 1, 0, 0, 0);
                Date firstFeb00 = cal.getTime();
                cal.set(2000, 2, 1, 0, 0, 0);
                Date firstMar00 = cal.getTime();
                PagingResults pagedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, firstDec99, firstJan00, null, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of user blog posts", (int)31, (int)pagedResults.getPage().size());
                pagedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, firstFeb00, firstMar00, null, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of user blog posts", (int)29, (int)pagedResults.getPage().size());
                pagedResults = BLOG_SERVICE.getPublished(BLOG_CONTAINER_NODE, firstJan00, firstMar00, null, pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of user blog posts", (int)60, (int)pagedResults.getPage().size());
                return null;
            }
        });
    }

    @Test
    @Category(value={RedundantTests.class})
    public void testGetBlogPostsByTagPaging() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> results = new ArrayList<NodeRef>();
                do {
                    String blogTitle = "blogTitle" + GUID.generate();
                    BlogPostInfo newBlogPost = BLOG_SERVICE.createBlogPost(BLOG_CONTAINER_NODE, blogTitle, "Hello world", false);
                    TAGGING_SERVICE.addTags(newBlogPost.getNodeRef(), Arrays.asList("testtag"));
                    BlogServiceImplTest.this.testNodesToTidy.add(newBlogPost.getNodeRef());
                    results.add(newBlogPost.getNodeRef());
                } while (results.size() < 2);
                return results;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PagingRequest pagingReq = new PagingRequest(0, 1, null);
                BlogService.RangedDateProperty dates = new BlogService.RangedDateProperty(null, null, ContentModel.PROP_CREATED);
                PagingResults pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, dates, "testtag", pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of blog posts on page 1 for testtag", (int)1, (int)pagedResults.getPage().size());
                BlogServiceImplTest.assertEquals((String)"Wrong total number of blog posts for testtag", (Object)new Pair((Object)2, (Object)2), (Object)pagedResults.getTotalResultCount());
                BlogServiceImplTest.assertEquals((String)"There should still be blog posts available to be retrieved for testtag", (boolean)true, (boolean)pagedResults.hasMoreItems());
                pagingReq = new PagingRequest(1, 1, null);
                pagedResults = BLOG_SERVICE.findBlogPosts(BLOG_CONTAINER_NODE, dates, "testtag", pagingReq);
                BlogServiceImplTest.assertEquals((String)"Wrong number of blog posts on page 2 for testtag", (int)1, (int)pagedResults.getPage().size());
                BlogServiceImplTest.assertEquals((String)"Wrong total number of blog posts for testtag", (Object)new Pair((Object)2, (Object)2), (Object)pagedResults.getTotalResultCount());
                BlogServiceImplTest.assertEquals((String)"All blog posts should have been retrieved by now for testtag", (boolean)false, (boolean)pagedResults.hasMoreItems());
                return null;
            }
        });
    }

    private static void createUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (!AUTHENTICATION_SERVICE.authenticationExists(userName)) {
                    AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!PERSON_SERVICE.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
                    ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                    ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                    ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
                    ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                    PERSON_SERVICE.createPerson((Map)ppOne);
                }
                return null;
            }
        });
    }
}

