/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.alfresco.repo.content.AbstractReadOnlyContentStoreTest;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentExistsException;
import org.alfresco.repo.content.ContentLimitProvider;
import org.alfresco.repo.content.ContentLimitViolationException;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.filestore.SpoofedTextContentReader;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.TempFileProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class})
public class FileContentStoreTest
extends AbstractWritableContentStoreTest {
    protected FileContentStore store;

    @Override
    @Before
    public void before() throws Exception {
        File tempDir = TempFileProvider.getTempDir();
        this.store = new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, String.valueOf(tempDir.getAbsolutePath()) + File.separatorChar + this.getName());
        this.store.setDeleteEmptyDirs(true);
    }

    @Override
    @After
    public void after() {
    }

    @Override
    protected ContentStore getStore() {
        return this.store;
    }

    @Test
    public void testConcurrentWriteDetection() throws Exception {
        ByteBuffer.wrap("Something".getBytes());
        ContentStore store = this.getStore();
        ContentContext firstContentCtx = ContentStore.NEW_CONTENT_CONTEXT;
        ContentWriter firstWriter = store.getWriter(firstContentCtx);
        String contentUrl = firstWriter.getContentUrl();
        ContentContext secondContentCtx = new ContentContext(null, contentUrl);
        try {
            store.getWriter(secondContentCtx);
            Assert.fail((String)("Store must disallow more than one writer onto the same content URL: " + store));
        }
        catch (ContentExistsException contentExistsException) {}
    }

    @Override
    @Test
    public void testRootLocation() throws Exception {
        ContentStore store = this.getStore();
        String root = store.getRootLocation();
        Assert.assertNotNull((String)"Root value can't be null", (Object)root);
        File dir = new File(root);
        Assert.assertTrue((String)"Root location for FileContentStore must exist", (boolean)dir.exists());
    }

    @Override
    @Test
    public void testSpaceFree() throws Exception {
        ContentStore store = this.getStore();
        long size = store.getSpaceFree();
        Assert.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Size must not be Long.MAX_VALUE", (size < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testSpaceTotal() throws Exception {
        ContentStore store = this.getStore();
        long size = store.getSpaceTotal();
        Assert.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Size must not be Long.MAX_VALUE", (size < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteRemovesEmptyDirs() throws Exception {
        String url;
        ContentStore store = this.getStore();
        if (store.exists(url = "store://1965/12/1/13/12/file.bin")) {
            store.delete(url);
        }
        String content = "Content for test: " + this.getName();
        store.getWriter(new ContentContext(null, url)).putContent(content);
        File root = new File(store.getRootLocation());
        this.assertDirExists(root, "");
        this.assertDirExists(root, "1965/12/1/13/12");
        store.delete(url);
        this.assertDirNotExists(root, "1965");
        this.assertDirExists(root, "");
    }

    @Test
    public void testDeleteLeavesNonEmptyDirs() {
        String url;
        ContentStore store = this.getStore();
        if (store.exists(url = "store://1965/12/1/13/12/file.bin")) {
            store.delete(url);
        }
        String content = "Content for test: " + this.getName();
        store.getWriter(new ContentContext(null, url)).putContent(content);
        File root = new File(store.getRootLocation());
        this.assertDirExists(root, "");
        this.assertDirExists(root, "1965/12/1/13/12");
        String anotherUrl = "store://1965/12/3/another.bin";
        if (store.exists(anotherUrl)) {
            store.delete(anotherUrl);
        }
        store.getWriter(new ContentContext(null, anotherUrl));
        store.delete(url);
        this.assertDirExists(root, "1965");
        this.assertDirExists(root, "1965/12");
        this.assertDirNotExists(root, "1965/12/1");
        this.assertDirExists(root, "");
    }

    @Test
    public void testNoParentDirsDeleted() throws Exception {
        this.store.setDeleteEmptyDirs(false);
        FileContentStore store = (FileContentStore)this.getStore();
        String url = "store://1965/12/1/13/12/file.bin";
        if (store.exists(url)) {
            store.delete(url);
        }
        String content = "Content for test: " + this.getName();
        store.getWriter(new ContentContext(null, url)).putContent(content);
        File root = new File(store.getRootLocation());
        store.delete(url);
        this.assertDirExists(root, "1965/12/1/13/12");
        this.assertDirExists(root, "");
    }

    @Test
    public void testWriteFileWithSizeLimit() throws Exception {
        ContentWriter writer = this.getWriter();
        Assert.assertEquals((String)"Writer was of wrong type", FileContentWriter.class, writer.getClass());
        FileContentWriter fileContentWriter = (FileContentWriter)writer;
        ContentLimitProvider.SimpleFixedLimitProvider limitProvider = new ContentLimitProvider.SimpleFixedLimitProvider(3L);
        fileContentWriter.setContentLimitProvider((ContentLimitProvider)limitProvider);
        boolean expectedExceptionThrown = false;
        try {
            writer.putContent("This will exceed the short limit.");
        }
        catch (ContentLimitViolationException contentLimitViolationException) {
            expectedExceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown.", (boolean)expectedExceptionThrown);
        Assert.assertTrue((String)"Stream close not detected", (boolean)writer.isClosed());
    }

    @Test
    public void testFileAccessOutsideStoreRoot() {
        String url = "store://../somefile.bin";
        try {
            this.store.getReader(url);
            Assert.fail((String)"Access to content outside of content store root should not be allowed.");
        }
        catch (ContentIOException contentIOException) {}
        try {
            this.store.exists(url);
            Assert.fail((String)"Access to content outside of content store root should not be allowed.");
        }
        catch (ContentIOException contentIOException) {}
        try {
            this.store.delete(url);
            Assert.fail((String)"Access to content outside of content store root should not be allowed.");
        }
        catch (ContentIOException contentIOException) {}
        try {
            this.store.getWriterInternal(null, url);
            Assert.fail((String)"Access to content outside of content store root should not be allowed.");
        }
        catch (ContentIOException contentIOException) {}
    }

    @Test
    public void testSpoofedContent() throws Exception {
        String url = SpoofedTextContentReader.createContentUrl((Locale)Locale.ENGLISH, (long)0L, (long)1024L, (String[])new String[0]);
        ContentContext ctx = new ContentContext(null, url);
        try {
            this.store.getWriter(ctx);
            Assert.fail((String)"FileContentStore should report that all 'spoof' content exists.");
        }
        catch (ContentExistsException contentExistsException) {}
        Assert.assertFalse((String)"Deletion should be 'false'.", (boolean)this.store.delete(url));
        Assert.assertTrue((String)"All spoofed content already exists!", (boolean)this.store.exists(url));
        ContentReader reader = this.store.getReader(url);
        Assert.assertTrue((boolean)(reader instanceof SpoofedTextContentReader));
        Assert.assertEquals((long)1024L, (long)reader.getContentString().getBytes("UTF-8").length);
    }

    private void assertDirExists(File root, String dir) {
        Assert.assertTrue((String)("Directory [" + dir + "] should exist"), (boolean)new File(root, dir).exists());
    }

    private void assertDirNotExists(File root, String dir) {
        Assert.assertFalse((String)("Directory [" + dir + "] should NOT exist"), (boolean)new File(root, dir).exists());
    }
}

