/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CloseFileCommand;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.RestoreFileCommand;
import org.alfresco.filesys.repo.rules.operations.CloseFileOperation;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.MoveFileOperation;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ScenarioDeleteRenameOrCreateInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioDeleteRenameOrCreateInstance.class);
    private Date startTime = new Date();
    private long timeout = 30000L;
    private boolean isComplete = false;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;
    private NodeRef originalNodeRef = null;
    InternalState state = InternalState.NONE;
    String name;

    ScenarioDeleteRenameOrCreateInstance() {
    }

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Instance timed out");
            }
            this.isComplete = true;
            return null;
        }
        switch (this.state) {
            case NONE: {
                if (operation instanceof CloseFileOperation) {
                    CloseFileOperation c = (CloseFileOperation)operation;
                    this.name = c.getName();
                    logger.debug((Object)("New scenario initialised for file " + this.name));
                    this.state = InternalState.INITIALISED;
                    ArrayList<Command> commands = new ArrayList<Command>();
                    ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                    ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                    commands.add(new CloseFileCommand(c.getName(), c.getNetworkFile(), c.getRootNodeRef(), c.getPath()));
                    postCommitCommands.add(this.newDeleteFileCallbackCommand());
                    return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                }
                if (!(operation instanceof DeleteFileOperation)) break;
                DeleteFileOperation c = (DeleteFileOperation)operation;
                this.name = c.getName();
                logger.debug((Object)("New scenario initialised for file " + this.name));
                this.state = InternalState.INITIALISED;
                ArrayList<Command> commands = new ArrayList<Command>();
                ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                commands.add(new DeleteFileCommand(c.getName(), c.getRootNodeRef(), c.getPath()));
                postCommitCommands.add(this.newDeleteFileCallbackCommand());
                return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
            }
            case INITIALISED: {
                Operation r;
                CreateFileOperation c;
                if (operation instanceof CreateFileOperation && (c = (CreateFileOperation)operation).getName().equalsIgnoreCase(this.name)) {
                    this.isComplete = true;
                    if (this.originalNodeRef != null) {
                        logger.debug((Object)("Delete create shuffle fire!:" + this));
                        return new RestoreFileCommand(c.getName(), c.getRootNodeRef(), c.getPath(), c.getAllocationSize(), this.originalNodeRef);
                    }
                    return null;
                }
                if (operation instanceof RenameFileOperation && this.name.equals(((RenameFileOperation)(r = (RenameFileOperation)operation)).getTo())) {
                    logger.debug((Object)"Delete Rename shuffle - fire!");
                    if (this.originalNodeRef != null) {
                        ArrayList<Command> commands = new ArrayList<Command>();
                        RestoreFileCommand r1 = new RestoreFileCommand(((RenameFileOperation)r).getTo(), ((RenameFileOperation)r).getRootNodeRef(), ((RenameFileOperation)r).getToPath(), 0L, this.originalNodeRef);
                        CopyContentCommand copyContent = new CopyContentCommand(((RenameFileOperation)r).getFrom(), ((RenameFileOperation)r).getTo(), ((RenameFileOperation)r).getRootNodeRef(), ((RenameFileOperation)r).getFromPath(), ((RenameFileOperation)r).getToPath());
                        DeleteFileCommand d1 = new DeleteFileCommand(((RenameFileOperation)r).getFrom(), ((RenameFileOperation)r).getRootNodeRef(), ((RenameFileOperation)r).getFromPath());
                        commands.add(r1);
                        commands.add(copyContent);
                        commands.add(d1);
                        logger.debug((Object)"Scenario complete");
                        this.isComplete = true;
                        return new CompoundCommand(commands);
                    }
                    logger.debug((Object)"Scenario complete");
                    this.isComplete = true;
                    return null;
                }
                if (!(operation instanceof MoveFileOperation) || !this.name.equals(((MoveFileOperation)(r = (MoveFileOperation)operation)).getTo())) break;
                logger.debug((Object)"Delete Rename shuffle - fire!");
                if (this.originalNodeRef != null) {
                    ArrayList<Command> commands = new ArrayList<Command>();
                    RestoreFileCommand r1 = new RestoreFileCommand(((MoveFileOperation)r).getTo(), ((MoveFileOperation)r).getRootNodeRef(), ((MoveFileOperation)r).getToPath(), 0L, this.originalNodeRef);
                    CopyContentCommand copyContent = new CopyContentCommand(((MoveFileOperation)r).getFrom(), ((MoveFileOperation)r).getTo(), ((MoveFileOperation)r).getRootNodeRef(), ((MoveFileOperation)r).getFromPath(), ((MoveFileOperation)r).getToPath());
                    DeleteFileCommand d1 = new DeleteFileCommand(((MoveFileOperation)r).getFrom(), ((MoveFileOperation)r).getRootNodeRef(), ((MoveFileOperation)r).getFromPath());
                    commands.add(r1);
                    commands.add(copyContent);
                    commands.add(d1);
                    logger.debug((Object)"Scenario complete");
                    this.isComplete = true;
                    return new CompoundCommand(commands);
                }
                logger.debug((Object)"Scenario complete");
                this.isComplete = true;
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    public String toString() {
        return "ScenarioDeleteRenameOrCreate name:" + this.name;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    private ResultCallback newDeleteFileCallbackCommand() {
        return new ResultCallback(){

            @Override
            public void execute(Object result) {
                if (result instanceof NodeRef) {
                    logger.debug((Object)"got node ref of deleted node");
                    ScenarioDeleteRenameOrCreateInstance.this.originalNodeRef = (NodeRef)result;
                }
            }

            @Override
            public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
                return AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
            }
        };
    }

    static enum InternalState {
        NONE,
        INITIALISED;

    }
}

