/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.bulkimport.ImportableItem;

public class AnalysedDirectory {
    private List<Path> originalPaths = null;
    private Map<Path, ImportableItem> importableItems = null;
    private Map<Path, ImportableItem> importableDirectories = null;

    public AnalysedDirectory(List<Path> paths) {
        this.originalPaths = paths;
        Collections.sort(this.originalPaths);
        this.importableItems = new HashMap<Path, ImportableItem>();
        this.importableDirectories = new HashMap<Path, ImportableItem>();
    }

    public List<Path> getOriginalPaths() {
        return this.originalPaths;
    }

    public Collection<ImportableItem> getImportableItems() {
        return this.importableItems.values();
    }

    public Collection<ImportableItem> getImportableDirectories() {
        return this.importableDirectories.values();
    }

    public void addImportableItem(ImportableItem importableItem) {
        if (importableItem.getHeadRevision().contentFileExists() && ImportableItem.FileType.DIRECTORY.equals((Object)importableItem.getHeadRevision().getContentFileType())) {
            this.importableDirectories.put(importableItem.getHeadRevision().getContentFile(), importableItem);
        } else {
            this.importableItems.put(importableItem.getHeadRevision().getContentFile(), importableItem);
        }
    }

    public ImportableItem findImportableItem(Path contentFile) {
        ImportableItem result = null;
        result = this.importableItems.get(contentFile);
        if (result == null) {
            result = this.importableDirectories.get(contentFile);
        }
        return result;
    }
}

