/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.filter;

import org.alfresco.repo.event2.filter.ChildAssociationTypeFilter;
import org.alfresco.repo.event2.filter.EventFilter;
import org.alfresco.repo.event2.filter.EventUserFilter;
import org.alfresco.repo.event2.filter.NodeAspectFilter;
import org.alfresco.repo.event2.filter.NodePropertyFilter;
import org.alfresco.repo.event2.filter.NodeTypeFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.lang.NonNull;

public class EventFilterRegistry
implements BeanFactoryAware {
    private static final Log LOGGER = LogFactory.getLog(EventFilterRegistry.class);
    private BeanFactory beanFactory;

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public <F extends EventFilter<?>> F getFilter(String beanName, Class<F> filterClass) {
        try {
            return (F)((EventFilter)this.beanFactory.getBean(beanName, filterClass));
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
            throw ex;
        }
    }

    public NodeTypeFilter getNodeTypeFilter() {
        return this.getFilter("event2NodeTypeFilter", NodeTypeFilter.class);
    }

    public NodeAspectFilter getNodeAspectFilter() {
        return this.getFilter("event2NodeAspectFilter", NodeAspectFilter.class);
    }

    public NodePropertyFilter getNodePropertyFilter() {
        return this.getFilter("event2NodePropertyFilter", NodePropertyFilter.class);
    }

    public ChildAssociationTypeFilter getChildAssociationTypeFilter() {
        return this.getFilter("event2ChildAssociationTypeFilter", ChildAssociationTypeFilter.class);
    }

    public EventUserFilter getEventUserFilter() {
        return this.getFilter("event2UserFilter", EventUserFilter.class);
    }
}

