/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import jakarta.mail.Flags;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.AttachmentsExtractor;
import org.alfresco.repo.imap.ContentModelMessage;
import org.alfresco.repo.imap.ImapModelMessage;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.config.ImapConfigMountPointsBean;
import org.alfresco.repo.imap.exception.AlfrescoImapRuntimeException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteDoesNotExistException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.MaxSizeMap;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class ImapServiceImpl
implements ImapService,
NodeServicePolicies.OnRestoreNodePolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private Log logger = LogFactory.getLog(ImapServiceImpl.class);
    private static final String ERROR_FOLDER_ALREADY_EXISTS = "imap.server.error.folder_already_exist";
    private static final String ERROR_MAILBOX_NAME_IS_MANDATORY = "imap.server.error.mailbox_name_is_mandatory";
    private static final String ERROR_CANNOT_GET_A_FOLDER = "imap.server.error.cannot_get_a_folder";
    private static final String ERROR_CANNOT_PARSE_DEFAULT_EMAIL = "imap.server.error.cannot_parse_default_email";
    private static final String CHECKED_NODES = "imap.flaggable.aspect.checked.list";
    private static final String FAVORITE_SITES = "imap.favorite.sites.list";
    private static final String UIDVALIDITY_TRANSACTION_LISTENER = "imap.uidvalidity.txn.listener";
    private SysAdminParams sysAdminParams;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private ServiceRegistry serviceRegistry;
    private BehaviourFilter policyBehaviourFilter;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private AttachmentsExtractor attachmentsExtractor;
    private Map<Pair<String, String>, ImapService.FolderStatus> folderCache;
    private int folderCacheSize = 1000;
    private ReentrantReadWriteLock folderCacheLock = new ReentrantReadWriteLock();
    private SimpleCache<NodeRef, CacheItem> messageCache;
    private Map<String, ImapConfigMountPointsBean> imapConfigMountPoints;
    private Map<String, Integer> mountPointIds;
    private RepositoryFolderConfigBean[] ignoreExtractionFoldersBeans;
    private RepositoryFolderConfigBean imapHomeConfigBean;
    private NodeRef imapHomeNodeRef;
    private Set<NodeRef> ignoreExtractionFolders;
    private String defaultFromAddress;
    private String defaultToAddress;
    private String repositoryTemplatePath;
    private boolean extractAttachmentsEnabled = true;
    private Map<ImapService.EmailBodyFormat, String> defaultBodyTemplates;
    private static final Map<QName, Flags.Flag> qNameToFlag;
    private static final Map<Flags.Flag, QName> flagToQname;
    private long imapServerShuffleMoveDeleteDelay = 5000L;
    private static final Timer deleteDelayTimer;
    private boolean imapServerEnabled = false;
    private List<String> messageHeadersToPersist = Collections.emptyList();

    static {
        deleteDelayTimer = new Timer();
        qNameToFlag = new HashMap<QName, Flags.Flag>();
        qNameToFlag.put(ImapModel.PROP_FLAG_ANSWERED, Flags.Flag.ANSWERED);
        qNameToFlag.put(ImapModel.PROP_FLAG_DELETED, Flags.Flag.DELETED);
        qNameToFlag.put(ImapModel.PROP_FLAG_DRAFT, Flags.Flag.DRAFT);
        qNameToFlag.put(ImapModel.PROP_FLAG_SEEN, Flags.Flag.SEEN);
        qNameToFlag.put(ImapModel.PROP_FLAG_RECENT, Flags.Flag.RECENT);
        qNameToFlag.put(ImapModel.PROP_FLAG_FLAGGED, Flags.Flag.FLAGGED);
        flagToQname = new HashMap<Flags.Flag, QName>();
        flagToQname.put(Flags.Flag.ANSWERED, ImapModel.PROP_FLAG_ANSWERED);
        flagToQname.put(Flags.Flag.DELETED, ImapModel.PROP_FLAG_DELETED);
        flagToQname.put(Flags.Flag.DRAFT, ImapModel.PROP_FLAG_DRAFT);
        flagToQname.put(Flags.Flag.SEEN, ImapModel.PROP_FLAG_SEEN);
        flagToQname.put(Flags.Flag.RECENT, ImapModel.PROP_FLAG_RECENT);
        flagToQname.put(Flags.Flag.FLAGGED, ImapModel.PROP_FLAG_FLAGGED);
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setMessageCache(SimpleCache<NodeRef, CacheItem> messageCache) {
        this.messageCache = messageCache;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setPolicyFilter(BehaviourFilter policyFilter) {
        this.policyBehaviourFilter = policyFilter;
    }

    public void setAttachmentsExtractor(AttachmentsExtractor attachmentsExtractor) {
        this.attachmentsExtractor = attachmentsExtractor;
    }

    public void setImapHome(RepositoryFolderConfigBean imapHomeConfigBean) {
        this.imapHomeConfigBean = imapHomeConfigBean;
    }

    public void setFolderCacheSize(int folderCacheSize) {
        this.folderCacheSize = folderCacheSize;
    }

    @Override
    public String getDefaultFromAddress() {
        return this.defaultFromAddress;
    }

    public void setDefaultFromAddress(String defaultFromAddress) {
        this.defaultFromAddress = defaultFromAddress;
    }

    @Override
    public String getDefaultToAddress() {
        return this.defaultToAddress;
    }

    public void setDefaultToAddress(String defaultToAddress) {
        this.defaultToAddress = defaultToAddress;
    }

    @Override
    public String getWebApplicationContextUrl() {
        return String.valueOf(this.sysAdminParams.getAlfrescoProtocol()) + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort() + "/" + this.sysAdminParams.getAlfrescoContext();
    }

    @Override
    public String getShareApplicationContextUrl() {
        return String.valueOf(this.sysAdminParams.getShareProtocol()) + "://" + this.sysAdminParams.getShareHost() + ":" + this.sysAdminParams.getSharePort() + "/" + this.sysAdminParams.getShareContext();
    }

    @Override
    public String getRepositoryTemplatePath() {
        return this.repositoryTemplatePath;
    }

    public void setRepositoryTemplatePath(String repositoryTemplatePath) {
        this.repositoryTemplatePath = repositoryTemplatePath;
    }

    public void setImapConfigMountPoints(ImapConfigMountPointsBean[] imapConfigMountPointsBeans) {
        this.imapConfigMountPoints = new LinkedHashMap<String, ImapConfigMountPointsBean>(imapConfigMountPointsBeans.length * 2);
        this.mountPointIds = new HashMap<String, Integer>(imapConfigMountPointsBeans.length * 2);
        int i = 0;
        while (i < imapConfigMountPointsBeans.length) {
            String name = imapConfigMountPointsBeans[i].getMountPointName();
            this.imapConfigMountPoints.put(name, imapConfigMountPointsBeans[i]);
            this.mountPointIds.put(name, i + 1);
            ++i;
        }
    }

    public void setIgnoreExtractionFolders(RepositoryFolderConfigBean[] ignoreExtractionFolders) {
        this.ignoreExtractionFoldersBeans = ignoreExtractionFolders;
    }

    public void setExtractAttachmentsEnabled(boolean extractAttachmentsEnabled) {
        this.extractAttachmentsEnabled = extractAttachmentsEnabled;
    }

    public void setImapServerEnabled(boolean enabled) {
        this.imapServerEnabled = enabled;
    }

    public void setMessageHeadersToPersist(List<String> headers) {
        this.messageHeadersToPersist = headers;
    }

    public void setImapServerShuffleMoveDeleteDelay(long imapServerShuffleMoveDeleteDelay) {
        this.imapServerShuffleMoveDeleteDelay = imapServerShuffleMoveDeleteDelay;
    }

    @Override
    public boolean getImapServerEnabled() {
        return this.imapServerEnabled;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"imapConfigMountPoints", this.imapConfigMountPoints);
        PropertyCheck.mandatory((Object)this, (String)"ignoreExtractionFoldersBeans", (Object)this.ignoreExtractionFoldersBeans);
        PropertyCheck.mandatory((Object)this, (String)"imapHome", (Object)this.imapHomeConfigBean);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"defaultFromAddress", (Object)this.defaultFromAddress);
        PropertyCheck.mandatory((Object)this, (String)"defaultToAddress", (Object)this.defaultToAddress);
        PropertyCheck.mandatory((Object)this, (String)"repositoryTemplatePath", (Object)this.repositoryTemplatePath);
        PropertyCheck.mandatory((Object)this, (String)"policyBehaviourFilter", (Object)this.policyBehaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.getSearchService());
        this.folderCache = new MaxSizeMap(this.folderCacheSize, false);
        try {
            InternetAddress.parse((String)this.defaultFromAddress);
        }
        catch (AddressException addressException) {
            throw new AlfrescoRuntimeException(ERROR_CANNOT_PARSE_DEFAULT_EMAIL, new Object[]{this.defaultFromAddress});
        }
        try {
            InternetAddress.parse((String)this.defaultToAddress);
        }
        catch (AddressException addressException) {
            throw new AlfrescoRuntimeException(ERROR_CANNOT_PARSE_DEFAULT_EMAIL, new Object[]{this.defaultToAddress});
        }
    }

    public void startup() {
        this.bindBehaviour();
        this.ignoreExtractionFolders = new HashSet<NodeRef>(this.ignoreExtractionFoldersBeans.length * 2);
        RepositoryFolderConfigBean[] repositoryFolderConfigBeanArray = this.ignoreExtractionFoldersBeans;
        int n = this.ignoreExtractionFoldersBeans.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryFolderConfigBean ignoreExtractionFoldersBean = repositoryFolderConfigBeanArray[n2];
            NodeRef nodeRef = ignoreExtractionFoldersBean.getFolderPath(this.namespaceService, this.nodeService, this.searchService, this.fileFolderService);
            if (!this.ignoreExtractionFolders.add(nodeRef)) {
                throw new AlfrescoRuntimeException("The folder extraction path has been referenced already: \n   Folder: " + ignoreExtractionFoldersBean);
            }
            ++n2;
        }
        this.imapHomeNodeRef = this.imapHomeConfigBean.getOrCreateFolderPath(this.namespaceService, this.nodeService, this.searchService, this.fileFolderService);
    }

    public void shutdown() {
    }

    protected void startupInTxn(boolean force) {
        if (force || this.getImapServerEnabled()) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    List<AlfrescoImapFolder> mailboxes = ImapServiceImpl.this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<AlfrescoImapFolder>>(){

                        @Override
                        public List<AlfrescoImapFolder> execute() throws Throwable {
                            ImapServiceImpl.this.startup();
                            LinkedList<AlfrescoImapFolder> result = new LinkedList<AlfrescoImapFolder>();
                            for (String mountPointName : ImapServiceImpl.this.imapConfigMountPoints.keySet()) {
                                result.addAll(ImapServiceImpl.this.listMailboxes(new AlfrescoImapUser(null, AuthenticationUtil.getSystemUserName(), null), String.valueOf(mountPointName) + "*", false));
                            }
                            return result;
                        }
                    });
                    for (AlfrescoImapFolder mailbox : mailboxes) {
                        mailbox.getUidNext();
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    protected void bindBehaviour() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"[bindBeahaviour] Binding behaviours");
        }
        PolicyComponent policyComponent = (PolicyComponent)this.serviceRegistry.getService(QName.createQName((String)"http://www.alfresco.org", (String)"policyComponent"));
        policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ImapModel.ASPECT_IMAP_FOLDER, ContentModel.ASSOC_CONTAINS, new JavaBehaviour(this, "onCreateChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteChildAssociationPolicy.QNAME, ImapModel.ASPECT_IMAP_FOLDER, ContentModel.ASSOC_CONTAINS, new JavaBehaviour(this, "onDeleteChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.EVERY_EVENT));
        policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        policyComponent.bindClassBehaviour(NodeServicePolicies.OnRestoreNodePolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onRestoreNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public SimpleStoredMessage getMessage(FileInfo mesInfo) throws MessagingException {
        NodeRef nodeRef = mesInfo.getNodeRef();
        Date modified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        if (modified != null) {
            CacheItem cached = (CacheItem)this.messageCache.get((Serializable)nodeRef);
            if (cached != null && cached.getModified().equals(modified)) {
                return cached.getMessage();
            }
            SimpleStoredMessage message = this.createImapMessage(mesInfo, true);
            this.messageCache.put((Serializable)nodeRef, (Object)new CacheItem(modified, message));
            return message;
        }
        SimpleStoredMessage message = this.createImapMessage(mesInfo, true);
        return message;
    }

    @Override
    public SimpleStoredMessage createImapMessage(FileInfo fileInfo, boolean generateBody) throws MessagingException {
        Long key = (Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID);
        if (this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) {
            return new SimpleStoredMessage((MimeMessage)new ImapModelMessage(fileInfo, this.serviceRegistry, generateBody), new Date(), key.longValue());
        }
        return new SimpleStoredMessage((MimeMessage)new ContentModelMessage(fileInfo, this.serviceRegistry, generateBody), new Date(), key.longValue());
    }

    @Override
    public void expungeMessage(FileInfo fileInfo) {
        Flags flags = this.getFlags(fileInfo);
        if (flags.contains(Flags.Flag.DELETED)) {
            this.hideAndDelete(fileInfo.getNodeRef());
            this.messageCache.remove((Serializable)fileInfo.getNodeRef());
        }
    }

    private void hideAndDelete(final NodeRef nodeRef) {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
        this.fileFolderService.setHidden(nodeRef, true);
        final String deleteDelayUser = AuthenticationUtil.getFullyAuthenticatedUser();
        TimerTask deleteDelayTask = new TimerTask(){

            @Override
            public void run() {
                AuthenticationUtil.RunAsWork<Void> deleteDelayRunAs = new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        return ImapServiceImpl.this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            @Override
                            public Void execute() throws Throwable {
                                if (!ImapServiceImpl.this.nodeService.exists(nodeRef) || !ImapServiceImpl.this.fileFolderService.isHidden(nodeRef)) {
                                    return null;
                                }
                                FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
                                ImapServiceImpl.this.fileFolderService.setHidden(nodeRef, false);
                                ImapServiceImpl.this.fileFolderService.delete(nodeRef);
                                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                    ImapServiceImpl.this.logger.debug((Object)("Node has been async deleted " + nodeRef));
                                }
                                return null;
                            }
                        });
                    }
                };
                try {
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)deleteDelayRunAs, (String)deleteDelayUser);
                }
                catch (Throwable e) {
                    ImapServiceImpl.this.logger.info((Object)"Exception thrown during IMAP delete timer task.", e);
                }
            }
        };
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Delete timer is scheduled for " + nodeRef));
        }
        deleteDelayTimer.schedule(deleteDelayTask, this.imapServerShuffleMoveDeleteDelay);
    }

    @Override
    public AlfrescoImapFolder getOrCreateMailbox(AlfrescoImapUser user, String mailboxName, boolean mayExist, boolean mayCreate) {
        FileInfo mailFolder;
        NodeRef root;
        if (mailboxName == null) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)ERROR_MAILBOX_NAME_IS_MANDATORY));
        }
        if (mailboxName.length() == 0) {
            return new AlfrescoImapFolder(user.getLogin(), this, this.serviceRegistry);
        }
        List<String> pathElements = null;
        AlfrescoImapConst.ImapViewMode viewMode = AlfrescoImapConst.ImapViewMode.ARCHIVE;
        int index = mailboxName.indexOf(47);
        int mountPointId = 0;
        String rootPath = index > 0 ? mailboxName.substring(0, index) : mailboxName;
        ImapConfigMountPointsBean imapConfigMountPoint = this.imapConfigMountPoints.get(rootPath);
        if (imapConfigMountPoint != null) {
            mountPointId = this.mountPointIds.get(rootPath);
            root = imapConfigMountPoint.getFolderPath(this.serviceRegistry.getNamespaceService(), this.nodeService, this.searchService, this.fileFolderService);
            if (index > 0) {
                pathElements = Arrays.asList(mailboxName.substring(index + 1).split(String.valueOf('/')));
            }
            viewMode = imapConfigMountPoint.getMode();
        } else {
            root = this.getUserImapHomeRef(user.getLogin());
            pathElements = Arrays.asList(mailboxName.split(String.valueOf('/')));
        }
        try {
            mailFolder = pathElements != null ? this.fileFolderService.resolveNamePath(root, pathElements, !mayCreate) : this.fileFolderService.getFileInfo(root);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AlfrescoImapRuntimeException(ERROR_CANNOT_GET_A_FOLDER, new String[]{mailboxName}, (Throwable)new FolderException("Does not exist locally, no further information available"));
        }
        if (mailFolder == null) {
            if (!mayCreate) {
                throw new AlfrescoImapRuntimeException(ERROR_CANNOT_GET_A_FOLDER, new String[]{mailboxName}, (Throwable)new FolderException("Does not exist locally, no further information available"));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating mailbox: " + mailboxName));
            }
            mailFolder = FileFolderUtil.makeFolders(this.fileFolderService, root, pathElements, ContentModel.TYPE_FOLDER);
        } else if (!mayExist) {
            throw new AlfrescoImapRuntimeException(ERROR_FOLDER_ALREADY_EXISTS, (Throwable)new FolderException("Already exists locally"));
        }
        String path = pathElements != null ? pathElements.get(pathElements.size() - 1) : rootPath;
        return new AlfrescoImapFolder(mailFolder, user.getLogin(), path, mailboxName, viewMode, this, this.serviceRegistry, true, this.isExtractionEnabled(mailFolder.getNodeRef()), mountPointId);
    }

    @Override
    public void deleteMailbox(AlfrescoImapUser user, String mailboxName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting mailbox: mailboxName=" + mailboxName));
        }
        if (mailboxName == null) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)ERROR_MAILBOX_NAME_IS_MANDATORY));
        }
        AlfrescoImapFolder folder = this.getOrCreateMailbox(user, mailboxName, true, false);
        NodeRef nodeRef = folder.getFolderInfo().getNodeRef();
        List<FileInfo> childFolders = this.fileFolderService.listFolders(nodeRef);
        if (childFolders.isEmpty()) {
            folder.signalDeletion();
            this.fileFolderService.delete(nodeRef);
        } else if (folder.isSelectable()) {
            List<FileInfo> messages = this.fileFolderService.listFiles(nodeRef);
            for (FileInfo message : messages) {
                this.fileFolderService.delete(message.getNodeRef());
            }
            this.nodeService.addAspect(nodeRef, ImapModel.ASPECT_IMAP_FOLDER_NONSELECTABLE, null);
        } else {
            throw new AlfrescoRuntimeException(String.valueOf(mailboxName) + " - Can't delete a non-selectable store with children.");
        }
    }

    @Override
    public void renameMailbox(AlfrescoImapUser user, String oldMailboxName, String newMailboxName) {
        String newMailName;
        NodeRef newMailParent;
        int index;
        if (oldMailboxName == null || newMailboxName == null) {
            throw new IllegalArgumentException(ERROR_MAILBOX_NAME_IS_MANDATORY);
        }
        AlfrescoImapFolder sourceNode = this.getOrCreateMailbox(user, oldMailboxName, true, false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Renaming folder oldMailboxName=" + oldMailboxName + " newMailboxName=" + newMailboxName));
        }
        if ((index = newMailboxName.lastIndexOf(47)) < 0) {
            newMailParent = this.getUserImapHomeRef(user.getLogin());
            newMailName = newMailboxName;
        } else {
            newMailParent = this.getOrCreateMailbox(user, newMailboxName.substring(0, index), true, true).getFolderInfo().getNodeRef();
            newMailName = newMailboxName.substring(index + 1);
        }
        try {
            if (oldMailboxName.equalsIgnoreCase("INBOX")) {
                this.fileFolderService.copy(sourceNode.getFolderInfo().getNodeRef(), newMailParent, "INBOX");
            } else {
                this.fileFolderService.move(sourceNode.getFolderInfo().getNodeRef(), newMailParent, newMailName);
            }
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (FileExistsException e) {
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public ImapService.FolderStatus getFolderStatus(String userName, final NodeRef contextNodeRef, AlfrescoImapConst.ImapViewMode viewMode) {
        Long uidValidity;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getFolderStatus contextNodeRef=" + contextNodeRef + ", viewMode=" + (Object)((Object)viewMode)));
        }
        String changeToken = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)((Object)ImapServiceImpl.this.nodeService.getProperty(contextNodeRef, ImapModel.PROP_CHANGE_TOKEN));
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        Pair cacheKey = null;
        if (changeToken != null) {
            cacheKey = new Pair((Object)userName, (Object)changeToken);
            this.folderCacheLock.readLock().lock();
            try {
                ImapService.FolderStatus result = this.folderCache.get(cacheKey);
                if (result != null) {
                    ImapService.FolderStatus folderStatus = result;
                    return folderStatus;
                }
            }
            finally {
                this.folderCacheLock.readLock().unlock();
            }
        }
        List<FileInfo> fileInfos = null;
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
        try {
            fileInfos = this.fileFolderService.listFiles(contextNodeRef);
        }
        finally {
            FileFilterMode.clearClient();
        }
        final TreeMap<Long, FileInfo> currentSearch = new TreeMap<Long, FileInfo>();
        switch (viewMode) {
            case MIXED: {
                for (FileInfo fileInfo : fileInfos) {
                    currentSearch.put((Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID), fileInfo);
                }
                break;
            }
            case ARCHIVE: {
                for (FileInfo fileInfo : fileInfos) {
                    if (!this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) continue;
                    currentSearch.put((Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID), fileInfo);
                }
                break;
            }
            case VIRTUAL: {
                for (FileInfo fileInfo : fileInfos) {
                    if (this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) continue;
                    currentSearch.put((Long)fileInfo.getProperties().get(ContentModel.PROP_NODE_DBID), fileInfo);
                }
                break;
            }
        }
        int messageCount = currentSearch.size();
        int recentCount = 0;
        int unseenCount = 0;
        int firstUnseen = 0;
        int i = 1;
        for (FileInfo fileInfo : currentSearch.values()) {
            Flags flags = this.getFlags(fileInfo);
            if (flags.contains(Flags.Flag.RECENT)) {
                ++recentCount;
            }
            if (!flags.contains(Flags.Flag.SEEN)) {
                if (firstUnseen == 0) {
                    firstUnseen = i;
                }
                ++unseenCount;
            }
            ++i;
        }
        if (changeToken == null) {
            changeToken = GUID.generate();
            cacheKey = new Pair((Object)userName, (Object)changeToken);
            final String finalToken = changeToken;
            this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    ImapServiceImpl.this.nodeService.setProperty(contextNodeRef, ImapModel.PROP_CHANGE_TOKEN, (Serializable)((Object)finalToken));
                    ImapServiceImpl.this.nodeService.setProperty(contextNodeRef, ImapModel.PROP_MAXUID, (Serializable)Long.valueOf(currentSearch.isEmpty() ? 0L : (Long)currentSearch.lastKey()));
                    return null;
                }
            });
        }
        ImapService.FolderStatus result = new ImapService.FolderStatus(messageCount, recentCount, firstUnseen, unseenCount, (uidValidity = (Long)this.nodeService.getProperty(contextNodeRef, ImapModel.PROP_UIDVALIDITY)) == null ? 0L : uidValidity, changeToken, currentSearch);
        this.folderCacheLock.writeLock().lock();
        try {
            ImapService.FolderStatus oldResult = this.folderCache.get(cacheKey);
            if (oldResult != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("At end of getFolderStatus. Found info in cache, changeToken:" + changeToken));
                }
                ImapService.FolderStatus folderStatus = oldResult;
                return folderStatus;
            }
            this.folderCache.put((Pair<String, String>)cacheKey, result);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("At end of getFolderStatus. Found files:" + currentSearch.size() + ", changeToken:" + changeToken));
            }
            ImapService.FolderStatus folderStatus = result;
            return folderStatus;
        }
        finally {
            this.folderCacheLock.writeLock().unlock();
        }
    }

    @Override
    public void subscribe(AlfrescoImapUser user, String mailbox) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Subscribing: " + user + ", " + mailbox));
        }
        AlfrescoImapFolder mailFolder = this.getOrCreateMailbox(user, mailbox, true, false);
        PersonService personService = this.serviceRegistry.getPersonService();
        NodeRef userRef = personService.getPerson(user.getLogin());
        this.nodeService.removeAssociation(userRef, mailFolder.getFolderInfo().getNodeRef(), ImapModel.ASSOC_IMAP_UNSUBSCRIBED);
    }

    @Override
    public void unsubscribe(AlfrescoImapUser user, String mailbox) {
        AlfrescoImapFolder mailFolder;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unsubscribing: " + user + ", " + mailbox));
        }
        if ((mailFolder = this.getOrCreateMailbox(user, mailbox, true, false)).getFolderInfo() != null) {
            PersonService personService = this.serviceRegistry.getPersonService();
            NodeRef userRef = personService.getPerson(user.getLogin());
            this.nodeService.createAssociation(userRef, mailFolder.getFolderInfo().getNodeRef(), ImapModel.ASSOC_IMAP_UNSUBSCRIBED);
        } else {
            this.logger.debug((Object)"Unable to find folder to unsubscribe");
        }
    }

    @Override
    public Flags getFlags(FileInfo messageInfo) {
        Flags flags = new Flags();
        Map props = this.nodeService.getProperties(messageInfo.getNodeRef());
        for (QName key : qNameToFlag.keySet()) {
            Boolean value = (Boolean)props.get(key);
            if (value == null || !value.booleanValue()) continue;
            flags.add(qNameToFlag.get(key));
        }
        return flags;
    }

    @Override
    public void setFlags(FileInfo messageInfo, Flags flags, boolean value) {
        this.checkForFlaggableAspect(messageInfo.getNodeRef());
        Flags.Flag[] flagArray = flags.getSystemFlags();
        int n = flagArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags.Flag flag = flagArray[n2];
            this.setFlag(messageInfo, flag, value);
            ++n2;
        }
    }

    @Override
    public void setFlag(FileInfo messageInfo, Flags.Flag flag, boolean value) {
        this.setFlag(messageInfo.getNodeRef(), flag, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setFlag(NodeRef nodeRef, Flags.Flag flag, boolean value) {
        String permission = flag == Flags.Flag.DELETED ? "DeleteNode" : "WriteProperties";
        AccessStatus status = this.permissionService.hasPermission(nodeRef, permission);
        if (status == AccessStatus.DENIED) {
            if (flag == Flags.Flag.DELETED) {
                this.logger.debug((Object)("[setFlag] Access denied to set DELETED FLAG:" + nodeRef));
                throw new AccessDeniedException("No permission to set DELETED flag");
            }
            if (flag == Flags.Flag.SEEN) {
                this.logger.debug((Object)("[setFlag] Access denied to set SEEN FLAG:" + nodeRef));
                return;
            }
            this.logger.debug((Object)("[setFlag] Access denied to set flag:" + nodeRef));
            throw new AccessDeniedException("No permission to set flag:" + flag.toString());
        }
        this.checkForFlaggableAspect(nodeRef);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("set flag nodeRef:" + nodeRef + ",flag:" + flagToQname.get(flag) + ", value:" + value));
            }
            this.nodeService.setProperty(nodeRef, flagToQname.get(flag), (Serializable)Boolean.valueOf(value));
            this.messageCache.remove((Serializable)nodeRef);
            return;
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
    }

    @Override
    public List<AlfrescoImapFolder> listMailboxes(AlfrescoImapUser user, String mailboxPattern, boolean listSubscribed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[listMailboxes] user:" + user.getLogin() + ", mailboxPattern:" + mailboxPattern + ", listSubscribed:" + listSubscribed));
        }
        LinkedList<AlfrescoImapFolder> result = new LinkedList<AlfrescoImapFolder>();
        int index = mailboxPattern.indexOf(47);
        String rootPath = index == -1 ? mailboxPattern : mailboxPattern.substring(0, index);
        boolean found = false;
        String userName = user.getLogin();
        Set<NodeRef> unsubscribedFodlers = this.getUnsubscribedFolders(userName);
        for (String mountPointName : this.imapConfigMountPoints.keySet()) {
            if (!mountPointName.matches(rootPath.replaceAll("[%\\*]", ".*"))) continue;
            NodeRef mountPoint = this.getMountPoint(mountPointName);
            if (mountPoint != null) {
                int mountPointId = this.mountPointIds.get(mountPointName);
                FileInfo mountPointFileInfo = this.fileFolderService.getFileInfo(mountPoint);
                AlfrescoImapConst.ImapViewMode viewMode = this.imapConfigMountPoints.get(mountPointName).getMode();
                if (index < 0) {
                    if (!listSubscribed || !unsubscribedFodlers.contains(mountPointFileInfo.getNodeRef())) {
                        result.add(new AlfrescoImapFolder(mountPointFileInfo, userName, mountPointName, mountPointName, viewMode, this.isExtractionEnabled(mountPointFileInfo.getNodeRef()), this, this.serviceRegistry, mountPointId));
                    } else if (rootPath.endsWith("%") && !this.expandFolder(mountPoint, user, mountPointName, "%", true, viewMode, mountPointId).isEmpty()) {
                        result.add(new AlfrescoImapFolder(mountPointFileInfo, userName, mountPointName, mountPointName, viewMode, this, this.serviceRegistry, false, this.isExtractionEnabled(mountPointFileInfo.getNodeRef()), mountPointId));
                    }
                    if (rootPath.endsWith("*")) {
                        result.addAll(this.expandFolder(mountPoint, user, mountPointName, "*", listSubscribed, viewMode, mountPointId));
                    }
                } else {
                    result.addAll(this.expandFolder(mountPoint, user, mountPointName, mailboxPattern.substring(index + 1), listSubscribed, viewMode, mountPointId));
                }
            }
            if (!mountPointName.equals(rootPath)) continue;
            found = true;
            break;
        }
        if (!found) {
            NodeRef root = this.getUserImapHomeRef(user.getLogin());
            result.addAll(this.expandFolder(root, user, "", mailboxPattern, listSubscribed, AlfrescoImapConst.ImapViewMode.ARCHIVE, 0));
        }
        this.logger.debug((Object)("listMailboxes returning size:" + result.size()));
        return result;
    }

    private List<AlfrescoImapFolder> expandFolder(NodeRef root, AlfrescoImapUser user, String rootPath, String mailboxPattern, boolean listSubscribed, AlfrescoImapConst.ImapViewMode viewMode, int mountPointId) {
        List<Object> list;
        String rootPathPrefix;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("expand folder: root:" + root + " user: " + user + " :mailboxPattern=" + mailboxPattern));
        }
        if (mailboxPattern == null) {
            return null;
        }
        int index = mailboxPattern.indexOf(47);
        String name = null;
        name = index < 0 ? mailboxPattern : mailboxPattern.substring(0, index);
        String string = rootPathPrefix = rootPath.length() == 0 ? "" : String.valueOf(rootPath) + '/';
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listing mailboxes: name=" + name));
        }
        LinkedList<AlfrescoImapFolder> fullList = new LinkedList<AlfrescoImapFolder>();
        ImapSubFolderFilter filter = new ImapSubFolderFilter(viewMode, name.replace('%', '*'), Arrays.asList("calendar", "dataLists"));
        if (name.contains("*") || name.contains("%")) {
            FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
            try {
                if (this.serviceRegistry.getSiteService().getSiteRoot().equals((Object)root)) {
                    list = this.fileFolderService.toFileInfoList(filter.favs);
                }
                list = this.fileFolderService.listFolders(root);
            }
            finally {
                FileFilterMode.clearClient();
            }
        } else {
            FileInfo fileInfo;
            NodeRef nodeRef = this.fileFolderService.searchSimple(root, name);
            List<Object> list2 = list = nodeRef == null || !(fileInfo = this.fileFolderService.getFileInfo(nodeRef)).isFolder() ? Collections.emptyList() : Collections.singletonList(fileInfo);
        }
        if (index < 0) {
            String string2 = user.getLogin();
            Set<NodeRef> unsubscribedFodlers = this.getUnsubscribedFolders(string2);
            for (FileInfo fileInfo : list) {
                if (!filter.isEnterSubfolder(fileInfo.getNodeRef())) continue;
                String folderPath = String.valueOf(rootPathPrefix) + fileInfo.getName();
                if (!listSubscribed || !unsubscribedFodlers.contains(fileInfo.getNodeRef())) {
                    fullList.add(new AlfrescoImapFolder(fileInfo, string2, fileInfo.getName(), folderPath, viewMode, this.isExtractionEnabled(fileInfo.getNodeRef()), this, this.serviceRegistry, mountPointId));
                } else if (name.endsWith("%") && !this.expandFolder(fileInfo.getNodeRef(), user, folderPath, "%", true, viewMode, mountPointId).isEmpty()) {
                    fullList.add(new AlfrescoImapFolder(fileInfo, string2, fileInfo.getName(), folderPath, viewMode, this, this.serviceRegistry, false, this.isExtractionEnabled(fileInfo.getNodeRef()), mountPointId));
                }
                if (!name.endsWith("*")) continue;
                fullList.addAll(this.expandFolder(fileInfo.getNodeRef(), user, folderPath, "*", listSubscribed, viewMode, mountPointId));
            }
        } else {
            for (FileInfo fileInfo : list) {
                if (!filter.isEnterSubfolder(fileInfo.getNodeRef())) continue;
                fullList.addAll(this.expandFolder(fileInfo.getNodeRef(), user, String.valueOf(rootPathPrefix) + fileInfo.getName(), mailboxPattern.substring(index + 1), listSubscribed, viewMode, mountPointId));
            }
        }
        return fullList;
    }

    private NodeRef getMountPoint(String rootFolder) {
        final ImapConfigMountPointsBean config = this.imapConfigMountPoints.get(rootFolder);
        try {
            return this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Exception {
                    try {
                        return config.getFolderPathOrNull(ImapServiceImpl.this.namespaceService, ImapServiceImpl.this.nodeService, ImapServiceImpl.this.searchService, ImapServiceImpl.this.fileFolderService);
                    }
                    catch (AccessDeniedException accessDeniedException) {
                        if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                            ImapServiceImpl.this.logger.debug((Object)("A mount point is skipped due to Access Dennied. \n   Mount point: " + config + "\n" + "   User: " + AuthenticationUtil.getFullyAuthenticatedUser()));
                        }
                        return null;
                    }
                }
            }, true, true);
        }
        catch (AccessDeniedException accessDeniedException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("A mount point is skipped due to Access Dennied. \n   Mount point: " + config + "\n" + "   User: " + AuthenticationUtil.getFullyAuthenticatedUser()));
            }
            return null;
        }
    }

    @Override
    public NodeRef getUserImapHomeRef(final String userName) {
        NodeRef userHome = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef userHome = ImapServiceImpl.this.fileFolderService.searchSimple(ImapServiceImpl.this.imapHomeNodeRef, userName);
                if (userHome == null) {
                    NodeRef result = ImapServiceImpl.this.fileFolderService.create(ImapServiceImpl.this.imapHomeNodeRef, userName, ContentModel.TYPE_FOLDER).getNodeRef();
                    ImapServiceImpl.this.nodeService.setProperty(result, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)userName));
                    ImapServiceImpl.this.fileFolderService.create(result, "INBOX", ContentModel.TYPE_FOLDER);
                    ImapServiceImpl.this.permissionService.setInheritParentPermissions(result, false);
                    ImapServiceImpl.this.permissionService.setPermission(result, "ROLE_OWNER", "All", true);
                    return result;
                }
                return userHome;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return userHome;
    }

    private Set<NodeRef> getUnsubscribedFolders(String userName) {
        HashSet<NodeRef> result = new HashSet<NodeRef>();
        PersonService personService = this.serviceRegistry.getPersonService();
        NodeRef userRef = null;
        if (personService.personExists(userName)) {
            userRef = personService.getPerson(userName);
        }
        if (userRef != null) {
            List unsubscribedFodlers = this.nodeService.getTargetAssocs(userRef, (QNamePattern)ImapModel.ASSOC_IMAP_UNSUBSCRIBED);
            for (AssociationRef asocRef : unsubscribedFodlers) {
                result.add(asocRef.getTargetRef());
            }
        }
        return result;
    }

    private String getCurrentUser() {
        return AuthenticationUtil.getFullyAuthenticatedUser();
    }

    private List<NodeRef> getFavouriteSites(String userName) {
        PersonService personService = this.serviceRegistry.getPersonService();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getFavouriteSites] entry for user: " + userName));
        }
        LinkedList<NodeRef> favSites = (LinkedList<NodeRef>)AlfrescoTransactionSupport.getResource((Object)FAVORITE_SITES);
        if (this.logger.isDebugEnabled()) {
            if (favSites == null) {
                this.logger.debug((Object)("[getFavouriteSites] There is no Favorite sites' list bound to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            } else {
                this.logger.debug((Object)("[getFavouriteSites] Found Favorite sites' list bound to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
        }
        if (favSites == null) {
            favSites = new LinkedList<NodeRef>();
            if (personService.personExists(userName)) {
                PreferenceService preferenceService = (PreferenceService)this.serviceRegistry.getService(ServiceRegistry.PREFERENCE_SERVICE);
                Map<String, Serializable> prefs = preferenceService.getPreferences(userName, "org.alfresco.share.sites.imapFavourites");
                for (String key : prefs.keySet()) {
                    SiteInfo siteInfo;
                    Boolean isImapFavourite = (Boolean)prefs.get(key);
                    if (isImapFavourite == null || !isImapFavourite.booleanValue()) continue;
                    String siteName = key.substring("org.alfresco.share.sites.imapFavourites".length() + 1);
                    boolean isMember = false;
                    try {
                        isMember = this.serviceRegistry.getSiteService().isMember(siteName, userName);
                    }
                    catch (SiteDoesNotExistException siteDoesNotExistException) {}
                    if (!isMember || (siteInfo = this.serviceRegistry.getSiteService().getSite(siteName)) == null) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[getFavouriteSites] User: " + userName + " Favourite site: " + siteInfo.getShortName()));
                    }
                    favSites.add(siteInfo.getNodeRef());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("[getFavouriteSites] Bind new Favorite sites' list to transaction " + AlfrescoTransactionSupport.getTransactionId()));
                }
                AlfrescoTransactionSupport.bindResource((Object)FAVORITE_SITES, favSites);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getFavouriteSites] end for user: " + userName));
        }
        return favSites;
    }

    private void checkForFlaggableAspect(NodeRef nodeRef) {
        HashSet<NodeRef> alreadyChecked = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource((Object)CHECKED_NODES);
        if (alreadyChecked == null) {
            alreadyChecked = new HashSet<NodeRef>();
        }
        if (alreadyChecked.contains(nodeRef)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[checkForFlaggableAspect] Flaggable aspect has been already checked for {" + nodeRef + "}"));
            }
            return;
        }
        try {
            this.serviceRegistry.getLockService().checkForLock(nodeRef);
        }
        catch (NodeLockedException nodeLockedException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[checkForFlaggableAspect] Node {" + nodeRef + "} is locked"));
            }
            alreadyChecked.add(nodeRef);
            return;
        }
        if (!this.nodeService.hasAspect(nodeRef, ImapModel.ASPECT_FLAGGABLE)) {
            AccessStatus status = this.permissionService.hasPermission(nodeRef, "WriteProperties");
            if (status == AccessStatus.DENIED) {
                this.logger.debug((Object)("[checkForFlaggableAspect] No permissions to add FLAGGABLE aspect" + nodeRef));
            } else {
                try {
                    this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                    this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                    this.logger.debug((Object)("[checkForFlaggableAspect] Adding flaggable aspect to nodeRef: " + nodeRef));
                    HashMap aspectProperties = new HashMap();
                    this.nodeService.addAspect(nodeRef, ImapModel.ASPECT_FLAGGABLE, aspectProperties);
                }
                finally {
                    this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
                    this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                }
            }
        }
        alreadyChecked.add(nodeRef);
        AlfrescoTransactionSupport.bindResource((Object)CHECKED_NODES, alreadyChecked);
    }

    private boolean isExtractionEnabled(NodeRef nodeRef) {
        return this.extractAttachmentsEnabled && !this.ignoreExtractionFolders.contains(nodeRef);
    }

    @Override
    public String getDefaultEmailBodyTemplate(ImapService.EmailBodyFormat type) {
        if (this.defaultBodyTemplates == null) {
            this.defaultBodyTemplates = new HashMap<ImapService.EmailBodyFormat, String>(4);
            ImapService.EmailBodyFormat[] emailBodyFormatArray = ImapService.EmailBodyFormat.values();
            int n = emailBodyFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImapService.EmailBodyFormat onetype = emailBodyFormatArray[n2];
                String result = onetype.getClasspathTemplatePath();
                try {
                    StoreRef storeRef;
                    NodeRef rootNode;
                    List templates;
                    StringBuilder templateName = new StringBuilder("emailbody").append("_").append(onetype.getTypeSubtype()).append("_").append(onetype.getWebApp()).append(".ftl");
                    String repositoryTemplatePath = this.getRepositoryTemplatePath();
                    int indexOfStoreDelim = repositoryTemplatePath.indexOf("://");
                    if (indexOfStoreDelim == -1) {
                        throw new IllegalArgumentException("Bad path format, :// not found");
                    }
                    int indexOfPathDelim = repositoryTemplatePath.indexOf("/", indexOfStoreDelim += "://".length());
                    if (indexOfPathDelim == -1) {
                        throw new IllegalArgumentException("Bad path format, '/' not found");
                    }
                    String storePath = repositoryTemplatePath.substring(0, indexOfPathDelim);
                    String rootPathInStore = repositoryTemplatePath.substring(indexOfPathDelim);
                    String query = String.valueOf(rootPathInStore) + "/" + "cm" + ":" + templateName;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[getDefaultEmailBodyTemplate] Query: " + query));
                    }
                    if ((templates = this.searchService.selectNodes(rootNode = this.nodeService.getRootNode(storeRef = new StoreRef(storePath)), query, null, (NamespacePrefixResolver)this.namespaceService, true)) == null || templates.size() == 0) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("template not found:" + templateName));
                        }
                        throw new AlfrescoRuntimeException(String.format("[getDefaultEmailBodyTemplate] IMAP message template '%1$s' does not exist in the path '%2$s'.", templateName, repositoryTemplatePath));
                    }
                    NodeRef defaultLocaleTemplate = (NodeRef)templates.get(0);
                    NodeRef localisedSibling = this.serviceRegistry.getFileFolderService().getLocalizedSibling(defaultLocaleTemplate);
                    result = localisedSibling.toString();
                }
                catch (Exception e) {
                    this.logger.error((Object)"ImapServiceImpl [getDefaultEmailBodyTemplate]", (Throwable)e);
                }
                this.defaultBodyTemplates.put(onetype, result);
                ++n2;
            }
        }
        return this.defaultBodyTemplates.get((Object)type);
    }

    public String getAlfrescoServerUID() {
        return "Not-Implemented";
    }

    private UidValidityTransactionListener getUidValidityTransactionListener(NodeRef folderRef) {
        String key = UIDVALIDITY_TRANSACTION_LISTENER + folderRef.toString();
        UidValidityTransactionListener txnListener = (UidValidityTransactionListener)AlfrescoTransactionSupport.getResource((Object)key);
        if (txnListener == null) {
            txnListener = new UidValidityTransactionListener(folderRef);
            AlfrescoTransactionSupport.bindListener(txnListener);
            AlfrescoTransactionSupport.bindResource((Object)key, (Object)txnListener);
        }
        return txnListener;
    }

    @Override
    public void onCreateChildAssociation(final ChildAssociationRef childAssocRef, boolean isNewNode) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef childNodeRef = childAssocRef.getChildRef();
                if (ImapServiceImpl.this.serviceRegistry.getDictionaryService().isSubClass(ImapServiceImpl.this.nodeService.getType(childNodeRef), ContentModel.TYPE_CONTENT)) {
                    long newId = (Long)ImapServiceImpl.this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NODE_DBID);
                    ImapServiceImpl.this.getUidValidityTransactionListener(childAssocRef.getParentRef()).recordNewUid(newId);
                    ImapServiceImpl.this.setFlag(childNodeRef, Flags.Flag.RECENT, true);
                }
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("[onCreateChildAssociation] Association " + childAssocRef + " created. CHANGETOKEN will be changed."));
                }
                return null;
            }
        });
    }

    @Override
    public void onDeleteChildAssociation(final ChildAssociationRef childAssocRef) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef childNodeRef = childAssocRef.getChildRef();
                if (ImapServiceImpl.this.serviceRegistry.getDictionaryService().isSubClass(ImapServiceImpl.this.nodeService.getType(childNodeRef), ContentModel.TYPE_CONTENT)) {
                    ImapServiceImpl.this.getUidValidityTransactionListener(childAssocRef.getParentRef());
                    ImapServiceImpl.this.messageCache.remove((Serializable)childNodeRef);
                }
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("[onDeleteChildAssociation] Association " + childAssocRef + " created. CHANGETOKEN will be changed."));
                }
                return null;
            }
        });
    }

    @Override
    public void onUpdateProperties(final NodeRef nodeRef, final Map<QName, Serializable> before, final Map<QName, Serializable> after) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                boolean hasChanged = false;
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_NAME), after.get(ContentModel.PROP_NAME));
                }
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_AUTHOR), after.get(ContentModel.PROP_AUTHOR));
                }
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_TITLE), after.get(ContentModel.PROP_TITLE));
                }
                if (!hasChanged) {
                    boolean bl = hasChanged = !EqualsHelper.nullSafeEquals(before.get(ContentModel.PROP_DESCRIPTION), after.get(ContentModel.PROP_DESCRIPTION));
                }
                if (!hasChanged) {
                    Serializable s1 = (Serializable)before.get(ContentModel.PROP_CONTENT);
                    Serializable s2 = (Serializable)after.get(ContentModel.PROP_CONTENT);
                    if (s1 != null && s2 != null) {
                        ContentData c1 = (ContentData)s1;
                        ContentData c2 = (ContentData)s2;
                        hasChanged = !EqualsHelper.nullSafeEquals((Object)c1.getContentUrl(), (Object)c2.getContentUrl());
                    }
                }
                for (ChildAssociationRef parentAssoc : ImapServiceImpl.this.nodeService.getParentAssocs(nodeRef)) {
                    NodeRef folderRef = parentAssoc.getParentRef();
                    if (!ImapServiceImpl.this.nodeService.hasAspect(folderRef, ImapModel.ASPECT_IMAP_FOLDER)) continue;
                    ImapServiceImpl.this.messageCache.remove((Serializable)nodeRef);
                    UidValidityTransactionListener listener = ImapServiceImpl.this.getUidValidityTransactionListener(folderRef);
                    if (!hasChanged) continue;
                    ImapServiceImpl.this.logger.debug((Object)"message has changed - force new uidvalidity for the parent folder");
                    listener.forceNewUidvalidity();
                }
                return null;
            }
        });
    }

    @Override
    public void onRestoreNode(final ChildAssociationRef childAssocRef) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef childNodeRef = childAssocRef.getChildRef();
                if (ImapServiceImpl.this.serviceRegistry.getDictionaryService().isSubClass(ImapServiceImpl.this.nodeService.getType(childNodeRef), ContentModel.TYPE_CONTENT)) {
                    ImapServiceImpl.this.setFlag(childNodeRef, Flags.Flag.DELETED, false);
                    ImapServiceImpl.this.setFlag(childNodeRef, Flags.Flag.SEEN, false);
                }
                NodeRef folderRef = childAssocRef.getParentRef();
                long newId = (Long)ImapServiceImpl.this.nodeService.getProperty(childNodeRef, ContentModel.PROP_NODE_DBID);
                if (ImapServiceImpl.this.nodeService.hasAspect(folderRef, ImapModel.ASPECT_IMAP_FOLDER)) {
                    ImapServiceImpl.this.getUidValidityTransactionListener(folderRef).recordNewUid(newId);
                }
                return null;
            }
        });
    }

    @Override
    public void beforeDeleteNode(final NodeRef nodeRef) {
        this.doAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                for (ChildAssociationRef parentAssoc : ImapServiceImpl.this.nodeService.getParentAssocs(nodeRef)) {
                    NodeRef folderRef = parentAssoc.getParentRef();
                    if (!ImapServiceImpl.this.nodeService.hasAspect(folderRef, ImapModel.ASPECT_IMAP_FOLDER)) continue;
                    ImapServiceImpl.this.messageCache.remove((Serializable)nodeRef);
                    ImapServiceImpl.this.getUidValidityTransactionListener(folderRef);
                }
                return null;
            }
        });
    }

    private <R> R doAsSystem(AuthenticationUtil.RunAsWork<R> work) {
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            Object object = AuthenticationUtil.runAs(work, (String)AuthenticationUtil.getSystemUserName());
            return (R)object;
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
    }

    @Override
    public NodeRef getNodeSiteContainer(final NodeRef inputNodeRef) {
        return this.doAsSystem(new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef nodeRef;
                block4: {
                    NodeRef parent;
                    nodeRef = inputNodeRef;
                    do {
                        if ((parent = ImapServiceImpl.this.nodeService.getPrimaryParent(nodeRef).getParentRef()) == null) {
                            if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                ImapServiceImpl.this.logger.debug((Object)("The node with nodeRef:" + inputNodeRef + " is not in the site."));
                            }
                            nodeRef = null;
                            break block4;
                        }
                        nodeRef = parent;
                    } while (!ImapServiceImpl.this.nodeService.hasAspect(parent, SiteModel.ASPECT_SITE_CONTAINER));
                    if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                        ImapServiceImpl.this.logger.debug((Object)("The node with nodeRef:" + inputNodeRef + " is in the site."));
                    }
                }
                return nodeRef;
            }
        });
    }

    @Override
    public String getContentFolderUrl(NodeRef contentNodeRef) {
        String url;
        block34: {
            String REPOSITORY_URL_TEMPLATE;
            block32: {
                url = "";
                String CONTAINER_URL_TEMPLATE = "%s/page/site/%s";
                REPOSITORY_URL_TEMPLATE = "%s/page/%s";
                NodeRef siteContainerNodeRef = this.getNodeSiteContainer(contentNodeRef);
                if (siteContainerNodeRef == null) break block32;
                NodeRef siteNodeRef = this.nodeService.getPrimaryParent(siteContainerNodeRef).getParentRef();
                String siteName = ((String)((Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_NAME))).toLowerCase();
                String componentId = (String)((Object)this.nodeService.getProperty(siteContainerNodeRef, SiteModel.PROP_COMPONENT_ID));
                switch (componentId.toLowerCase()) {
                    case "datalists": {
                        url = String.format(CONTAINER_URL_TEMPLATE, this.getShareApplicationContextUrl(), String.valueOf(siteName) + "/data-lists");
                        break;
                    }
                    case "wiki": {
                        url = String.format(CONTAINER_URL_TEMPLATE, this.getShareApplicationContextUrl(), String.valueOf(siteName) + "/wiki");
                        break;
                    }
                    case "links": {
                        url = String.format(CONTAINER_URL_TEMPLATE, this.getShareApplicationContextUrl(), String.valueOf(siteName) + "/links");
                        break;
                    }
                    case "calendar": {
                        url = String.format(CONTAINER_URL_TEMPLATE, this.getShareApplicationContextUrl(), String.valueOf(siteName) + "/calendar");
                        break;
                    }
                    case "discussions": {
                        url = String.format(CONTAINER_URL_TEMPLATE, this.getShareApplicationContextUrl(), String.valueOf(siteName) + "/discussions-topiclist");
                        break;
                    }
                    case "blog": {
                        url = String.format(CONTAINER_URL_TEMPLATE, this.getShareApplicationContextUrl(), String.valueOf(siteName) + "/blog-postlist");
                        break;
                    }
                    case "documentlibrary": {
                        String pathFromSites = this.getPathFromSites(this.nodeService.getPrimaryParent(contentNodeRef).getParentRef());
                        StringBuilder parsedPath = new StringBuilder();
                        String[] pathParts = pathFromSites.split("/");
                        if (pathParts.length > 2) {
                            parsedPath.append(String.valueOf(pathParts[0]) + "/" + pathParts[1]);
                            parsedPath.append("?filter=path|");
                            int i = 2;
                            while (i < pathParts.length) {
                                parsedPath.append("/").append(pathParts[i]);
                                ++i;
                            }
                        } else {
                            parsedPath.append(pathFromSites);
                        }
                        url = String.format(CONTAINER_URL_TEMPLATE, this.getShareApplicationContextUrl(), parsedPath.toString());
                        break;
                    }
                }
                break block34;
            }
            String pathFromRepo = this.getPathFromRepo(this.nodeService.getPrimaryParent(contentNodeRef));
            StringBuilder parsedPath = new StringBuilder();
            String[] pathParts = pathFromRepo.split("/");
            if (pathParts.length > 1) {
                parsedPath.append(pathParts[0]);
                parsedPath.append("?filter=path|");
                int i = 1;
                while (i < pathParts.length) {
                    parsedPath.append("/").append(pathParts[i]);
                    ++i;
                }
            } else {
                parsedPath.append(pathFromRepo);
            }
            url = String.format(REPOSITORY_URL_TEMPLATE, this.getShareApplicationContextUrl(), parsedPath.toString());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolved content folder URL:" + url + " for node " + contentNodeRef));
        }
        return url;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    @Override
    public void extractAttachments(NodeRef messageRef, MimeMessage originalMessage) throws IOException, MessagingException {
        this.attachmentsExtractor.extractAttachments(messageRef, originalMessage);
    }

    @Override
    public String generateUniqueFilename(NodeRef destFolderNodeRef, String fileName) {
        if (this.fileFolderService.searchSimple(destFolderNodeRef, fileName) != null) {
            String name = fileName;
            String ext = "";
            if (fileName.lastIndexOf(".") != -1) {
                int index = fileName.lastIndexOf(".");
                name = fileName.substring(0, index);
                ext = fileName.substring(index);
            }
            int copyNum = 0;
            while (this.fileFolderService.searchSimple(destFolderNodeRef, String.valueOf(name) + " (" + ++copyNum + ")" + ext) != null) {
            }
            fileName = String.valueOf(name) + " (" + copyNum + ")" + ext;
        }
        return fileName;
    }

    @Override
    public void persistMessageHeaders(NodeRef messageRef, MimeMessage message) {
        try {
            Enumeration headers = message.getAllHeaders();
            ArrayList<String> messaheHeadersProperties = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                if (!this.isPersistableHeader(header)) continue;
                messaheHeadersProperties.add(String.valueOf(header.getName()) + ":" + header.getValue());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("[persistHeaders] Persisting Header " + header.getName() + " : " + header.getValue()));
            }
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
            props.put(ImapModel.PROP_MESSAGE_HEADERS, messaheHeadersProperties);
            this.serviceRegistry.getNodeService().addAspect(messageRef, ImapModel.ASPECT_IMAP_MESSAGE_HEADERS, props);
        }
        catch (MessagingException messagingException) {}
    }

    private boolean isPersistableHeader(Header header) {
        for (String headerToPersist : this.messageHeadersToPersist) {
            if (!headerToPersist.equalsIgnoreCase(header.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPathFromSites(final NodeRef ref) {
        return this.doAsSystem(new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                String name = ((String)((Object)ImapServiceImpl.this.nodeService.getProperty(ref, ContentModel.PROP_NAME))).toLowerCase();
                if (ImapServiceImpl.this.nodeService.getType(ref).equals((Object)SiteModel.TYPE_SITE)) {
                    return name;
                }
                NodeRef parent = ImapServiceImpl.this.nodeService.getPrimaryParent(ref).getParentRef();
                return String.valueOf(ImapServiceImpl.this.getPathFromSites(parent)) + "/" + name;
            }
        });
    }

    @Override
    public String getPathFromRepo(final ChildAssociationRef assocRef) {
        return this.doAsSystem(new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                NodeRef ref = assocRef.getParentRef();
                String name = ((String)((Object)ImapServiceImpl.this.nodeService.getProperty(ref, ContentModel.PROP_NAME))).toLowerCase();
                ChildAssociationRef parent = ImapServiceImpl.this.nodeService.getPrimaryParent(ref);
                QName qname = parent.getQName();
                if (qname.equals((Object)QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"company_home"))) {
                    return "repository";
                }
                return String.valueOf(ImapServiceImpl.this.getPathFromRepo(parent)) + "/" + name;
            }
        });
    }

    static class CacheItem {
        private Date modified;
        private SimpleStoredMessage message;

        public CacheItem(Date modified, SimpleStoredMessage message) {
            this.setMessage(message);
            this.setModified(modified);
        }

        public void setModified(Date modified) {
            this.modified = modified;
        }

        public Date getModified() {
            return this.modified;
        }

        public void setMessage(SimpleStoredMessage message) {
            this.message = message;
        }

        public SimpleStoredMessage getMessage() {
            return this.message;
        }
    }

    public static class ImapServiceBootstrap
    extends AbstractLifecycleBean {
        private ImapServiceImpl service;

        public void setService(ImapServiceImpl service) {
            this.service = service;
        }

        protected void onBootstrap(ApplicationEvent event) {
            this.service.startupInTxn(false);
        }

        protected void onShutdown(ApplicationEvent event) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    if (service.getImapServerEnabled()) {
                        service.shutdown();
                    }
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        }
    }

    private class ImapSubFolderFilter
    implements SubFolderFilter {
        private Collection<QName> typesToExclude;
        private List<NodeRef> favs;
        private String mailboxPattern;
        private AlfrescoImapConst.ImapViewMode imapViewMode;
        private List<String> excludedComponentIds;

        ImapSubFolderFilter(AlfrescoImapConst.ImapViewMode imapViewMode) {
            this.imapViewMode = imapViewMode;
            this.typesToExclude = ImapServiceImpl.this.serviceRegistry.getDictionaryService().getSubTypes(SiteModel.TYPE_SITE, true);
            this.favs = ImapServiceImpl.this.getFavouriteSites(ImapServiceImpl.this.getCurrentUser());
        }

        ImapSubFolderFilter(AlfrescoImapConst.ImapViewMode imapViewMode, String mailboxPattern) {
            this(imapViewMode);
            this.mailboxPattern = mailboxPattern.replaceAll("\\*", "(.)*");
        }

        ImapSubFolderFilter(AlfrescoImapConst.ImapViewMode imapViewMode, String mailboxPattern, List<String> excludedComponentIds) {
            this(imapViewMode, mailboxPattern);
            this.excludedComponentIds = excludedComponentIds;
        }

        @Override
        public boolean isEnterSubfolder(ChildAssociationRef subfolderRef) {
            return this.isEnterSubfolder(subfolderRef.getChildRef());
        }

        private boolean containsIgnoreCase(String s, List<String> list) {
            return list.stream().anyMatch(e -> e.equalsIgnoreCase(s));
        }

        public boolean isEnterSubfolder(NodeRef folder) {
            String componentId;
            String name = (String)((Object)ImapServiceImpl.this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
            if (this.mailboxPattern != null) {
                ImapServiceImpl.this.logger.debug((Object)("Child name: " + name));
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("Folder name: " + name + ". Pattern: " + this.mailboxPattern + ". Matches: " + name.matches(this.mailboxPattern)));
                }
                if (!name.matches(this.mailboxPattern)) {
                    return false;
                }
            }
            if (this.excludedComponentIds != null && !this.excludedComponentIds.isEmpty() && (componentId = (String)((Object)ImapServiceImpl.this.nodeService.getProperty(folder, SiteModel.PROP_COMPONENT_ID))) != null && this.containsIgnoreCase(componentId, this.excludedComponentIds)) {
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] Excluding folder with name: " + name + " because its componentID is: " + componentId));
                }
                return false;
            }
            QName typeOfFolder = ImapServiceImpl.this.nodeService.getType(folder);
            if (this.typesToExclude.contains(typeOfFolder)) {
                if (this.imapViewMode == AlfrescoImapConst.ImapViewMode.VIRTUAL || this.imapViewMode == AlfrescoImapConst.ImapViewMode.MIXED) {
                    if (this.favs.contains(folder)) {
                        ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (VIRTUAL) including fav site folder :" + name));
                        return true;
                    }
                    ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (VIRTUAL) excluding non fav site folder :" + name));
                    return false;
                }
                ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (ARCHIVE) excluding site folder :" + name));
                return false;
            }
            return true;
        }
    }

    private class UidValidityTransactionListener
    extends TransactionListenerAdapter {
        private String changeToken = GUID.generate();
        private NodeRef folderNodeRef;
        private Long minUid;
        private Long maxUid;
        private boolean forceNewUidValidity = false;

        public UidValidityTransactionListener(NodeRef folderNodeRef) {
            this.folderNodeRef = folderNodeRef;
        }

        public void forceNewUidvalidity() {
            this.forceNewUidValidity = true;
        }

        public void recordNewUid(long newUid) {
            if (this.minUid == null) {
                this.minUid = this.maxUid = Long.valueOf(newUid);
            } else if (newUid < this.minUid) {
                this.minUid = newUid;
            } else if (newUid > this.maxUid) {
                this.maxUid = newUid;
            }
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            ImapServiceImpl.this.doAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    if (!ImapServiceImpl.this.nodeService.exists(UidValidityTransactionListener.this.folderNodeRef)) {
                        return null;
                    }
                    if (UidValidityTransactionListener.this.forceNewUidValidity || UidValidityTransactionListener.this.minUid != null) {
                        long modifDate = System.currentTimeMillis();
                        Long oldMax = (Long)ImapServiceImpl.this.nodeService.getProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_MAXUID);
                        if (UidValidityTransactionListener.this.forceNewUidValidity || oldMax == null || UidValidityTransactionListener.this.minUid <= oldMax) {
                            ImapServiceImpl.this.nodeService.setProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_UIDVALIDITY, (Serializable)Long.valueOf(modifDate));
                            if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                ImapServiceImpl.this.logger.debug((Object)("UIDVALIDITY was modified for folder, nodeRef:" + UidValidityTransactionListener.this.folderNodeRef));
                            }
                        }
                        if (UidValidityTransactionListener.this.maxUid != null) {
                            ImapServiceImpl.this.nodeService.setProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_MAXUID, (Serializable)UidValidityTransactionListener.this.maxUid);
                            if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                ImapServiceImpl.this.logger.debug((Object)("MAXUID was modified for folder, nodeRef:" + UidValidityTransactionListener.this.folderNodeRef));
                            }
                        }
                    }
                    ImapServiceImpl.this.nodeService.setProperty(UidValidityTransactionListener.this.folderNodeRef, ImapModel.PROP_CHANGE_TOKEN, (Serializable)((Object)UidValidityTransactionListener.this.changeToken));
                    return null;
                }
            });
        }
    }
}

