/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class FFCLoadsOfFiles {
    private static int totalNumDocs = 6000;
    private static int docsPerTx = 2000;
    private static int currentDoc = 0;

    public static void main(String[] args) {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        final ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        MutableAuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
        authenticationService.authenticate(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        TransactionService transactionService = serviceRegistry.getTransactionService();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> exampleWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                FFCLoadsOfFiles.doExample(serviceRegistry);
                return null;
            }
        };
        currentDoc = 0;
        while (currentDoc < totalNumDocs) {
            transactionService.getRetryingTransactionHelper().doInTransaction(exampleWork);
        }
        System.exit(0);
    }

    public static void doExample(ServiceRegistry serviceRegistry) throws Exception {
        SearchService searchService = serviceRegistry.getSearchService();
        NodeService nodeService = serviceRegistry.getNodeService();
        NamespaceService namespaceService = serviceRegistry.getNamespaceService();
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
        List results = searchService.selectNodes(rootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)namespaceService, false);
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Can't find /app:company_home");
        }
        NodeRef companyHomeNodeRef = (NodeRef)results.get(0);
        NodeRef loadTestHome = (results = searchService.selectNodes(companyHomeNodeRef, "./cm:LoadTest", null, (NamespacePrefixResolver)namespaceService, false)).size() == 0 ? nodeService.createNode(companyHomeNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"LoadTest"), ContentModel.TYPE_FOLDER).getChildRef() : (NodeRef)results.get(0);
        if (currentDoc + docsPerTx > totalNumDocs) {
            docsPerTx = totalNumDocs - currentDoc;
        }
        String spaceName = "Bulk Load Space (" + System.currentTimeMillis() + ") from " + currentDoc + " to " + (currentDoc + docsPerTx - 1) + " of " + totalNumDocs;
        HashMap<QName, String> spaceProps = new HashMap<QName, String>();
        spaceProps.put(ContentModel.PROP_NAME, spaceName);
        NodeRef newSpace = nodeService.createNode(loadTestHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)spaceName), ContentModel.TYPE_FOLDER, spaceProps).getChildRef();
        int k = 1;
        while (k <= docsPerTx) {
            System.out.println("About to start document " + ++currentDoc);
            String name = "BulkLoad (" + System.currentTimeMillis() + ") " + currentDoc;
            HashMap<QName, String> contentProps = new HashMap<QName, String>();
            contentProps.put(ContentModel.PROP_NAME, name);
            ChildAssociationRef association = nodeService.createNode(newSpace, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)name), ContentModel.TYPE_CONTENT, contentProps);
            NodeRef content = association.getChildRef();
            HashMap<QName, String> titledProps = new HashMap<QName, String>();
            titledProps.put(ContentModel.PROP_TITLE, name);
            titledProps.put(ContentModel.PROP_DESCRIPTION, name);
            nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
            ContentService contentService = serviceRegistry.getContentService();
            ContentWriter writer = contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            String text = "This is some text in a doc";
            writer.putContent(text);
            System.out.println("About to get child assocs ");
            int count = 0;
            while (count <= 10000) {
                nodeService.getChildAssocs(newSpace);
                ++count;
            }
            ++k;
        }
        System.out.println("About to end transaction ");
    }
}

