/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ValueDerivingMapFactory<O, K, V> {
    private final Map<K, ValueDeriver<O, V>> valueDerivers;

    public ValueDerivingMapFactory(Map<K, ValueDeriver<O, V>> valueDerivers) {
        this.valueDerivers = valueDerivers;
    }

    public Map<K, V> getMap(final O source) {
        return new AbstractMap<K, V>(){

            @Override
            public V get(Object key) {
                ValueDeriver valueDeriver = (ValueDeriver)ValueDerivingMapFactory.this.valueDerivers.get(key);
                return valueDeriver == null ? null : (Object)valueDeriver.deriveValue(source);
            }

            @Override
            public boolean containsKey(Object key) {
                return ValueDerivingMapFactory.this.valueDerivers.containsKey(key);
            }

            @Override
            public Set<K> keySet() {
                return ValueDerivingMapFactory.this.valueDerivers.keySet();
            }

            @Override
            public int size() {
                return ValueDerivingMapFactory.this.valueDerivers.size();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                final Set entries = ValueDerivingMapFactory.this.valueDerivers.entrySet();
                return new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        final Iterator i = entries.iterator();
                        return new Iterator<Map.Entry<K, V>>(){

                            @Override
                            public boolean hasNext() {
                                return i.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                final Map.Entry next = (Map.Entry)i.next();
                                return new Map.Entry<K, V>(){

                                    @Override
                                    public K getKey() {
                                        return next.getKey();
                                    }

                                    @Override
                                    public V getValue() {
                                        return this.get(next.getKey());
                                    }

                                    @Override
                                    public V setValue(V value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return entries.size();
                    }
                };
            }
        };
    }

    public static interface ValueDeriver<O, V> {
        public V deriveValue(O var1);
    }
}

