/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.doclink;

import jakarta.transaction.UserTransaction;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.DeleteLinksStatusReport;
import org.alfresco.service.cmr.repository.DocumentLinkService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

public class DocumentLinkServiceImplTest
extends TestCase {
    private ApplicationContext ctx;
    private static final String TEST_USER = String.valueOf(DocumentLinkServiceImplTest.class.getSimpleName()) + "_testuser";
    private UserTransaction txn;
    private TransactionService transactionService;
    private DocumentLinkService documentLinkService;
    private PermissionService permissionService;
    private PersonService personService;
    private SiteService siteService;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private CheckOutCheckInService cociService;
    private NodeRef site1;
    private NodeRef site1File1;
    private NodeRef site1File2;
    private NodeRef site1Folder1;
    private NodeRef site1Folder2;
    private NodeRef site1Folder3;
    private NodeRef site2File;
    private NodeRef site2Folder1;
    private NodeRef site2Folder2;
    private NodeRef linkOfFile1Site2;
    private String site1File1Name = GUID.generate();
    private String site1Folder1Name = GUID.generate();

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.documentLinkService = serviceRegistry.getDocumentLinkService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.personService = serviceRegistry.getPersonService();
        this.siteService = serviceRegistry.getSiteService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.nodeService = serviceRegistry.getNodeService();
        this.cociService = serviceRegistry.getCheckOutCheckInService();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_USERNAME, TEST_USER);
        this.personService.createPerson(props);
        this.site1 = this.siteService.createSite("site1", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC).getNodeRef();
        this.permissionService.setPermission(this.site1, TEST_USER, "All", true);
        this.site1Folder1 = this.fileFolderService.create(this.site1, this.site1Folder1Name, ContentModel.TYPE_FOLDER).getNodeRef();
        this.site1File1 = this.fileFolderService.create(this.site1Folder1, this.site1File1Name, ContentModel.TYPE_CONTENT).getNodeRef();
        this.site1File2 = this.fileFolderService.create(this.site1Folder1, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
        this.site1Folder2 = this.fileFolderService.create(this.site1, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        this.site1Folder3 = this.fileFolderService.create(this.site1, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        this.documentLinkService.createDocumentLink(this.site1File2, this.site1Folder3);
        NodeRef site2 = this.siteService.createSite("site2", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PRIVATE).getNodeRef();
        this.permissionService.setPermission(site2, TEST_USER, "All", false);
        this.site2File = this.fileFolderService.create(site2, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
        this.site2Folder1 = this.fileFolderService.create(site2, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        this.site2Folder2 = this.fileFolderService.create(site2, GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        this.linkOfFile1Site2 = this.documentLinkService.createDocumentLink(this.site1File2, this.site2Folder2);
    }

    protected void tearDown() throws Exception {
        try {
            if (this.txn.getStatus() != 4 && this.txn.getStatus() != 3) {
                this.txn.rollback();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testCreateFileLink() throws Exception {
        NodeRef linkNodeRef = this.documentLinkService.createDocumentLink(this.site1File1, this.site1Folder2);
        DocumentLinkServiceImplTest.assertNotNull((Object)linkNodeRef);
        String site1File1LinkName = I18NUtil.getMessage((String)"doclink_service.link_to_label", (Object[])new Object[]{String.valueOf(this.site1File1Name) + ".url"});
        NodeRef linkNodeRef2 = this.fileFolderService.searchSimple(this.site1Folder2, site1File1LinkName);
        DocumentLinkServiceImplTest.assertNotNull((Object)linkNodeRef2);
        DocumentLinkServiceImplTest.assertEquals((Object)linkNodeRef, (Object)linkNodeRef2);
        DocumentLinkServiceImplTest.assertEquals((Object)this.nodeService.getType(linkNodeRef), (Object)ApplicationModel.TYPE_FILELINK);
        NodeRef linkDestination = this.documentLinkService.getLinkDestination(linkNodeRef);
        DocumentLinkServiceImplTest.assertNotNull((Object)linkDestination);
        DocumentLinkServiceImplTest.assertEquals((Object)linkDestination, (Object)this.site1File1);
    }

    public void testCreateFolderLink() throws Exception {
        NodeRef linkNodeRef = this.documentLinkService.createDocumentLink(this.site1Folder1, this.site1Folder2);
        DocumentLinkServiceImplTest.assertNotNull((Object)linkNodeRef);
        String site1Folder1LinkName = I18NUtil.getMessage((String)"doclink_service.link_to_label", (Object[])new Object[]{String.valueOf(this.site1Folder1Name) + ".url"});
        NodeRef linkNodeRef2 = this.fileFolderService.searchSimple(this.site1Folder2, site1Folder1LinkName);
        DocumentLinkServiceImplTest.assertNotNull((Object)linkNodeRef2);
        DocumentLinkServiceImplTest.assertEquals((Object)linkNodeRef, (Object)linkNodeRef2);
        DocumentLinkServiceImplTest.assertEquals((Object)this.nodeService.getType(linkNodeRef), (Object)ApplicationModel.TYPE_FOLDERLINK);
        NodeRef linkDestination = this.documentLinkService.getLinkDestination(linkNodeRef);
        DocumentLinkServiceImplTest.assertNotNull((Object)linkDestination);
        DocumentLinkServiceImplTest.assertEquals((Object)linkDestination, (Object)this.site1Folder1);
    }

    public void testCreateDocumentWithNullArguments() throws Exception {
        try {
            this.documentLinkService.createDocumentLink(null, null);
            DocumentLinkServiceImplTest.fail((String)"null arguments must generate AlfrescoRuntimeException.");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    public void testInvalidDestination() throws Exception {
        try {
            this.documentLinkService.createDocumentLink(this.site1Folder2, this.site1File1);
            DocumentLinkServiceImplTest.fail((String)"invalid destination argument must generate IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testCreateDocLinkWithoutReadPermissionOnSource() throws Exception {
        try {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    DocumentLinkServiceImplTest.this.documentLinkService.createDocumentLink(DocumentLinkServiceImplTest.this.site2File, DocumentLinkServiceImplTest.this.site1Folder2);
                    return null;
                }
            }, (String)TEST_USER);
            DocumentLinkServiceImplTest.fail((String)"no read permission on the source node must generate AccessDeniedException.");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    public void testCreateDocLinkWithoutWritePermissionOnDestination() throws Exception {
        try {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    DocumentLinkServiceImplTest.this.documentLinkService.createDocumentLink(DocumentLinkServiceImplTest.this.site1File1, DocumentLinkServiceImplTest.this.site2Folder1);
                    return null;
                }
            }, (String)TEST_USER);
            DocumentLinkServiceImplTest.fail((String)"no write permission on the destination node must generate AccessDeniedException.");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    public void testDeleteLinks() throws Exception {
        DeleteLinksStatusReport report = (DeleteLinksStatusReport)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<DeleteLinksStatusReport>(){

            public DeleteLinksStatusReport doWork() throws Exception {
                return DocumentLinkServiceImplTest.this.documentLinkService.deleteLinksToDocument(DocumentLinkServiceImplTest.this.site1File2);
            }
        }, (String)TEST_USER);
        DocumentLinkServiceImplTest.assertEquals((int)2, (int)report.getTotalLinksFoundCount());
        DocumentLinkServiceImplTest.assertEquals((int)1, (int)report.getDeletedLinksCount());
        DocumentLinkServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.site1File2, ApplicationModel.ASPECT_LINKED));
        Throwable ex = (Throwable)report.getErrorDetails().get(this.linkOfFile1Site2);
        DocumentLinkServiceImplTest.assertNotNull((Object)ex);
        DocumentLinkServiceImplTest.assertEquals(ex.getClass(), AccessDeniedException.class);
    }

    public void testCreateLinksNotAllowed() throws Exception {
        try {
            this.documentLinkService.createDocumentLink(this.site1, this.site2Folder1);
            DocumentLinkServiceImplTest.fail((String)("unsupported source node type : " + this.nodeService.getType(this.site1)));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        NodeRef firstLinkNodeRef = this.documentLinkService.createDocumentLink(this.site1File1, this.site1Folder1);
        DocumentLinkServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.hasAspect(this.site1File1, ApplicationModel.ASPECT_LINKED));
        NodeRef workingCopyNodeRef = this.cociService.checkout(this.site1File1);
        try {
            this.documentLinkService.createDocumentLink(workingCopyNodeRef, this.site1Folder1);
            DocumentLinkServiceImplTest.fail((String)("Cannot perform operation since the node (id:" + workingCopyNodeRef.getId() + ") is locked."));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.documentLinkService.createDocumentLink(this.site1File1, this.site1Folder1);
            DocumentLinkServiceImplTest.fail((String)("Cannot perform operation since the node (id:" + this.site1File1.getId() + ") is locked."));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.nodeService.deleteNode(firstLinkNodeRef);
        DocumentLinkServiceImplTest.assertEquals((boolean)false, (boolean)this.nodeService.hasAspect(this.site1File1, ApplicationModel.ASPECT_LINKED));
        this.cociService.cancelCheckout(workingCopyNodeRef);
    }
}

