/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.repo.events.EventPreparator;
import org.alfresco.sync.repo.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPublisherForTestingOnly
implements EventPublisher {
    private static final Logger logger = LoggerFactory.getLogger(EventPublisherForTestingOnly.class);
    Queue<Event> queue = new ConcurrentLinkedQueue<Event>();

    public void publishEvent(Event event) {
        this.queue.add(event);
        this.log("Event published for [" + event + "]");
    }

    public void publishEvent(EventPreparator prep) {
        ThreadInfo info = this.getThreadInfo();
        Event event = prep.prepareEvent(info.user, info.network, info.transaction);
        this.queue.add(event);
        this.log("Event published: [" + event + "]");
    }

    private void log(String logMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug(logMessage);
        }
    }

    public Queue<Event> getQueue() {
        return this.queue;
    }

    public <T extends Event> List<T> getQueueByType(Class<T> type) {
        ArrayList<Event> toReturn = new ArrayList<Event>();
        for (Event event : this.queue) {
            if (!type.equals(event.getClass())) continue;
            toReturn.add(event);
        }
        return toReturn;
    }

    protected ThreadInfo getThreadInfo() {
        return new ThreadInfo(AuthenticationUtil.getFullyAuthenticatedUser(), AlfrescoTransactionSupport.getTransactionId(), TenantUtil.getCurrentDomain());
    }

    public static class ThreadInfo {
        public final String user;
        public final String transaction;
        public final String network;

        public ThreadInfo(String user, String transaction, String network) {
            this.user = user;
            this.transaction = transaction;
            this.network = network;
        }
    }
}

