/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.traitextender.AJExtender;
import org.alfresco.traitextender.Extensible;
import org.junit.Test;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class AJExtensionsCompileTest
extends TestCase {
    protected void compile(Class<? extends Extensible> extensible) throws Exception {
        HashSet<Class<? extends Extensible>> extensiblesSet = new HashSet<Class<? extends Extensible>>();
        extensiblesSet.add(extensible);
        this.compile(extensiblesSet);
    }

    protected void compile(Set<Class<? extends Extensible>> extensibles) throws Exception {
        StringBuilder errorString = new StringBuilder();
        boolean errorsFound = false;
        for (Class<? extends Extensible> extensible : extensibles) {
            AJExtender.CompiledExtensible ce = AJExtender.compile(extensible);
            if (!ce.hasErrors()) continue;
            errorsFound = true;
            errorString.append("Error compiling ");
            errorString.append(extensible);
            errorString.append(":\n");
            errorString.append(ce.getErrorsString());
            errorString.append(":\n");
        }
        AJExtensionsCompileTest.assertFalse((String)errorString.toString(), (boolean)errorsFound);
    }

    @Test
    public void testCompileExtendedServices() throws Exception {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Extensible.class));
        Set components = provider.findCandidateComponents("org/alfresco/*");
        HashSet<Class<? extends Extensible>> extensibles = new HashSet<Class<? extends Extensible>>();
        for (BeanDefinition component : components) {
            Class<?> extensibleClass = Class.forName(component.getBeanClassName());
            extensibles.add(extensibleClass);
        }
        this.compile(extensibles);
    }
}

