/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.Date;
import java.util.UUID;
import org.alfresco.service.cmr.action.Action;

public class RunningAction {
    private UUID id = UUID.randomUUID();
    private String name;
    private Thread thread;
    private Date started;
    private boolean exceptionThrown = false;

    public RunningAction(Action action) {
        this.name = action.getActionDefinitionName();
        this.started = new Date();
        this.thread = Thread.currentThread();
    }

    public String getActionName() {
        return this.name;
    }

    public String getThread() {
        return this.thread.toString();
    }

    public UUID getId() {
        return this.id;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.started.getTime();
    }

    public void setException(Throwable e) {
        this.exceptionThrown = true;
    }

    public boolean hasError() {
        return this.exceptionThrown;
    }
}

