/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FolderExistsException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.apache.commons.lang3.StringUtils;

public class ImporterActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "import";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_DESTINATION_FOLDER = "destination";
    public static final String ARCHIVE_CONTAINS_SUSPICIOUS_PATHS_ERROR = "Archive contains suspicious paths. Please review it's contents and make sure it doesn't contain entries with absolute paths or paths containing references to the parent folder (i.e. \"..\")";
    private static final int BUFFER_SIZE = 16384;
    private static final String TEMP_FILE_PREFIX = "alf";
    private static final String TEMP_FILE_SUFFIX_ACP = ".acp";
    private long ratioThreshold;
    private long uncompressedBytesLimit = -1L;
    private boolean highByteZip = false;
    private ImporterService importerService;
    private NodeService nodeService;
    private ContentService contentService;
    private FileFolderService fileFolderService;

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public boolean isHighByteZip() {
        return this.highByteZip;
    }

    public void setHighByteZip(boolean highByteZip) {
        this.highByteZip = highByteZip;
    }

    public void setRatioThreshold(long ratioThreshold) {
        this.ratioThreshold = ratioThreshold;
    }

    public void setUncompressedBytesLimit(String limit) {
        long longLimit = -1L;
        try {
            longLimit = Long.parseLong(limit);
        }
        catch (NumberFormatException numberFormatException) {}
        this.uncompressedBytesLimit = longLimit;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        ContentReader reader;
        if (this.nodeService.exists(actionedUponNodeRef) && (reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT)) != null) {
            NodeRef importDest = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
            if ("application/acp".equals(reader.getMimetype())) {
                File zipFile = null;
                try {
                    zipFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX_ACP);
                    reader.getContent(zipFile);
                    ACPImportPackageHandler importHandler = new ACPImportPackageHandler(zipFile, (String)((Object)ruleAction.getParameterValue(PARAM_ENCODING)));
                    this.importerService.importView(importHandler, new Location(importDest), null, null);
                }
                finally {
                    if (zipFile != null) {
                        zipFile.delete();
                    }
                }
            }
            if ("application/zip".equals(reader.getMimetype())) {
                ZipFile zipFile = null;
                File tempFile = null;
                try {
                    try {
                        tempFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX_ACP);
                        reader.getContent(tempFile);
                        String encoding = (String)((Object)ruleAction.getParameterValue(PARAM_ENCODING));
                        if (encoding == null) {
                            encoding = "UTF-8";
                        } else if (encoding.equalsIgnoreCase("default")) {
                            encoding = null;
                        }
                        zipFile = new ZipFile(tempFile, encoding, false);
                        File alfTempDir = TempFileProvider.getLongLifeTempDir((String)NAME);
                        File tempDir = new File(String.valueOf(alfTempDir.getPath()) + File.separatorChar + actionedUponNodeRef.getId());
                        try {
                            ImporterActionExecuter.extractFile(zipFile, tempDir.getPath(), new ZipBombProtection(this.ratioThreshold, this.uncompressedBytesLimit));
                            this.importDirectory(tempDir.getPath(), importDest);
                        }
                        finally {
                            ImporterActionExecuter.deleteDir(tempDir);
                        }
                    }
                    catch (IOException ioErr) {
                        throw new AlfrescoRuntimeException("Failed to import ZIP file.", (Throwable)ioErr);
                    }
                }
                finally {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {
                            throw new AlfrescoRuntimeException("Failed to close zip package.", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void importDirectory(String dir, NodeRef root) {
        File topdir = new File(dir);
        File[] fileArray = topdir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                HashMap<QName, String> titledProps;
                if (file.isFile()) {
                    String fileName = file.getName();
                    FileInfo fileInfo = this.fileFolderService.create(root, fileName, ContentModel.TYPE_CONTENT);
                    NodeRef fileRef = fileInfo.getNodeRef();
                    titledProps = new HashMap<QName, String>(1, 1.0f);
                    titledProps.put(ContentModel.PROP_TITLE, fileName);
                    this.nodeService.addAspect(fileRef, ContentModel.ASPECT_TITLED, titledProps);
                    BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file), 16384);
                    ContentWriter writer = this.contentService.getWriter(fileRef, ContentModel.PROP_CONTENT, true);
                    writer.guessMimetype(fileName);
                    writer.putContent((InputStream)contentStream);
                } else {
                    String folderName = file.getName();
                    FileInfo folderInfo = this.fileFolderService.create(root, folderName, ContentModel.TYPE_FOLDER);
                    NodeRef folderRef = folderInfo.getNodeRef();
                    titledProps = new HashMap(1, 1.0f);
                    this.nodeService.addAspect(folderRef, ContentModel.ASPECT_TITLED, titledProps);
                    this.nodeService.addAspect(folderRef, ApplicationModel.ASPECT_UIFACETS, null);
                    this.importDirectory(file.getPath(), folderRef);
                }
            }
            catch (FileNotFoundException e) {
                throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
            }
            catch (FileExistsException e) {
                if (e.getType().equalsIgnoreCase("folder")) {
                    throw new FolderExistsException(root, file.getName());
                }
                throw e;
            }
            ++n2;
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ENCODING, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_ENCODING)));
    }

    public static void extractFile(ZipFile archive, String extractDir) {
        ImporterActionExecuter.extractFile(archive, extractDir, ExtractionProgressTracker.NONE);
    }

    /*
     * Unable to fully structure code
     */
    public static void extractFile(ZipFile archive, String extractDir, ExtractionProgressTracker tracker) {
        buffer = new byte[16384];
        extractDir = String.valueOf(extractDir) + File.separator;
        try {
            totalCompressedBytesCount = 0L;
            totalUncompressedBytesCount = 0L;
            tracker.reportProgress(0L, 0L);
            e = archive.getEntries();
            while (e.hasMoreElements()) {
                entry = (ZipArchiveEntry)e.nextElement();
                if (!entry.isDirectory()) {
                    fileName = StringUtils.stripAccents((String)entry.getName()).replaceAll("\\?", "_");
                    if ((fileName = fileName.replace('/', File.separatorChar)).startsWith("/") || fileName.indexOf(":" + File.separator) == 1 || fileName.contains(".." + File.separator)) {
                        throw new AlfrescoRuntimeException("Archive contains suspicious paths. Please review it's contents and make sure it doesn't contain entries with absolute paths or paths containing references to the parent folder (i.e. \"..\")");
                    }
                    destFileName = String.valueOf(extractDir) + fileName;
                    destFile = new File(destFileName);
                    parent = destFile.getParent();
                    if (parent != null && !(parentFile = new File(parent)).exists()) {
                        parentFile.mkdirs();
                    }
                    var14_15 = null;
                    var15_17 = null;
                    try {
                        zis = archive.getInputStream(entry);
                        try {
                            in = new BufferedInputStream(zis, 16384);
                            try {
                                out = new BufferedOutputStream(new FileOutputStream(destFileName), 16384);
                                try {
                                    entryStats = (InputStreamStatistics)zis;
                                    while ((count = in.read(buffer)) != -1) {
                                        tracker.reportProgress(totalCompressedBytesCount + entryStats.getCompressedCount(), totalUncompressedBytesCount + entryStats.getUncompressedCount());
                                        out.write(buffer, 0, count);
                                    }
                                    totalCompressedBytesCount += entryStats.getCompressedCount();
                                    totalUncompressedBytesCount += entryStats.getUncompressedCount();
                                }
                                finally {
                                    if (out != null) {
                                        out.close();
                                    }
                                }
                                ** if (in == null) goto lbl-1000
                            }
                            catch (Throwable var15_18) {
                                if (var14_15 == null) {
                                    var14_15 = var15_18;
                                } else if (var14_15 != var15_18) {
                                    var14_15.addSuppressed(var15_18);
                                }
                                if (in != null) {
                                    in.close();
                                }
                                throw var14_15;
                            }
lbl-1000:
                            // 1 sources

                            {
                                in.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                            if (zis == null) continue;
                        }
                        catch (Throwable var15_19) {
                            if (var14_15 == null) {
                                var14_15 = var15_19;
                            } else if (var14_15 != var15_19) {
                                var14_15.addSuppressed(var15_19);
                            }
                            if (zis != null) {
                                zis.close();
                            }
                            throw var14_15;
                        }
                        zis.close();
                        continue;
                    }
                    catch (Throwable var15_20) {
                        if (var14_15 == null) {
                            var14_15 = var15_20;
                        } else if (var14_15 != var15_20) {
                            var14_15.addSuppressed(var15_20);
                        }
                        throw var14_15;
                    }
                }
                newdir = new File(String.valueOf(extractDir) + StringUtils.stripAccents((String)entry.getName()).replaceAll("\\?", "_"));
                newdir.mkdirs();
            }
        }
        catch (ZipException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
    }

    public static void deleteDir(File dir) {
        if (dir != null) {
            File elenco = new File(dir.getPath());
            File[] files = elenco.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        file.delete();
                    } else {
                        ImporterActionExecuter.deleteDir(file);
                    }
                    ++n2;
                }
            }
            dir.delete();
        }
    }

    private static interface ExtractionProgressTracker {
        public static final ExtractionProgressTracker NONE = new ExtractionProgressTracker(){

            @Override
            public void reportProgress(long compressedBytesCount, long uncompressedBytesCount) {
            }
        };

        public void reportProgress(long var1, long var3);
    }

    private static class ZipBombProtection
    implements ExtractionProgressTracker {
        private final long ratioThreshold;
        private final long uncompressedBytesLimit;

        private ZipBombProtection(long ratioThreshold, long uncompressedBytesLimit) {
            this.ratioThreshold = ratioThreshold;
            this.uncompressedBytesLimit = uncompressedBytesLimit;
        }

        @Override
        public void reportProgress(long compressedBytesCount, long uncompressedBytesCount) {
            if (compressedBytesCount <= 0L || uncompressedBytesCount <= 0L) {
                return;
            }
            long ratio = uncompressedBytesCount / compressedBytesCount;
            if (ratio > this.ratioThreshold) {
                throw new AlfrescoRuntimeException("Unexpected compression ratio detected (" + ratio + "%). Possible zip bomb attack. Breaking the extraction process.");
            }
            if (this.uncompressedBytesLimit > 0L && uncompressedBytesCount > this.uncompressedBytesLimit) {
                throw new AlfrescoRuntimeException("Uncompressed bytes limit exceeded (" + uncompressedBytesCount + "). Possible zip bomb attack. Breaking the extraction process.");
            }
        }
    }
}

