/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import org.alfresco.repo.cache.AbstractCacheFactory;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.SimpleCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCacheFactory<K extends Serializable, V>
extends AbstractCacheFactory<K, V> {
    private static final Log log = LogFactory.getLog(DefaultCacheFactory.class);
    private static final String EVICT_NONE = "NONE";

    @Override
    public SimpleCache<K, V> createCache(String cacheName) {
        return this.createLocalCache(cacheName);
    }

    private SimpleCache<K, V> createLocalCache(String cacheName) {
        int maxItems = this.maxItems(cacheName);
        boolean useMaxItems = this.useMaxItems(cacheName);
        int ttlSecs = this.ttlSeconds(cacheName);
        int maxIdleSeconds = this.maxIdleSeconds(cacheName);
        DefaultSimpleCache cache = new DefaultSimpleCache(maxItems, useMaxItems, ttlSecs, maxIdleSeconds, cacheName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating cache: " + cache));
        }
        return cache;
    }

    private int maxItems(String cacheName) {
        String maxItemsStr = this.getProperty(cacheName, "maxItems", "0");
        Integer maxItems = Integer.parseInt(maxItemsStr);
        return maxItems;
    }

    private boolean useMaxItems(String cacheName) {
        String evictionPolicy = this.getProperty(cacheName, "eviction-policy", EVICT_NONE);
        return !evictionPolicy.equals(EVICT_NONE);
    }

    private int ttlSeconds(String cacheName) {
        String ttlSecsStr = this.getProperty(cacheName, "timeToLiveSeconds", "0");
        Integer ttlSecs = Integer.parseInt(ttlSecsStr);
        return ttlSecs;
    }

    private int maxIdleSeconds(String cacheName) {
        String maxIdleSecsStr = this.getProperty(cacheName, "maxIdleSeconds", "0");
        Integer maxIdleSecs = Integer.parseInt(maxIdleSecsStr);
        return maxIdleSecs;
    }
}

