/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event2.ChildAssociationEventConsolidator;
import org.alfresco.repo.event2.ChildAssociationEventSupportedPolicies;
import org.alfresco.repo.event2.EventConsolidator;
import org.alfresco.repo.event2.EventInfo;
import org.alfresco.repo.event2.EventSender;
import org.alfresco.repo.event2.EventSupportedPolicies;
import org.alfresco.repo.event2.NodeEventConsolidator;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.repo.event2.PeerAssociationEventConsolidator;
import org.alfresco.repo.event2.PeerAssociationEventSupportedPolicies;
import org.alfresco.repo.event2.filter.ChildAssociationTypeFilter;
import org.alfresco.repo.event2.filter.EventFilterRegistry;
import org.alfresco.repo.event2.filter.EventUserFilter;
import org.alfresco.repo.event2.filter.NodeTypeFilter;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.ServiceBehaviourBinding;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TriPredicate;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class EventGenerator
extends AbstractLifecycleBean
implements InitializingBean,
EventSupportedPolicies,
ChildAssociationEventSupportedPolicies,
PeerAssociationEventSupportedPolicies {
    private static final Log LOGGER = LogFactory.getLog(EventGenerator.class);
    protected PolicyComponent policyComponent;
    protected NodeService nodeService;
    private NamespaceService namespaceService;
    protected DictionaryService dictionaryService;
    private DescriptorService descriptorService;
    private EventFilterRegistry eventFilterRegistry;
    private TransactionService transactionService;
    private PersonService personService;
    protected NodeResourceHelper nodeResourceHelper;
    protected NodeDAO nodeDAO;
    private EventSender eventSender;
    private NodeTypeFilter nodeTypeFilter;
    private ChildAssociationTypeFilter childAssociationTypeFilter;
    private EventUserFilter userFilter;
    protected final EventTransactionListener transactionListener = new EventTransactionListener();
    protected boolean enabled;
    private Set<Behaviour> behaviours;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void afterPropertiesSet() {
        if (!this.isEnabled()) {
            return;
        }
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
        PropertyCheck.mandatory((Object)this, (String)"eventFilterRegistry", (Object)this.eventFilterRegistry);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"nodeResourceHelper", (Object)this.nodeResourceHelper);
        PropertyCheck.mandatory((Object)this, (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)this, (String)"eventSender", (Object)this.eventSender);
        this.nodeTypeFilter = this.eventFilterRegistry.getNodeTypeFilter();
        this.childAssociationTypeFilter = this.eventFilterRegistry.getChildAssociationTypeFilter();
        this.userFilter = this.eventFilterRegistry.getEventUserFilter();
    }

    private void bindBehaviours() {
        this.setClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, "onCreateNode");
        this.setClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, "beforeDeleteNode");
        this.setClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, "onUpdateProperties");
        this.setClassBehaviour(NodeServicePolicies.OnSetNodeTypePolicy.QNAME, "onSetNodeType");
        this.setClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, "onAddAspect");
        this.setClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, "onRemoveAspect");
        this.setClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, "onMoveNode");
        this.setAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, "onCreateChildAssociation");
        this.setAssociationBehaviour(NodeServicePolicies.BeforeDeleteChildAssociationPolicy.QNAME, "beforeDeleteChildAssociation");
        this.setAssociationBehaviour(NodeServicePolicies.OnCreateAssociationPolicy.QNAME, "onCreateAssociation");
        this.setAssociationBehaviour(NodeServicePolicies.BeforeDeleteAssociationPolicy.QNAME, "beforeDeleteAssociation");
    }

    private boolean isSendingEventBeforeCommitRequired() {
        return this.eventSender.shouldParticipateInTransaction();
    }

    public void disable() {
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
        this.disableBehaviours();
    }

    public void enable() {
        if (this.isEnabled()) {
            return;
        }
        this.setEnabled(true);
        if (this.behaviours == null) {
            this.behaviours = new HashSet<Behaviour>();
            this.afterPropertiesSet();
            this.bindBehaviours();
        } else {
            this.enableBehaviours();
        }
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setEventFilterRegistry(EventFilterRegistry eventFilterRegistry) {
        this.eventFilterRegistry = eventFilterRegistry;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setNodeResourceHelper(NodeResourceHelper nodeResourceHelper) {
        this.nodeResourceHelper = nodeResourceHelper;
    }

    public void setEventSender(EventSender eventSender) {
        this.eventSender = eventSender;
    }

    public EventSender getEventSender() {
        return this.eventSender;
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        this.getEventConsolidator(childAssocRef.getChildRef()).onCreateNode(childAssocRef);
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        this.getEventConsolidator(newChildAssocRef.getChildRef()).onMoveNode(oldChildAssocRef, newChildAssocRef);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        this.getEventConsolidator(nodeRef).onUpdateProperties(nodeRef, before, after);
    }

    @Override
    public void onSetNodeType(NodeRef nodeRef, QName before, QName after) {
        this.getEventConsolidator(nodeRef).onSetNodeType(nodeRef, before, after);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.getEventConsolidator(nodeRef).beforeDeleteNode(nodeRef);
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.getEventConsolidator(nodeRef).onAddAspect(nodeRef, aspectTypeQName);
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.getEventConsolidator(nodeRef).onRemoveAspect(nodeRef, aspectTypeQName);
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssociationRef, boolean isNewNode) {
        this.getEventConsolidator(childAssociationRef).onCreateChildAssociation(childAssociationRef, isNewNode);
        if (!childAssociationRef.isPrimary()) {
            ChildAssociationRef oldChildAssociationRef = EventGenerator.childAssociationWithoutParentOf(childAssociationRef);
            this.getEventConsolidator(childAssociationRef.getChildRef()).onMoveNode(oldChildAssociationRef, childAssociationRef);
        }
    }

    @Override
    public void beforeDeleteChildAssociation(ChildAssociationRef childAssociationRef) {
        this.getEventConsolidator(childAssociationRef).beforeDeleteChildAssociation(childAssociationRef);
        if (!childAssociationRef.isPrimary()) {
            ChildAssociationRef newChildAssociationRef = EventGenerator.childAssociationWithoutParentOf(childAssociationRef);
            this.getEventConsolidator(childAssociationRef.getChildRef()).onMoveNode(childAssociationRef, newChildAssociationRef);
        }
    }

    @Override
    public void onCreateAssociation(AssociationRef associationRef) {
        this.getEventConsolidator(associationRef).onCreateAssociation(associationRef);
    }

    @Override
    public void beforeDeleteAssociation(AssociationRef associationRef) {
        this.getEventConsolidator(associationRef).beforeDeleteAssociation(associationRef);
    }

    protected NodeEventConsolidator createEventConsolidator() {
        return new NodeEventConsolidator(this.nodeResourceHelper);
    }

    protected ChildAssociationEventConsolidator createChildAssociationEventConsolidator(ChildAssociationRef childAssociationRef) {
        return new ChildAssociationEventConsolidator(childAssociationRef, this.nodeResourceHelper);
    }

    protected PeerAssociationEventConsolidator createPeerAssociationEventConsolidator(AssociationRef peerAssociationRef) {
        return new PeerAssociationEventConsolidator(peerAssociationRef, this.nodeResourceHelper);
    }

    private void setClassBehaviour(QName policyQName, String method) {
        Behaviour behaviour = this.bindClassBehaviour(policyQName, method);
        this.behaviours.add(behaviour);
    }

    private void setAssociationBehaviour(QName policyQName, String method) {
        Behaviour behaviour = this.bindAssociationBehaviour(policyQName, method);
        this.behaviours.add(behaviour);
    }

    protected Behaviour bindClassBehaviour(QName policyQName, String method) {
        BehaviourDefinition<ServiceBehaviourBinding> behaviourDef = this.policyComponent.bindClassBehaviour(policyQName, this, (Behaviour)new JavaBehaviour(this, method));
        return behaviourDef.getBehaviour();
    }

    protected Behaviour bindAssociationBehaviour(QName policyQName, String method) {
        BehaviourDefinition<ServiceBehaviourBinding> behaviourDef = this.policyComponent.bindAssociationBehaviour(policyQName, this, (Behaviour)new JavaBehaviour(this, method));
        return behaviourDef.getBehaviour();
    }

    private void disableBehaviours() {
        this.disableBehaviours(this.behaviours);
    }

    protected void disableBehaviours(Set<Behaviour> boundBehaviours) {
        if (boundBehaviours != null) {
            boundBehaviours.forEach(Behaviour::disable);
        }
    }

    private void enableBehaviours() {
        this.enableBehaviours(this.behaviours);
    }

    protected void enableBehaviours(Set<Behaviour> boundBehaviours) {
        if (boundBehaviours != null) {
            boundBehaviours.forEach(Behaviour::enable);
        }
    }

    protected NodeEventConsolidator getEventConsolidator(NodeRef nodeRef) {
        NodeEventConsolidator eventConsolidator;
        Consolidators consolidators = this.getTxnConsolidators((Object)this.transactionListener);
        Map<NodeRef, NodeEventConsolidator> nodeEvents = consolidators.getNodes();
        if (nodeEvents.isEmpty()) {
            AlfrescoTransactionSupport.bindListener((TransactionListener)this.transactionListener);
        }
        if ((eventConsolidator = nodeEvents.get(nodeRef)) == null) {
            eventConsolidator = this.createEventConsolidator();
            nodeEvents.put(nodeRef, eventConsolidator);
        }
        return eventConsolidator;
    }

    protected Consolidators getTxnConsolidators(Object resourceKey) {
        Consolidators consolidators = (Consolidators)AlfrescoTransactionSupport.getResource((Object)resourceKey);
        if (consolidators == null) {
            consolidators = new Consolidators();
            AlfrescoTransactionSupport.bindResource((Object)resourceKey, (Object)consolidators);
        }
        return consolidators;
    }

    private ChildAssociationEventConsolidator getEventConsolidator(ChildAssociationRef childAssociationRef) {
        ChildAssociationEventConsolidator eventConsolidator;
        Consolidators consolidators = this.getTxnConsolidators((Object)this.transactionListener);
        Map<ChildAssociationRef, ChildAssociationEventConsolidator> assocEvents = consolidators.getChildAssocs();
        if (assocEvents.isEmpty()) {
            AlfrescoTransactionSupport.bindListener((TransactionListener)this.transactionListener);
        }
        if ((eventConsolidator = assocEvents.get(childAssociationRef)) == null) {
            eventConsolidator = this.createChildAssociationEventConsolidator(childAssociationRef);
            assocEvents.put(childAssociationRef, eventConsolidator);
        }
        return eventConsolidator;
    }

    private PeerAssociationEventConsolidator getEventConsolidator(AssociationRef peerAssociationRef) {
        PeerAssociationEventConsolidator eventConsolidator;
        Consolidators consolidators = this.getTxnConsolidators((Object)this.transactionListener);
        Map<AssociationRef, PeerAssociationEventConsolidator> assocEvents = consolidators.getPeerAssocs();
        if (assocEvents.isEmpty()) {
            AlfrescoTransactionSupport.bindListener((TransactionListener)this.transactionListener);
        }
        if ((eventConsolidator = assocEvents.get(peerAssociationRef)) == null) {
            eventConsolidator = this.createPeerAssociationEventConsolidator(peerAssociationRef);
            assocEvents.put(peerAssociationRef, eventConsolidator);
        }
        return eventConsolidator;
    }

    private boolean isFiltered(QName nodeType, String user) {
        return this.nodeTypeFilter.isExcluded(nodeType) || this.userFilter.isExcluded(user);
    }

    private boolean isFilteredChildAssociation(QName childAssocType, String user) {
        return this.childAssociationTypeFilter.isExcluded(childAssocType) || this.userFilter.isExcluded(user);
    }

    protected EventInfo getEventInfo(String user) {
        return new EventInfo().setTimestamp(this.getCurrentTransactionTimestamp()).setId(UUID.randomUUID().toString()).setTxnId(AlfrescoTransactionSupport.getTransactionId()).setPrincipal(user).setSource(URI.create("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()));
    }

    private ZonedDateTime getCurrentTransactionTimestamp() {
        Long currentTransactionCommitTime = this.nodeDAO.getCurrentTransactionCommitTime();
        Instant commitTimeMs = Instant.ofEpochMilli(currentTransactionCommitTime);
        return ZonedDateTime.ofInstant(commitTimeMs, ZoneOffset.UTC);
    }

    private static ChildAssociationRef childAssociationWithoutParentOf(ChildAssociationRef childAssociationRef) {
        return new ChildAssociationRef(null, null, childAssociationRef.getQName(), childAssociationRef.getChildRef(), childAssociationRef.isPrimary(), childAssociationRef.getNthSibling());
    }

    protected void onBootstrap(ApplicationEvent applicationEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.behaviours = new HashSet<Behaviour>();
        this.bindBehaviours();
    }

    protected void onShutdown(ApplicationEvent applicationEvent) {
    }

    protected static class Consolidators {
        private Map<NodeRef, NodeEventConsolidator> nodes;
        private Map<ChildAssociationRef, ChildAssociationEventConsolidator> childAssocs;
        private Map<AssociationRef, PeerAssociationEventConsolidator> peerAssocs;

        protected Consolidators() {
        }

        public Map<NodeRef, NodeEventConsolidator> getNodes() {
            if (this.nodes == null) {
                this.nodes = new LinkedHashMap<NodeRef, NodeEventConsolidator>(29);
            }
            return this.nodes;
        }

        public Map<ChildAssociationRef, ChildAssociationEventConsolidator> getChildAssocs() {
            if (this.childAssocs == null) {
                this.childAssocs = new LinkedHashMap<ChildAssociationRef, ChildAssociationEventConsolidator>(29);
            }
            return this.childAssocs;
        }

        public Map<AssociationRef, PeerAssociationEventConsolidator> getPeerAssocs() {
            if (this.peerAssocs == null) {
                this.peerAssocs = new LinkedHashMap<AssociationRef, PeerAssociationEventConsolidator>(29);
            }
            return this.peerAssocs;
        }
    }

    protected class EventTransactionListener
    extends TransactionListenerAdapter {
        protected EventTransactionListener() {
        }

        public void beforeCommit(boolean readOnly) {
            if (EventGenerator.this.isSendingEventBeforeCommitRequired()) {
                this.sendAllEvents();
            }
        }

        public void afterCommit() {
            if (!EventGenerator.this.isSendingEventBeforeCommitRequired()) {
                this.sendAllEvents();
            }
        }

        public Integer getCustomOrder() {
            return EventGenerator.this.isSendingEventBeforeCommitRequired() ? this.getBeforeCommitOrder() : this.getAfterCommitOrder();
        }

        protected Integer getBeforeCommitOrder() {
            return 3;
        }

        protected Integer getAfterCommitOrder() {
            return null;
        }

        protected boolean isTransactionCommitted() {
            return EventGenerator.this.nodeDAO.getCurrentTransactionCommitTime() != null;
        }

        protected void sendAllEvents() {
            if (this.isTransactionCommitted()) {
                try {
                    this.sendEvents();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Unexpected error while sending repository events", (Throwable)e);
                }
            }
        }

        private void sendEvents() {
            Consolidators consolidators = EventGenerator.this.getTxnConsolidators((Object)this);
            for (Map.Entry<NodeRef, NodeEventConsolidator> entry : consolidators.getNodes().entrySet()) {
                this.sendEvent(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, EventConsolidator> entry : consolidators.getChildAssocs().entrySet()) {
                this.sendEvent((ChildAssociationRef)entry.getKey(), (ChildAssociationEventConsolidator)entry.getValue());
            }
            for (Map.Entry<Object, EventConsolidator> entry : consolidators.getPeerAssocs().entrySet()) {
                this.sendEvent((AssociationRef)entry.getKey(), (PeerAssociationEventConsolidator)entry.getValue());
            }
        }

        protected void sendEvent(NodeRef nodeRef, NodeEventConsolidator consolidator) {
            this.sendEvent(nodeRef, consolidator, this.nodeToEventEligibilityVerifier());
        }

        protected void sendEvent(ChildAssociationRef childAssociationRef, ChildAssociationEventConsolidator consolidator) {
            this.sendEvent(childAssociationRef, consolidator, this.childAssociationToEventEligibilityVerifier());
        }

        protected void sendEvent(AssociationRef peerAssociationRef, PeerAssociationEventConsolidator consolidator) {
            this.sendEvent(peerAssociationRef, consolidator, null);
        }

        private <REF extends EntityRef, CON extends EventConsolidator<REF, ? extends Resource>> void sendEvent(REF entityReference, CON eventConsolidator, TriPredicate<REF, CON, EventInfo> entityToEventEligibilityVerifier) {
            EventInfo eventInfo = EventGenerator.this.getEventInfo(AuthenticationUtil.getFullyAuthenticatedUser());
            if (EventGenerator.this.isSendingEventBeforeCommitRequired()) {
                EventGenerator.this.eventSender.accept(() -> this.createEvent(entityReference, eventConsolidator, eventInfo, entityToEventEligibilityVerifier));
            } else {
                EventGenerator.this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                    EventGenerator.this.eventSender.accept(() -> this.createEvent(entityReference, eventConsolidator, eventInfo, entityToEventEligibilityVerifier));
                    return null;
                }, true, true);
            }
        }

        private <REF extends EntityRef, CON extends EventConsolidator<REF, ? extends Resource>> Optional<RepoEvent<?>> createEvent(REF entityReference, CON eventConsolidator, EventInfo eventInfo, TriPredicate<REF, CON, EventInfo> entityToEventEligibilityVerifier) {
            if (eventConsolidator.isTemporaryEntity()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)("Ignoring temporary entity: " + entityReference));
                }
                return Optional.empty();
            }
            RepoEvent<DataAttributes<? extends Resource>> event = eventConsolidator.getRepoEvent(eventInfo);
            if (entityToEventEligibilityVerifier != null && !entityToEventEligibilityVerifier.test(entityReference, eventConsolidator, eventInfo)) {
                return Optional.empty();
            }
            this.logEvent(event, eventConsolidator.getEventTypes());
            return Optional.of(event);
        }

        private TriPredicate<NodeRef, NodeEventConsolidator, EventInfo> nodeToEventEligibilityVerifier() {
            return (nodeReference, eventConsolidator, eventInfo) -> {
                String user = eventInfo.getPrincipal();
                QName nodeType = eventConsolidator.getEntityType();
                if (EventGenerator.this.isFiltered(nodeType, user)) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("EventFilter - Excluding node: '" + nodeReference + "' of type: '" + (nodeType == null ? "Unknown' " : nodeType.toPrefixString()) + "' created by: " + user));
                    }
                    return false;
                }
                if (eventConsolidator.isEventTypeEqualTo(EventType.NODE_UPDATED) && eventConsolidator.isResourceBeforeAllFieldsNull()) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Ignoring node updated event as no fields have been updated: " + nodeReference));
                    }
                    return false;
                }
                return true;
            };
        }

        private TriPredicate<ChildAssociationRef, ChildAssociationEventConsolidator, EventInfo> childAssociationToEventEligibilityVerifier() {
            return (childAssociationReference, eventConsolidator, eventInfo) -> {
                String user = eventInfo.getPrincipal();
                QName childAssocType = eventConsolidator.getEntityType();
                if (EventGenerator.this.isFilteredChildAssociation(childAssocType, user)) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("EventFilter - Excluding child association: '" + childAssociationReference + "' of type: '" + (childAssocType == null ? "Unknown' " : childAssocType.toPrefixString()) + "' created by: " + user));
                    }
                    return false;
                }
                if (childAssociationReference.isPrimary()) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("EventFilter - Excluding primary child association: '" + childAssociationReference + "' of type: '" + (childAssocType == null ? "Unknown' " : childAssocType.toPrefixString()) + "' created by: " + user));
                    }
                    return false;
                }
                return true;
            };
        }

        private void logEvent(RepoEvent<?> event, Deque<EventType> listOfEvents) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("List of Events:" + listOfEvents));
                LOGGER.trace((Object)("Sending event:" + event));
            }
        }
    }
}

