/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageDeployer;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.LockHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class MessageServiceImpl
implements MessageService {
    private static final Log logger = LogFactory.getLog(MessageServiceImpl.class);
    public static final String PROPERTIES_FILE_SUFFIX = ".properties";
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private TenantService tenantService;
    private ContentService contentService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private long tryLockTimeout;
    private SimpleCache<String, Set<String>> resourceBundleBaseNamesCache;
    private SimpleCache<String, Map<Locale, Set<String>>> loadedResourceBundlesCache;
    private SimpleCache<String, Map<Locale, Map<String, String>>> messagesCache;
    private List<MessageDeployer> messageDeployers = new ArrayList<MessageDeployer>();

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setResourceBundleBaseNamesCache(SimpleCache<String, Set<String>> resourceBundleBaseNamesCache) {
        this.resourceBundleBaseNamesCache = resourceBundleBaseNamesCache;
    }

    public void setLoadedResourceBundlesCache(SimpleCache<String, Map<Locale, Set<String>>> loadedResourceBundlesCache) {
        this.loadedResourceBundlesCache = loadedResourceBundlesCache;
    }

    public void setMessagesCache(SimpleCache<String, Map<Locale, Map<String, String>>> messagesCache) {
        this.messagesCache = messagesCache;
    }

    public void setTryLockTimeout(long tryLockTimeout) {
        this.tryLockTimeout = tryLockTimeout;
    }

    @Override
    public void setLocale(Locale locale) {
        I18NUtil.setLocale((Locale)locale);
    }

    @Override
    public Locale getLocale() {
        return I18NUtil.getLocale();
    }

    @Override
    public void setContentLocale(Locale locale) {
        I18NUtil.setContentLocale((Locale)locale);
    }

    @Override
    public Locale getContentLocale() {
        return I18NUtil.getContentLocale();
    }

    @Override
    public Locale getNearestLocale(Locale templateLocale, Set<Locale> options) {
        return I18NUtil.getNearestLocale((Locale)templateLocale, options);
    }

    @Override
    public Locale parseLocale(String localeStr) {
        return I18NUtil.parseLocale((String)localeStr);
    }

    @Override
    public void registerResourceBundle(String resBundlePath) {
        String tenantDomain = this.getTenantDomain();
        Set<String> tenantResourceBundleBaseNames = null;
        LockHelper.tryLock((Lock)this.readLock, (long)this.tryLockTimeout, (String)"getting resource bundle base names in 'MessageServiceImpl.registerResourceBundle()'");
        try {
            tenantResourceBundleBaseNames = this.getResourceBundleBaseNames(tenantDomain, false, true);
        }
        finally {
            this.readLock.unlock();
        }
        LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"adding new resource bundle path and clearing loaded resource bundles in 'MessageServiceImpl.registerResourceBundle()'");
        try {
            if (!tenantResourceBundleBaseNames.contains(resBundlePath)) {
                tenantResourceBundleBaseNames.add(resBundlePath);
                this.reloadResourceBundles(tenantResourceBundleBaseNames);
            }
            logger.info((Object)("Registered message bundle '" + resBundlePath + "'"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, this.getLocale());
    }

    public String getMessage(final String messageKey, final Locale locale) {
        String message = null;
        Map<String, String> props = this.getLocaleProperties(locale);
        if (props != null) {
            message = props.get(messageKey);
        }
        if (message == null) {
            if (this.tenantService.isTenantUser()) {
                message = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                    public String doWork() throws Exception {
                        String message = null;
                        Map props = MessageServiceImpl.this.getLocaleProperties(locale);
                        if (props != null) {
                            message = (String)props.get(messageKey);
                        }
                        return message;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
            if (message == null) {
                message = I18NUtil.getMessage((String)this.tenantService.getBaseName(messageKey), (Locale)locale);
            }
        }
        return message;
    }

    public String getMessage(String messageKey, Object ... params) {
        return this.getMessage(messageKey, this.getLocale(), params);
    }

    public String getMessage(String messageKey, Locale locale, Object ... params) {
        String message = this.getMessage(messageKey, locale);
        if (message != null && params != null) {
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    @Override
    public void unregisterResourceBundle(String resBundlePath) {
        Set<String> resourceBundleBaseNamesForAllLocales;
        Map<Locale, Map<String, String>> cachedMessagesForAllLocales;
        Map<Locale, Set<String>> loadedResourceBundlesForAllLocales;
        String tenantDomain = this.getTenantDomain();
        LockHelper.tryLock((Lock)this.readLock, (long)this.tryLockTimeout, (String)"getting loaded resource bundles, messages and base names in 'MessageServiceImpl.unregisterResourceBundle()'");
        try {
            loadedResourceBundlesForAllLocales = this.getLoadedResourceBundles(tenantDomain, false);
            cachedMessagesForAllLocales = this.getMessages(tenantDomain, false);
            resourceBundleBaseNamesForAllLocales = this.getResourceBundleBaseNames(tenantDomain, false, true);
        }
        finally {
            this.readLock.unlock();
        }
        LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"removing resource bundle by path in 'MessageServiceImpl.unregisterResourceBundle()'");
        try {
            if (loadedResourceBundlesForAllLocales != null && cachedMessagesForAllLocales != null) {
                for (Locale locale : loadedResourceBundlesForAllLocales.keySet()) {
                    Set<String> loadedBundles = loadedResourceBundlesForAllLocales.get(locale);
                    Map<String, String> props = cachedMessagesForAllLocales.get(locale);
                    if (loadedBundles == null || props == null || !loadedBundles.contains(resBundlePath)) continue;
                    ResourceBundle resourcebundle = null;
                    int idx1 = resBundlePath.indexOf("://");
                    if (idx1 != -1) {
                        int idx2 = resBundlePath.indexOf("/", idx1 + 3);
                        String store = resBundlePath.substring(0, idx2);
                        String path = resBundlePath.substring(idx2);
                        StoreRef storeRef = this.tenantService.getName(new StoreRef(store));
                        try {
                            resourcebundle = this.getRepoResourceBundle(storeRef, path, locale);
                        }
                        catch (IOException ioe) {
                            throw new AlfrescoRuntimeException("Failed to read message resource bundle from repository " + resBundlePath + " : " + ioe);
                        }
                    } else {
                        resourcebundle = ResourceBundle.getBundle(resBundlePath, locale);
                    }
                    if (resourcebundle != null) {
                        Enumeration<String> enumKeys = resourcebundle.getKeys();
                        while (enumKeys.hasMoreElements()) {
                            String key = enumKeys.nextElement();
                            props.remove(key);
                        }
                    }
                    loadedBundles.remove(resBundlePath);
                }
            }
            if (resourceBundleBaseNamesForAllLocales != null) {
                resourceBundleBaseNamesForAllLocales.remove(resBundlePath);
                this.reloadResourceBundles(resourceBundleBaseNamesForAllLocales);
                logger.info((Object)("Unregistered message bundle '" + resBundlePath + "'"));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void reloadResourceBundles(Set<String> newResourceBundles) {
        logger.debug((Object)"Reloading message bundles ...");
        String tenantDomain = this.getTenantDomain();
        this.putResourceBundleBaseNames(tenantDomain, newResourceBundles);
        this.clearLoadedResourceBundles(tenantDomain);
    }

    private Map<String, String> getLocaleProperties(Locale locale) {
        Set<String> loadedBundles = null;
        Map<String, String> props = null;
        int loadedBundleCount = 0;
        String tenantDomain = this.getTenantDomain();
        boolean init = false;
        Map<Locale, Set<String>> tenantLoadedResourceBundles = null;
        Map<Locale, Map<String, String>> tenantCachedMessages = null;
        Set<String> tenantResourceBundleBaseNames = null;
        LockHelper.tryLock((Lock)this.readLock, (long)this.tryLockTimeout, (String)"getting loaded resource bundles, messages and base names in 'MessageServiceImpl.getLocaleProperties()'");
        try {
            tenantLoadedResourceBundles = this.getLoadedResourceBundles(tenantDomain, true);
            loadedBundles = tenantLoadedResourceBundles.get(locale);
            tenantCachedMessages = this.getMessages(tenantDomain, true);
            props = tenantCachedMessages.get(locale);
            tenantResourceBundleBaseNames = this.getResourceBundleBaseNames(tenantDomain, false, false);
            loadedBundleCount = tenantResourceBundleBaseNames.size();
        }
        finally {
            this.readLock.unlock();
        }
        if (loadedBundles == null) {
            LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"adding resource bundle for locale in 'MessageServiceImpl.getLocaleProperties()'");
            try {
                loadedBundles = new HashSet<String>();
                tenantLoadedResourceBundles.put(locale, loadedBundles);
                this.putLoadedResourceBundles(tenantDomain, tenantLoadedResourceBundles);
                init = true;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (props == null) {
            LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"adding resource bundle properties into the cache (because properties are not cached) in 'MessageServiceImpl.getLocaleProperties()'");
            try {
                props = new HashMap<String, String>();
                tenantCachedMessages.put(locale, props);
                this.putMessages(tenantDomain, tenantCachedMessages);
                init = true;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (loadedBundles.size() != loadedBundleCount || init) {
            LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"searching resource bundle and adding new resource bundle for locale if the bundle is not found in 'MessageServiceImpl.getLocaleProperties()'");
            try {
                Set<String> resBundleBaseNames = this.getResourceBundleBaseNames(tenantDomain, true, false);
                int count = 0;
                for (String resBundlePath : resBundleBaseNames) {
                    if (loadedBundles.contains(resBundlePath)) continue;
                    ResourceBundle resourcebundle = null;
                    int idx1 = resBundlePath.indexOf("://");
                    if (idx1 != -1) {
                        int idx2 = resBundlePath.indexOf("/", idx1 + 3);
                        String store = resBundlePath.substring(0, idx2);
                        String path = resBundlePath.substring(idx2);
                        StoreRef storeRef = this.tenantService.getName(new StoreRef(store));
                        try {
                            resourcebundle = this.getRepoResourceBundle(storeRef, path, locale);
                        }
                        catch (IOException ioe) {
                            throw new AlfrescoRuntimeException("Failed to read message resource bundle from repository " + resBundlePath + " : " + ioe);
                        }
                    } else {
                        resourcebundle = ResourceBundle.getBundle(resBundlePath, locale);
                    }
                    if (resourcebundle == null) continue;
                    Enumeration<String> enumKeys = resourcebundle.getKeys();
                    while (enumKeys.hasMoreElements()) {
                        String key = enumKeys.nextElement();
                        props.put(key, resourcebundle.getString(key));
                    }
                    loadedBundles.add(resBundlePath);
                    ++count;
                }
                logger.info((Object)("Message bundles (x " + count + ") loaded for locale " + locale));
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return props;
    }

    @Override
    public ResourceBundle getRepoResourceBundle(final StoreRef storeRef, final String path, final Locale locale) throws IOException {
        AuthenticationUtil.RunAsWork<ResourceBundle> getBundleWork = new AuthenticationUtil.RunAsWork<ResourceBundle>(){

            public ResourceBundle doWork() throws Exception {
                NodeRef rootNode = MessageServiceImpl.this.nodeService.getRootNode(storeRef);
                NodeRef nodeRef = MessageServiceImpl.this.getNode(rootNode, String.valueOf(path) + "_" + locale + MessageServiceImpl.PROPERTIES_FILE_SUFFIX);
                if (nodeRef == null) {
                    nodeRef = MessageServiceImpl.this.getNode(rootNode, String.valueOf(path) + MessageServiceImpl.PROPERTIES_FILE_SUFFIX);
                }
                if (nodeRef == null) {
                    logger.debug((Object)("Could not find message resource bundle " + storeRef + "/" + path));
                    return null;
                }
                ContentReader cr = MessageServiceImpl.this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
                MessagePropertyResourceBundle resBundle = new MessagePropertyResourceBundle(new InputStreamReader(cr.getContentInputStream(), cr.getEncoding()));
                return resBundle;
            }
        };
        return (ResourceBundle)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getBundleWork, (String)AuthenticationUtil.getSystemUserName());
    }

    public void onEnableTenant() {
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void init() {
        String tenantDomain = this.getTenantDomain();
        this.putResourceBundleBaseNames(tenantDomain, new HashSet<String>());
        this.putLoadedResourceBundles(tenantDomain, new HashMap<Locale, Set<String>>());
        this.putMessages(tenantDomain, new HashMap<Locale, Map<String, String>>());
        logger.info((Object)"Empty message service initialised");
    }

    public void destroy() {
        String tenantDomain = this.getTenantDomain();
        this.removeLoadedResourceBundles(tenantDomain);
        this.removeMessages(tenantDomain);
        this.removeResourceBundleBaseNames(tenantDomain);
        logger.info((Object)"Messages cache destroyed (all locales)");
    }

    @Override
    public Set<String> getRegisteredBundles() {
        LockHelper.tryLock((Lock)this.readLock, (long)this.tryLockTimeout, (String)"getting resource bundle base names in 'MessageServiceImpl.getRegisteredBundles()'");
        try {
            Set<String> set = this.getResourceBundleBaseNames(this.getTenantDomain(), false, false);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Set<String> getResourceBundleBaseNames(String tenantDomain, boolean haveWriteLock, boolean forWrite) {
        Set resourceBundleBaseNames = (Set)this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain));
        if (resourceBundleBaseNames != null) {
            return this.getOrCopyResourceBundleBaseNames(resourceBundleBaseNames, forWrite);
        }
        if (!haveWriteLock) {
            this.readLock.unlock();
            LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"getting cached resource bundle base names by tenant domain in 'MessageServiceImpl.getRegisteredBundles()'");
        }
        try {
            resourceBundleBaseNames = (Set)this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain));
            if (resourceBundleBaseNames != null) {
                Set<String> set = this.getOrCopyResourceBundleBaseNames(resourceBundleBaseNames, forWrite);
                return set;
            }
            this.reset(tenantDomain);
            resourceBundleBaseNames = (Set)this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain));
        }
        finally {
            if (!haveWriteLock) {
                this.writeLock.unlock();
                LockHelper.tryLock((Lock)this.readLock, (long)this.tryLockTimeout, (String)"upgrading to read lock in MessageServiceImpl.getResourceBundleBaseNames()");
            }
        }
        if (resourceBundleBaseNames == null) {
            throw new AlfrescoRuntimeException("Failed to re-initialise resourceBundleBaseNamesCache " + tenantDomain);
        }
        return this.getOrCopyResourceBundleBaseNames(resourceBundleBaseNames, forWrite);
    }

    private Set<String> getOrCopyResourceBundleBaseNames(Set<String> inbound, boolean createNew) {
        return createNew ? new HashSet(inbound) : inbound;
    }

    private void putResourceBundleBaseNames(String tenantDomain, Set<String> resourceBundleBaseNames) {
        resourceBundleBaseNames = Collections.unmodifiableSet(new HashSet<String>(resourceBundleBaseNames));
        this.resourceBundleBaseNamesCache.put((Serializable)((Object)tenantDomain), resourceBundleBaseNames);
    }

    private void removeResourceBundleBaseNames(String tenantDomain) {
        if (this.resourceBundleBaseNamesCache.get((Serializable)((Object)tenantDomain)) != null) {
            this.resourceBundleBaseNamesCache.remove((Serializable)((Object)tenantDomain));
        }
    }

    private Map<Locale, Set<String>> getLoadedResourceBundles(String tenantDomain, boolean forWrite) {
        Map loadedResourceBundles = (Map)this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain));
        if (loadedResourceBundles != null) {
            return this.getOrCopyResourceBundles(loadedResourceBundles, forWrite);
        }
        this.readLock.unlock();
        LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"getting cached resource bundle by tenant domain in 'MessageServiceImpl.getLoadedResourceBundles()'");
        try {
            loadedResourceBundles = (Map)this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain));
            if (loadedResourceBundles != null) {
                Map<Locale, Set<String>> map = this.getOrCopyResourceBundles(loadedResourceBundles, forWrite);
                return map;
            }
            this.reset(tenantDomain);
            loadedResourceBundles = (Map)this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain));
        }
        finally {
            this.writeLock.unlock();
            LockHelper.tryLock((Lock)this.readLock, (long)this.tryLockTimeout, (String)"upgrading to read lock in MessageServiceImpl.getLoadedResourceBundles()");
        }
        if (loadedResourceBundles == null) {
            throw new AlfrescoRuntimeException("Failed to re-initialise loadedResourceBundlesCache " + tenantDomain);
        }
        return this.getOrCopyResourceBundles(loadedResourceBundles, forWrite);
    }

    private Map<Locale, Set<String>> getOrCopyResourceBundles(Map<Locale, Set<String>> inbound, boolean createNew) {
        return createNew ? new HashMap(inbound) : inbound;
    }

    private void putLoadedResourceBundles(String tenantDomain, Map<Locale, Set<String>> loadedResourceBundles) {
        loadedResourceBundles = Collections.unmodifiableMap(new HashMap<Locale, Set<String>>(loadedResourceBundles));
        this.loadedResourceBundlesCache.put((Serializable)((Object)tenantDomain), loadedResourceBundles);
    }

    private void removeLoadedResourceBundles(String tenantDomain) {
        if (this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain)) != null) {
            this.loadedResourceBundlesCache.remove((Serializable)((Object)tenantDomain));
        }
    }

    private void clearLoadedResourceBundles(String tenantDomain) {
        if (this.loadedResourceBundlesCache.get((Serializable)((Object)tenantDomain)) != null) {
            this.putLoadedResourceBundles(tenantDomain, new HashMap<Locale, Set<String>>());
        }
    }

    private Map<Locale, Map<String, String>> getMessages(String tenantDomain, boolean forWrite) {
        Map messages = (Map)this.messagesCache.get((Serializable)((Object)tenantDomain));
        if (messages != null) {
            return this.getOrCopyMessages(messages, forWrite);
        }
        this.readLock.unlock();
        LockHelper.tryLock((Lock)this.writeLock, (long)this.tryLockTimeout, (String)"getting messages by tenant domain from the cache in 'MessageServiceImpl.getMessages()'");
        try {
            messages = (Map)this.messagesCache.get((Serializable)((Object)tenantDomain));
            if (messages != null) {
                Map<Locale, Map<String, String>> map = this.getOrCopyMessages(messages, forWrite);
                return map;
            }
            this.reset(tenantDomain);
            messages = (Map)this.messagesCache.get((Serializable)((Object)tenantDomain));
        }
        finally {
            this.writeLock.unlock();
            LockHelper.tryLock((Lock)this.readLock, (long)this.tryLockTimeout, (String)"upgrading to read lock in MessageServiceImpl.getMessages()");
        }
        if (messages == null) {
            throw new AlfrescoRuntimeException("Failed to re-initialise messagesCache " + tenantDomain);
        }
        return this.getOrCopyMessages(messages, forWrite);
    }

    private Map<Locale, Map<String, String>> getOrCopyMessages(Map<Locale, Map<String, String>> inbound, boolean createNew) {
        return createNew ? new HashMap(inbound) : inbound;
    }

    private void putMessages(String tenantDomain, Map<Locale, Map<String, String>> messages) {
        messages = Collections.unmodifiableMap(new HashMap<Locale, Map<String, String>>(messages));
        this.messagesCache.put((Serializable)((Object)tenantDomain), messages);
    }

    private void removeMessages(String tenantDomain) {
        if (this.messagesCache.get((Serializable)((Object)tenantDomain)) != null) {
            this.messagesCache.remove((Serializable)((Object)tenantDomain));
        }
    }

    private String getTenantDomain() {
        return this.tenantService.getCurrentUserDomain();
    }

    @Override
    public void register(MessageDeployer messageDeployer) {
        if (!this.messageDeployers.contains(messageDeployer)) {
            this.messageDeployers.add(messageDeployer);
        }
    }

    public void reset() {
        this.reset(this.getTenantDomain());
    }

    private void reset(String tenantDomain) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resetting messages ...");
        }
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() {
                MessageServiceImpl.this.destroy();
                MessageServiceImpl.this.init();
                for (MessageDeployer messageDeployer : MessageServiceImpl.this.messageDeployers) {
                    messageDeployer.initMessages();
                }
                return null;
            }
        }, (String)tenantDomain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"... resetting messages completed");
        }
    }

    @Override
    public String getBaseBundleName(String resourceName) {
        String bundleBaseName = resourceName;
        int idx = resourceName.indexOf("_");
        if (idx > 0) {
            bundleBaseName = resourceName.substring(0, idx);
        } else {
            int idx1 = resourceName.indexOf(".");
            if (idx1 > 0) {
                bundleBaseName = resourceName.substring(0, idx1);
            }
        }
        return bundleBaseName;
    }

    protected NodeRef getNode(NodeRef rootNodeRef, String path) {
        RepositoryLocation repositoryLocation = new RepositoryLocation(rootNodeRef.getStoreRef(), path, "path");
        String[] pathElements = repositoryLocation.getPathElements();
        NodeRef nodeRef = rootNodeRef;
        if (pathElements.length > 0) {
            nodeRef = this.resolveQNamePath(rootNodeRef, pathElements);
        }
        return nodeRef;
    }

    protected NodeRef resolveQNamePath(NodeRef rootNodeRef, String[] pathPrefixQNameStrings) {
        if (pathPrefixQNameStrings.length == 0) {
            throw new IllegalArgumentException("Path array is empty");
        }
        NodeRef parentNodeRef = rootNodeRef;
        int i = 0;
        while (i < pathPrefixQNameStrings.length) {
            String pathPrefixQNameString = pathPrefixQNameStrings[i];
            QName pathQName = null;
            if (AuthenticationUtil.isMtEnabled()) {
                String[] parts = QName.splitPrefixedQName((String)pathPrefixQNameString);
                if (parts.length == 2 && parts[0].equals("app")) {
                    String pathUriQNameString = new StringBuilder(64).append('{').append("http://www.alfresco.org/model/application/1.0").append('}').append(parts[1]).toString();
                    pathQName = QName.createQName((String)pathUriQNameString);
                } else {
                    pathQName = QName.createQName((String)pathPrefixQNameString, (NamespacePrefixResolver)this.namespaceService);
                }
            } else {
                pathQName = QName.createQName((String)pathPrefixQNameString, (NamespacePrefixResolver)this.namespaceService);
            }
            List childAssocRefs = this.nodeService.getChildAssocs(parentNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)pathQName);
            if (childAssocRefs.size() != 1) {
                return null;
            }
            parentNodeRef = ((ChildAssociationRef)childAssocRefs.get(0)).getChildRef();
            ++i;
        }
        return parentNodeRef;
    }

    private class MessagePropertyResourceBundle
    extends ResourceBundle {
        private Properties properties = new Properties();

        public MessagePropertyResourceBundle(Reader reader) throws IOException {
            BufferedReader br = new BufferedReader(reader);
            try {
                String line = br.readLine();
                while (line != null) {
                    if (line.length() > 0 && line.charAt(0) != '#') {
                        String[] splits = line.split("=", 2);
                        if (splits.length == 2) {
                            this.properties.put(splits[0], splits[1]);
                        } else if (splits.length == 1) {
                            this.properties.put(splits[0], "");
                        } else {
                            logger.warn((Object)("Unexpected message properties file format: " + line));
                            throw new AlfrescoRuntimeException("Unexpected message properties file format: " + line);
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException iOException) {}
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }

        @Override
        public Enumeration<String> getKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            Enumeration<Object> enums = this.properties.keys();
            while (enums.hasMoreElements()) {
                keys.add((String)enums.nextElement());
            }
            return new StringIteratorEnumeration(keys.iterator());
        }

        @Override
        protected Object handleGetObject(String arg0) {
            return this.properties.get(arg0);
        }

        private class StringIteratorEnumeration
        implements Enumeration<String> {
            private Iterator<String> enums;

            public StringIteratorEnumeration(Iterator<String> enums) {
                this.enums = enums;
            }

            @Override
            public boolean hasMoreElements() {
                return this.enums.hasNext();
            }

            @Override
            public String nextElement() {
                return this.enums.next();
            }
        }
    }
}

