/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AspectsIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(AspectsIntegrityEvent.class);

    protected AspectsIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef nodeRef) {
        super(nodeService, dictionaryService, nodeRef, null, null);
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        NodeRef nodeRef = this.getNodeRef();
        if (!this.nodeService.exists(nodeRef)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event ignored - node gone: " + this));
            }
            eventResults.clear();
            return;
        }
        this.checkMandatoryAspects(this.getNodeRef(), eventResults);
    }

    private void checkMandatoryAspects(NodeRef nodeRef, List<IntegrityRecord> eventResults) {
        Set aspects = this.nodeService.getAspects(nodeRef);
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
        List mandatoryAspectDefs = typeDef == null ? Collections.emptyList() : typeDef.getDefaultAspects();
        for (AspectDefinition aspect : mandatoryAspectDefs) {
            if (aspects.contains(aspect.getName())) continue;
            IntegrityRecord result = new IntegrityRecord("Mandatory aspect not set: \n   Node: " + nodeRef + "\n" + "   Type: " + nodeTypeQName + "\n" + "   Aspect: " + aspect.getName());
            eventResults.add(result);
        }
        for (QName aspectQName : aspects) {
            AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectQName);
            mandatoryAspectDefs = aspectDef == null ? Collections.emptyList() : aspectDef.getDefaultAspects();
            for (AspectDefinition aspect : mandatoryAspectDefs) {
                if (aspects.contains(aspect.getName())) continue;
                IntegrityRecord result = new IntegrityRecord("Mandatory aspect (aspect-declared) not set: \n   Node:    " + nodeRef + "\n" + "   Aspect:  " + aspectQName + "\n" + "   Missing: " + aspect.getName());
                eventResults.add(result);
            }
        }
    }
}

