/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class PropertySupport
implements DBQueryBuilderComponent {
    Pair<Long, QName> pair;
    private String value;
    private String[] values;
    private DBQueryBuilderJoinCommandType joinCommandType = DBQueryBuilderJoinCommandType.PROPERTY;
    private QName propertyQName;
    private DataTypeDefinition propertyDataType;
    private String fieldName;
    String alias;
    DBQueryBuilderPredicatePartCommandType commandType;
    LuceneFunction luceneFunction;
    private boolean leftOuter;

    public void setPair(Pair<Long, QName> pair) {
        this.pair = pair;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public void setJoinCommandType(DBQueryBuilderJoinCommandType joinCommandType) {
        this.joinCommandType = joinCommandType;
    }

    public void setPropertyQName(QName propertyQName) {
        this.propertyQName = propertyQName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setCommandType(DBQueryBuilderPredicatePartCommandType commandType) {
        this.commandType = commandType;
    }

    public void setPropertyDataType(DataTypeDefinition propertyDataType) {
        this.propertyDataType = propertyDataType;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext, boolean supportBooleanFloatAndDouble) {
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        this.alias = "PROP";
        if (this.commandType == DBQueryBuilderPredicatePartCommandType.ORDER) {
            DBQueryBuilderJoinCommand join = singleJoins.get(this.propertyQName);
            if (join == null && this.pair != null) {
                join = new DBQueryBuilderJoinCommand();
                this.alias = "PROP_" + singleJoins.size();
                join.setAlias(this.alias);
                join.setOuter(this.leftOuter);
                join.setType(this.joinCommandType);
                join.setQnameId((Long)this.pair.getFirst());
                singleJoins.put(this.propertyQName, join);
            }
            if (join != null) {
                this.alias = join.getAlias();
                if (this.leftOuter) {
                    join.setOuter(true);
                }
            }
        }
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        if (this.pair == null) {
            DBQueryBuilderPredicatePartCommand command = new DBQueryBuilderPredicatePartCommand();
            command.setJoinCommandType(DBQueryBuilderJoinCommandType.NODE);
            switch (this.joinCommandType) {
                case NODE: {
                    command.setAlias("node");
                    command.setType(this.commandType);
                    command.setFieldName(this.fieldName);
                    command.setValue(this.value);
                    command.setValues(this.values);
                    command.setFunction(this.luceneFunction);
                    predicatePartCommands.add(command);
                    break;
                }
                case PROPERTY: {
                    command.setType(this.commandType.propertyNotFound());
                    predicatePartCommands.add(command);
                    break;
                }
                default: {
                    command.setType(this.commandType.propertyNotFound());
                    predicatePartCommands.add(command);
                }
            }
            command.setQName(this.propertyQName);
        } else {
            DBQueryBuilderPredicatePartCommand command = new DBQueryBuilderPredicatePartCommand();
            command.setJoinCommandType(this.joinCommandType);
            command.setQnameId((Long)this.pair.getFirst());
            switch (this.joinCommandType) {
                case NODE: {
                    command.setAlias("node");
                    command.setType(this.commandType);
                    command.setValue(this.value);
                    command.setValues(this.values);
                    break;
                }
                case PROPERTY: {
                    command.setAlias(this.alias);
                    command.setType(this.commandType);
                    if (this.propertyDataType != null) {
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.ASSOC_REF)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.CATEGORY)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.DATE)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.DATETIME)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.LOCALE)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.NODE_REF)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.PERIOD)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        if (this.propertyDataType.getName().equals((Object)DataTypeDefinition.QNAME)) {
                            command.setValue(this.value);
                            command.setValues(this.values);
                            break;
                        }
                        command.setValue(DefaultTypeConverter.INSTANCE.convert(this.propertyDataType, (Object)this.value));
                        Collection collection = DefaultTypeConverter.INSTANCE.convert(this.propertyDataType, (Object[])this.values);
                        command.setValues(collection == null ? null : collection.toArray());
                        break;
                    }
                    command.setValue(this.value);
                    command.setValues(this.values);
                    break;
                }
                case CONTENT_MIMETYPE: {
                    command.setAlias(this.alias);
                    command.setType(this.commandType);
                    command.setValue(this.value);
                    command.setValues(this.values);
                    break;
                }
                case CONTENT_URL: {
                    command.setAlias(this.alias);
                    command.setType(this.commandType);
                    if (this.commandType == DBQueryBuilderPredicatePartCommandType.ORDER) {
                        command.setValue(this.value);
                        command.setValues(this.values);
                        break;
                    }
                    command.setValue(DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.value));
                    command.setValues(this.values == null ? null : DefaultTypeConverter.INSTANCE.convert(Integer.class, Arrays.asList(this.values)).toArray(new Integer[0]));
                    break;
                }
                default: {
                    command.setType(this.commandType.propertyNotFound());
                    command.setValue(this.value);
                    command.setValues(this.values);
                }
            }
            command.setFieldName(this.fieldName);
            command.setFunction(this.luceneFunction);
            command.setQName(this.propertyQName);
            predicatePartCommands.add(command);
        }
    }

    public void setLuceneFunction(LuceneFunction luceneFunction) {
        this.luceneFunction = luceneFunction;
    }

    public void setLeftOuter(boolean leftOuter) {
        this.leftOuter = leftOuter;
    }
}

