/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.search.impl.JSONAPIResultFactory;
import org.alfresco.repo.search.impl.solr.SolrQueryClient;
import org.alfresco.repo.solr.SOLRAdminClient;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SolrBackupClient
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(SolrBackupClient.class);
    private QName lock;
    private JobLockService jobLockService;
    private String remoteBackupLocation;
    private int numberToKeep;
    private String core;
    private boolean fixNumberToKeepOffByOneError = false;
    private SOLRAdminClient solrAdminClient;
    private SolrQueryClient solrQueryHTTPClient;

    public void setFixNumberToKeepOffByOneError(boolean fixNumberToKeepOffByOneError) {
        this.fixNumberToKeepOffByOneError = fixNumberToKeepOffByOneError;
    }

    public void setSolrAdminClient(SOLRAdminClient solrAdminClient) {
        this.solrAdminClient = solrAdminClient;
    }

    public void setCore(String core) {
        this.core = core;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setRemoteBackupLocation(String remoteBackupLocation) {
        this.remoteBackupLocation = remoteBackupLocation;
    }

    public void setSolrQueryHTTPClient(SolrQueryClient solrQueryHTTPClient) {
        this.solrQueryHTTPClient = solrQueryHTTPClient;
    }

    public void setNumberToKeep(int numberToKeep) {
        this.numberToKeep = numberToKeep;
    }

    public void execute() {
        if (this.solrQueryHTTPClient.isSharded()) {
            return;
        }
        String lockToken = this.getLock(60000L);
        if (lockToken == null) {
            return;
        }
        final AtomicBoolean running = new AtomicBoolean(true);
        this.jobLockService.refreshLock(lockToken, this.lock, 30000L, new JobLockService.JobLockRefreshCallback(){

            @Override
            public boolean isActive() {
                return running.get();
            }

            @Override
            public void lockReleased() {
                running.set(false);
            }
        });
        try {
            this.executeImpl(running);
        }
        finally {
            running.set(false);
            this.jobLockService.releaseLock(lockToken, this.lock);
        }
    }

    private void executeImpl(AtomicBoolean running) {
        if ((this.remoteBackupLocation == null || this.remoteBackupLocation.length() == 0) && logger.isInfoEnabled()) {
            logger.info((Object)("Back up of SOLR core skipped - no remote backup localtion set for: " + this.core));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("wt", "json");
        parameters.put("location", this.remoteBackupLocation);
        if (this.fixNumberToKeepOffByOneError) {
            parameters.put("numberToKeep", String.valueOf(this.numberToKeep > 1 ? this.numberToKeep + 1 : this.numberToKeep));
        } else {
            parameters.put("numberToKeep", String.valueOf(this.numberToKeep));
        }
        this.solrAdminClient.executeCommand(this.core, JSONAPIResultFactory.HANDLER.REPLICATION, JSONAPIResultFactory.COMMAND.BACKUP, parameters);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Back up of SOLR core completed: " + this.core));
        }
    }

    private String getLock(long time) {
        try {
            return this.jobLockService.getLock(this.lock, time);
        }
        catch (LockAcquisitionException lockAcquisitionException) {
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.lock = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)("SolrBackupClient-" + this.core));
    }
}

